/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.scheme;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.management.util.ConditionalRuleConvertUtil;

public class WorkflowDynConfSchemePlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "btnok";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String DESCRIPTION = "description";
    private static final String CONDITION = "condition";
    private static final String CONDITION_VALUE = "condition_value";
    private static final String CONDITIONAL_RULE = "conditional_rule";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        TextEdit condition = (TextEdit)this.getControl(CONDITION);
        condition.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "condition": {
                this.openCondition();
                break;
            }
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    private String validate(String number, ILocaleString name, String condition) {
        QFilter[] filters;
        if (WfUtils.isEmpty((String)number)) {
            return ResManager.loadKDString((String)"\u201c\u65b9\u6848\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowDynConfSchemePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (!PluginUtil.matchPattern("^[A-Za-z][A-Za-z0-9_]*$", number)) {
            return ResManager.loadKDString((String)"\u201c\u65b9\u6848\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"WorkflowDynConfSchemePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        String lowerNumber = number.toLowerCase();
        if (lowerNumber.matches("((^[\\w]+)_sync)\\d*$")) {
            return ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4ee5\u201c_sync+\u6570\u5b57\u201d\u7ed3\u5c3e\u3002", (String)"WorkflowDynConfSchemePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (name == null || WfUtils.isEmpty((String)name.getLocaleValue())) {
            return ResManager.loadKDString((String)"\u201c\u65b9\u6848\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowDynConfSchemePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (WfUtils.isEmpty((String)condition) || WfUtils.isEmpty((String)this.getPageCache().get(CONDITION_VALUE))) {
            return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5e94\u7528\u6761\u4ef6\u201d\u3002", (String)"WorkflowDynConfSchemePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        ManagementService service = this.getManagementService();
        Long count = service.getConfigSchemeCountByFilters(filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)number)});
        if (count > 0L) {
            return ResManager.loadKDString((String)"\u201c\u65b9\u6848\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"WorkflowDynConfSchemePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void confirm() {
        String condition;
        ILocaleString name;
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_processdefinition", (String)"/8M2NEU9PFQV")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u65b0\u589e\u6d41\u7a0b\u65b9\u6848\u201d\u6743\u9650\u3002", (String)"WorkflowDynamicConfigSchemePlugin_33", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        String number = (String)model.getValue(NUMBER);
        String result = this.validate(number, name = (ILocaleString)model.getValue(NAME), condition = (String)this.getModel().getValue(CONDITION));
        if (result != null) {
            this.getView().showTipNotification(result);
            return;
        }
        condition = this.getPageCache().get(CONDITION_VALUE);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long procDefId = (Long)parameter.getCustomParam("procDefId");
        ILocaleString description = (ILocaleString)model.getValue(DESCRIPTION);
        DynamicConfigSchemeEntity scheme = this.getManagementService().createDynamicConfigScheme(procDefId, number, condition, name, description);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(NAME, name);
        ret.put(NUMBER, number);
        ret.put(DESCRIPTION, description);
        ret.put("id", scheme.getId());
        this.getView().returnDataToParent(ret);
        this.getView().close();
        WfUtils.addOpLog((String)"wf_processdynamicconfig", (String)"addDynConfScheme", (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e\u6d41\u7a0b\u65b9\u6848", "WorkflowDynConfSchemePlugin_8", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b9\u6848ID: [%1$s] \u540d\u79f0: %2$s \u7f16\u7801: %3$s", "WorkflowDynConfSchemePlugin_9", "bos-wf-formplugin"), (Object[])new Object[]{scheme.getId(), scheme.getName().toString(), scheme.getNumber()});
    }

    private void openCondition() {
        Long procDefId = (Long)this.getView().getFormShowParameter().getCustomParam("procDefId");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("procDefId", procDefId);
        params.put("openType", "managermentCenter");
        String type = ConditionalRuleType.configScheme.toString();
        params.put("type", type);
        String value = this.getPageCache().get(CONDITION_VALUE);
        if (value != null) {
            params.put("value", value);
        }
        String caption = ConditionalRuleType.getTypeName((String)type);
        FormShowParameter parameter = this.getShowParameter(CONDITIONAL_RULE, "wf_conditionrule_update", caption, params);
        parameter.setShowTitle(false);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (CONDITIONAL_RULE.equals(actionId) && returnData instanceof String) {
            String json = (String)returnData;
            ConditionalRuleEntity entity = ConditionalRuleConvertUtil.jsonToConditionalRuleModel((String)json);
            this.getModel().setValue(CONDITION, (Object)entity.getShowtext().getLocaleValue());
            this.getPageCache().put(CONDITION_VALUE, json);
        }
    }
}

