/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowDesignerPlugin;
import kd.bos.workflow.design.plugin.ISupportDesignerModelChange;
import kd.bos.workflow.design.plugin.event.BeforeSaveDigramEvent;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.management.batchsetting.MutexResult;
import kd.bos.workflow.engine.management.util.ConditionalRuleConvertUtil;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.management.plugin.scheme.SelectedScheme;

public class WorkflowDynamicConfigSchemePlugin
extends AbstractWorkflowDesignerPlugin
implements ISupportDesignerModelChange,
RowClickEventListener {
    private static final String KEY_SCHEME = "wfscheme";
    private static final String TOOLBAR = "toolbar";
    protected static final String BTN_SAVE = "savebtn";
    private static final String BTN_CHECK = "checkbtn";
    private static final String BTN_ENABLE = "enablebtn";
    private static final String BTN_DISABLE = "disablebtn";
    private static final String BTN_DELETE = "deletebtn";
    private static final String BTN_ADDSCHEME = "addschemebtn";
    private static final String BTN_AUTOTEST = "autotest";
    private static final String BTN_SHOWPLANS = "showplans";
    private static final String BTN_SYNCTOIDE = "synctoide";
    private static final String BTN_EXPORTIMAGE = "exportimage";
    private static final String COMPARE_VERSION_DIFFERENCES = "compareversiondifferences";
    private static final String PANEL_SPLIT = "splitpanelap";
    private static final String PANEL_SCHEMEINFO = "schemeinfopanel";
    private static final String CONTAINER_SPLIT = "splitcontainerap";
    private static final String CONTAINER_SCHEMESPLITCONTAINER = "schemesplitcontainer";
    private static final String LABEL_TITLE = "title";
    private static final String LABEL_SUBTITLE = "subtitle";
    private static final String CARD_SCHEME_LIST = "entryentity";
    private static final String CARD_STATE = "cardstate";
    private static final String CARD_NAME = "cardname";
    private static final String CARD_SCHEMEID = "schemeid";
    private static final String CARD_DESCRIPTION = "carddescription";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_BUSINESSID = "businessId";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_CONDITION = "condition";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_ORGUNITID = "orgUnitId";
    private static final String CONDITION_ID = "conditionId";
    private static final String CONDITION_VALUE = "condition_value";
    private static final String DELETE_SCHEME = "delete_scheme";
    private static final String ENABLE_SCHEME = "enable_scheme";
    private static final String DISABLE_SCHEME = "disable_scheme";
    private static final String LAST_SCHEME_INDEX = "last_select_scheme_index";
    private static final String SCHEME_CHANGED = "scheme_changed";
    private static final String IS_SCHEME_INIT = "scheme_init";
    private static final String WORKFLOW_JSFILE_LOADED = "loaded";
    private static final String SYNCTOIDECONFIRM = "syncToIDEConfirm";
    private static final String CONTINUEWHENFAILED = "continueWhenFailed";
    private static final String STILLSAVE_WHEN_CONDITIONCHANGED = "stillSaveWhenConditionChanged";
    private static final String KEY_PROCESSCONFIG_ID = "processConfigId";
    private static final String KEY_PROCESSCONFIG_MODIFYTIME = "processConfigModifyTime";
    private static final String KEY_IS_BIZFLOW = "isBizFlow";
    private static final String KEY_NETMUTUALEXCLUSION = "netMutualExclusion";
    private static final String KEY_OPENED_PAGE_ID = "opened_page_id";
    private static final String KEY_OPENED_PLAN_LIST_ID = "opened_plan_list_id";
    private static final String PROCESSNUMBER = "processNumber";
    private static final String PROCESSVERSION = "processVersion";
    private static final String ORIG_MODEL_JSON = "origModelJson";
    private static final String OPENED_VERSION_DIFF_IDS = "openedVersionDiffIds";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADDSCHEME, BTN_SAVE, BTN_ENABLE, BTN_DISABLE, BTN_DELETE, BTN_CHECK, BTN_AUTOTEST, BTN_SHOWPLANS, BTN_SYNCTOIDE, BTN_EXPORTIMAGE, COMPARE_VERSION_DIFFERENCES});
        CardEntry entry = (CardEntry)this.getControl(CARD_SCHEME_LIST);
        entry.addRowClickListener((RowClickEventListener)this);
        TextEdit condition = (TextEdit)this.getControl(FIELD_CONDITION);
        condition.addButtonClickListener((ClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPropertiesPanel();
        this.init();
        this.hideButtons();
        this.checkNetMutExclusive();
    }

    public void afterBindData(EventObject e) {
        this.selectDynamicScheme();
    }

    private void init() {
        this.getPageCache().put(IS_SCHEME_INIT, "true");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long procDefId = (Long)parameter.getCustomParam("procDefId");
        ProcessDefinition procDef = this.getRepositoryService().getProcessDefinition(procDefId);
        String lang = RequestContext.get().getLang().toString();
        String title = String.format("%s V%s.0", this.getMultiLangValue(procDef.getName(), lang), Integer.valueOf(procDef.getVersion()));
        ((Label)this.getControl(LABEL_TITLE)).setText(title);
        ((Label)this.getControl(LABEL_SUBTITLE)).setText(title);
        this.initSchemeList(procDefId);
        String processType = procDef instanceof ProcessDefinitionEntity ? ((ProcessDefinitionEntity)procDef).getType() : null;
        boolean isLatest = this.getManagementService().isLatestProcessDefinition(procDefId);
        boolean isBizFlow = ModelType.BizFlow.name().equals(processType);
        this.getPageCache().put(KEY_IS_BIZFLOW, String.valueOf(isBizFlow));
        if (!isLatest || isBizFlow) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ADDSCHEME});
        }
        if (isBizFlow) {
            this.cacheConditionModifyTime();
        }
        if (null != procDef) {
            HashMap<String, String> cacheMap = new HashMap<String, String>(2);
            cacheMap.put(PROCESSNUMBER, procDef.getKey());
            cacheMap.put(PROCESSVERSION, procDef.getVersion());
            if (WfUtils.isNotEmptyForMap(cacheMap)) {
                this.getPageCache().put(cacheMap);
            }
        }
    }

    private void cacheConditionModifyTime() {
        Long procDefId = (Long)this.getView().getFormShowParameter().getCustomParam("procDefId");
        ProcessConfigEntity processConfig = this.getRepositoryService().getProcessConfigByProcDefId(procDefId);
        if (processConfig == null) {
            return;
        }
        this.getPageCache().put(KEY_PROCESSCONFIG_ID, String.valueOf(processConfig.getId()));
        this.getPageCache().put(KEY_PROCESSCONFIG_MODIFYTIME, String.valueOf(processConfig.getModifyDate().getTime()));
    }

    private void hideButtons() {
        if (!Lang.get().equals((Object)Lang.zh_CN) && !WfConfigurationUtil.isEnableOtherLang().booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_DELETE, BTN_ADDSCHEME, BTN_SYNCTOIDE});
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        boolean permFlag = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"1//JGEENPGO0");
        if (!BizFlowPluginUtil.isBizFlow(this.modelType) && !WfConfigurationUtil.isProdEnvironment() && WfConfigurationUtil.canUseAutoTesting() && permFlag) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_AUTOTEST, BTN_SHOWPLANS});
        }
    }

    private String getMultiLangValue(ILocaleString data, String lang) {
        if (data == null) {
            return "";
        }
        String value = (String)data.get((Object)lang);
        if (value != null) {
            return value;
        }
        for (Map.Entry entry : data.entrySet()) {
            value = (String)entry.getValue();
            if (value == null) continue;
            return value;
        }
        return "";
    }

    private void initSchemeList(Long procDefId) {
        IDataModel model = this.getModel();
        List schemes = this.getManagementService().getDynamicConfigSchemeByProcDefId(procDefId, false);
        if (schemes.isEmpty()) {
            DynamicConfigSchemeEntity defScheme = this.getManagementService().createDefaultConfigScheme(procDefId, true);
            ILocaleString defSchemeName = defScheme.getName();
            if (defSchemeName != null) {
                model.setValue(CARD_NAME, (Object)defSchemeName.toString(), 0);
            }
            model.setValue(CARD_STATE, this.getStateName(defScheme.getState()), 0);
            model.setValue(CARD_SCHEMEID, (Object)defScheme.getId(), 0);
            ILocaleString defSchemeDescription = defScheme.getDescription();
            if (defSchemeDescription != null) {
                model.setValue(CARD_DESCRIPTION, (Object)defSchemeDescription.toString(), 0);
            }
            model.setValue(FIELD_NAME, (Object)defSchemeName);
            model.setValue(FIELD_NUMBER, (Object)defScheme.getNumber());
            model.setValue(FIELD_DESCRIPTION, (Object)defSchemeDescription);
            model.setValue(FIELD_STATUS, this.getStateName(defScheme.getState()));
        } else {
            model.deleteEntryData(CARD_SCHEME_LIST);
            model.batchCreateNewEntryRow(CARD_SCHEME_LIST, schemes.size());
            DynamicConfigSchemeEntity defaultScheme = (DynamicConfigSchemeEntity)schemes.get(0);
            if (schemes.size() > 1 && !defaultScheme.isAcquiescence()) {
                Iterator iterator = schemes.iterator();
                while (iterator.hasNext()) {
                    defaultScheme = (DynamicConfigSchemeEntity)iterator.next();
                    if (!defaultScheme.isAcquiescence()) continue;
                    iterator.remove();
                    break;
                }
                schemes.add(0, defaultScheme);
            }
            int index = 0;
            for (DynamicConfigSchemeEntity scheme : schemes) {
                ILocaleString name = scheme.getName();
                ILocaleString description = scheme.getDescription();
                model.setValue(CARD_SCHEMEID, (Object)scheme.getId(), index);
                if (name != null) {
                    model.setValue(CARD_NAME, (Object)name.toString(), index);
                }
                model.setValue(CARD_STATE, this.getStateName(scheme.getState()), index);
                if (description != null) {
                    model.setValue(CARD_DESCRIPTION, (Object)description.toString(), index);
                }
                ++index;
            }
        }
    }

    private void selectDynamicScheme() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String itemId = (String)parameter.getCustomParam("selected_cellId");
        Object schemeId = parameter.getCustomParam("config_scheme_id");
        if (schemeId != null) {
            int i = 0;
            int index = 0;
            DynamicObjectCollection schemeCards = this.getModel().getEntryEntity(CARD_SCHEME_LIST);
            for (DynamicObject card : schemeCards) {
                if (schemeId.equals(card.get(CARD_SCHEMEID))) {
                    index = i;
                    break;
                }
                ++i;
            }
            this.getPageCache().put("selected_cellId", itemId);
            this.selectScheme(index);
        } else {
            this.selectScheme(0);
        }
    }

    private Object getStateName(String state) {
        if ("enable".equals(state)) {
            return ResManager.loadKDString((String)"\u5df2\u542f\u7528", (String)"WorkflowDynamicConfigSchemePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5df2\u7981\u7528", (String)"WorkflowDynamicConfigSchemePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    private void switchBtnState(boolean isDefault, String state) {
        if (isDefault) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ENABLE, BTN_DISABLE, BTN_DELETE, COMPARE_VERSION_DIFFERENCES});
            if (!Lang.get().equals((Object)Lang.zh_CN) && !WfConfigurationUtil.isEnableOtherLang().booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SYNCTOIDE});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_SYNCTOIDE});
            }
        } else {
            if ("enable".equals(state)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ENABLE, BTN_DELETE});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_DISABLE});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_DISABLE});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_ENABLE, BTN_DELETE});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SYNCTOIDE});
            this.getView().setVisible(Boolean.TRUE, new String[]{COMPARE_VERSION_DIFFERENCES});
            if (!Lang.zh_CN.equals((Object)RequestContext.get().getLang()) && !WfConfigurationUtil.isEnableShowMutiLangLog()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPARE_VERSION_DIFFERENCES});
            }
        }
        if ("true".equals(this.getPageCache().get(KEY_NETMUTUALEXCLUSION))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SYNCTOIDE, BTN_DELETE});
        }
    }

    private void initPropertiesPanel() {
        HashMap<String, Object> propsPanel = new HashMap<String, Object>();
        propsPanel.put("id", "rightpanel");
        propsPanel.put("type", "flexpanel");
        HashMap<String, Object> width = new HashMap<String, Object>();
        this.setLocaleProperties(width, "461px");
        propsPanel.put("w", width);
        propsPanel.put("as", "stretch");
        propsPanel.put("ai", "stretch");
        propsPanel.put("sk", 0);
        propsPanel.put("wr", Boolean.TRUE);
        ArrayList<JSONObject> confPanels = new ArrayList<JSONObject>();
        propsPanel.put("items", confPanels);
        HashSet<String> types = new HashSet<String>(16);
        List<StencilConfig> configs = DesignerModelUtil.getStencilConfigs(this.modelType, true);
        ArrayList<String> panelIds = new ArrayList<String>();
        for (StencilConfig config : configs) {
            if (!config.isVisible()) continue;
            types.add(config.getId());
            confPanels.add(this.getConfigureFlexJSON(config.getId()));
            panelIds.add(this.getConfigurePanelId(config.getId()));
        }
        types.add("SequenceFlow");
        confPanels.add(this.getConfigureFlexJSON("SequenceFlow"));
        panelIds.add(this.getConfigurePanelId("SequenceFlow"));
        types.add("SSCImageUpload");
        confPanels.add(this.getConfigureFlexJSON("SSCImageUpload"));
        panelIds.add(this.getConfigurePanelId("SSCImageUpload"));
        types.add("Diagram");
        confPanels.add(this.getConfigureFlexJSON("Diagram"));
        this.getView().updateControlMetadata("rightpanel", propsPanel);
        this.getView().setVisible(Boolean.FALSE, panelIds.toArray(new String[0]));
        this.getPageCache().put("allType", SerializationUtils.toJsonString(types));
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        String lastSelectRow = this.getPageCache().get(LAST_SCHEME_INDEX);
        if (!String.valueOf(rowIndex).equals(lastSelectRow)) {
            DynamicObject entity;
            String schemeId;
            if ("true".equals(this.getPageCache().get(WORKFLOW_JSFILE_LOADED))) {
                this.showBlock(true, this.getView());
            }
            if (WfUtils.isEmpty((String)(schemeId = (entity = this.getModel().getEntryRowEntity(CARD_SCHEME_LIST, rowIndex)).getString(CARD_SCHEMEID)))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowDynamicConfigSchemePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else {
                DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)this.getRepositoryService().findEntityById(Long.valueOf(schemeId), "wf_processdynamicconfig");
                this.initSchemeInfo(scheme, rowIndex, this.getPageCache().get("selected_cellId"));
                this.getPageCache().remove("selected_cellId");
                this.getPageCache().put("isDefaultScheme", scheme.isAcquiescence() ? "true" : "false");
                this.getPageCache().put("schemeId", schemeId);
                if (scheme.isAcquiescence()) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_NAME});
                    this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_NUMBER});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_NAME});
                    this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_NUMBER});
                }
            }
            if (lastSelectRow != null) {
                this.getPageCache().put(SCHEME_CHANGED, "true");
            }
            this.getPageCache().put(LAST_SCHEME_INDEX, String.valueOf(rowIndex));
            this.getPageCache().remove(CONDITION_VALUE);
        }
    }

    private void initSchemeInfo(DynamicConfigSchemeEntity scheme, int rowIndex, String selectedItemId) {
        this.switchBtnState(scheme.isAcquiescence(), scheme.getState());
        ILocaleString name = scheme.getName();
        ILocaleString description = scheme.getDescription();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String key = lang.toString();
            if (name != null && WfUtils.isEmpty((String)((String)name.get((Object)key)))) {
                name.setItem(key, (Object)name.toString());
            }
            if (description == null || !WfUtils.isEmpty((String)((String)description.get((Object)key)))) continue;
            description.setItem(key, (Object)description.toString());
        }
        IDataModel model = this.getModel();
        model.setValue(FIELD_NAME, (Object)name);
        model.setValue(FIELD_NUMBER, (Object)scheme.getNumber());
        model.setValue(FIELD_DESCRIPTION, (Object)description);
        this.getPageCache().put("schemeNumber", scheme.getNumber());
        if (scheme.isAcquiescence()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_CONDITION});
            this.getPageCache().remove(CONDITION_ID);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_CONDITION});
            this.getPageCache().put(CONDITION_ID, String.valueOf(scheme.getConditionId()));
            model.setValue(FIELD_CONDITION, (Object)WfMultiLangUtils.getValueFromLocalString((ILocaleString)scheme.getConditionText(), (String)RequestContext.get().getLang().toString()));
        }
        model.setValue(FIELD_STATUS, this.getStateName(scheme.getState()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("config_scheme_id", String.valueOf(scheme.getId()));
        params.put("selected_cellId", selectedItemId);
        if (!"true".equals(this.getPageCache().get(IS_SCHEME_INIT))) {
            this.loadDesigner(params);
            this.hideCurrentConfigurePanel();
        } else {
            this.getPageCache().put(IS_SCHEME_INIT, "false");
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "addschemebtn": {
                this.addScheme();
                break;
            }
            case "savebtn": {
                this.save();
                break;
            }
            case "enablebtn": {
                this.changeState(true);
                break;
            }
            case "disablebtn": {
                this.changeState(false);
                break;
            }
            case "deletebtn": {
                this.delete();
                break;
            }
            case "condition": {
                this.openCondition();
                break;
            }
            case "checkbtn": {
                this.check();
                break;
            }
            case "autotest": {
                this.autoTest();
                break;
            }
            case "showplans": {
                this.showPlans();
                break;
            }
            case "synctoide": {
                this.syncToIDEConfirm();
                break;
            }
            case "exportimage": {
                this.exportImage();
                break;
            }
            case "compareversiondifferences": {
                this.compareVersionDifferences();
                break;
            }
        }
    }

    private void exportImage() {
        String number = (String)this.getModel().getValue(FIELD_NUMBER);
        this.getDesigner().exportImage(this.getView(), number);
    }

    private void openCondition() {
        String id = this.getPageCache().get(CONDITION_ID);
        if (id != null) {
            Long procDefId = (Long)this.getView().getFormShowParameter().getCustomParam("procDefId");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("procDefId", procDefId);
            params.put("openType", "managermentCenter");
            String type = ConditionalRuleType.configScheme.toString();
            params.put("type", type);
            String value = this.getPageCache().get(CONDITION_VALUE);
            if (value != null) {
                params.put("value", value);
            } else {
                params.put("condruleid", id);
            }
            String caption = ConditionalRuleType.getTypeName((String)type);
            FormShowParameter parameter = this.getShowParameter("wf_conditionrule_update", "wf_conditionrule_update", caption, params);
            parameter.setShowTitle(false);
            this.getView().showForm(parameter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6253\u5f00\u6761\u4ef6\u89c4\u5219\u3002", (String)"WorkflowDynamicConfigSchemePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void changeState(boolean enable) {
        block11: {
            if (this.canNotDoOperation()) {
                this.getView().showErrorNotification(WFMultiLangConstants.getNotAdminForOperation());
                return;
            }
            if (enable) {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"4730fc5d000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u542f\u7528\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDynamicConfigSchemePlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                String modelJson = this.getGraphModel().getBpmnModelJson();
                SelectedScheme selected = this.getSelectSchemeInfo();
                DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)this.getRepositoryService().findEntityById(selected.getSchemeId(), "wf_processdynamicconfig");
                try {
                    BpmnModel bpmnModel = DesignerModelUtil.getBpmnModel(modelJson);
                    String condRuleStr = this.getPageCache().get(CONDITION_VALUE);
                    ConditionalRuleEntity condRule = null;
                    if (WfUtils.isNotEmpty((String)condRuleStr)) {
                        condRule = ConditionalRuleConvertUtil.jsonToConditionalRuleModel((String)condRuleStr);
                    } else if (WfUtils.isNotEmpty((Long)scheme.getConditionId())) {
                        condRule = this.getRepositoryService().getConditionalRuleById(scheme.getConditionId());
                    }
                    List result = this.getRepositoryService().validateProcesses(bpmnModel, condRule);
                    if (null != result && !result.isEmpty()) {
                        DesignerModelUtil.showProcessValidateInfo(this, result, ENABLE_SCHEME);
                        break block11;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u542f\u7528\u6b64\u65b9\u6848\uff1f", (String)"WorkflowDynamicConfigSchemePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(ENABLE_SCHEME));
                }
                catch (Exception e) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u914d\u7f6e\u65b9\u6848\u6821\u9a8c\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"WorkflowDynamicConfigSchemePlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
            } else {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"47160c2b000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7981\u7528\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDynamicConfigSchemePlugin_31", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u7981\u7528\u6b64\u65b9\u6848\uff1f", (String)"WorkflowDynamicConfigSchemePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DISABLE_SCHEME));
            }
        }
    }

    private void delete() {
        if (this.canNotDoOperation()) {
            this.getView().showErrorNotification(WFMultiLangConstants.getNotAdminForOperation());
            return;
        }
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"/8M2NEU9PFQV")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5220\u9664\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDynamicConfigSchemePlugin_32", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6b64\u65b9\u6848\uff1f", (String)"WorkflowDynamicConfigSchemePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_SCHEME));
    }

    private void showChangeStatueConfirm() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6821\u9a8c\u51fa\u6709\u9519\u8bef\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u542f\u7528\uff1f", (String)"WorkflowDynamicConfigSchemePlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(ENABLE_SCHEME));
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        SelectedScheme selected = this.getSelectSchemeInfo();
        switch (evt.getCallBackId()) {
            case "delete_scheme": {
                this.deleteScheme(selected);
                break;
            }
            case "enable_scheme": {
                this.updateSchemeState(selected, true);
                break;
            }
            case "disable_scheme": {
                this.updateSchemeState(selected, false);
                break;
            }
            case "syncToIDEConfirm": {
                this.syncToIDE();
                break;
            }
            case "continueWhenFailed": {
                this.continueWhenFailed();
                break;
            }
            case "stillSaveWhenConditionChanged": {
                this.stillSaveWhenConditionChanged();
            }
        }
    }

    private void stillSaveWhenConditionChanged() {
        this.save("true");
    }

    private void continueWhenFailed() {
        this.save(true);
    }

    private void deleteScheme(SelectedScheme scheme) {
        try {
            this.getManagementService().deleteDynamicConfigScheme(scheme.getSchemeId());
            this.getModel().deleteEntryRow(CARD_SCHEME_LIST, scheme.getIndex());
        }
        catch (WFException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void updateSchemeState(SelectedScheme selected, boolean enable) {
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)this.getRepositoryService().findEntityById(selected.getSchemeId(), "wf_processdynamicconfig");
        if (scheme.isAcquiescence()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u542f\u7528\u6216\u7981\u7528\u9ed8\u8ba4\u65b9\u6848\u3002", (String)"WorkflowDynamicConfigSchemePlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String state = enable ? "enable" : "disable";
        scheme.setState(state);
        this.getManagementService().updateDynamicConfigScheme(scheme);
        this.getModel().setValue(FIELD_STATUS, this.getStateName(state));
        this.getModel().setValue(CARD_STATE, this.getStateName(state), selected.getIndex());
        this.switchBtnState(scheme.isAcquiescence(), state);
        String opKey = enable ? "enableScheme" : "disableScheme";
        WfUtils.addOpLog((String)"wf_processdynamicconfig", (String)opKey, (MultiLangEnumBridge)(enable ? new MultiLangEnumBridge("\u542f\u7528\u65b9\u6848", "WorkflowDynamicConfigSchemePlugin_9", "bos-wf-formplugin") : new MultiLangEnumBridge("\u7981\u7528\u65b9\u6848", "WorkflowDynamicConfigSchemePlugin_10", "bos-wf-formplugin")), (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b9\u6848ID: %1$s \u540d\u79f0: %2$s \u7f16\u7801: %3$s", "WorkflowDynamicConfigSchemePlugin_11", "bos-wf-formplugin"), (Object[])new Object[]{scheme.getId(), scheme.getName().toString(), scheme.getNumber()});
    }

    private void selectScheme(int rowIndex) {
        CardEntry schemeList = (CardEntry)this.getControl(CARD_SCHEME_LIST);
        schemeList.selectRows(rowIndex);
    }

    protected SelectedScheme getSelectSchemeInfo() {
        CardEntry schemeList = (CardEntry)this.getControl(CARD_SCHEME_LIST);
        int[] selectRows = schemeList.getSelectRows();
        int index = selectRows[0];
        DynamicObject entity = this.getModel().getEntryRowEntity(CARD_SCHEME_LIST, index);
        String schemeId = entity.getString(CARD_SCHEMEID);
        String schemeName = entity.getString(CARD_NAME);
        return new SelectedScheme(index, Long.valueOf(schemeId), schemeName);
    }

    private void addScheme() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (WfAdminUtil.controlBtnByAdmin((Long)userId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6d41\u7a0b\u7ba1\u7406\u5458\u4e0d\u53ef\u65b0\u589e\u5b50\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"WorkflowDynamicConfigSchemePlugin_40", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"/8M2NEU9PFQV")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u65b0\u589e\u6d41\u7a0b\u65b9\u6848\u201d\u6743\u9650\u3002", (String)"WorkflowDynamicConfigSchemePlugin_33", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = "wf_dynamicconfigscheme";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("procDefId", this.getView().getFormShowParameter().getCustomParam("procDefId"));
        this.showForm(formId, formId, params);
    }

    private void saveScheme(String modelJson) {
        SelectedScheme selected = this.getSelectSchemeInfo();
        String index = this.getPageCache().get(LAST_SCHEME_INDEX);
        if (index != null && !index.equals(String.valueOf(selected.getIndex()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u4fdd\u5b58\u7684\u65b9\u6848\u4e0e\u5de6\u4fa7\u65b9\u6848\u5217\u8868\u4e2d\u9009\u4e2d\u7684\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b9\u6848\u3002", (String)"WorkflowDynamicConfigSchemePlugin_36", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)this.getRepositoryService().findEntityById(selected.getSchemeId(), "wf_processdynamicconfig");
        Object description = this.getModel().getValue(FIELD_DESCRIPTION);
        Object name = this.getModel().getValue(FIELD_NAME);
        Object number = this.getModel().getValue(FIELD_NUMBER);
        scheme.setName((ILocaleString)name);
        scheme.setNumber((String)number);
        scheme.setDescription((ILocaleString)description);
        if (scheme.getDescription() != null) {
            this.getModel().setValue(CARD_DESCRIPTION, (Object)scheme.getDescription().getLocaleValue(), selected.getIndex());
            this.getModel().setValue(CARD_NAME, (Object)scheme.getName().getLocaleValue(), selected.getIndex());
        }
        String origModelJson = this.getPageCache().get(ORIG_MODEL_JSON);
        String initedPropertiesStr = this.getPageCache().get("initialized_property");
        Set initedPropsSet = Collections.emptySet();
        if (WfUtils.isNotEmpty((String)initedPropertiesStr)) {
            initedPropsSet = (Set)SerializationUtils.fromJsonString((String)initedPropertiesStr, Set.class);
        }
        this.getManagementService().updateDynamicConfigScheme(scheme, modelJson, origModelJson, this.getPageCache().get(CONDITION_VALUE), initedPropsSet);
    }

    private void check() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u6821\u9a8c\u201d\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String modelJson = this.getGraphModel().getBpmnModelJson();
        SelectedScheme selected = this.getSelectSchemeInfo();
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)this.getRepositoryService().findEntityById(selected.getSchemeId(), "wf_processdynamicconfig");
        try {
            BpmnModel bpmnModel = DesignerModelUtil.getBpmnModel(modelJson);
            String condRuleStr = this.getPageCache().get(CONDITION_VALUE);
            ConditionalRuleEntity condRule = null;
            if (WfUtils.isNotEmpty((String)condRuleStr)) {
                condRule = ConditionalRuleConvertUtil.jsonToConditionalRuleModel((String)condRuleStr);
            } else if (WfUtils.isNotEmpty((Long)scheme.getConditionId())) {
                condRule = this.getRepositoryService().getConditionalRuleById(scheme.getConditionId());
            }
            List result = this.getRepositoryService().validateProcesses(bpmnModel, condRule);
            DesignerModelUtil.showProcessValidateInfo(this, result);
            this.fireAfterCheckDigram(result, KEY_SCHEME);
        }
        catch (Exception e) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u914d\u7f6e\u65b9\u6848\u6821\u9a8c\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"WorkflowDynamicConfigSchemePlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        this.showBlock(false, this.getView());
    }

    private void autoTest() {
        IFormView openedView;
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"1//JGEENPGO0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u6a21\u62df\u6d4b\u8bd5\u201d\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        SelectedScheme selected = this.getSelectSchemeInfo();
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)this.getRepositoryService().findEntityById(selected.getSchemeId(), "wf_processdynamicconfig");
        String cacheKey = String.format("%s_%s", KEY_OPENED_PAGE_ID, scheme.getId().toString());
        String openedPageId = this.getPageCache().get(cacheKey);
        if (null != openedPageId && (openedView = this.getView().getView(openedPageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        IFormView parentView = DesignerModelUtil.getTabControlView(this.getView());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("schemeId", (Object)scheme.getId());
        parameter.setCustomParam("sp", (Object)"dynamicScheme");
        parameter.setFormId("wf_testinginput");
        if (parentView != null) {
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setStatus(OperationStatus.EDIT);
            parentView.showForm(parameter);
            this.getView().sendFormAction(parentView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        }
        this.getPageCache().put(cacheKey, parameter.getPageId());
    }

    private void showPlans() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d4b\u8bd5\u8ba1\u5212\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"WorkflowDynamicConfigSchemePlugin_26", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        SelectedScheme selected = this.getSelectSchemeInfo();
        Long schemeId = selected.getSchemeId();
        String ids = this.getPageCache().get(KEY_OPENED_PLAN_LIST_ID);
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String idStr = String.valueOf(schemeId);
        String pageId = null;
        IFormView openedView = null;
        pageId = (String)idsMap.get(idStr);
        if (pageId != null && (openedView = this.getView().getView(pageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        QFilter qFilter = new QFilter("newschemeid", "=", (Object)schemeId);
        QFilter[] filters = new QFilter[]{qFilter};
        List retList = this.getRepositoryService().findEntitiesByFilters("wf_testingplan", filters);
        if (null != retList && !retList.isEmpty()) {
            IFormView settingsFormView = DesignerModelUtil.getTabControlView(this.getView());
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("wf_testingplan");
            parameter.setFormId("bos_list");
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            if (settingsFormView != null) {
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setCustomParam("isOpenNewTab", (Object)true);
                parameter.setCustomParam("sp", (Object)"dynamicScheme");
                parameter.setMultiSelect(true);
                settingsFormView.showForm((FormShowParameter)parameter);
                this.getView().sendFormAction(settingsFormView);
            } else {
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            }
            idsMap.put(idStr, parameter.getPageId());
            this.getPageCache().put(KEY_OPENED_PLAN_LIST_ID, SerializationUtils.toJsonString(idsMap));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5386\u53f2\u6d4b\u8bd5\u8ba1\u5212\u4e3a\u7a7a\u3002", (String)"WorkflowDynamicConfigSchemePlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    public void save() {
        this.save("false");
    }

    public void save(String force) {
        if ("true".equals(force)) {
            this.save(false);
            this.cacheConditionModifyTime();
        } else if (this.checkStartupConditionModifyState()) {
            this.save(false);
            this.cacheConditionModifyTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean continueWhenFailed) {
        boolean showFatalError;
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"/8M2NEU9PFQV")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u52a8\u6001\u914d\u7f6e\u65b9\u6848\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\u3002", (String)"WorkflowDynamicConfigSchemePlugin_29", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String modelJson = this.getGraphModel().getBpmnModelJson();
        String number = (String)this.getModel().getValue(FIELD_NUMBER);
        String result = this.validate(number);
        JSONObject modelJsonObject = JSON.parseObject((String)modelJson);
        JSONObject properties = modelJsonObject.getJSONObject("properties");
        String businessId = properties.getString(FIELD_BUSINESSID);
        businessId = StringUtils.isBlank((CharSequence)businessId) ? number : String.valueOf(businessId);
        Object orgUnitId = properties.get((Object)FIELD_ORGUNITID);
        if (!this.canDoOperation(Long.valueOf(orgUnitId.toString()))) {
            this.getView().showErrorNotification(WFMultiLangConstants.getNotAdminForOperation());
            return;
        }
        boolean isExistCurrentNodeInst = this.isPermitSwitch(modelJsonObject);
        if (isExistCurrentNodeInst) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5207\u6362\u4f1a\u7b7e\u6a21\u5f0f\u540e\uff0c\u4f1a\u5ba1\u4efb\u52a1\u672a\u5904\u7406\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"WorkflowDynamicConfigSchemePlugin_38", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (result != null && !this.getPageCache().get("schemeNumber").equals(number)) {
            this.getPageCache().put("schemeNumber", number);
            this.clearDataChanged();
            this.getView().showTipNotification(result);
            return;
        }
        boolean canSave = this.fireBeforeSaveDigram();
        if (!canSave) {
            return;
        }
        if (!continueWhenFailed && (showFatalError = DesignerModelUtil.showFatalValidateError(this.getGraphModel().getBpmnModelJson(), this, "validateWhenSave"))) {
            return;
        }
        try {
            MutexResult mutexResult = BatchSettingUtil.requireBatchSettingMutexLock((String)"save_dynamic_scheme");
            if (!mutexResult.isSuccess()) {
                BatchSettingUtil.showRequireFailedTip((IFormView)this.getView(), (MutexResult)mutexResult);
                return;
            }
            this.saveScheme(modelJson);
        }
        finally {
            BatchSettingUtil.releaseBatchSettingMutexLock((String)"save_dynamic_scheme");
        }
        this.getPageCache().put("schemeNumber", number);
        this.clearDataChanged();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WorkflowDynamicConfigSchemePlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.fireAfterSaveDigram(this.getPageCache().get(PROCESSNUMBER), this.getPageCache().get(PROCESSVERSION), KEY_SCHEME);
        this.getPageCache().put(ORIG_MODEL_JSON, modelJson);
    }

    protected boolean isPermitSwitch(JSONObject modelJsonObject) {
        JSONArray childShapes = (JSONArray)modelJsonObject.get((Object)"childShapes");
        ArrayList<String> jointResourceIds = new ArrayList<String>();
        if (childShapes != null && !childShapes.isEmpty()) {
            for (Object childShape : childShapes) {
                JSONObject childShapeJson = (JSONObject)childShape;
                if (childShapeJson == null) continue;
                String resourceId = childShapeJson.getString("resourceId");
                String resourceIdCache = this.getPageCache().get(resourceId + "ModifySignType");
                if (!WfUtils.isNotEmpty((String)resourceIdCache)) continue;
                jointResourceIds.add(resourceId);
                this.getPageCache().put(resourceId + "ModifySignType", null);
            }
        }
        if (jointResourceIds == null || jointResourceIds.isEmpty()) {
            return false;
        }
        boolean isPermitSwitch = false;
        String schemeIdstr = (String)this.getModel().getValue(CARD_SCHEMEID);
        long schemeId = WfUtils.isEmpty((String)schemeIdstr) ? 0L : Long.parseLong(schemeIdstr);
        QFilter executionFilter1 = new QFilter(CARD_SCHEMEID, "=", (Object)schemeId);
        QFilter[] executionFilters = new QFilter[]{executionFilter1};
        DynamicObjectCollection executionIdDyColle = QueryServiceHelper.query((String)"wf_execution", (String)"id", (QFilter[])executionFilters);
        if (executionIdDyColle == null || executionIdDyColle.isEmpty()) {
            return false;
        }
        ArrayList<Long> executionIdList = new ArrayList<Long>(executionIdDyColle.size());
        for (DynamicObject executionIdDy : executionIdDyColle) {
            executionIdList.add(executionIdDy.getLong("id"));
        }
        QFilter taskFilter1 = new QFilter("taskdefinitionkey", "in", jointResourceIds);
        QFilter taskFilter2 = new QFilter("executionid", "in", executionIdList);
        QFilter[] taskFilters = new QFilter[]{taskFilter1, taskFilter2};
        isPermitSwitch = QueryServiceHelper.exists((String)"wf_task", (QFilter[])taskFilters);
        return isPermitSwitch;
    }

    private boolean checkStartupConditionModifyState() {
        if (!Boolean.parseBoolean(this.getPageCache().get(KEY_IS_BIZFLOW))) {
            return true;
        }
        String configId = this.getPageCache().get(KEY_PROCESSCONFIG_ID);
        if (WfUtils.isEmpty((String)configId)) {
            return true;
        }
        Long id = Long.valueOf(configId);
        String modifyTime = this.getPageCache().get(KEY_PROCESSCONFIG_MODIFYTIME);
        ProcessConfigEntity entity = (ProcessConfigEntity)this.getRepositoryService().findEntityById(id, "wf_processconfig", "modifyDate");
        if (entity != null && !String.valueOf(entity.getModifyDate().getTime()).equals(modifyTime)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6d41\u7a0b\u542f\u52a8\u6761\u4ef6\u5df2\u88ab\u4fee\u6539\uff0c\u5efa\u8bae\u60a8\u91cd\u65b0\u6253\u5f00\u6d41\u7a0b\u65b9\u6848\u3002\u5982\u679c\u7ee7\u7eed\u4fdd\u5b58\u65b9\u6848\u5c06\u4f1a\u8986\u76d6\u542f\u52a8\u6761\u4ef6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"WorkflowDynamicConfigSchemePlugin_37", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(STILLSAVE_WHEN_CONDITIONCHANGED));
            return false;
        }
        return true;
    }

    private boolean fireBeforeSaveDigram() {
        try {
            GraphCell model;
            GraphCell graphCell = model = this.getGraphModel() == null ? null : this.getGraphModel().getRootCell();
            if (model != null) {
                BeforeSaveDigramEvent evt = new BeforeSaveDigramEvent(this.getView(), KEY_SCHEME, "beforeSaveDigram", null, model.getChildShapes());
                FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
                proxy.fireCustomEvent((CustomEventArgs)evt);
                return !evt.isCancel();
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        this.getPageCache().remove("participantRearrangement");
        String loaded = this.getPageCache().get(WORKFLOW_JSFILE_LOADED);
        if (loaded == null) {
            ((SplitContainer)this.getControl(CONTAINER_SPLIT)).setCollapse(PANEL_SPLIT, true);
            ((SplitContainer)this.getControl(CONTAINER_SCHEMESPLITCONTAINER)).setCollapse(PANEL_SCHEMEINFO, true);
        }
        this.getPageCache().put(WORKFLOW_JSFILE_LOADED, "true");
        String procDefId = (String)params.get("procDefId");
        Long schemeId = null;
        if (WfUtils.isNotEmpty((String)procDefId)) {
            QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)Long.valueOf(procDefId)), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
            List schemes = this.getManagementService().getDynamicConfigSchemeByFilters(filters);
            schemeId = ((DynamicConfigSchemeEntity)schemes.get(0)).getId();
        } else if (WfUtils.isNotEmptyString((Object)params.get("config_scheme_id"))) {
            schemeId = Long.valueOf((String)params.get("config_scheme_id"));
        }
        if (WfUtils.isEmpty(schemeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u8bbe\u8ba1\u5668\u6240\u9700\u914d\u7f6e\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowDynamicConfigSchemePlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return null;
        }
        String modelJson = this.getManagementService().getDynamicConfigSchemeModelString(schemeId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)modelJson);
        this.getPageCache().put(ORIG_MODEL_JSON, modelJson);
        HashMap<String, Object> result = new HashMap<String, Object>();
        GraphCodecContext ctx = new GraphCodecContext(bpmnModel);
        ctx.setConfigScheme(true);
        Long processDefinitionId = 0L;
        if (WfUtils.isEmpty((String)procDefId)) {
            DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)this.getRepositoryService().findEntityById(schemeId, "wf_processdynamicconfig");
            if (scheme != null) {
                processDefinitionId = scheme.getProcDefId();
            }
        } else {
            processDefinitionId = Long.valueOf(procDefId);
        }
        String xml = this.getInitGraphXml(null, processDefinitionId, schemeId, modelJson, ctx);
        result.put("graph_xml", xml);
        result.put("flowType", bpmnModel.getMainProcess().getProcessType());
        Object cellId = params.get("selected_cellId");
        if (cellId != null && bpmnModel.getFlowElement((String)cellId) != null) {
            result.put("selected_cellId", cellId);
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getConfigurePanelId("Diagram").toLowerCase()});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{TOOLBAR});
        this.showBlock(false, this.getView());
        return result;
    }

    @Override
    protected boolean isNodeChanged(String type, String itemId, String nodeId) {
        boolean schemeChanged = "true".equals(this.getPageCache().get(SCHEME_CHANGED));
        return schemeChanged || super.isNodeChanged(type, itemId, nodeId);
    }

    @Override
    protected String getDesignerFormId() {
        return "wf_processconfig_scheme";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (FIELD_CONDITION.equals(name) && (newValue == null || "".equals(newValue.toString().trim()))) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u9002\u7528\u6761\u4ef6\u4e0d\u80fd\u5220\u9664\u3002", (String)"WorkflowDynamicConfigSchemePlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(FIELD_CONDITION, oldValue);
        } else {
            super.propertyChanged(e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "wf_dynamicconfigscheme": {
                this.updateSchemeList(returnData);
                break;
            }
            case "wf_conditionrule_update": {
                this.setConditionValue(returnData);
                break;
            }
            case "enable_scheme": {
                this.showChangeStatueConfirm();
                break;
            }
            case "validateWhenSave": {
                this.validationInfoCallBack(returnData);
            }
        }
    }

    protected void validationInfoCallBack(Object returnData) {
        if (!"true".equals(returnData)) {
            return;
        }
        Object continueWhenFailed = WfConfigurationUtil.getConfigCenterVal((String)"workflow.config.continueWhenValidateFailed");
        this.log.debug("continue when validate failed: " + continueWhenFailed);
        if ("true".equals(continueWhenFailed)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6821\u9a8c\u51fa\u6709\u9519\u8bef\u4fe1\u606f\uff0c\u786e\u8ba4\u4fdd\u5b58\uff1f", (String)"WorkflowDynamicConfigSchemePlugin_35", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONTINUEWHENFAILED));
        }
    }

    private void updateSchemeList(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            Long schemeId = (Long)data.get("id");
            Map name = (Map)data.get(FIELD_NAME);
            Map description = (Map)data.get(FIELD_DESCRIPTION);
            int index = this.getModel().createNewEntryRow(CARD_SCHEME_LIST);
            this.getModel().setValue(CARD_SCHEMEID, (Object)schemeId, index);
            this.getModel().setValue(CARD_NAME, name.get(RequestContext.get().getLang().toString()), index);
            this.getModel().setValue(CARD_DESCRIPTION, description.get(RequestContext.get().getLang().toString()), index);
            this.getModel().setValue(CARD_STATE, this.getStateName("disable"), index);
            this.selectScheme(index);
        }
    }

    private void setConditionValue(Object returnData) {
        if (returnData instanceof String) {
            String json = (String)returnData;
            ConditionalRuleEntity entity = ConditionalRuleConvertUtil.jsonToConditionalRuleModel((String)json);
            this.getModel().setValue(FIELD_CONDITION, (Object)entity.getShowtext().getLocaleValue());
            this.getPageCache().put(CONDITION_VALUE, json);
        }
    }

    @Override
    public void handleCustomEvent(String type, Map<String, Object> param) {
        if ("downloadFlowChart".equals(type)) {
            this.exportImage();
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(LAST_SCHEME_INDEX);
        this.getPageCache().remove(SCHEME_CHANGED);
        this.getPageCache().remove(CONDITION_ID);
        this.getPageCache().remove(IS_SCHEME_INIT);
        this.getPageCache().remove(KEY_NETMUTUALEXCLUSION);
        this.getPageCache().remove("isDefaultScheme");
        this.getPageCache().remove("schemeId");
        this.getPageCache().remove(WORKFLOW_JSFILE_LOADED);
        this.getPageCache().remove(ORIG_MODEL_JSON);
        this.getPageCache().remove(KEY_PROCESSCONFIG_ID);
        this.getPageCache().remove(KEY_PROCESSCONFIG_MODIFYTIME);
    }

    @Override
    protected String getType() {
        return "scheme";
    }

    private String validate(String number) {
        if (!PluginUtil.matchPattern("^[A-Za-z][A-Za-z0-9_]*$", number)) {
            return ResManager.loadKDString((String)"\u201c\u65b9\u6848\u7f16\u7801\u201d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"WorkflowDynamicConfigSchemePlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        String lowerNumber = number.toLowerCase();
        if (lowerNumber.matches("((^[\\w]+)_sync)\\d*$")) {
            return ResManager.loadKDString((String)"\u201c\u65b9\u6848\u7f16\u7801\u201d\u4e0d\u80fd\u4ee5\u201c_sync+\u6570\u5b57\u201d\u7ed3\u5c3e\u3002", (String)"WorkflowDynamicConfigSchemePlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        ManagementService service = this.getManagementService();
        QFilter[] filters = new QFilter[]{new QFilter(FIELD_NUMBER, "=", (Object)number)};
        Long count = service.getConfigSchemeCountByFilters(filters);
        if (count > 0L) {
            return ResManager.loadKDString((String)"\u201c\u65b9\u6848\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"WorkflowDynamicConfigSchemePlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void syncToIDEConfirm() {
        if (this.canNotDoOperation()) {
            this.getView().showErrorNotification(WFMultiLangConstants.getNotAdminForOperation());
            return;
        }
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"/8M2NEU9PFQV")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u540c\u6b65\u81f3\u8bbe\u8ba1\u5668\u201d\u6743\u9650\u3002", (String)"WorkflowDynamicConfigSchemePlugin_28", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u540c\u6b65\u540e\uff0c\u6d41\u7a0b\u9ed8\u8ba4\u65b9\u6848\u5c06\u4f1a\u66ff\u6362\u8bbe\u8ba1\u4e2d\u5fc3\u5185\u76f8\u540c\u7f16\u7801\u7684\u6d41\u7a0b\uff0c\u786e\u8ba4\u540c\u6b65\uff1f", (String)"WorkflowDynamicConfigSchemePlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SYNCTOIDECONFIRM));
    }

    private void syncToIDE() {
        SelectedScheme selected = this.getSelectSchemeInfo();
        Boolean retFlag = this.getRepositoryService().syncDynResourceDataToModel(selected.getSchemeId());
        MultiLangEnumBridge descBridge = null;
        String message = "";
        if (retFlag.booleanValue()) {
            descBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "WorkflowDynamicConfigSchemePlugin_24", "bos-wf-formplugin");
            message = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"WorkflowDynamicConfigSchemePlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(message);
        } else {
            descBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\u3002", "WorkflowDynamicConfigSchemePlugin_25", "bos-wf-formplugin");
            message = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"WorkflowDynamicConfigSchemePlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
        }
        WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)"wf_processconfig_scheme", (String)BTN_SYNCTOIDE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u540c\u6b65\u81f3\u8bbe\u8ba1\u4e2d\u5fc3", "WorkflowDynamicConfigSchemePlugin_39", "bos-wf-formplugin"), (MultiLangEnumBridge)descBridge, (Object[])new Object[0]);
    }

    private void compareVersionDifferences() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u65b9\u6848\u5dee\u5f02\u5bf9\u6bd4\u201d\u6743\u9650\u3002", (String)"WorkflowDynamicConfigSchemePlugin_27", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        SelectedScheme selectedScheme = this.getSelectSchemeInfo();
        Long schemeId = selectedScheme.getSchemeId();
        String ids = this.getPageCache().get(OPENED_VERSION_DIFF_IDS);
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String idStr = String.valueOf(schemeId);
        String pageId = (String)idsMap.get(idStr);
        IFormView openedView = this.getView().getView(pageId);
        if (pageId != null && openedView != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_version_diff");
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.setCustomParam("parentPage", (Object)"dynamicConfigScheme");
        parameter.setCustomParam("schemeId", (Object)schemeId);
        parameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u5dee\u5f02\u5bf9\u6bd4", (String)"WorkflowDynamicConfigSchemePlugin_34", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
        idsMap.put(idStr, parameter.getPageId());
        this.getPageCache().put(OPENED_VERSION_DIFF_IDS, SerializationUtils.toJsonString(idsMap));
    }

    private boolean isNetMutuallyExclusiveAllowed() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long procDefId = (Long)parameter.getCustomParam("procDefId");
        StringBuilder failInfo = new StringBuilder();
        boolean isAllowed = MutexHelper.require((IFormView)this.getView(), (String)"wf_processdefinition", (Object)procDefId, (String)"donothing", (boolean)false, (StringBuilder)failInfo);
        if (!isAllowed) {
            this.getView().showTipNotification(failInfo.toString());
        }
        return isAllowed;
    }

    private void setMutexInfosInPageCache() {
        IPageCache pageCache = this.getPageCache();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long procDefId = (Long)parameter.getCustomParam("procDefId");
        pageCache.put("MUTEX_ENTITY_KEY", "wf_processdefinition");
        pageCache.put("MUTEX_OPER_KEY", "donothing");
        pageCache.put("MUTEX_OBJ_ID", String.valueOf(procDefId));
    }

    private void checkNetMutExclusive() {
        if (WfConfigurationUtil.isNetMutuallyExclusiveOpened() && !this.isNetMutuallyExclusiveAllowed()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_DELETE, BTN_ADDSCHEME, BTN_SYNCTOIDE});
            this.getPageCache().put(KEY_NETMUTUALEXCLUSION, "true");
            return;
        }
        this.setMutexInfosInPageCache();
    }

    @Override
    public List<Map<String, Object>> getListPropertyValue(String nodeId, String property) {
        GraphModel graphModel = this.getGraphModel();
        return BizFlowPluginUtil.getListPropertyValue(graphModel, nodeId, property);
    }

    @Override
    public void setObjectProperty(String nodeId, String property, Object value) {
        GraphModel graphModel = this.getGraphModel();
        GraphCell cell = graphModel.getGraphCell(nodeId);
        if (cell != null) {
            BpmnModelUtil.setProperty((Map)cell.getProperties(), (String)property, (Object)value);
            this.cacheModelJson();
        }
    }

    private boolean canNotDoOperation() {
        String modelJson = this.getGraphModel().getBpmnModelJson();
        JSONObject properties = JSON.parseObject((String)modelJson).getJSONObject("properties");
        Object orgUnitId = properties.get((Object)FIELD_ORGUNITID);
        return !this.canDoOperation(Long.valueOf(orgUnitId.toString()));
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }
}

