/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;

public class DelegateSettingUtil {
    private static final String DELEGATESETTING = "delegate";
    private static final String EXISTSMUTUALDELEGATE = "bos.wf.existsMutualDelegate";
    private static final String EXISTSDELEGATERING = "bos.wf.existsDelegateRing";

    private DelegateSettingUtil() {
    }

    public static boolean isOpenFromMessageCenter(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        String delegate = (String)customParams.get(DELEGATESETTING);
        return !WfUtils.isEmpty((String)delegate);
    }

    public static boolean existDelegateRing(Long curDelegateId, Long assignorId, Long trusteeId, IFormView view, boolean isListEnable) {
        block3: {
            try {
                WorkflowService wfService = WfUtils.getWfService();
                ManagementService managementService = wfService.getManagementService();
                managementService.validateDelegateSetting(curDelegateId, assignorId, trusteeId);
            }
            catch (KDBizException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (!EXISTSMUTUALDELEGATE.equals(errorCode.getCode()) && !EXISTSDELEGATERING.equals(errorCode.getCode())) break block3;
                String notification = errorCode.getMessage();
                if (isListEnable) {
                    notification = String.format(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c%s\u3002", (String)"DelegateSettingUtil_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), notification);
                }
                view.showErrorNotification(notification);
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> existDelegateRing(Long curDelegateId, Long assignorId, Long trusteeId, boolean isListEnable) {
        HashMap<String, Object> resultMap;
        block3: {
            resultMap = new HashMap<String, Object>(2);
            try {
                WorkflowService wfService = WfUtils.getWfService();
                ManagementService managementService = wfService.getManagementService();
                managementService.validateDelegateSetting(curDelegateId, assignorId, trusteeId);
            }
            catch (KDBizException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (!EXISTSMUTUALDELEGATE.equals(errorCode.getCode()) && !EXISTSDELEGATERING.equals(errorCode.getCode())) break block3;
                String notification = errorCode.getMessage();
                if (isListEnable) {
                    notification = String.format(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c%s\u3002", (String)"DelegateSettingUtil_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), notification);
                }
                resultMap.put("reslut", true);
                resultMap.put("message", notification);
                return resultMap;
            }
        }
        resultMap.put("reslut", false);
        return resultMap;
    }
}

