/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MasterIdField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;

public class TreeBuilderUtil {
    public static TreeNode buildEntityTree(EntityMetadata entityMetadata, Map<String, Object> params) {
        MainEntity rootEntity = entityMetadata.getRootEntity();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootEntity.getKey());
        root.setIsOpened(true);
        root.setData((Object)rootEntity.getId());
        if (rootEntity.getName() == null) {
            root.setText(rootEntity.getKey());
        } else {
            root.setText(rootEntity.getName().toString());
        }
        List entitys = entityMetadata.getEntitys();
        Boolean isHideSubEntry = params.get("isHideSubEntry") != null ? (Boolean)params.get("isHideSubEntry") : Boolean.FALSE;
        Boolean isHideEntry = params.get("isHideEntry") != null ? (Boolean)params.get("isHideEntry") : Boolean.FALSE;
        for (Entity entity : entitys) {
            TreeNode entityNode;
            if (isHideEntry.booleanValue() && entity instanceof EntryEntity || isHideSubEntry.booleanValue() && entity instanceof SubEntryEntity || (entityNode = TreeBuilderUtil.buildEntityAndFields(entity, rootEntity, params)).getChildren() == null || entityNode.getChildren().isEmpty()) continue;
            root.addChild(entityNode);
        }
        return root;
    }

    private static TreeNode buildEntityAndFields(Entity<?, ?> entity, MainEntity rootEntity, Map<String, Object> params) {
        TreeNode entityNode = TreeBuilderUtil.buildEntityNode(entity, rootEntity);
        List items = entity.getItems();
        items.forEach(entityItem -> {
            if (!(entityItem instanceof Field) || !TreeBuilderUtil.canAddField((Field)entityItem, params)) {
                return;
            }
            if (entityItem instanceof MulBasedataField) {
                TreeNode muliBDFldNode = TreeBuilderUtil.buildMuliBaseFieldNode((MulBasedataField)entityItem, entityNode, params);
                entityNode.addChild(muliBDFldNode);
                return;
            }
            if (entityItem instanceof BasedataField) {
                TreeNode bdFldNode = TreeBuilderUtil.buildBaseFieldNode((AbstractBasedataField)entityItem, entityNode, params);
                entityNode.addChild(bdFldNode);
                return;
            }
            if (entityItem instanceof MasterIdField && ((MasterIdField)entityItem).getMasterIdType() == 2) {
                TreeNode bdFldNode = TreeBuilderUtil.buildBaseFieldNode((AbstractBasedataField)entityItem, entityNode, params);
                entityNode.addChild(bdFldNode);
                return;
            }
            List<TreeNode> childNodes = TreeBuilderUtil.buildPropNodes((Field)entityItem, entityNode);
            for (TreeNode node : childNodes) {
                entityNode.addChild(node);
            }
        });
        return entityNode;
    }

    private static boolean canAddField(Field<?> entityItem, Map<String, Object> params) {
        Object onlyDateFieldType = params.get("onlyDateFieldType");
        if (onlyDateFieldType != null && ((Boolean)onlyDateFieldType).booleanValue() && !(entityItem instanceof DateTimeField)) {
            return false;
        }
        Object onlyBigDecimalFieldType = params.get("onlyBigDecimalFieldType");
        if (onlyBigDecimalFieldType != null && ((Boolean)onlyBigDecimalFieldType).booleanValue() && !(entityItem instanceof DecimalField)) {
            return false;
        }
        Object filterDateAndBigDecimalType = params.get("filterDateAndBigDecimalType");
        if (filterDateAndBigDecimalType != null && ((Boolean)filterDateAndBigDecimalType).booleanValue() && (entityItem instanceof DecimalField || entityItem instanceof DateTimeField)) {
            return false;
        }
        Object ingnoreFieldArr = params.get("ingnoreFieldArr");
        if (ingnoreFieldArr != null) {
            Class[] classArr;
            for (Class classObj : classArr = (Class[])ingnoreFieldArr) {
                if (!entityItem.getClass().equals(classObj) && !classObj.isAssignableFrom(entityItem.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    private static TreeNode buildEntityNode(Entity<?, ?> entity, MainEntity rootEntity) {
        TreeNode entityNode = new TreeNode();
        if (entity instanceof MainEntity) {
            entityNode.setParentid(rootEntity.getKey());
            entityNode.setId("_headNode_");
            entityNode.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"TreeBuilderUtil_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            entityNode.setType("main");
        } else {
            entityNode.setParentid(rootEntity.getKey());
            entityNode.setId(entity.getKey());
            String entityTypeName = ResManager.loadKDString((String)"(\u5355\u636e\u4f53)", (String)"TreeBuilderUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            if (entity.getName() == null) {
                entityNode.setText(entity.getKey() + entityTypeName);
            } else {
                entityNode.setText(entity.getName().toString() + entityTypeName);
            }
            entityNode.setType("entry");
        }
        return entityNode;
    }

    private static List<TreeNode> buildPropNodes(Field<?> field, TreeNode parentNode) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        List items = field.createEntityTreeNodes(true, 2, false);
        items.forEach(item -> {
            String key = (String)item.get("Id");
            String name = (String)item.get("Name");
            TreeNode node = new TreeNode();
            node.setParentid(parentNode.getId());
            node.setText(name + "(" + key + ")");
            if ("entry".equals(parentNode.getType())) {
                key = parentNode.getId() + "." + key;
            }
            node.setId(key);
            nodes.add(node);
        });
        return nodes;
    }

    private static TreeNode buildBaseFieldNode(AbstractBasedataField<?> bdField, TreeNode parentNode, Map<String, Object> params) {
        TreeNode bdFieldNode = TreeBuilderUtil.buildFieldNode(bdField, parentNode);
        String capPreFix = bdField.getName() == null ? bdField.getKey() : bdField.getName().toString();
        String refBaseEntityId = bdField.getBaseEntityId();
        if (StringUtils.isBlank((CharSequence)refBaseEntityId)) {
            return bdFieldNode;
        }
        String refBaseEntityNumber = MetadataDao.getEntityNumberById((String)refBaseEntityId);
        if (refBaseEntityNumber == null) {
            return bdFieldNode;
        }
        BasedataEntityType dt = null;
        if (bdField instanceof MasterIdField) {
            dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)refBaseEntityNumber);
            capPreFix = dt.getDisplayName() == null ? capPreFix : dt.getDisplayName().toString();
            bdFieldNode.setText(capPreFix + "(" + bdField.getKey() + ")");
        } else {
            dt = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)refBaseEntityNumber, (Collection)bdField.getRuntimeRefProps());
        }
        List<TreeNode> refPropNodes = TreeBuilderUtil.buildRefBaseDataTypeNodes((MainEntityType)dt, bdFieldNode, bdFieldNode.getId(), capPreFix, params);
        if (!refPropNodes.isEmpty()) {
            bdFieldNode.addChildren(refPropNodes);
        }
        return bdFieldNode;
    }

    private static TreeNode buildMuliBaseFieldNode(MulBasedataField muliBDField, TreeNode parentNode, Map<String, Object> params) {
        TreeNode bdFieldNode = null;
        bdFieldNode = TreeBuilderUtil.buildFieldNode(muliBDField, parentNode);
        String refBaseEntityId = muliBDField.getBaseEntityId();
        if (StringUtils.isBlank((CharSequence)refBaseEntityId)) {
            return bdFieldNode;
        }
        String refBaseEntityNumber = MetadataDao.getEntityNumberById((String)refBaseEntityId);
        if (refBaseEntityNumber == null) {
            return bdFieldNode;
        }
        BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)refBaseEntityNumber, (Collection)muliBDField.getRuntimeRefProps());
        List<TreeNode> refPropNodes = TreeBuilderUtil.buildRefBaseDataTypeNodes((MainEntityType)dt, bdFieldNode, muliBDField.getKey(), muliBDField.getName().toString(), params);
        if (!refPropNodes.isEmpty()) {
            bdFieldNode.addChildren(refPropNodes);
        }
        return bdFieldNode;
    }

    private static TreeNode buildPropNode(IDataEntityProperty property, TreeNode parentNode, String keyPrefix, String capPrefix) {
        TreeNode fldNode = null;
        DynamicProperty prop = (DynamicProperty)property;
        if (prop != null) {
            String fldNodeName;
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)keyPrefix) ? prop.getName() : keyPrefix + "." + prop.getName();
            String string = fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            if (StringUtils.isNotBlank((CharSequence)capPrefix)) {
                fldNodeName = capPrefix + "." + fldNodeName;
            }
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static List<TreeNode> buildRefBaseDataTypeNodes(MainEntityType refBDType, TreeNode bdFieldNode, String keyPrefix, String capPrefix, Map<String, Object> params) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        Optional.ofNullable(refBDType).ifPresent(x -> refBDType.getFields().values().forEach(refProp -> {
            if (refProp instanceof MulBasedataProp) {
                refNodes.addAll(TreeBuilderUtil.buildRefMuliBaseProp2Node((MulBasedataProp)refProp, bdFieldNode, keyPrefix, capPrefix, params));
                return;
            }
            if (refProp instanceof ICollectionProperty) {
                return;
            }
            if (refProp instanceof BasedataProp) {
                refNodes.addAll(TreeBuilderUtil.buildRefBaseProp2Node((BasedataProp)refProp, bdFieldNode, keyPrefix, capPrefix, params));
                return;
            }
            if (TreeBuilderUtil.canAddProperty(refProp, params)) {
                refNodes.add(TreeBuilderUtil.buildPropNode(refProp, bdFieldNode, keyPrefix, capPrefix));
            }
        }));
        return refNodes;
    }

    private static List<TreeNode> buildRefBaseProp2Node(BasedataProp refBDProp, TreeNode bdFieldNode, String keyPrefix, String capPrefix, Map<String, Object> params) {
        String capPrefix2;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        boolean matched = TreeBuilderUtil.canAddProperty((IDataEntityProperty)refBDProp, params);
        TreeNode refPropNode = TreeBuilderUtil.buildPropNode((IDataEntityProperty)refBDProp, bdFieldNode, keyPrefix, capPrefix);
        if (matched) {
            nodes.add(refPropNode);
        }
        if (refBDProp == null) {
            return nodes;
        }
        MainEntityType bdType2 = (MainEntityType)refBDProp.getComplexType();
        if (bdType2 == null) {
            return nodes;
        }
        String keyPrefix2 = keyPrefix + "." + refBDProp.getName();
        List<TreeNode> refNodes2 = TreeBuilderUtil.buildRefBaseDataTypeNodes(bdType2, refPropNode, keyPrefix2, capPrefix2 = capPrefix + "." + (refBDProp.getDisplayName() == null ? refBDProp.getName() : refBDProp.getDisplayName().toString()), params);
        if (!refNodes2.isEmpty()) {
            if (!matched) {
                nodes.add(refPropNode);
            }
            refPropNode.addChildren(refNodes2);
        }
        return nodes;
    }

    private static List<TreeNode> buildRefMuliBaseProp2Node(MulBasedataProp refMuliBDProp, TreeNode bdFieldNode, String keyPrefix, String capPrefix, Map<String, Object> params) {
        String capPrefix2;
        String keyPrefix2;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        boolean matched = TreeBuilderUtil.canAddProperty((IDataEntityProperty)refMuliBDProp, params);
        TreeNode refPropNode = TreeBuilderUtil.buildPropNode((IDataEntityProperty)refMuliBDProp, bdFieldNode, keyPrefix, capPrefix);
        if (matched) {
            nodes.add(refPropNode);
        }
        if (refMuliBDProp == null) {
            return nodes;
        }
        BasedataProp refBDProp = (BasedataProp)refMuliBDProp.getRefBaseProp();
        if (refBDProp == null || refBDProp.getComplexType() == null) {
            return nodes;
        }
        MainEntityType bdType2 = (MainEntityType)refBDProp.getComplexType();
        List<TreeNode> refNodes2 = TreeBuilderUtil.buildRefBaseDataTypeNodes(bdType2, refPropNode, keyPrefix2 = keyPrefix + "." + refMuliBDProp.getName(), capPrefix2 = capPrefix + "." + (refMuliBDProp.getDisplayName() == null ? refMuliBDProp.getName() : refMuliBDProp.getDisplayName().toString()), params);
        if (!refNodes2.isEmpty()) {
            if (!matched) {
                nodes.add(refPropNode);
            }
            refPropNode.addChildren(refNodes2);
        }
        return nodes;
    }

    private static TreeNode buildFieldNode(Field<?> field, TreeNode parentNode) {
        TreeNode node = new TreeNode();
        node.setParentid(parentNode.getId());
        String key = field.getKey();
        if ("entry".equals(parentNode.getType())) {
            key = parentNode.getId() + "." + key;
        }
        node.setId(key);
        node.setText(field.getName().toString() + "(" + field.getKey() + ")");
        return node;
    }

    private static boolean canAddProperty(IDataEntityProperty property, Map<String, Object> params) {
        Object filterDateAndBigDecimalType = params.get("filterDateAndBigDecimalType");
        if (filterDateAndBigDecimalType != null && ((Boolean)filterDateAndBigDecimalType).booleanValue() && (property instanceof DecimalProp || property instanceof DateTimeProp)) {
            return false;
        }
        Object ingnorePropertyArr = params.get("ingnoreFieldArr");
        if (ingnorePropertyArr != null) {
            Class[] classArr;
            for (Class classObj : classArr = (Class[])ingnorePropertyArr) {
                if (!property.getClass().equals(classObj) && !classObj.isAssignableFrom(property.getClass())) continue;
                return false;
            }
        }
        return true;
    }
}

