/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.workflow.engine.WfMultiLangUtils;

public class BarChartHelper {
    private static final String ALGOKEY = "bpm.apphome.queryData";
    private BarChart customchart;

    public BarChart getCustomchart() {
        return this.customchart;
    }

    public void setCustomchart(BarChart customchart) {
        this.customchart = customchart;
    }

    void drawChart(BarChart customchart) {
        customchart.clearData();
        this.setCustomchart(customchart);
        LinkedHashMap<String, Number> data = this.getData();
        ArrayList<String> keys = new ArrayList<String>(data.size());
        ArrayList<Number> values = new ArrayList<Number>(data.size());
        ArrayList<String> numbers = new ArrayList<String>(data.size());
        for (Map.Entry<String, Number> entry : data.entrySet()) {
            String name = entry.getKey().split("\\.")[0];
            String number = entry.getKey().split("\\.")[1];
            if (name.length() > 10) {
                keys.add(name.substring(0, 9));
            } else {
                keys.add(name);
            }
            values.add(entry.getValue());
            numbers.add(number);
        }
        Collections.reverse(keys);
        Collections.reverse(values);
        ArrayList<String> numberOrder = new ArrayList<String>(numbers.size());
        for (int i = numbers.size() - 1; i >= 0; --i) {
            numberOrder.add(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u7f16\u7801\uff1a%s", (String)"BarChartHelper_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), numbers.get(i)));
        }
        Collections.reverse(numbers);
        this.customToolTip(customchart, numberOrder);
        this.createCategoryAxis(ResManager.loadKDString((String)"\u7c7b\u522b", (String)"BarChartHelper_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), keys);
        this.createValueAxis(ResManager.loadKDString((String)"\u503c", (String)"BarChartHelper_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.createBarSeries("", values, "#40A9FF");
        customchart.setMargin(Position.right, "30px");
        customchart.setMargin(Position.top, "50px");
        HashMap textStyle = new HashMap();
        customchart.setLegendPropValue("textStyle", textStyle);
        customchart.refresh();
    }

    private void customToolTip(BarChart customchart, List<String> numberOrder) {
        StringBuilder numbersSb = new StringBuilder();
        for (int i = 0; i < numberOrder.size(); ++i) {
            numbersSb.append("'").append(numberOrder.get(i)).append("'").append(",");
        }
        BarChart control = customchart;
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        String formatter = "function(params){var param = params[0]; var datas = [%s];return ('' + datas[param.dataIndex]);}";
        control.addTooltip("formatter", (Object)String.format(formatter, numbersSb));
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        control.addFuncPath(toolTipFuncPath);
        HashMap<String, String> axisPointType = new HashMap<String, String>();
        axisPointType.put("type", "shadow");
        control.addTooltip("axisPointer", axisPointType);
    }

    private Axis createCategoryAxis(String name, List<String> demensions) {
        Axis axis = null;
        axis = this.customchart.createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(true));
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#212121");
        return axis;
    }

    private Axis createValueAxis(String name) {
        Axis axis = null;
        axis = this.customchart.createXAxis(name, AxisType.value);
        HashMap<String, Serializable> splitLine = new HashMap<String, Serializable>();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#45cdff");
        splitLine.put("lineStyle", lineStyle);
        splitLine.put("show", Boolean.valueOf(true));
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#212121");
        this.customchart.setShowTooltip(true);
        return axis;
    }

    private void createBarSeries(String name, List<Number> values, String color) {
        BarSeries barSeries = this.customchart.createBarSeries(name);
        barSeries.setBarWidth("30px");
        barSeries.setColor(color);
        Label label = barSeries.getLabel();
        label.setColor("#ffffff");
        label.setPosition(Position.inside);
        barSeries.setLabel(label);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    private void setLineColor(Axis axis, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    private LinkedHashMap<String, Number> getData() {
        Serializable count;
        LinkedHashMap<String, Number> numberAndCount = new LinkedHashMap<String, Number>();
        HashMap<String, String> numberAndName = new HashMap<String, String>();
        String sb = "select  count(a.fid) instcount , b.fkey from t_wf_hiprocinst as a left join t_wf_procdef as b on a.fprocdefid = b.fid where b.ftype = 'BizFlow' group by b.fkey";
        try (DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.workflow, (String)sb);){
            for (Row row : ds) {
                count = row.getLong("instcount");
                String number = row.getString("fkey");
                numberAndCount.put(number, (Number)count);
            }
        }
        String localeLang = RequestContext.get().getLang().toString();
        StringBuilder sql = new StringBuilder();
        String name = WfMultiLangUtils.getGeneralLangSQL((String)"wf_processdefinition", (String)"a", (String)"b", (String)"fname", (String)"fname", (String)"name");
        sql.append("select distinct a.fkey ,").append(name).append(" from t_wf_procdef as a left join t_wf_procdef_l as b ").append("on a.fid  = b.fid ").append("and a.ftype  = 'BizFlow' ").append("and (b.flocaleid = ? or b.flocaleid is null )");
        DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{localeLang});
        count = null;
        try {
            for (Row row : ds) {
                String fkey = row.getString("fkey");
                String fname = row.getString("fname");
                String oldName = (String)numberAndName.get(fkey);
                if (!StringUtils.isEmpty((CharSequence)oldName)) continue;
                numberAndName.put(fkey, fname);
            }
        }
        catch (Throwable throwable) {
            count = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (count != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)count).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Map<String, Number> newMap = this.sortMapByValue(numberAndCount);
        LinkedHashMap results = (LinkedHashMap)BarChartHelper.getTopMapNumber(newMap, numberAndName, 5);
        return results;
    }

    public Map<String, Number> sortMapByValue(Map<String, Number> oriMap) {
        LinkedHashMap<String, Number> sortedMap = new LinkedHashMap<String, Number>();
        if (oriMap != null && !oriMap.isEmpty()) {
            ArrayList<Map.Entry<String, Number>> entryList = new ArrayList<Map.Entry<String, Number>>(oriMap.entrySet());
            Collections.sort(entryList, new Comparator<Map.Entry<String, Number>>(){

                @Override
                public int compare(Map.Entry<String, Number> entry1, Map.Entry<String, Number> entry2) {
                    try {
                        int value1 = entry1.getValue().intValue();
                        int value2 = entry2.getValue().intValue();
                        return value2 - value1;
                    }
                    catch (Exception e) {
                        return 1;
                    }
                }
            });
            Iterator iter = entryList.iterator();
            Map.Entry tmpEntry = null;
            while (iter.hasNext()) {
                tmpEntry = (Map.Entry)iter.next();
                sortedMap.put((String)tmpEntry.getKey(), (Number)tmpEntry.getValue());
            }
        }
        return sortedMap;
    }

    public static Map<String, Number> getTopMapNumber(Map<String, Number> map, Map<String, String> newMap, int num) {
        LinkedHashMap<String, Number> maxMap = new LinkedHashMap<String, Number>();
        LinkedList<Map.Entry<String, Number>> list = new LinkedList<Map.Entry<String, Number>>();
        list.addAll(map.entrySet());
        int flag = 0;
        for (Map.Entry entry : list) {
            if (flag >= num) break;
            StringBuilder sb = new StringBuilder();
            sb.append(newMap.get(entry.getKey())).append(".").append((String)entry.getKey());
            maxMap.put(sb.toString(), (Number)entry.getValue());
            ++flag;
        }
        return maxMap;
    }
}

