/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class CirculationLogPlugin
extends AbstractFormPlugin {
    private static final String SELECTPROPERTIES = "owner,createdate,opinion,assignee,nopinion";
    private static final String REMINDERENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskid");
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        List operationLogs = taskService.findCirculationOperationLog(taskId, SELECTPROPERTIES);
        if (WfUtils.isNotEmptyForCollection((Collection)operationLogs)) {
            this.getModel().batchCreateNewEntryRow(REMINDERENTITY, operationLogs.size());
            for (int i = 0; i < operationLogs.size(); ++i) {
                String owner = ((OperationLogEntity)operationLogs.get(i)).getOwner().toString();
                Date createdate = ((OperationLogEntity)operationLogs.get(i)).getCreateDate();
                String opinion = ((OperationLogEntity)operationLogs.get(i)).getOpinion().toString();
                String nOpinion = ((OperationLogEntity)operationLogs.get(i)).getNOpinion().toString();
                String assignee = ((OperationLogEntity)operationLogs.get(i)).getAssignee().toString();
                if (WfUtils.isEmpty((String)owner)) {
                    this.getModel().setValue("owner", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf", (String)"CirculationLogPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), i);
                } else {
                    this.getModel().setValue("owner", (Object)owner, i);
                }
                this.getModel().setValue("createdate", (Object)createdate, i);
                this.getModel().setValue("opinion", (Object)(WfUtils.isEmpty((String)nOpinion) ? opinion : nOpinion), i);
                this.getModel().setValue("assignee", (Object)assignee, i);
            }
        }
    }
}

