/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.pojo.ErrorAbandonProcess;

public class ErrorAbandonPlugin
extends AbstractWorkflowPlugin {
    @Override
    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        List<ErrorAbandonProcess> errorAbandonProcesses = this.getErrorAbandonProcesses();
        if (errorAbandonProcesses == null || errorAbandonProcesses.isEmpty()) {
            return;
        }
        this.forEachList(errorAbandonProcesses);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.getView().close();
        }
    }

    private List<ErrorAbandonProcess> getErrorAbandonProcesses() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("errorAbandonProcesses");
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ArrayList<ErrorAbandonProcess>();
        }
        ObjectMapper JSON2 = new ObjectMapper();
        try {
            return (List)JSON2.readValue(str, (TypeReference)new TypeReference<List<ErrorAbandonProcess>>(){});
        }
        catch (Throwable e) {
            this.logger.info(String.valueOf(e));
            return new ArrayList<ErrorAbandonProcess>();
        }
    }

    public void forEachList(List<ErrorAbandonProcess> errorAbandonProcesses) {
        this.getModel().deleteEntryData("entryentity");
        if (errorAbandonProcesses == null || errorAbandonProcesses.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", errorAbandonProcesses.size());
        this.logger.info("\u9519\u8bef\u7ec8\u6b62:" + errorAbandonProcesses);
        for (int i = 0; i < errorAbandonProcesses.size(); ++i) {
            ErrorAbandonProcess item = errorAbandonProcesses.get(i);
            this.getModel().setValue("entrabillname", (Object)item.getEntraBillName(), i);
            this.getModel().setValue("name", (Object)item.getName(), i);
            this.getModel().setValue("billno", (Object)item.getBillNo(), i);
            this.getModel().setValue("errmsg", (Object)item.getErrMsg(), i);
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.setPageIndex(1);
    }
}

