/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.pojo.ErrorAbandonProcess;
import kd.bos.workflow.monitor.plugin.vo.ErrorAbandonVo;

public class ErrorAbandonTipsPlugin
extends AbstractWorkflowPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"buttonap"});
        Label labelap = (Label)this.getControl("labelap");
        labelap.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Label label = (Label)this.getControl("message");
        label.setText("");
        ErrorAbandonVo errorAbandonVo = this.getVo();
        List<ErrorAbandonProcess> errorAbandonProcesses = errorAbandonVo.getErrorAbandonProcesses();
        if (errorAbandonProcesses == null || errorAbandonProcesses.isEmpty()) {
            return;
        }
        int errorSize = errorAbandonProcesses.size();
        int total = errorAbandonVo.getTotal();
        String format = String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a%1$s\u6761\uff0c\u5931\u8d25\uff1a%2$s\u6761", (String)"ErrorAbandonTipsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), total - errorSize, errorSize);
        label.setText(format);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("buttonap".equals(key)) {
            this.getView().close();
        } else if ("labelap".equals(key)) {
            ErrorAbandonVo vo = this.getVo();
            List<ErrorAbandonProcess> errorAbandonProcesses = vo.getErrorAbandonProcesses();
            if (errorAbandonProcesses == null) {
                return;
            }
            FormShowParameter param = new FormShowParameter();
            param.setFormId("wf_errorabandonprocess");
            param.setCustomParam("errorAbandonProcesses", (Object)SerializationUtils.toJsonString(errorAbandonProcesses));
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(param);
        }
    }

    private ErrorAbandonVo getVo() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String errorAbandonVoStr = (String)parameter.getCustomParam("errorAbandonVo");
        if (StringUtils.isEmpty((CharSequence)errorAbandonVoStr)) {
            return new ErrorAbandonVo();
        }
        ErrorAbandonVo errorAbandonVo = (ErrorAbandonVo)SerializationUtils.fromJsonString((String)errorAbandonVoStr, ErrorAbandonVo.class);
        if (errorAbandonVo == null) {
            return new ErrorAbandonVo();
        }
        return errorAbandonVo;
    }
}

