/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class EventLogEntryEsListPlugin
extends AbstractListPlugin {
    private static final String OPERATION = "operation";
    private static final String TODO_OPERATE = "todooperate";
    private static final String GET_DD_TASK = "getddtask";
    private static final String TODO_DING = "dingtodo";

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.setOrderBy("timestamp desc");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (WfUtils.isNotEmpty((String)appId)) {
            ArrayList<String> notQueryProcessTypes = new ArrayList<String>(2);
            if ("wf".equals(appId)) {
                notQueryProcessTypes.add(ProcessType.BizFlow.name());
            } else if ("bpm".equals(appId)) {
                notQueryProcessTypes.add(ProcessType.AuditFlow.name());
            }
            notQueryProcessTypes.add(ProcessType.NoCodeFlow.name());
            QFilter filter = new QFilter("processtype", "not in", notQueryProcessTypes);
            e.addCustomQFilter(filter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!WfConfigurationUtil.isYunzhijiaEnable()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TODO_OPERATE});
        }
        if (!WfConfigurationUtil.isDDEnable()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{GET_DD_TASK});
            this.getView().setVisible(Boolean.FALSE, new String[]{TODO_DING});
        }
        PluginUtil.setControlInvisible(this.getView(), "exit");
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "todooperate": {
                this.showTodoState();
                break;
            }
            case "getddtask": {
                this.showDDTaskList();
                break;
            }
            case "dingtodo": {
                this.showDingTodoState();
                break;
            }
        }
    }

    private void showDDTaskList() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_eventlogentry", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u9489\u9489\u5f02\u5e38\u5f85\u529e\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"EventLogEntryListPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_searchddtask");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void showTodoState() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_eventlogentry", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4e91\u4e4b\u5bb6\u5f02\u5e38\u5f85\u529e\u201d\u7684\u201c\u67e5\u8be2\u201d\u7684\u6743\u9650\u3002", (String)"EventLogEntryListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!WfConfigurationUtil.isYunzhijiaEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4e91\u4e4b\u5bb6\u201d\u672a\u542f\u7528\u3002", (String)"EventLogEntryListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_todostate");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5f85\u529e\u4efb\u52a1\u5904\u7406", (String)"EventLogEntryListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private void showDingTodoState() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_eventlogentry", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u9489\u9489\u5f02\u5e38\u5f85\u529e\u201d\u7684\u201c\u67e5\u8be2\u201d\u7684\u6743\u9650\u3002", (String)"EventLogEntryListPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!WfConfigurationUtil.isDDEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9489\u9489\u201d\u672a\u542f\u7528\u3002", (String)"EventLogEntryListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_dingtodostate");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u9489\u9489\u5f85\u529e\u5904\u7406", (String)"EventLogEntryListPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        super.billListHyperLinkClick(args);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setFormId("wf_eventlogentryes");
        parameter.setPkId((Object)((Long)((ListView)this.getView()).getFocusRowPkId()));
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
        args.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        super.listRowDoubleClick(evt);
        BillList billList = (BillList)evt.getSource();
        String focusField = billList.getEntryState().getFocusField();
        if (OPERATION.equalsIgnoreCase(focusField)) {
            evt.setCancel(true);
        }
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }
}

