/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ReminderLogPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String USERID = "userId";
    private static final String REMINDERENTITY = "entryentity";
    private static final String SELECTPROPERTIES = "owner,createdate,opinion,assignee,nopinion";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTNOK, BTNCANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return;
        }
        String businessKey = (String)customParams.get("businesskey");
        Long userId = null;
        if (customParams.get(USERID) != null) {
            String userIdStr = String.valueOf(customParams.get(USERID));
            userId = Long.parseLong(userIdStr);
        }
        String type = (String)customParams.get("type");
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        List operationLogs = taskService.findOperationLogByBusinessKeyAndType(SELECTPROPERTIES, businessKey, userId, type);
        if (WfUtils.isNotEmptyForCollection((Collection)operationLogs)) {
            this.getModel().batchCreateNewEntryRow(REMINDERENTITY, operationLogs.size());
            for (int i = 0; i < operationLogs.size(); ++i) {
                String owner = ((OperationLogEntity)operationLogs.get(i)).getOwner().toString();
                Date createdate = ((OperationLogEntity)operationLogs.get(i)).getCreateDate();
                String opinion = ((OperationLogEntity)operationLogs.get(i)).getOpinion().toString();
                String nOpinion = ((OperationLogEntity)operationLogs.get(i)).getNOpinion().toString();
                String assignee = ((OperationLogEntity)operationLogs.get(i)).getAssignee().toString();
                this.getModel().setValue("owner", (Object)owner, i);
                this.getModel().setValue("createdate", (Object)createdate, i);
                this.getModel().setValue("opinion", (Object)(WfUtils.isEmpty((String)nOpinion) ? opinion : nOpinion), i);
                this.getModel().setValue("assignee", (Object)assignee, i);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(BTNOK)) {
            this.getView().close();
        }
    }
}

