/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class WorkflowAbandonPlugin
extends AbstractWorkflowPlugin {
    private static final String CONFIRM = "btnconfirm";
    public static final String PROCESSINSTANCEID = "processInstanceId";
    private static final String BUSINESSKEY = "businesskey";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        Long processInstanceId = (Long)this.getView().getFormShowParameter().getCustomParam(PROCESSINSTANCEID);
        List executions = this.getTaskService().getBillExecutionInBizFlow(processInstanceId);
        if (CollectionUtil.isNotEmpty((Collection)executions)) {
            this.getModel().batchCreateNewEntryRow("entryentity", executions.size());
            for (int i = 0; i < executions.size(); ++i) {
                ExecutionEntity execution = (ExecutionEntity)executions.get(i);
                this.getModel().setValue(BUSINESSKEY, (Object)execution.getBusinessKey(), i);
                this.getModel().setValue("executionid", (Object)execution.getId(), i);
                this.getModel().setValue("number", (Object)execution.getBillNo(), i);
                ILocaleString entraBillName = execution.getEntraBillName();
                String billName = entraBillName != null ? entraBillName.getLocaleValue() : "";
                String showBillNameInfo = String.format("%s(%s)", billName, execution.getEntityNumber());
                this.getModel().setValue("name", (Object)showBillNameInfo, i);
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"WorkflowAbandonPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String executionId = this.getModel().getValue("executionid", selectIndex[0]).toString();
        try {
            this.getTaskService().abandonBizFlowByBusinessKey(executionId);
            this.getView().returnDataToParent((Object)Boolean.TRUE);
            this.getView().close();
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(e.getMessage());
        }
    }
}

