/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;

public class WorkflowErrorListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener {
    private static final String BOS_LIST = "bos_list";
    private static final String ERROR_LIST_PKID = "M1A++W+C5FZ";
    private static final String SUBMIT_MAIN_TAB = "_submaintab_";
    private static final String WF_DEAD_LETTER_JOB = "wf_deadletterjob";
    private static final String BITTON_OPEN_ERROR_MOINTOR = "btnopenerrormointor";
    private static final String BILL_LIST_TAP = "billlistap";

    public void initialize() {
        super.initialize();
        Button button = (Button)this.getView().getControl(BITTON_OPEN_ERROR_MOINTOR);
        button.addClickListener((ClickListener)this);
        this.addWfFilter();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if (BITTON_OPEN_ERROR_MOINTOR.equalsIgnoreCase(c.getKey())) {
            this.openErrorMointorForm();
        }
    }

    public void customEvent(CustomEventArgs e) {
        BillList billControl = (BillList)this.getView().getControl(BILL_LIST_TAP);
        billControl.refreshData();
    }

    private void openErrorMointorForm() {
        IFormView mainPageView = this.getView().getMainView();
        String menuPageID = ERROR_LIST_PKID + mainPageView.getPageId();
        Boolean isMainGate = mainPageView.getFormShowParameter().getCustomParam("appNumber") == null;
        if (mainPageView.getView(menuPageID) != null && !isMainGate.booleanValue()) {
            IFormView childFormView = mainPageView.getView(menuPageID);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        } else {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(WF_DEAD_LETTER_JOB);
            parameter.setCustomParam("billFormId", (Object)WF_DEAD_LETTER_JOB);
            parameter.setFormId(BOS_LIST);
            parameter.getOpenStyle().setTargetKey(SUBMIT_MAIN_TAB);
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            parameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u6d41\u7a0b\u4fe1\u606f", (String)"WorkflowErrorListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            parameter.setPageId(menuPageID);
            IFormView appPageView = this.getView().getParentView();
            appPageView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(appPageView);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_TAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        if (StringUtils.equals((CharSequence)"exceptionmessage", (CharSequence)arg0.getFieldName())) {
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setShowTitle(false);
            parameter.setFormId(WF_DEAD_LETTER_JOB);
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_TAP);
            parameter.setPkId((Object)((Long)billList.getFocusRowPkId()));
            parameter.setStatus(OperationStatus.VIEW);
            IFormView parentView = DesignerModelUtil.getTabControlView(this.getView());
            if (parentView != null) {
                parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                parameter.getOpenStyle().setTargetKey(SUBMIT_MAIN_TAB);
                parentView.showForm((FormShowParameter)parameter);
                this.getView().sendFormAction(parentView);
            } else {
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    private void addWfFilter() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_TAP);
        List qFilters = billList.getDataPermQFilters();
        if (WfConfigurationUtil.isFilterDataByOrg() && WfAdminUtil.needFilterData()) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            List withSubordinateByConf = new ArrayList<Long>();
            Map ret = WfAdminUtil.getWfAdminCache((String)(userId + ""));
            if (null != ret) {
                withSubordinateByConf = (List)WfUtils.stringToCollection((String)((String)ret.get("withSubordinateByConf")), (String)",");
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                if (WfUtils.isNotEmptyForCollection(withSubordinateByConf) && withSubordinateByConf.contains(rootOrgId)) {
                    return;
                }
            }
            if (WfUtils.isEmptyForCollection(withSubordinateByConf)) {
                withSubordinateByConf.add(-1L);
            }
            qFilters.add(new QFilter("orgunitid", "in", withSubordinateByConf));
        }
        if ("wf".equals(this.getView().getFormShowParameter().getAppId())) {
            qFilters.add(new QFilter("processtype", "=", (Object)ModelType.AuditFlow.name()));
        } else {
            qFilters.add(new QFilter("processtype", "!=", (Object)ModelType.NoCodeFlow.name()));
        }
        billList.setDataPermQFilters(qFilters);
    }
}

