/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.ArrayList;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowListPlugin;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.HandleFailedJobResult;
import kd.bos.workflow.service.archive.ArchiveFormService;

public class WorkflowFailedJobListPlugin
extends AbstractWorkflowListPlugin {
    private static final String BTN_DELETE = "btndelete";
    private static final String BTN_HANDLE = "btnhandle";
    private static final String CALLBACKID_DELETE = "delete";

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btndelete": {
                this.showConfirmDelete();
                break;
            }
            case "btnhandle": {
                this.handleFailedJob();
                break;
            }
            default: {
                super.itemClick(evt);
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        boolean isArchiveDB = ArchiveFormService.create().isArchiveDBInView(this.getView());
        if (isArchiveDB) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETE, BTN_HANDLE});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETE, BTN_HANDLE});
        }
    }

    private void showConfirmDelete() {
        String appId = ProcessInstancePluginUtil.getPermissionAppId(this.getView());
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"wf_failedjob", (String)"4715e1f1000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f02\u5e38\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\u3002", (String)"WorkflowFailedJobListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)"wf_failedjob", (String)BTN_DELETE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664", "WorkflowFailedJobListPlugin_9", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u5f02\u5e38\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\u3002", "WorkflowFailedJobListPlugin_11", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows != null && !rows.isEmpty()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u6240\u9009\u8bb0\u5f55\u5417\uff1f", (String)"WorkflowFailedJobListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_DELETE));
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    private void handleFailedJob() {
        String appId = ProcessInstancePluginUtil.getPermissionAppId(this.getView());
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"wf_failedjob", (String)"018JWO8RKN3U")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f02\u5e38\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\u3002", (String)"WorkflowFailedJobListPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)"wf_failedjob", (String)BTN_HANDLE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5904\u7406", "WorkflowFailedJobListPlugin_10", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d8a\u6743\u8bbf\u95ee:\u65e0\u201c\u5f02\u5e38\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", "WorkflowFailedJobListPlugin_12", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows != null && !rows.isEmpty()) {
            ArrayList<Long> jobIds = new ArrayList<Long>();
            for (ListSelectedRow row : rows) {
                jobIds.add((Long)row.getPrimaryKeyValue());
            }
            HandleFailedJobResult ret = this.getRuntimeService().handleFailedJobs(jobIds);
            if (ret.getSuccessed() == jobIds.size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f\u3002", (String)"WorkflowFailedJobListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                WfUtils.addOpLogByAppId((String)appId, (String)"wf_failedjob", (String)BTN_HANDLE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5904\u7406", "WorkflowFailedJobListPlugin_10", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5904\u7406\u6210\u529f\u3002", "WorkflowFailedJobListPlugin_3", "bos-wf-formplugin"), (Object[])new Object[0]);
            } else if (ret.getFailed() > 0) {
                String handleName = ResManager.loadKDString((String)"\u5904\u7406", (String)"WorkflowFailedJobListPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                StandardTips.view((IFormView)this.getView()).batchOptionMsg(handleName, ret.getSuccessMsgList(), ret.getFailMsgList());
            }
            this.refresh();
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        if (CALLBACKID_DELETE.equals(evt.getCallBackId())) {
            String appId = ProcessInstancePluginUtil.getPermissionAppId(this.getView());
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"wf_failedjob", (String)"4715e1f1000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f02\u5e38\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\u3002", (String)"WorkflowFailedJobListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                WfUtils.addOpLogByAppId((String)appId, (String)"wf_failedjob", (String)BTN_DELETE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664", "WorkflowFailedJobListPlugin_9", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u5f02\u5e38\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\u3002", "WorkflowFailedJobListPlugin_11", "bos-wf-formplugin"), (Object[])new Object[0]);
                return;
            }
            this.deleteFailedJob();
        } else {
            super.confirmCallBack(evt);
        }
    }

    private void deleteFailedJob() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> jobIds = new ArrayList<Long>();
        for (ListSelectedRow row : rows) {
            jobIds.add((Long)row.getPrimaryKeyValue());
        }
        this.getRuntimeService().deleteFailedJobs(jobIds, ProcessInstancePluginUtil.getPermissionAppId(this.getView()));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WorkflowFailedJobListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.refresh();
    }

    private void refresh() {
        ((BillList)this.getControl("billlistap")).refresh();
        ((IListView)this.getView()).clearSelection();
    }
}

