/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoState;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;

public class WorkflowGetTodoStatePlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_SELECT = "btnok";
    private static final String BTN_DEAL = "dealtodo";
    private static final String BTN_DELETE = "deletetodo";
    private static final String FIELD_TASK = "task";
    private static final String FIELD_USERID = "userid";
    private static final String APPID = "appid";
    private static final String RESULT = "result";
    private static final String API_RESULT = "apiret";
    private static final String PANEL_RESULT = "retpanel";
    private static final String FLOWASSIST = "flowassist";
    private static final String CONFCENTERKEY = "msg.channel.yzjappidchange";
    private static final String CONFCENTER = "wf_confcenter";
    private static final String APP_ID = "appId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SELECT, BTN_DEAL, BTN_DELETE});
        this.showUsersAddCustomParam();
    }

    private void showUsersAddCustomParam() {
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(FIELD_USERID);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String type = this.getChanelType();
        if ("yunzhijiaup".equalsIgnoreCase(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SELECT});
        }
        String appId = WfConfigurationUtil.getLightAppId((String)type, (String)FLOWASSIST, null);
        String secret = WfConfigurationUtil.getLightAppSecret((String)type, (String)FLOWASSIST, null);
        Map<String, JSONObject> appInfos = this.getFilterAppInfos(type);
        ArrayList<ComboItem> appIdItems = new ArrayList<ComboItem>(appInfos.size() + 1);
        appIdItems.add(new ComboItem(new LocaleString(appId), appId + "::" + secret));
        for (Map.Entry<String, JSONObject> entry : appInfos.entrySet()) {
            JSONObject appInfo = entry.getValue();
            String appId1 = appInfo.getString(APP_ID);
            String appSecret = appInfo.getString("appSecret");
            if (!StringUtils.isNotBlank((CharSequence)appId1)) continue;
            appIdItems.add(new ComboItem(new LocaleString(appId1), appId1 + "::" + appSecret));
        }
        ((ComboEdit)this.getControl(APPID)).setComboItems(appIdItems);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        if (BTN_SELECT.equals(ctrl.getKey())) {
            this.getTodoState();
        } else if (BTN_DEAL.equals(ctrl.getKey())) {
            this.dealTodo(YzjToDoState.DEAL);
        } else if (BTN_DELETE.equals(ctrl.getKey())) {
            this.dealTodo(YzjToDoState.DELETE);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        if (!FIELD_TASK.equals(propName) && !FIELD_USERID.equals(propName)) {
            return;
        }
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_RESULT});
        if (FIELD_TASK.equals(propName) && newValue != null) {
            DynamicObject newTask = (DynamicObject)newValue;
            List<Long> participants = this.getParticipantsByTaskId(newTask.getLong("id"));
            if (participants == null || participants.isEmpty()) {
                this.getModel().setValue(FIELD_USERID, null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4efb\u52a1\u6ca1\u6709\u53c2\u4e0e\u4eba\u3002", (String)"WorkflowGetTodoStatePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue(FIELD_USERID, (Object)participants.get(0));
            }
        }
    }

    private List<Long> getParticipantsByTaskId(Long taskId) {
        ArrayList<Long> participants = new ArrayList<Long>();
        TaskService taskService = this.getTaskService();
        List entities = taskService.getHiParticipantByTaskId(taskId);
        if (entities != null && !entities.isEmpty()) {
            for (HistoricIdentityLinkEntity entity : entities) {
                participants.add(entity.getUserId());
            }
        }
        return participants;
    }

    private void dealTodo(YzjToDoState todoState) {
        String tip = this.validate();
        if (tip != null) {
            this.getView().showTipNotification(tip);
            return;
        }
        DynamicObject user = (DynamicObject)this.getModel().getValue(FIELD_USERID);
        DynamicObject task = (DynamicObject)this.getModel().getValue(FIELD_TASK);
        List<Long> participants = this.getParticipantsByTaskId((Long)task.getPkValue());
        if (participants.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4efb\u52a1\u6ca1\u6709\u53c2\u4e0e\u4eba\u3002", (String)"WorkflowGetTodoStatePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!participants.contains(user.getPkValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4e0d\u662f\u6240\u9009\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\u3002", (String)"WorkflowGetTodoStatePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_RESULT});
        try {
            String[] appInfo = ((String)this.getModel().getValue(APP_ID)).split("::");
            String type = this.getChanelType();
            JSONObject res = new JSONObject();
            res = "yunzhijiaup".equalsIgnoreCase(type) ? YunzhijiaCommonUtil.updateYzjUpToDoState((String)appInfo[0], (String)String.valueOf(task.getLong("id")), (String)((String)user.get("useropenid")), (YzjToDoState)todoState) : YunzhijiaCommonUtil.updateToDoState((String)appInfo[0], (String)appInfo[1], (String)String.valueOf(task.getLong("id")), (String)((String)user.get("useropenid")), (YzjToDoState)todoState, (String)type);
            String retStr = null;
            if (res.getBoolean("success").booleanValue()) {
                retStr = ResManager.loadKDString((String)"\u5f85\u529e\u5df2\u6210\u529f\u5904\u7406\u3002", (String)"WorkflowGetTodoStatePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                WfUtils.addOpLog((String)"wf_task", (String)BTN_DEAL, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5904\u7406\u5f85\u529e", "WorkflowGetTodoStatePlugin_19", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7528\u6237 %1$s \u5904\u7406\u5f85\u529e\u6210\u529f, TaskId: %2$s, appId: %3$s, OpenId: %4$s, operateType: %5$s", "WorkflowGetTodoStatePlugin_20", "bos-wf-formplugin"), (Object[])new Object[]{user.getString("name"), task.getString("id"), appInfo[0], user.getString("useropenid"), todoState});
            } else {
                retStr = ResManager.loadKDString((String)"\u5904\u7406\u5f85\u529e\u5931\u8d25\u3002", (String)"WorkflowGetTodoStatePlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                WfUtils.addOpLog((String)"wf_task", (String)BTN_DEAL, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5904\u7406\u5f85\u529e", "WorkflowGetTodoStatePlugin_19", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7528\u6237 %1$s \u5904\u7406\u5f85\u529e\u5931\u8d25, TaskId: %2$s, OpenId: %3$s, operateType: %4$s", "WorkflowGetTodoStatePlugin_21", "bos-wf-formplugin"), (Object[])new Object[]{user.getString("name"), task.getString("id"), user.getString("useropenid"), todoState});
            }
            Label result = (Label)this.getControl(RESULT);
            result.setText(String.format(ResManager.loadKDString((String)"\u7528\u6237 %1$s \u7684 %2$s \u4efb\u52a1\u72b6\u6001\uff1a %3$s", (String)"WorkflowGetTodoStatePlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), user.get("name"), task.getString("name"), retStr));
            Label apiResult = (Label)this.getControl(API_RESULT);
            apiResult.setText(String.format("%s", res.toJSONString()));
        }
        catch (Exception e) {
            this.logger.error(String.format("yzj_tools_exception:%s", WfUtils.getExceptionStacktrace((Throwable)e)));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f85\u529e\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowGetTodoStatePlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void getTodoState() {
        String tip = this.validate();
        if (tip != null) {
            this.getView().showTipNotification(tip);
            return;
        }
        DynamicObject user = (DynamicObject)this.getModel().getValue(FIELD_USERID);
        DynamicObject task = (DynamicObject)this.getModel().getValue(FIELD_TASK);
        List<Long> participants = this.getParticipantsByTaskId((Long)task.getPkValue());
        if (participants.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4efb\u52a1\u6ca1\u6709\u53c2\u4e0e\u4eba\u3002", (String)"WorkflowGetTodoStatePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!participants.contains(user.getPkValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4e0d\u662f\u6240\u9009\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\u3002", (String)"WorkflowGetTodoStatePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_RESULT});
        try {
            String[] appInfo = ((String)this.getModel().getValue(APP_ID)).split("::");
            JSONObject result = YunzhijiaCommonUtil.getCheckTodoResult((String)String.valueOf(task.getLong("id")), (String)((String)user.get("useropenid")), (String)appInfo[0], (String)appInfo[1], (String)this.getChanelType());
            JSONObject data = (JSONObject)result.get((Object)"data");
            if (data != null) {
                boolean check = data.getBoolean("check");
                if (check) {
                    this.checkSuccessed(data, user, task);
                } else {
                    this.checkFailed(data);
                }
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"WorkflowGetTodoStatePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), result));
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("yzj_tools_exception:%s", WfUtils.getExceptionStacktrace((Throwable)e)));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a%s", (String)"WorkflowGetTodoStatePlugin_3_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void checkSuccessed(JSONObject data, DynamicObject user, DynamicObject task) {
        String retStr = ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5\u3002", (String)"WorkflowGetTodoStatePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        int dealCount = data.getIntValue("dealCount");
        int undelCount = data.getIntValue("undelCount");
        if (dealCount == 0 && undelCount == 0) {
            retStr = ResManager.loadKDString((String)"\u5f85\u529e\u751f\u6210\u5931\u8d25\u6216\u672a\u751f\u6210\u3002", (String)"WorkflowGetTodoStatePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        } else if (dealCount == 0 && undelCount == 1) {
            retStr = ResManager.loadKDString((String)"\u5f85\u529e\u5df2\u751f\u6210\uff0c\u5c1a\u672a\u5904\u7406\u3002", (String)"WorkflowGetTodoStatePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        } else if (dealCount == 1 && undelCount == 0) {
            retStr = ResManager.loadKDString((String)"\u5f85\u529e\u5df2\u53d8\u4e3a\u5df2\u529e\u3002", (String)"WorkflowGetTodoStatePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        Label result = (Label)this.getControl(RESULT);
        result.setText(String.format(ResManager.loadKDString((String)"\u7528\u6237 %1$s \u7684 %2$s \u4efb\u52a1\u72b6\u6001\uff1a %3$s", (String)"WorkflowGetTodoStatePlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), user.get("name"), task.getString("name"), retStr));
        Label apiResult = (Label)this.getControl(API_RESULT);
        apiResult.setText(String.format("%s", data.toJSONString()));
    }

    private void checkFailed(JSONObject data) {
        String errorMsg = data.getString("errormsg");
        Label result = (Label)this.getControl(RESULT);
        result.setText(String.format(ResManager.loadKDString((String)"\u72b6\u6001\u67e5\u8be2\u5931\u8d25\u3002\u539f\u56e0\uff1a%s", (String)"WorkflowGetTodoStatePlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), errorMsg));
        Label apiResult = (Label)this.getControl(API_RESULT);
        apiResult.setText(data.toJSONString());
    }

    private String validate() {
        DynamicObject task = (DynamicObject)this.getModel().getValue(FIELD_TASK);
        if (task == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u3002", (String)"WorkflowGetTodoStatePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        DynamicObject user = (DynamicObject)this.getModel().getValue(FIELD_USERID);
        if (user == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u3002", (String)"WorkflowGetTodoStatePlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        String openId = (String)user.get("useropenid");
        if (WfUtils.isEmpty((String)openId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_RESULT});
            return ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u6240\u9009\u7528\u6237\u6ca1\u6709OpenID\u3002", (String)"WorkflowGetTodoStatePlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        String appInfo = (String)this.getModel().getValue(APP_ID);
        if (WfUtils.isEmpty((String)appInfo)) {
            return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u8f7b\u5e94\u7528ID\u201d\u3002", (String)"WorkflowGetTodoStatePlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private Map<String, JSONObject> getFilterAppInfos(String type) {
        String lightAppId = WfConfigurationUtil.getLightAppId((String)type, (String)FLOWASSIST, null);
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        QFilter filter = new QFilter("key", "=", (Object)CONFCENTERKEY);
        DynamicObject channelAppInfo = BusinessDataServiceHelper.loadSingle((String)CONFCENTER, (String)"value", (QFilter[])new QFilter[]{filter});
        if (channelAppInfo != null && !channelAppInfo.getString("value").isEmpty()) {
            JSONArray appInfos = JSONArray.parseArray((String)channelAppInfo.getString("value"));
            for (int i = 0; i < appInfos.size(); ++i) {
                JSONObject obj;
                JSONObject appInfo = appInfos.getJSONObject(i);
                String channelNumber = appInfo.getString("channelNumber");
                String appId = appInfo.getString(APP_ID);
                if ((!WfUtils.isEmpty((String)channelNumber) || !"yunzhijia".equals(type)) && (!WfUtils.isNotEmpty((String)channelNumber) || !type.equals(channelNumber)) || lightAppId.equals(appId) || (obj = (JSONObject)map.get(appId)) != null && (!appId.equals(obj.getString(APP_ID)) || obj.getLong("switchDate") >= appInfo.getLong("switchDate"))) continue;
                map.put(appId, appInfo);
            }
        }
        return map;
    }

    private String getChanelType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (WfUtils.isNotEmptyForMap((Map)customParams) && WfUtils.isNotEmptyString(customParams.get("channelNumber")) && "yunzhijiaup".equals(customParams.get("channelNumber"))) {
            return "yunzhijiaup";
        }
        if (WfConfigurationUtil.isYunzhijiaECO()) {
            return "yunzhijiaeco";
        }
        return "yunzhijia";
    }
}

