/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCApplyedPlugin;

public class WorkflowHistoricalProcessesPlugin
extends WorkflowTCApplyedPlugin {
    private static final String BTNREFRESH = "btnrefresh";
    private static final String BTN_EXIT = "baritemexit";
    private static final String BTN_HANDLEFAILEDJOB = "handlefailedjob";
    private static final String BTN_VIEWBILLRELATION = "viewbillrelation";
    private static final String ENTRABILLNAMESHOW = "entrabillnameshow";
    private static final String SUBJECTSHOW = "subjectshow";
    private static final String CREATEDATE = "createdate";
    private static final String ENDTIME = "endtime";
    private static final String BUSINESSID = "businessid";
    private static final String STARTNAME = "startname";
    private static final String BAR_OPERATELOG = "baroperatelog";
    private static final String BTNBILL = "btnbill";
    private static final String PROCESSTYPE = "processtype";
    private static final String BILLFORMID = "billFormId";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && !"bpm".equals(parentView.getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VIEWBILLRELATION});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (WfAdminUtil.needFilterData()) {
            WfAdminUtil.addWfOrgFilter((SetFilterEvent)e, (String)"wf_historicalprocesses");
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        HashMap<String, String> fieldWidths = new HashMap<String, String>();
        String[][] arrays = null;
        if (this.isFromAuditFlow()) {
            arrays = new String[][]{{"Id", "id"}, {ResManager.loadKDString((String)"\u5355\u636e", (String)"WorkflowHistoricalProcessesPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), ENTRABILLNAMESHOW}, {ResManager.loadKDString((String)"\u6d41\u7a0b\u6807\u8bc6", (String)"WorkflowHistoricalProcessesPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), BUSINESSID}, {ResManager.loadKDString((String)"\u53d1\u8d77\u4eba", (String)"WorkflowHistoricalProcessesPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), STARTNAME}, {ResManager.loadKDString((String)"\u5355\u636e\u4e3b\u9898", (String)"WorkflowHistoricalProcessesPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), SUBJECTSHOW}, {ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"WorkflowHistoricalProcessesPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), CREATEDATE}, {ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4", (String)"WorkflowHistoricalProcessesPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), ENDTIME}, {ResManager.loadKDString((String)"\u5904\u7406\u8017\u65f6", (String)"WorkflowHistoricalProcessesPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), "handletime"}, {ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7/\u6d41\u7a0b/\u7248\u672c/\u65b9\u6848\u540d\u79f0", (String)"WorkflowHistoricalProcessesPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), "proandversion"}};
        } else {
            arrays = new String[][]{{"Id", "id"}, {ResManager.loadKDString((String)"\u5355\u636e", (String)"WorkflowHistoricalProcessesPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), ENTRABILLNAMESHOW}, {ResManager.loadKDString((String)"\u6d41\u7a0b\u6807\u8bc6", (String)"WorkflowHistoricalProcessesPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), BUSINESSID}, {ResManager.loadKDString((String)"\u53d1\u8d77\u4eba", (String)"WorkflowHistoricalProcessesPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), STARTNAME}, {ResManager.loadKDString((String)"\u5355\u636e\u4e3b\u9898", (String)"WorkflowHistoricalProcessesPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), SUBJECTSHOW}, {ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"WorkflowHistoricalProcessesPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), CREATEDATE}, {ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4", (String)"WorkflowHistoricalProcessesPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), ENDTIME}, {ResManager.loadKDString((String)"\u5904\u7406\u8017\u65f6", (String)"WorkflowHistoricalProcessesPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), "handletime"}, {ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7/\u6d41\u7a0b/\u7248\u672c/\u65b9\u6848\u540d\u79f0", (String)"WorkflowHistoricalProcessesPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), "proandversion"}, {ResManager.loadKDString((String)"\u6d41\u7a0b\u7c7b\u578b", (String)"WorkflowHistoricalProcessesPlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]), PROCESSTYPE}};
            fieldWidths.put(PROCESSTYPE, "15%");
        }
        fieldWidths.put(ENTRABILLNAMESHOW, "10%");
        fieldWidths.put(STARTNAME, "10%");
        fieldWidths.put(SUBJECTSHOW, "35%");
        fieldWidths.put(CREATEDATE, "10%");
        fieldWidths.put(ENDTIME, "10%");
        fieldWidths.put("handletime", "10%");
        fieldWidths.put("proandversion", "15%");
        List listColumns = args.getListColumns();
        String entityNumber = this.getPageCache().get("entityNumber");
        BillList parent = (BillList)args.getSource();
        for (Control control : parent.getItems()) {
            if (!(control instanceof ListGridView)) continue;
            parent = (ListGridView)control;
            break;
        }
        if (!listColumns.isEmpty()) {
            return;
        }
        for (String[] arr : arrays) {
            ListColumn listColumn = this.createListColumn(entityNumber, arr, "wf_historicalprocesses", fieldWidths);
            listColumn.setBlankFieldCanOrderAndFilter(true);
            listColumn.setParent((Container)parent);
            listColumn.setParentViewKey(parent.getKey());
            if (ENTRABILLNAMESHOW.equals(arr[1]) || SUBJECTSHOW.equals(arr[1]) || CREATEDATE.equals(arr[1]) || ENDTIME.equals(arr[1]) || BUSINESSID.equals(arr[1]) || STARTNAME.equals(arr[1]) || PROCESSTYPE.equals(arr[1])) {
                listColumn.setColumnOrderAndFilter(true);
            } else {
                listColumn.setColumnOrderAndFilter(false);
            }
            if (BUSINESSID.equals(arr[1])) {
                listColumn.setVisible(0);
            }
            listColumns.add(listColumn);
        }
    }

    public ListColumn createListColumn(String entityNumber, String[] arr, String entity, Map<String, String> fieldWidths) {
        boolean flag = false;
        if (WfUtils.isNotEmpty((String)entityNumber) && ENTRABILLNAMESHOW.equals(arr[1])) {
            flag = true;
        }
        if ("id".equalsIgnoreCase(arr[1])) {
            flag = true;
        }
        ListColumn listColumn = new ListColumn();
        listColumn.setCaption(new LocaleString(arr[0]));
        listColumn.setClassName("className");
        listColumn.setEntityName(entity);
        listColumn.setFieldName(arr[1]);
        listColumn.setKey("key" + arr[1]);
        listColumn.setListFieldKey(arr[1]);
        listColumn.setSeq(2);
        String width = fieldWidths.get(arr[1]);
        if (StringUtils.isNotBlank((CharSequence)width)) {
            listColumn.setWidth(new LocaleString(width));
        }
        listColumn.setVisible(flag ? 0 : 13);
        return listColumn;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        String key = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (key) {
            case "handlefailedjob": {
                this.handleFailedJob();
                break;
            }
            case "viewbillrelation": {
                this.viewBillRelation(rows);
                break;
            }
            case "baritemexit": {
                this.exit();
                break;
            }
            case "btnrefresh": {
                this.refresh();
                break;
            }
            case "baroperatelog": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getBillFormId(), (String)"47150e89000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u64cd\u4f5c\u65e5\u5fd7\u201d\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_31", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().getPageCache().put("openFormId", "wf_hioperationlog");
                this.queryAllApprovalRecord(rows);
                break;
            }
            case "btnbill": {
                this.showBtnBill(rows, evt);
                break;
            }
            default: {
                super.itemClick(evt);
            }
        }
    }

    private void showBtnBill(ListSelectedRowCollection rows, ItemClickEvent evt) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getBillFormId(), (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        } else if (rows.size() != 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
        } else {
            Long procInstId = (Long)rows.get(0).getPrimaryKeyValue();
            String workFlowType = ViewFlowchartUtil.getWorkFlowType((Long)procInstId);
            if (ProcessType.BizFlow.name().equals(workFlowType)) {
                this.viewBizflowBills(procInstId, workFlowType);
            } else {
                super.itemClick(evt);
            }
        }
    }

    private void viewBillRelation(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() != 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(Optional.ofNullable(rows).map(ArrayList::size).orElseGet(() -> 0).intValue());
            return;
        }
        BizFlowPluginUtil.openBillRelationGraph((Long)rows.get(0).getPrimaryKeyValue(), this.getView());
    }

    private void exit() {
        this.getView().close();
    }

    private void refresh() {
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    private void handleFailedJob() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getBillFormId(), (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4e91\u4e4b\u5bb6\u5f02\u5e38\u5f85\u529e\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"WorkflowHistoricalProcessesPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_failedjob");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new HistoryListDataProvider(this.getPageCache().get("entityNumber"), this.getView()));
    }

    @Override
    protected List<QFilter> wrapParallelQFilter(List<QFilter> filters) {
        if (CollectionUtil.isEmpty(filters)) {
            return new ArrayList<QFilter>();
        }
        ArrayList<QFilter> splitFilter = new ArrayList<QFilter>(filters.size());
        int size = filters.size();
        for (int i = size - 1; i >= 0; --i) {
            this.wrapNestQFilter(splitFilter, filters.get(i));
        }
        return splitFilter;
    }

    private boolean isFromAuditFlow() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter instanceof ListShowParameter) {
            return !"bpm_historicalprocess".equals(((ListShowParameter)parameter).getBillFormId());
        }
        return true;
    }

    @Override
    public Map<String, List<Object>> buildFilter(List<QFilter> filters) {
        if (filters.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
        formFieldMapSQLFiled.put("id", "a.fid");
        formFieldMapSQLFiled.put(CREATEDATE, "a.fcreatedate");
        formFieldMapSQLFiled.put("entitynumber", "a.fentitynumber");
        formFieldMapSQLFiled.put(ENTRABILLNAMESHOW, "b.fentrabillname");
        formFieldMapSQLFiled.put("entrabillname", "b.fentrabillname");
        formFieldMapSQLFiled.put(SUBJECTSHOW, "b.fsubject");
        formFieldMapSQLFiled.put("subject", "b.fsubject");
        formFieldMapSQLFiled.put(ENDTIME, "a.fendtime");
        formFieldMapSQLFiled.put("businesskey", "a.fbusinesskey");
        formFieldMapSQLFiled.put("name", "b.fname");
        formFieldMapSQLFiled.put(BUSINESSID, "a.fbusinessid");
        formFieldMapSQLFiled.put("mainorgid", "a.fmainorgid");
        if (WfConfigurationUtil.isDisplaySetting()) {
            formFieldMapSQLFiled.put(STARTNAME, "b.fstarusernameformat");
        } else {
            formFieldMapSQLFiled.put(STARTNAME, "b.fstartname");
        }
        if (!this.isFromAuditFlow()) {
            formFieldMapSQLFiled.put(PROCESSTYPE, "a.fprocesstype");
        }
        return this.getFilterSql(filters, formFieldMapSQLFiled);
    }

    @Override
    public String getOrderByStr(String orderBy) {
        if (WfUtils.isEmpty((String)orderBy)) {
            return orderBy;
        }
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
        formFieldMapSQLFiled.put("id", "a.fid");
        formFieldMapSQLFiled.put(CREATEDATE, "a.fcreatedate");
        formFieldMapSQLFiled.put("entitynumber", "a.fentitynumber");
        formFieldMapSQLFiled.put(ENTRABILLNAMESHOW, "b.fentrabillname");
        formFieldMapSQLFiled.put("entrabillname", "b.fentrabillname");
        formFieldMapSQLFiled.put(SUBJECTSHOW, "b.fsubject");
        formFieldMapSQLFiled.put("subject", "b.fsubject");
        formFieldMapSQLFiled.put(ENDTIME, "a.fendtime");
        formFieldMapSQLFiled.put(BUSINESSID, "a.fbusinessid");
        formFieldMapSQLFiled.put(STARTNAME, "a.fstartname");
        if (!this.isFromAuditFlow()) {
            formFieldMapSQLFiled.put(PROCESSTYPE, "a.fprocesstype");
        }
        String[] sqlFiledArray = orderBy.split(",");
        String result = "";
        StringBuilder resultSB = new StringBuilder(" ");
        for (int i = 0; i < sqlFiledArray.length; ++i) {
            String[] os = sqlFiledArray[i].split(" ");
            if (os.length != 2) continue;
            String ob = (String)formFieldMapSQLFiled.get(os[0]) + " " + os[1];
            resultSB.append(ob).append(',');
        }
        result = resultSB.substring(0, resultSB.length() - 1);
        return result;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (args.getSource() instanceof ExportList) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getBillFormId(), (String)"4730fc9f000004ae")) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_39", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rows == null || rows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkflowHistoricalProcessesPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private String getBillFormId() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID);
        return "bpm_historicalprocess".equals(billFormId) ? "bpm_historicalprocess" : "wf_historicalprocesses";
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }

    class HistoryListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = new QueryResult();
        private String entityNumber;
        private IFormView view;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public HistoryListDataProvider(String entityNumber, IFormView view) {
            this.entityNumber = entityNumber;
            this.view = view;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            String orderBy = this.getOrderByExpr();
            orderBy = WorkflowHistoricalProcessesPlugin.this.getOrderByStr(orderBy);
            Map<String, List<Object>> filterSqlAndParams = WorkflowHistoricalProcessesPlugin.this.buildFilter(this.getQFilters());
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            this.queryResult.setDataCount(this.getDataCount(filterSqlAndParams));
            DynamicObjectCollection data = null;
            try {
                boolean isFormAuditFlow = WorkflowHistoricalProcessesPlugin.this.isFromAuditFlow();
                data = WorkflowHistoricalProcessesPlugin.this.getHistoryService().getHistoricalProcessesData(start, limit, this.entityNumber, filterSql, params, orderBy, isFormAuditFlow);
            }
            catch (KDException ex) {
                if (WFErrorCode.workflowEngineNotConfiguration().equals((Object)ex.getErrorCode())) {
                    String hour = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"WorkflowHistoricalProcessesPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    String masterTableAlias = "a";
                    String multiLangTableAlias = "b";
                    String entityNumber = "wf_hiprocinst";
                    String entraBillNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fentrabillname", (String)"fentrabillname", (String)"entrabillname");
                    String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fstartname", (String)"fstartname", (String)WorkflowHistoricalProcessesPlugin.STARTNAME);
                    String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsubject", (String)"fsubject", (String)"subject");
                    String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fname", (String)"fname", (String)"name");
                    String sql = String.format("select a.fid," + entraBillNameSQL + "," + startNameSQL + "," + subjectSQL + ",a.fcreatedate,a.fendtime,concat((datediff(a.fcreatedate,a.fendtime))/3600, '%s')," + nameSQL + " from t_wf_hiprocinst a left join t_wf_hiprocinst_l b on a.fid = b.fid where 1!=1", hour);
                    try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.t_wf_hiprocinst.queryGridData.nodata", (DBRoute)DBRoute.workflow, (String)sql);){
                        data = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
                    }
                    WorkflowHistoricalProcessesPlugin.this.getView().showMessage(ex.getMessage());
                }
                throw ex;
            }
            this.queryResult.setCollection(data);
            return data;
        }

        public int getRealCount() {
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            Map<String, List<Object>> filterSqlAndParams = WorkflowHistoricalProcessesPlugin.this.buildFilter(this.getQFilters());
            return this.getDataCount(filterSqlAndParams);
        }

        private int getDataCount(Map<String, List<Object>> filterSqlAndParams) {
            int dataCount = 0;
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            try {
                boolean isFormAuditFlow = WorkflowHistoricalProcessesPlugin.this.isFromAuditFlow();
                dataCount = (int)WorkflowHistoricalProcessesPlugin.this.getHistoryService().getHistoricalProcessesDataCount(this.entityNumber, filterSql, params, isFormAuditFlow);
            }
            catch (KDException ex) {
                if (WFErrorCode.workflowEngineNotConfiguration().equals((Object)ex.getErrorCode())) {
                    WorkflowHistoricalProcessesPlugin.this.getView().showMessage(ex.getMessage());
                }
                throw ex;
            }
            return dataCount;
        }
    }
}

