/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.bos.workflow.component.WFNavigationBar;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowMoniterCenterPlugin
extends AbstractWorkflowPlugin
implements ItemClickListener {
    private static final String WORKFLOW_DEAD_LETTER_JOB_ID = "wf_deadletterjob";
    private static final String WORKFLOW_PROCESS_INSTANCE = "wf_execution";

    @Override
    public void initialize() {
        super.initialize();
        ControlTypes.register(WFNavigationBar.class);
        WFNavigationBar bar = (WFNavigationBar)this.getView().getControl("wfnavigationbarap");
        bar.addCustomListListener(this);
    }

    public void itemClick(ItemClickEvent evt) {
        String parentType = evt.getOperationKey();
        Map param = (Map)SerializationUtils.fromJsonString((String)evt.getItemKey(), Map.class);
        String type = (String)param.get("type");
        if (StringUtils.isBlank((String)parentType)) {
            this.openRigthPage(type, "");
        } else {
            this.openRigthPage(parentType, type);
        }
    }

    public void afterCreateNewData(EventObject e) {
        WFNavigationBar bar = (WFNavigationBar)this.getControl("wfnavigationbarap");
        List navigationData = this.getRuntimeService().getProInstNavigationData();
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("task", navigationData);
        bar.setData(data, "", "");
        this.openRigthPage(WORKFLOW_PROCESS_INSTANCE, "");
    }

    public void openRigthPage(String billType, String parentType) {
        if (StringUtils.isBlank((String)billType)) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String parentBill = pageCache.get("parentBillType");
        pageCache.put("currentBillType", billType);
        pageCache.put("parentBillType", parentBill);
        String menuPageid = this.getPageCache().get("menupageid");
        if (menuPageid != null) {
            HashMap<String, String> pageIds = new HashMap<String, String>();
            pageIds.put("pageId", menuPageid);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", pageIds);
        }
        menuPageid = UUID.randomUUID().toString();
        pageCache.put("menupageid", menuPageid);
        ListShowParameter parameter = new ListShowParameter();
        StyleCss sc = new StyleCss();
        parameter.getOpenStyle().setInlineStyleCss(sc);
        parameter.setBillFormId(billType);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelright");
        parameter.setPageId(menuPageid);
        Map pcustomParams = this.getView().getFormShowParameter().getCustomParams();
        parameter.setCustomParam("pparentPageId", pcustomParams.get("parentPageId"));
        if (WfUtils.isNotEmpty((String)parentType)) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter("entityNumber", "in", (Object)parentType);
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
        }
        this.getView().showForm((FormShowParameter)parameter);
    }
}

