/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowOpenBills
extends AbstractWorkflowPlugin
implements ItemClickListener {
    private static final String BILLSPANEL = "billspanel";
    private static final String WF_APPHOME_NEW = "wf_apphome_new";
    private static final String BPM_APPHOME_GRID = "bpm_apphome_grid";
    private static final String BARITEMAP = "baritemap1";
    private static final String JUMPSUSPEND = "jumpSuspend";
    private static final String IFRAMEPANEL = "iframepanel";
    private static final String IFRAME_REMOTEDATASOURCE = "remotedatasource";
    private static final String CURSELPROCESSINSTANCEID = "CURSELPROCESSINSTANCEID";
    private static final String DESTNODEID = "DESTNODEID";
    private static final String SRCID = "SRCID";
    private static final String PROCESSINSTANCEBILLFORMID = "wf_execution";
    private static final String CURRENTTASKFORMID = "wf_taskmonitoring";
    private static final String WF_EXECUTION_TREE = "wf_execution_tree";
    private static final String EXCEPTIONALPROCEDUREBILLFORMID = "wf_deadletterjob";
    private static final String HISTORICALPROCESSBILLFORMID = "wf_historicalprocesses";
    private static final String BPMHISTORICALPROCESS = "bpm_historicalprocess";
    private static final String BAR_ERROR_MESSAGE = "barerrormessage";
    private static final String BAR_SUSPEND = "suspend";
    private static final String BAR_REVOKE_SUSPEND = "barrevokesuspend";
    private static final String DYNAMIC_UPDATE_PROCINST = "updateprocinst";
    private static final String ABANDON = "feiqi";
    private static final String CURTASK = "curtask";
    private static final String BAR_PROCESS_SALUTION = "barprocesssalution";
    private static final String TRANSFERLOG = "transferlog";
    private static final String BARVIEWCHART = "barviewchart";
    private static final String SKIP = "skip";
    private static final String BAR_OPERATIONLOG = "operationlog";
    private static final String CONFIRMABANDONFROMSHARED = "confirmAbandonFromShared";
    private static final String WF_HIPROCINST_MENU = "wf_hiprocinst_menu";
    private static final String KEY_OPENED_LOG_LIST_ID = "openedLogIds";
    private static final String BILL_FORM_ID = "BillFormId";
    private static final String APP = "appType";
    private static final String PROCINSTID = "procInstId";
    private static final String ROWID = "rowId";

    public void afterCreateNewData(EventObject e) {
        Object procInstId;
        super.afterCreateNewData(e);
        ArchiveFormService archiveFormService = ArchiveFormService.create();
        archiveFormService.injectArchiveRouteInfo(this.getView());
        this.implantPage();
        FormView formView = (FormView)this.getView();
        ArrayList<Long> executionIds = new ArrayList();
        executionIds = this.getExecutionIds();
        Object pkId = this.getView().getFormShowParameter().getCustomParam("pkId");
        ProcessInstancePluginUtil.buttonAvailable(executionIds, pkId, (IFormView)formView, 1);
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILL_FORM_ID);
        if ("evt_job".equals(billFormId) || "evt_deadletterjob".equals(billFormId)) {
            formView.setVisible(Boolean.FALSE, new String[]{BARITEMAP});
        }
        if ((procInstId = this.getView().getFormShowParameter().getCustomParam(PROCINSTID)) != null && ProcessType.BizFlow.name().equals(ViewFlowchartUtil.getWorkFlowType((Long)Long.valueOf(procInstId.toString())))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SUSPEND, SKIP});
        }
        if (EXCEPTIONALPROCEDUREBILLFORMID.equals(billFormId) && archiveFormService.isArchiveDBInView(this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BARITEMAP});
        }
    }

    private void implantPage() {
        String app;
        String parentId = this.getView().getFormShowParameter().getParentFormId();
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILL_FORM_ID);
        IFormView parentView = this.getView().getParentView();
        String string = app = null == parentView ? null : (String)parentView.getFormShowParameter().getCustomParam(APP);
        if (WF_APPHOME_NEW.equals(parentId) || "wf".equalsIgnoreCase(app) || BPM_APPHOME_GRID.equals(parentId)) {
            if (HISTORICALPROCESSBILLFORMID.equals(billFormId) || BPMHISTORICALPROCESS.equals(billFormId) || WF_HIPROCINST_MENU.equals(billFormId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BARITEMAP});
            }
            this.openPage(false);
        } else if ("bizevent_apphome".equals(parentId)) {
            this.openPage(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BARITEMAP});
            this.openPage(true);
        }
    }

    private void openPage(boolean msgCenter) {
        Object pkId;
        this.getView().setVisible(Boolean.TRUE, new String[]{BILLSPANEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{IFRAMEPANEL});
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("pageId");
        String appId = (String)this.getView().getFormShowParameter().getCustomParam("appId");
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        Object pk = this.getView().getFormShowParameter().getCustomParam("pkId");
        String url = WfUtils.buildTrdBillShowPageURL((String)String.valueOf(pk), (String)formId);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLSPANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{IFRAMEPANEL});
            IFrame iFrame = (IFrame)this.getControl(IFRAME_REMOTEDATASOURCE);
            iFrame.setSrc(url);
            return;
        }
        IFormView settingsFormView = this.getView();
        Object para_base = null;
        QFilter q = new QFilter("number", "=", (Object)formId);
        QFilter[] filters = new QFilter[]{q};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"modeltype", (QFilter[])filters);
        String modelType = dynamicObject.getString("modeltype");
        para_base = "BaseFormModel".equals(modelType) ? new BaseShowParameter() : new BillShowParameter();
        if (this.getView().getFormShowParameter().getCustomParam("pkId") instanceof Long) {
            pkId = (Long)this.getView().getFormShowParameter().getCustomParam("pkId");
            para_base.setPkId(pkId);
        } else if (this.getView().getFormShowParameter().getCustomParam("pkId") instanceof Integer) {
            pkId = (Integer)this.getView().getFormShowParameter().getCustomParam("pkId");
            if (pkId != null) {
                para_base.setPkId((Object)Long.valueOf(((Integer)pkId).toString()));
            } else {
                this.logger.debug("pk is null, it may not open bill form.");
            }
        } else if (this.getView().getFormShowParameter().getCustomParam("pkId") instanceof String) {
            pkId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
            para_base.setPkId(pkId);
        }
        para_base.setPageId(pageId);
        if (WfUtils.isNotEmptyString((Object)appId)) {
            para_base.getCustomParams().put("ServiceAppId", appId);
        }
        if (msgCenter) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object id = customParams.get(PROCINSTID);
            if (id instanceof Long) {
                para_base.setCustomParam("processInstanceId", id);
            } else if (id instanceof String) {
                para_base.setCustomParam("processInstanceId", (Object)Long.valueOf((String)customParams.get(PROCINSTID)));
            }
            para_base.setCustomParam("taskDefinitionKey", customParams.get("taskDefinitionKey"));
            para_base.setCustomParam("formkey", customParams.get("formkey"));
            para_base.setCustomParam("businessKey", customParams.get("businessKey"));
            para_base.setCustomParam("onlyView", (Object)Boolean.TRUE);
            para_base.setCustomParam("pcShow", (Object)Boolean.TRUE);
            para_base.setCustomParam("istoapplyorapplyed", (Object)("toApply".equals(type) || "applyed".equals(type) ? 1 : 0));
            para_base.setCustomParam("showBillBtnsWhenToApplyOrApplyed", (Object)"true");
            para_base.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "istoapplyorapplyed"));
        }
        para_base.getCustomParams().put("fromMsgCenter", msgCenter);
        Object procInstId = this.getView().getFormShowParameter().getCustomParam(PROCINSTID);
        if (procInstId != null) {
            TaskService taskService;
            String appNumber;
            Long procInstenceId = null;
            if (procInstId instanceof Long) {
                procInstenceId = (Long)procInstId;
            } else if (procInstId instanceof String) {
                procInstenceId = Long.parseLong(procInstId.toString());
            }
            if (WfUtils.isNotEmpty((Long)procInstenceId) && WfUtils.isNotEmpty((String)(appNumber = (taskService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService()).findVariableInstancesByExecutionAndNames(procInstenceId, "appnumber")))) {
                para_base.getCustomParams().put("checkRightAppId", appNumber);
            }
        }
        para_base.getCustomParams().put("VIEWBILL", Boolean.TRUE);
        para_base.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        para_base.setFormId(formId);
        para_base.setStatus(OperationStatus.VIEW);
        para_base.setBillStatus(BillOperationStatus.VIEW);
        para_base.getOpenStyle().setTargetKey(BILLSPANEL);
        para_base.getOpenStyle().setShowType(ShowType.InContainer);
        para_base.setHasRight(true);
        para_base.setCustomParam("SOURCE", (Object)"WF");
        para_base.addCustPlugin("kd.bos.workflow.runtime.plugin.ApprovalBillControlPlugIn");
        this.logger.info("openPage setDisableLayoutScheme:" + !WfConfigurationUtil.isJumpEmbeddedPageByBillType());
        para_base.setCustomParam("disableBillType", (Object)(!WfConfigurationUtil.isJumpEmbeddedPageByBillType() ? 1 : 0));
        ArchiveFormService.create().setArchiveRouteInfo(this.getView(), (FormShowParameter)para_base);
        settingsFormView.showForm((FormShowParameter)para_base);
        this.getView().sendFormAction(settingsFormView);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BARITEMAP});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILL_FORM_ID);
        Long primaryKeyValue = (Long)this.getView().getFormShowParameter().getCustomParam(ROWID);
        String key = evt.getItemKey();
        List<Long> procInstId = this.getProcInstId(billFormId, primaryKeyValue);
        if (procInstId == null || procInstId.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u8bd5\u3002", (String)"WorkflowOpenBills_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "barerrormessage": {
                ProcessInstancePluginUtil.openErrorMSGList(procInstId, this.getView());
                break;
            }
            case "suspend": {
                ProcessInstancePluginUtil.suspend(this.getView(), procInstId);
                break;
            }
            case "barrevokesuspend": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)PROCESSINSTANCEBILLFORMID, (String)"/8M3MNJNJZE5")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u91cd\u65b0\u6fc0\u6d3b\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                ProcessInstancePluginUtil.revokeSuspend(this.getView(), procInstId);
                String listViewId = (String)this.getView().getFormShowParameter().getCustomParam("listView");
                ListView view = (ListView)this.getView().getView(listViewId);
                view.updateView();
                view.showSuccessNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u64a4\u9500\u6302\u8d77\u5df2\u6210\u529f\u3002", (String)"WorkflowOpenBills_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().sendFormAction((IFormView)view);
                this.getView().close();
                break;
            }
            case "updateprocinst": {
                ProcessInstancePluginUtil.updateProcInst(this.getView(), procInstId);
                break;
            }
            case "feiqi": {
                ProcessInstancePluginUtil.abandon(this.getView(), procInstId.get(0), (IFormPlugin)this);
                break;
            }
            case "curtask": {
                ProcessInstancePluginUtil.viewCurrentTask(this.getView(), procInstId);
                break;
            }
            case "barprocesssalution": {
                ProcessInstancePluginUtil.showProcessConfiguration(this.getView(), procInstId.get(0));
                break;
            }
            case "transferlog": {
                ProcessInstancePluginUtil.showTransferLog(this.getView(), procInstId);
                break;
            }
            case "barviewchart": {
                this.viewFlowchart(procInstId);
                break;
            }
            case "skip": {
                if (procInstId != null && procInstId.size() > 0) {
                    this.getPageCache().put("pk", Long.toString(procInstId.get(0)));
                }
                ProcessInstancePluginUtil.skip(this.getView(), procInstId, (IFormPlugin)this);
                break;
            }
            case "operationlog": {
                this.showOperationLog(procInstId);
                break;
            }
        }
    }

    private List<Long> getProcInstId(String billFormId, Long primaryKeyValue) {
        ArrayList<Long> procInstIds = new ArrayList<Long>(1);
        if (PROCESSINSTANCEBILLFORMID.equals(billFormId) || WF_EXECUTION_TREE.equals(billFormId)) {
            procInstIds.add(primaryKeyValue);
        } else if (EXCEPTIONALPROCEDUREBILLFORMID.equals(billFormId)) {
            Long procInstId = this.getExceptionalProcedureProId(primaryKeyValue);
            if (procInstId != null) {
                procInstIds.add(procInstId);
            }
        } else if (WF_HIPROCINST_MENU.equals(billFormId)) {
            procInstIds.add(primaryKeyValue);
        } else {
            procInstIds.add(this.getMissionControProId(primaryKeyValue));
        }
        return procInstIds;
    }

    private void viewFlowchart(List<Long> procInstIds) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u56fe\u201d\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\u3002", (String)"WorkflowOpenBills_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!procInstIds.isEmpty()) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam(PROCINSTID, (Object)String.valueOf(procInstIds.get(0)));
            parameter.setClientParam(PROCINSTID, (Object)String.valueOf(procInstIds.get(0)));
            parameter.setClientParam("showButtons", (Object)"true");
            ViewFlowchartUtil.showFlowchart((IFormView)this.getView(), (FormShowParameter)parameter);
        } else {
            this.logger.debug("The procInstId param is null!");
        }
    }

    private void showOperationLog(List<Long> procInstIds) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u64cd\u4f5c\u65e5\u5fd7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"WorkflowOpenBills_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!procInstIds.isEmpty()) {
            Long procInstId = procInstIds.get(0);
            String ids = this.getPageCache().get(KEY_OPENED_LOG_LIST_ID);
            Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
            String idStr = String.valueOf(procInstId);
            String pageId = null;
            IFormView openedView = null;
            pageId = (String)idsMap.get(idStr);
            if (pageId != null && (openedView = this.getView().getView(pageId)) != null) {
                openedView.activate();
                this.getView().sendFormAction(openedView);
                return;
            }
            String openBillFormId = "wf_operationlog";
            if (QueryServiceHelper.exists((String)"wf_hiprocinst", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)procInstId), new QFilter("endtime", "is not null", null)})) {
                openBillFormId = "wf_hioperationlog";
            }
            QFilter qFilter = new QFilter("procinstid", "=", (Object)procInstId);
            IFormView settingsFormView = DesignerModelUtil.getTabControlView(this.getView());
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(openBillFormId);
            parameter.setFormId("bos_list");
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            if (settingsFormView != null) {
                parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setCustomParam("isOpenNewTab", (Object)true);
                settingsFormView.showForm((FormShowParameter)parameter);
                this.getView().sendFormAction(settingsFormView);
            } else {
                parameter.getOpenStyle().setShowType(ShowType.NonModal);
                this.getView().showForm((FormShowParameter)parameter);
            }
            idsMap.put(idStr, parameter.getPageId());
            this.getPageCache().put(KEY_OPENED_LOG_LIST_ID, SerializationUtils.toJsonString(idsMap));
        } else {
            this.logger.debug("The procInstId param is null!");
        }
    }

    private List<Long> getExecutionIds() {
        ArrayList<Long> executionIds = new ArrayList<Long>();
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILL_FORM_ID);
        Long primaryKeyValue = 0L;
        if (PROCESSINSTANCEBILLFORMID.equals(billFormId) || CURRENTTASKFORMID.equals(billFormId)) {
            primaryKeyValue = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam(PROCINSTID));
            executionIds.add(primaryKeyValue);
        } else {
            primaryKeyValue = (Long)this.getView().getFormShowParameter().getCustomParam(ROWID);
            String sql = "select FEXECUTIONID,FPROCESSINSTANCEID from t_wf_deadletterjob WHERE fid = " + primaryKeyValue;
            try (DataSet ds = DB.queryDataSet((String)"wf.plugin.findExecutionId", (DBRoute)WfUtils.WFS, (String)sql, null);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    executionIds.add(r.getLong("FPROCESSINSTANCEID"));
                }
            }
        }
        return executionIds;
    }

    private Long getExceptionalProcedureProId(Long pkValue) {
        String sql = "select FPROCESSINSTANCEID from t_wf_deadletterjob WHERE fid =" + pkValue;
        ArrayList<Long> processinstanceids = new ArrayList<Long>(1);
        try (DataSet ds = DB.queryDataSet((String)"wf.plugin.findExecutionId", (DBRoute)DBRoute.workflow, (String)sql, null);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row r = (Row)iter.next();
                processinstanceids.add(r.getLong("FPROCESSINSTANCEID"));
            }
        }
        if (processinstanceids.size() > 0) {
            return (Long)processinstanceids.get(0);
        }
        return null;
    }

    private Long getMissionControProId(Long primaryKeyValue) {
        String sql = "select FPROCINSTID from t_wf_hitaskinst WHERE fid =" + primaryKeyValue;
        ArrayList<Long> processinstanceids = new ArrayList<Long>(1);
        try (DataSet ds = DB.queryDataSet((String)"wf.plugin.findExecutionId", (DBRoute)DBRoute.workflow, (String)sql, null);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row r = (Row)iter.next();
                processinstanceids.add(r.getLong("FPROCINSTID"));
            }
        }
        if (!processinstanceids.isEmpty()) {
            return (Long)processinstanceids.get(0);
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        block11: {
            super.closedCallBack(e);
            Object returnData = e.getReturnData();
            if ("wf_skipnode".equalsIgnoreCase(e.getActionId()) && returnData instanceof Map) {
                Map ret = (Map)returnData;
                if (ret != null && !ret.isEmpty()) {
                    Long pk = Long.valueOf(this.getPageCache().get("pk"));
                    if (pk == null) {
                        return;
                    }
                    Map obj = ret;
                    String destId = (String)obj.get("id");
                    String srcId = (String)obj.get("srcId");
                    WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                    try {
                        this.getPageCache().put(CURSELPROCESSINSTANCEID, String.valueOf(pk));
                        this.getPageCache().put(DESTNODEID, destId);
                        this.getPageCache().put(SRCID, srcId);
                        wfService.getManagementService().jumpToNode(pk.longValue(), destId, srcId);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8df3\u8f6c\u6210\u529f\u3002", (String)"WorkflowOpenBills_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        this.getPageCache().remove(CURSELPROCESSINSTANCEID);
                        this.getPageCache().remove(DESTNODEID);
                        this.getPageCache().remove(SRCID);
                        ProcessInstancePluginUtil.closeAndRefreshParentView(this.getView());
                    }
                    catch (Exception e1) {
                        ErrorCode code;
                        if (!(e1 instanceof KDException) || (code = ((KDException)((Object)e1)).getErrorCode()) == null) break block11;
                        if (WFErrorCode.processSuspendSimple().equals((Object)code) || WFErrorCode.processSuspend().equals((Object)code)) {
                            this.getView().showConfirm(e1.getMessage(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(JUMPSUSPEND));
                            break block11;
                        }
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowOpenBills_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), e1.getMessage()));
                        this.getPageCache().remove(CURSELPROCESSINSTANCEID);
                        this.getPageCache().remove(DESTNODEID);
                    }
                }
            } else if ("wf_abandon".equalsIgnoreCase(e.getActionId()) && returnData != null) {
                this.getView().showSuccessNotification(WFMultiLangConstants.getAbandonCauseSuccess());
            } else if ("wf_adminabandon_option".equals(e.getActionId())) {
                this.logger.debug("admin abandon opinion callback: " + returnData);
                Object pkId = this.getView().getFormShowParameter().getCustomParam(PROCINSTID);
                ProcessInstancePluginUtil.adminAbandonOpionCallback(this.getView(), String.valueOf(pkId), returnData);
            }
        }
        if ("istoapplyorapplyed".equals(e.getActionId())) {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            switch (callBackId) {
                case "feiqi": {
                    this.realAbandon();
                    break;
                }
                case "jumpSuspend": {
                    this.getPageCache().put("openbill", "true");
                    ProcessInstancePluginUtil.skipSuspend(this.getView(), this.getPageCache());
                    break;
                }
                case "suspend": {
                    this.confirmSuspend();
                    break;
                }
                case "confirmAbandonFromShared": {
                    ProcessInstancePluginUtil.abandonConfirm((IFormPlugin)this, this.getView());
                    break;
                }
            }
        }
    }

    private void realAbandon() {
        String id = null;
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILL_FORM_ID);
        Long primaryKeyValue = (Long)this.getView().getFormShowParameter().getCustomParam(ROWID);
        if (PROCESSINSTANCEBILLFORMID.equals(billFormId)) {
            id = String.valueOf(primaryKeyValue);
        } else if (EXCEPTIONALPROCEDUREBILLFORMID.equals(billFormId)) {
            Long procDefId = this.getExceptionalProcedureProId(primaryKeyValue);
            if (procDefId != null) {
                id = String.valueOf(this.getExceptionalProcedureProId(primaryKeyValue));
            }
        } else {
            Long missionControProId = this.getMissionControProId(primaryKeyValue);
            if (WfUtils.isNotEmpty((Long)missionControProId)) {
                id = String.valueOf(missionControProId);
            }
        }
        if (id != null) {
            ProcessInstancePluginUtil.realAbandon(this.getView(), id);
        }
    }

    private void confirmSuspend() {
        Long primaryKeyValue;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String billFormId = (String)showParameter.getCustomParam(BILL_FORM_ID);
        List<Long> procInstIds = this.getProcInstId(billFormId, primaryKeyValue = (Long)this.getView().getFormShowParameter().getCustomParam(ROWID));
        if (!procInstIds.isEmpty()) {
            ProcessInstancePluginUtil.confirmSuspend(this.getView(), procInstIds, false, (IFormPlugin)this);
            Object pkId = showParameter.getCustomParam("pkId");
            ProcessInstancePluginUtil.buttonAvailable(procInstIds, pkId, this.getView(), 1);
        }
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }

    private String getPermissionEntity() {
        return ProcessInstancePluginUtil.getPermissionEntity(this.getView());
    }
}

