/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCDataPlugin;

public class WorkflowOperateLogPlugin
extends WorkflowTCDataPlugin {
    private static final String ACTIVITYNAME = "activityname";
    private static final String TYPE = "type";
    private static final String CREATEDATE = "createdate";
    private static final String OPINION = "opinion";
    private static final String TERMINALWAY = "terminalway";
    private static final String NOTE = "notesummary";
    private static final String ACTIVITYID = "activityid";
    private static final String ASSIGNEE = "assignee";
    private static final String OWNER = "owner";
    private static final String RESULTNAME = "resultname";
    private static final String BOS_WF_FORMPLUGIN = "bos-wf-formplugin";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String[][] fields = new String[][]{{ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0", (String)"WorkflowOperateLogPlugin_0", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), ACTIVITYNAME}, {ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"WorkflowOperateLogPlugin_1", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), OWNER}, {ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"WorkflowOperateLogPlugin_2", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), TYPE}, {ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"WorkflowOperateLogPlugin_3", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), CREATEDATE}, {ResManager.loadKDString((String)"\u5904\u7406\u610f\u89c1", (String)"WorkflowOperateLogPlugin_4", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), OPINION}, {ResManager.loadKDString((String)"\u7ec8\u7aef", (String)"WorkflowOperateLogPlugin_5", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), TERMINALWAY}, {ResManager.loadKDString((String)"\u5907\u6ce8", (String)"WorkflowOperateLogPlugin_6", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), NOTE}, {ResManager.loadKDString((String)"\u8282\u70b9\u7f16\u7801", (String)"WorkflowOperateLogPlugin_7", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), ACTIVITYID}, {ResManager.loadKDString((String)"\u51b3\u7b56\u9879", (String)"WorkflowOperateLogPlugin_13", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), RESULTNAME}};
        Container parent = (Container)args.getSource();
        for (Control control : parent.getItems()) {
            if (!(control instanceof ListGridView)) continue;
            parent = (Container)control;
            break;
        }
        for (String[] arr : fields) {
            ListColumn listColumn = new ListColumn();
            listColumn.setCaption(new LocaleString(arr[0]));
            listColumn.setClassName("className");
            listColumn.setEntityName("wf_operationlog");
            listColumn.setFieldName(arr[1]);
            listColumn.setKey("key" + arr[1]);
            listColumn.setListFieldKey(arr[1]);
            listColumn.setSeq(2);
            listColumn.setWidth(new LocaleString(arr[1]));
            listColumn.setParentViewKey(parent.getKey());
            if (OWNER.equals(arr[1])) {
                listColumn.setColumnOrderAndFilter(false);
                listColumn.setBlankFieldCanOrderAndFilter(false);
            } else {
                listColumn.setColumnOrderAndFilter(true);
                listColumn.setBlankFieldCanOrderAndFilter(true);
            }
            List listColumns = args.getListColumns();
            listColumns.add(listColumn);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new OperationLogListDataProvider(this.getView()));
    }

    class OperationLogListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private IFormView view;

        public OperationLogListDataProvider(IFormView view) {
            this.view = view;
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String orderBy = this.getOrderByExpr();
            orderBy = this.buildOrderByCondition(orderBy);
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, this.getQueryBuilder());
            Map<String, List<Object>> filterSqlAndParams = this.buildFilter(this.getQFilters());
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            this.queryResult = new QueryResult();
            DynamicObjectCollection data = WorkflowOperateLogPlugin.this.getRepositoryService().getOperationLogList(start, limit, filterSql, params, orderBy);
            if (WfUtils.isNotEmptyForCollection((Collection)data)) {
                this.queryResult.setDataCount(data.size());
                for (DynamicObject row : data) {
                    this.createDescription(row);
                }
            }
            this.queryResult.setCollection(data);
            return data;
        }

        private String buildOrderByCondition(String orderBy) {
            if (WfUtils.isEmpty((String)orderBy)) {
                return "a.fstep asc";
            }
            HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.ACTIVITYNAME, "b.factivityname");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.TYPE, "a.ftype");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.CREATEDATE, "a.fcreatedate");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.OPINION, "b.fnopinion");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.TERMINALWAY, "a.fterminalway");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.NOTE, "b.fnote");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.ACTIVITYID, "a.factivityid");
            formFieldMapSQLFiled.put("id", "a.fid");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.RESULTNAME, "b.fresultname");
            String[] sqlFiledArray = orderBy.split(",");
            String result = "";
            StringBuilder resultSB = new StringBuilder(" ");
            for (int i = 0; i < sqlFiledArray.length; ++i) {
                String[] sqlFileds = sqlFiledArray[i].split(" ");
                if (sqlFileds.length != 2) continue;
                String ob = (String)formFieldMapSQLFiled.get(sqlFileds[0]) + " " + sqlFileds[1];
                resultSB.append(ob).append(',');
            }
            result = resultSB.substring(0, resultSB.length() - 1);
            return result;
        }

        private Map<String, List<Object>> buildFilter(List<QFilter> filters) {
            HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
            formFieldMapSQLFiled.put("procinstid", "a.fprocinstid");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.ACTIVITYNAME, "b.factivityname");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.TYPE, "a.ftype");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.CREATEDATE, "a.fcreatedate");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.OPINION, "b.fnopinion");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.TERMINALWAY, "a.fterminalway");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.NOTE, "b.fnote");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.ACTIVITYID, "a.factivityid");
            formFieldMapSQLFiled.put(WorkflowOperateLogPlugin.RESULTNAME, "b.fresultname");
            return WorkflowOperateLogPlugin.this.getFilterSql(filters, formFieldMapSQLFiled);
        }

        private void createDescription(DynamicObject row) {
            if (null == row) {
                return;
            }
            String type = (String)row.get(WorkflowOperateLogPlugin.TYPE);
            String owner = (String)row.get(WorkflowOperateLogPlugin.OWNER);
            String assignee = (String)row.get(WorkflowOperateLogPlugin.ASSIGNEE);
            switch (type) {
                case "delegate": {
                    row.set(WorkflowOperateLogPlugin.OWNER, (Object)String.format(ResManager.loadKDString((String)"%1$s [\u59d4\u6258\u7ed9] %2$s", (String)"WorkflowOperateLogPlugin_8", (String)WorkflowOperateLogPlugin.BOS_WF_FORMPLUGIN, (Object[])new Object[0]), owner, assignee));
                    break;
                }
                case "transfer": {
                    row.set(WorkflowOperateLogPlugin.OWNER, (Object)String.format(ResManager.loadKDString((String)"%1$s [\u8f6c\u4ea4\u7ed9] %2$s", (String)"WorkflowOperateLogPlugin_9", (String)WorkflowOperateLogPlugin.BOS_WF_FORMPLUGIN, (Object[])new Object[0]), owner, assignee));
                    break;
                }
                case "coordinateRequest": {
                    row.set(WorkflowOperateLogPlugin.OWNER, (Object)String.format(ResManager.loadKDString((String)"%1$s [\u8bf7\u6c42] %2$s [\u534f\u529e]", (String)"WorkflowOperateLogPlugin_10", (String)WorkflowOperateLogPlugin.BOS_WF_FORMPLUGIN, (Object[])new Object[0]), owner, assignee));
                    break;
                }
                case "coordinateReply": {
                    row.set(WorkflowOperateLogPlugin.OWNER, (Object)String.format(ResManager.loadKDString((String)"%1$s [\u56de\u590d\u4e86] %2$s [\u7684\u534f\u529e]", (String)"WorkflowOperateLogPlugin_11", (String)WorkflowOperateLogPlugin.BOS_WF_FORMPLUGIN, (Object[])new Object[0]), owner, assignee));
                    break;
                }
                case "circulation": {
                    row.set(WorkflowOperateLogPlugin.OWNER, (Object)String.format(ResManager.loadKDString((String)"%1$s [\u4f20\u9605\u7ed9] %2$s", (String)"WorkflowOperateLogPlugin_12", (String)WorkflowOperateLogPlugin.BOS_WF_FORMPLUGIN, (Object[])new Object[0]), owner, assignee));
                    break;
                }
                default: {
                    row.set(WorkflowOperateLogPlugin.OWNER, (Object)(WfUtils.isNotEmpty((String)owner) ? owner : assignee));
                }
            }
        }
    }
}

