/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCDataPlugin;

public class WorkflowProcessInstancePluginNew
extends WorkflowTCDataPlugin {
    private static final String SCOPE = "scope";
    private static final String VIEWBILLRELATION = "viewbillrelation";
    private static final String ENTRABILLNAME = "entrabillname";
    private static final String BILLNO = "billno";
    private static final String NAME = "name";
    private static final String SUBJECT = "subject";
    private static final String SUSPENSIONSTATE = "suspensionstate";
    private static final String ACTIVITYNAME = "activityname";
    private static final String MODIFYDATE = "modifydate";
    private static final String CREATEDATE = "createdate";
    private static final String PROCESSTYPE = "processtype";
    private static final String VIEWBILLS = "btnviewbills";
    private static final String WF_EXECUTION_TREE = "wf_execution_tree";

    public void beforeBindData(EventObject e) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ArrayList<String> typeList = new ArrayList<String>(2);
        typeList.add(ModelType.AuditFlow.name());
        typeList.add(ModelType.BizFlow.name());
        QFilter filter = new QFilter(SCOPE, "=", (Object)"1").and(new QFilter(PROCESSTYPE, "in", typeList));
        list.setFilter(filter);
        list.setOrderBy("modifydate desc");
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnbill"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (WfAdminUtil.needFilterData()) {
            WfAdminUtil.addWfOrgFilter((SetFilterEvent)e, (String)"wf_execution");
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        String itemKey = evt.getItemKey();
        if (VIEWBILLRELATION.equals(itemKey)) {
            this.viewBillRelation();
        } else if (VIEWBILLS.equals(itemKey)) {
            this.viewBills();
        } else if ("abandonbill".equals(itemKey)) {
            this.showAbandonBillPage();
        }
    }

    private void showAbandonBillPage() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"194JD185SVFC", (String)WF_EXECUTION_TREE, (String)"/8M3RG6213GO")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u5f3a\u5236\u7ec8\u6b62\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_26", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null) {
            Long pk = (Long)rows.get(0).getPrimaryKeyValue();
            ProcessInstancePluginUtil.abandonBill(this.getView(), pk, (IFormPlugin)this);
        }
    }

    private void viewBills() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"194JD185SVFC", (String)WF_EXECUTION_TREE, (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null) {
            Object pk = rows.get(0).getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"wf_execution");
            String processtype = dynamicObject.getString(PROCESSTYPE);
            if (ProcessType.BizFlow.name().equals(processtype)) {
                Long processInstanceId = dynamicObject.getLong("processInstanceId");
                this.viewBizflowBills(processInstanceId, processtype);
            } else {
                this.showBill("toApply");
            }
        }
    }

    private void viewBillRelation() {
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null) {
            BizFlowPluginUtil.openBillRelationGraph((Long)rows.get(0).getPrimaryKeyValue(), this.getView());
        }
    }
}

