/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Control;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.monitor.plugin.WorkflowUserUtil;

public class WorkflowSearchDDTaskListPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_QUERY = "btnquery";
    private static final String BTN_QUERY_AGAIN = "btnqueryagain";
    private static final String USER_ID = "user";
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_QUERY});
        WorkflowUserUtil.showUsersAddCustomParam(this.getView(), new String[]{USER_ID});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_QUERY_AGAIN});
        this.getModel().setEntryCurrentRowIndex(ENTRY_ENTITY, 1);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_QUERY.equals(key)) {
            this.query();
        }
    }

    private void query() {
        int totalSize;
        List<Map<String, Object>> records;
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        DynamicObject userObject = (DynamicObject)this.getModel().getValue(USER_ID);
        if (null == userObject) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u53ef\u4e3a\u7a7a", (String)"WorkflowSearchDDTaskListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String userId = userObject.getPkValue().toString();
        String openId = this.getOpenIdByUserId(userId);
        if (WfUtils.isEmpty((String)openId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u7684\u9489\u9489\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowSearchDDTaskListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean statusZero = true;
        long status = Long.parseLong((String)this.getModel().getValue("status"));
        if (status == -1L) {
            statusZero = false;
        }
        boolean hasMore = false;
        int pageSize = 0;
        ArrayList resultData = new ArrayList();
        HashSet todoIds = new HashSet();
        do {
            long count;
            long offSet;
            Map retObject;
            if (null == (retObject = MessageServiceHelper.queryDDTask((String)openId, (long)(offSet = (long)pageSize), (long)(count = 50L), (long)status)) || null == retObject.get("errcode")) continue;
            long l = (Long)retObject.get("errcode");
            if (0L == l) {
                hasMore = (Boolean)retObject.get("has_more");
                List results = (List)retObject.get("result");
                if (null != results && results.size() > 0) {
                    int retSize = results.size();
                    resultData.addAll(results);
                    for (int i = 0; i < retSize; ++i) {
                        Map m = (Map)results.get(i);
                        todoIds.add(m.get("taskId"));
                    }
                    pageSize += retSize;
                    if (retSize >= 50) continue;
                    hasMore = false;
                    continue;
                }
                hasMore = false;
                continue;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"WorkflowSearchDDTaskListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), l, retObject.get("errmsg") == null ? "" : retObject.get("errmsg").toString()));
            return;
        } while (hasMore);
        HashMap<String, Map<String, Object>> partA = new HashMap<String, Map<String, Object>>();
        ArrayList<Map<String, Object>> partB = new ArrayList<Map<String, Object>>();
        if (statusZero && null != (records = this.getDingTodoRecords(userId)) && records.size() > 0) {
            for (Map<String, Object> m : records) {
                String string = m.get("todoid").toString();
                if (todoIds.contains(string)) {
                    partA.put(string, m);
                    continue;
                }
                partB.add(m);
            }
        }
        if ((totalSize = pageSize + partB.size()) == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, totalSize);
        for (int i = 0; i < pageSize; ++i) {
            Map item = (Map)resultData.get(i);
            this.getModel().setValue("todoid", item.get("taskId"), i);
            this.getModel().setValue("dprocinstid", item.get("instanceId"), i);
            this.getModel().setValue("title", item.get("title"), i);
            Map map = (Map)partA.get(item.get("taskId"));
            if (!statusZero || null == map) continue;
            this.getModel().setValue("taskid", map.get("taskid"), i);
            this.getModel().setValue("procinstid", map.get("procinstid"), i);
            this.getModel().setValue("createdate", map.get("createdate"), i);
        }
        int signIndex = pageSize;
        if (null != partB && partB.size() > 0) {
            for (Map map : partB) {
                this.getModel().setValue("todoid", map.get("todoid"), signIndex);
                this.getModel().setValue("taskid", map.get("taskid"), signIndex);
                this.getModel().setValue("procinstid", map.get("procinstid"), signIndex);
                this.getModel().setValue("createdate", map.get("createdate"), signIndex);
                ++signIndex;
            }
        }
    }

    private String getOpenIdByUserId(String userId) {
        String openId = "";
        ArrayList<Long> params = new ArrayList<Long>();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FOpenID FROM t_bas_immapping WHERE FIMTypeID =2 AND FUserID = ?");
        params.add(Long.parseLong(userId));
        DynamicObjectCollection objectCollection = null;
        try (DataSet ds = DB.queryDataSet((String)"DingdingCommonUtil.getOpenIds.queryDingOpenId", (DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params.toArray());){
            objectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
        }
        if (objectCollection != null && !objectCollection.isEmpty()) {
            openId = ((DynamicObject)objectCollection.get(0)).getString("FOpenID");
        }
        return openId;
    }

    private List<Map<String, Object>> getDingTodoRecords(String userId) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        String selectFields = "userid,procinstid,taskid,dtodoid,createdate";
        QFilter idFilter = new QFilter("userid", "=", (Object)Long.parseLong(userId));
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection ObjectCollection = QueryServiceHelper.query((String)"wf_msg_dingtodo", (String)selectFields, (QFilter[])filters);
        if (ObjectCollection != null && !ObjectCollection.isEmpty()) {
            for (DynamicObject dObject : ObjectCollection) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("procinstid", dObject.getString("procinstid"));
                m.put("taskid", dObject.getString("taskid"));
                m.put("todoid", dObject.getString("dtodoid"));
                m.put("createdate", dObject.getDate("createdate"));
                retList.add(m);
            }
        }
        return retList;
    }
}

