/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.TaskHandleState;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCToHandlePlugin;

public class WorkflowTaskMonitoringPlugin
extends WorkflowTCToHandlePlugin {
    private static final String BTN_TRANSFER = "transfer";
    private static final String BTNBILL = "btnbill";
    private static final String BTNREFRESH = "btnrefresh";
    private static final String SSCAPPROVE = "SSCApprove";
    private static final String EXPORTEXCEL = "exportexcel";
    private static final String BTNTRANSFER = "btntransfer";
    private static final String BTNCIRCULATED = "btncirculated";
    private static final String BTNWITHDRAW_TRANSFER = "btnwithdraw_transfer";
    private static final String BTNBATCHAPPROVE = "btnbatchapprove";
    private static final String BTNBATCHREJECT = "btnbatchreject";
    private static final String BILLNO = "billno";
    private static final String ENTITYNAME = "entityname";
    private static final String STARTNAME = "startname";
    private static final String SUBJECT = "subject";
    private static final String PARTICIPANTNAME = "participantname";
    private static final String CREATEDATE = "createdate";
    private static final String RESETPARTICIPANT = "018KHLXC/8=R";

    @Override
    public void listRowClick(ListRowClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        this.changeTransferBtnState(rows);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (WfAdminUtil.needFilterData()) {
            WfAdminUtil.addWfOrgFilter((SetFilterEvent)e, (String)"wf_taskmonitoring");
        }
    }

    private void changeTransferBtnState(ListSelectedRowCollection rows) {
        boolean btnTransferEnable = true;
        QFilter qFilter2 = new QFilter("type", "=", (Object)SuspendType.MANUALSUSPEND.getCode());
        QFilter qFilter3 = new QFilter("undosuspendtime", "is null", null);
        if (rows != null && rows.size() == 1) {
            Long taskId = (Long)rows.get(0).getPrimaryKeyValue();
            TaskEntity taskEntity = (TaskEntity)this.getRepositoryService().findEntityById(taskId, "wf_task");
            if (taskEntity != null) {
                boolean isSSCTask = false;
                String currentNode = taskEntity.getCategory();
                if (!WfUtils.isEmpty((String)currentNode) && SSCAPPROVE.equals(currentNode)) {
                    isSSCTask = true;
                }
                QFilter qFilter1 = new QFilter("taskid", "=", (Object)taskId);
                QFilter[] filters = new QFilter[]{qFilter1, qFilter2, qFilter3};
                Long durations = this.getRepositoryService().getEntityCountByFilter("wf_durationdetail", filters);
                if (isSSCTask || durations > 0L) {
                    btnTransferEnable = false;
                }
            }
        } else if (rows != null && rows.size() > 1) {
            Object[] pKValues = rows.getPrimaryKeyValues();
            QFilter filter1 = new QFilter("taskid", "in", (Object)pKValues);
            QFilter[] filters = new QFilter[]{filter1, qFilter2, qFilter3};
            Long durations = this.getRepositoryService().getEntityCountByFilter("wf_durationdetail", filters);
            if (durations > 0L) {
                btnTransferEnable = false;
            }
        }
        this.getView().setEnable(Boolean.valueOf(btnTransferEnable), new String[]{BTN_TRANSFER});
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "transfer": {
                this.transfer();
                break;
            }
            case "btnbill": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_taskmonitoring", (String)"47150e89000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showBill("toHandle");
                break;
            }
            case "btnrefresh": {
                this.refresh();
                break;
            }
        }
    }

    private void refresh() {
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndelegatehandle", "btnhandle", EXPORTEXCEL, BTNTRANSFER, BTNCIRCULATED, BTNWITHDRAW_TRANSFER, BTNBATCHAPPROVE, BTNBATCHREJECT, "btnconvert", "batchprint"});
        PluginUtil.setControlInvisible(this.getView(), "bariteexit");
    }

    private void transfer() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_taskmonitoring", (String)RESETPARTICIPANT)) {
            WfUtils.addOpLog((String)"wf_taskmonitoring", (String)BTN_TRANSFER, (MultiLangEnumBridge)new MultiLangEnumBridge("\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba", "WorkflowTaskMonitoringPlugin_13", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d8a\u6743\u8bbf\u95ee:\u65e0\u201c\u4efb\u52a1\u76d1\u63a7\u201d\u7684\u201c\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", "WorkflowTaskMonitoringPlugin_14", "bos-wf-formplugin"), (Object[])new Object[0]);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4efb\u52a1\u76d1\u63a7\u201d\u7684\u201c\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba\u201d\u6743\u9650\u3002", (String)"WorkflowTaskMonitoringPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_transfertask");
        StringBuilder taskIds = new StringBuilder();
        StringBuilder userIds = new StringBuilder();
        String currentNode = "";
        Long[] ids = (Long[])Arrays.stream(rows.getPrimaryKeyValues()).map(item -> (Long)item).toArray(Long[]::new);
        boolean hasyzjtask = this.getTaskService().findTaskCategorysByTaskIds(ids).stream().anyMatch(item -> "YunzhijiaTask".equalsIgnoreCase(item.getString("category")));
        parameter.setCustomParam("hasYzjTask", (Object)hasyzjtask);
        for (Object taskId : rows.getPrimaryKeyValues()) {
            if (this.isTaskExist(String.valueOf(taskId))) {
                taskIds.append(String.valueOf(taskId)).append(',');
                if (rows.size() != 1) continue;
                List identityLinkEntities = this.getRuntimeService().getIdentityLinksByTaskId((Long)taskId);
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                    if (!"participant".equals(identityLinkEntity.getType())) continue;
                    Long userId = identityLinkEntity.getUserId();
                    userIds.append(String.valueOf(userId)).append(',');
                }
                TaskEntity taskEntity = (TaskEntity)this.getRepositoryService().findEntityById((Long)taskId, "wf_task");
                currentNode = taskEntity.getCategory();
                continue;
            }
            return;
        }
        parameter.setCustomParam("entrance", (Object)"wf_taskmonitoring");
        parameter.setCustomParam("taskId", (Object)taskIds.toString());
        parameter.setCustomParam("userId", (Object)userIds.toString());
        parameter.setCustomParam("currentNode", (Object)currentNode);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_TRANSFER));
        this.getView().showForm(parameter);
    }

    public boolean isTaskExist(String taskId) {
        TaskHandleState state = this.getRepositoryService().isTaskHandled(taskId);
        if (state != null && TaskHandleState.NOTEXIST == state) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u7ecf\u88ab\u5904\u7406,\u8bf7\u5237\u65b0\u5217\u8868\uff01", (String)"WorkflowTaskMonitoringPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        if (BTN_TRANSFER.equalsIgnoreCase(e.getActionId())) {
            Object returnData = e.getReturnData();
            if (returnData instanceof Map) {
                Map message = (Map)returnData;
                String title = (String)message.get("title");
                String details = (String)message.get("details");
                String failMsg = (String)message.get("failMsgList");
                String successMsg = (String)message.get("successMsgList");
                if (StringUtils.isNotEmpty((CharSequence)failMsg) || StringUtils.isNotEmpty((CharSequence)successMsg)) {
                    Splitter splitter = Splitter.on((String)",");
                    List failMsgList = Optional.ofNullable(failMsg).map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).orElseGet(ArrayList::new).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                    List successMsgList = Optional.ofNullable(successMsg).map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).orElseGet(ArrayList::new).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                    String handelName = ResManager.loadKDString((String)"\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba", (String)"WorkflowTaskMonitoringPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    StandardTips.view((IFormView)this.getView()).batchOptionMsg(handelName, successMsgList, failMsgList);
                    this.refresh();
                    return;
                }
                if (!WfUtils.isEmpty((String)details)) {
                    this.getView().showMessage(title, details, null);
                } else {
                    this.getView().showMessage(title);
                }
                this.refresh();
            }
        } else {
            super.closedCallBack(e);
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String[][] arrays = new String[][]{{"Id", "id"}, {ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"WorkflowTaskMonitoringPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), BILLNO}, {ResManager.loadKDString((String)"\u5355\u636e", (String)"WorkflowTaskMonitoringPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), ENTITYNAME}, {ResManager.loadKDString((String)"\u53d1\u8d77\u4eba", (String)"WorkflowTaskMonitoringPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), STARTNAME}, {ResManager.loadKDString((String)"\u5355\u636e\u4e3b\u9898", (String)"WorkflowTaskMonitoringPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), SUBJECT}, {ResManager.loadKDString((String)"\u72b6\u6001", (String)"WorkflowTaskMonitoringPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), "handlestate"}, {ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9", (String)"WorkflowTaskMonitoringPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), "name"}, {ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u4eba", (String)"WorkflowTaskMonitoringPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), PARTICIPANTNAME}, {ResManager.loadKDString((String)"\u4e0a\u4e00\u6b65\u5904\u7406\u4eba", (String)"WorkflowTaskMonitoringPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), "sendername"}, {ResManager.loadKDString((String)"\u53d1\u9001\u65f6\u95f4", (String)"WorkflowTaskMonitoringPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), CREATEDATE}};
        HashMap<String, String> fieldWidths = new HashMap<String, String>();
        fieldWidths.put(ENTITYNAME, "12.7%");
        fieldWidths.put(BILLNO, "12%");
        fieldWidths.put(STARTNAME, "6.7%");
        fieldWidths.put(SUBJECT, "28%");
        fieldWidths.put("handlestate", "6%");
        fieldWidths.put("name", "8.6%");
        fieldWidths.put(PARTICIPANTNAME, "8.6%");
        fieldWidths.put("sendername", "9%");
        fieldWidths.put(CREATEDATE, "12.3%");
        List listColumns = args.getListColumns();
        BillList parent = (BillList)args.getSource();
        for (Control control : parent.getItems()) {
            if (!(control instanceof ListGridView)) continue;
            parent = (ListGridView)control;
            break;
        }
        if (!listColumns.isEmpty()) {
            return;
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        for (String[] arr : arrays) {
            ListColumn listColumn = this.createListColumn(arr, "wf_taskmonitoring", fieldWidths);
            listColumn.setParentViewKey(parent.getKey());
            listColumn.setBlankFieldCanOrderAndFilter(true);
            if ("bos_listf7".equalsIgnoreCase(formId)) {
                listColumn.setVisible(10);
            }
            if (SUBJECT.equals(arr[1])) {
                listColumn.setHyperlink(false);
            }
            if (STARTNAME.equals(arr[1]) || ENTITYNAME.equals(arr[1]) || SUBJECT.equals(arr[1]) || "name".equals(arr[1]) || BILLNO.equals(arr[1]) || PARTICIPANTNAME.equals(arr[1]) || CREATEDATE.equals(arr[1])) {
                listColumn.setColumnOrderAndFilter(true);
            } else {
                listColumn.setColumnOrderAndFilter(false);
            }
            listColumns.add(listColumn);
        }
    }

    public ListColumn createListColumn(String[] arr, String entity, Map<String, String> fieldWidths) {
        boolean flag = false;
        if ("id".equalsIgnoreCase(arr[1])) {
            flag = true;
        }
        ListColumn listColumn = new ListColumn();
        listColumn.setCaption(new LocaleString(arr[0]));
        listColumn.setClassName("className");
        listColumn.setEntityName(entity);
        listColumn.setFieldName(arr[1]);
        listColumn.setKey("key" + arr[1]);
        listColumn.setListFieldKey(arr[1]);
        listColumn.setSeq(2);
        String width = fieldWidths.get(arr[1]);
        if (WfUtils.isNotEmpty((String)width)) {
            listColumn.setWidth(new LocaleString(width));
        }
        listColumn.setVisible(flag ? 0 : 13);
        return listColumn;
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ToHandleListDataProvider());
    }

    private void handleListQueryQFilters(IListDataProvider dataProvider) {
        super.analyzeHandlestateFilter(dataProvider);
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }

    class ToHandleListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;

        ToHandleListDataProvider() {
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            WorkflowTaskMonitoringPlugin.this.handleListQueryQFilters((IListDataProvider)this);
            String orderBy = this.getOrderByExpr();
            orderBy = WorkflowTaskMonitoringPlugin.this.getOrderByStr(orderBy);
            Map<String, List<Object>> filterSqlAndParams = WorkflowTaskMonitoringPlugin.this.buildFilter(this.getQFilters(), true, true);
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            this.queryResult = new QueryResult();
            DynamicObjectCollection data = null;
            try {
                data = WorkflowTaskMonitoringPlugin.this.getRuntimeService().getTaskMonitoringData(start, limit, filterSql, params, orderBy, this.isFromAuditFlow());
            }
            catch (KDException ex) {
                if (WFErrorCode.workflowEngineNotConfiguration().equals((Object)ex.getErrorCode())) {
                    String masterTableAlias = "a";
                    String multiLangTableAlias = "b";
                    String entityNumber = "wf_task";
                    String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fentityname", (String)"fentityname", (String)WorkflowTaskMonitoringPlugin.ENTITYNAME);
                    String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fstartname", (String)"fstartname", (String)WorkflowTaskMonitoringPlugin.STARTNAME);
                    String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsubject", (String)"fsubject", (String)WorkflowTaskMonitoringPlugin.SUBJECT);
                    String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fname", (String)"fname", (String)"name");
                    String participantNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fparticipantname", (String)"fparticipantname", (String)WorkflowTaskMonitoringPlugin.PARTICIPANTNAME);
                    String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsendername", (String)"fsendername", (String)"sendername");
                    String sql = "select a.fid,a.fbillno," + entityNameSQL + "," + startNameSQL + "," + subjectSQL + ",a.fhandlestate," + nameSQL + "," + participantNameSQL + "," + senderNameSQL + ",a.fcreatedate from t_wf_task a left join t_wf_task_l b on a.fid=b.fid where 1!=1";
                    try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.wf_task.queryGridData.nodata", (DBRoute)DBRoute.workflow, (String)sql);){
                        data = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
                    }
                    WorkflowTaskMonitoringPlugin.this.getView().showMessage(ex.getMessage());
                }
                throw ex;
            }
            this.queryResult.setCollection(data);
            return data;
        }

        private boolean isFromAuditFlow() {
            FormShowParameter parameter = WorkflowTaskMonitoringPlugin.this.getView().getFormShowParameter();
            return !"bpm".equals(parameter.getAppId());
        }

        public int getRealCount() {
            WorkflowTaskMonitoringPlugin.this.handleListQueryQFilters((IListDataProvider)this);
            Map<String, List<Object>> filterSqlAndParams = WorkflowTaskMonitoringPlugin.this.buildFilter(this.getQFilters(), true, true);
            return this.getDataCount(filterSqlAndParams);
        }

        private int getDataCount(Map<String, List<Object>> filterSqlAndParams) {
            int dataCount = 0;
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            try {
                dataCount = (int)WorkflowTaskMonitoringPlugin.this.getRuntimeService().getTaskMonitoringDataCount(filterSql, params, this.isFromAuditFlow());
            }
            catch (KDException ex) {
                if (WFErrorCode.workflowEngineNotConfiguration().equals((Object)ex.getErrorCode())) {
                    WorkflowTaskMonitoringPlugin.this.getView().showMessage(ex.getMessage());
                }
                throw ex;
            }
            return dataCount;
        }
    }
}

