/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFErrorCode;

public class WorkflowTransferTaskPlugin
extends AbstractWorkflowPlugin {
    private static final String SUGGESTION = "suggestion";
    private static final String SUBSCRIBE = "subscribe";
    private static final String BTN_CONFIRM = "confirmbtn";
    private static final String BTN_CANCEL = "cancelbtn";
    private static final String PAGEID = "pageId";
    private static final String USERID = "userId";
    private static final String TOUSER = "touser";
    private static final String YUNZHIJIATOUSER = "yunzhijiatouser";
    private static final String TASKID = "taskId";
    private static final String CURRENTNODE = "currentNode";
    public static final String HASYZJTASK = "hasYzjTask";
    private static final String RESETPARTICIPANT = "018KHLXC/8=R";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_CONFIRM});
        this.showUsersAddCustomParam();
    }

    private void showUsersAddCustomParam() {
        MulBasedataEdit bosUserF7 = (MulBasedataEdit)this.getControl(TOUSER);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
        BasedataEdit yunzhijiaBosUserF7 = (BasedataEdit)this.getControl(YUNZHIJIATOUSER);
        yunzhijiaBosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
    }

    public void afterCreateNewData(EventObject e) {
        String userIds;
        super.afterCreateNewData(e);
        Boolean hasYzjTask = (Boolean)this.getView().getFormShowParameter().getCustomParam(HASYZJTASK);
        if (hasYzjTask == null) {
            hasYzjTask = Boolean.FALSE;
        }
        this.getView().setVisible(Boolean.valueOf(hasYzjTask == false), new String[]{TOUSER});
        this.getView().setVisible(hasYzjTask, new String[]{YUNZHIJIATOUSER});
        String currentNode = (String)this.getView().getFormShowParameter().getCustomParam(CURRENTNODE);
        if (!WfUtils.isEmpty((String)currentNode)) {
            this.getPageCache().put(CURRENTNODE, currentNode);
        }
        if (!WfUtils.isEmpty((String)(userIds = (String)this.getView().getFormShowParameter().getCustomParam(USERID)))) {
            String[] userIdsArray = userIds.split(",");
            if (userIdsArray.length > 0) {
                Object[] userIdz = new Object[userIdsArray.length];
                for (int i = 0; i < userIdsArray.length; ++i) {
                    userIdz[i] = Long.parseLong(userIdsArray[i]);
                }
                this.getModel().setValue(TOUSER, (Object)userIdz);
            }
            if ("YunzhijiaTask".equals(currentNode)) {
                this.getView().setVisible(Boolean.valueOf(hasYzjTask == false), new String[]{TOUSER});
                this.getView().setVisible(hasYzjTask, new String[]{YUNZHIJIATOUSER});
                this.getModel().setValue(YUNZHIJIATOUSER, (Object)userIdsArray[0]);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        if (BTN_CANCEL.equals(ctl.getKey())) {
            this.getView().close();
        } else if (BTN_CONFIRM.equals(ctl.getKey())) {
            this.confirm();
        }
    }

    private void confirm() {
        String entrance = (String)this.getView().getFormShowParameter().getCustomParam("entrance");
        if ("wf_taskmonitoring".equals(entrance)) {
            String appId = ProcessInstancePluginUtil.getPermissionAppId(this.getView());
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"wf_taskmonitoring", (String)RESETPARTICIPANT)) {
                WfUtils.addOpLogByAppId((String)appId, (String)"wf_taskmonitoring", (String)"transfer", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba", "WorkflowTaskMonitoringPlugin_13", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d8a\u6743\u8bbf\u95ee:\u65e0\u201c\u4efb\u52a1\u76d1\u63a7\u201d\u7684\u201c\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", "WorkflowTaskMonitoringPlugin_14", "bos-wf-formplugin"), (Object[])new Object[0]);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4efb\u52a1\u76d1\u63a7\u201d\u7684\u201c\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba\u201d\u6743\u9650\u3002", (String)"WorkflowTaskMonitoringPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        ILocaleString suggestion = (ILocaleString)this.getModel().getValue(SUGGESTION);
        Object subscribe = this.getModel().getValue(SUBSCRIBE);
        StringBuilder transferIds = new StringBuilder();
        StringBuilder names = new StringBuilder();
        Boolean customParam = (Boolean)this.getView().getFormShowParameter().getCustomParam(HASYZJTASK);
        if ("YunzhijiaTask".equals(this.getPageCache().get(CURRENTNODE)) || Boolean.TRUE.equals(customParam)) {
            DynamicObject yunZhiJiaToUser = (DynamicObject)this.getModel().getValue(YUNZHIJIATOUSER);
            if (yunZhiJiaToUser == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eba\u5458\u3002", (String)"WorkflowTransferTaskPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            Long transferId = (Long)yunZhiJiaToUser.getPkValue();
            transferIds = transferIds.append(transferId).append(',');
            names = names.append(yunZhiJiaToUser.get("name"));
        } else {
            DynamicObjectCollection toUsers = (DynamicObjectCollection)this.getModel().getValue(TOUSER);
            if (toUsers == null || toUsers.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eba\u5458\u3002", (String)"WorkflowTransferTaskPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject toUser : toUsers) {
                DynamicObject toUserDynamicObject = toUser.getDynamicObject("fbasedataid");
                if (toUserDynamicObject == null) continue;
                String transferId = String.valueOf(toUserDynamicObject.getPkValue());
                String name = toUserDynamicObject.getString("name");
                transferIds.append(transferId).append(',');
                names.append(name).append(',');
            }
        }
        Map<String, String> result = this.transferTasks(transferIds, suggestion, subscribe);
        this.addLog(transferIds.toString(), names.toString());
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private Map<String, String> transferTasks(StringBuilder transferIds, ILocaleString suggestion, Object subscribe) {
        HashMap<String, String> result = new HashMap();
        try {
            result = this.transferTasks(transferIds.toString(), suggestion, (Boolean)subscribe);
        }
        catch (Exception e) {
            List tasks;
            WFBizException wfBizException;
            Long processInstanceId;
            if (e.getCause() instanceof WFBizException && WFErrorCode.businessUnknowOperationError().equals((Object)((WFBizException)e.getCause()).getErrorCode()) && !WfUtils.isEmpty((Long)(processInstanceId = (wfBizException = (WFBizException)e.getCause()).getProcessInstanceId())) && (tasks = this.getTaskService().getTasksByProcessInstanceId(processInstanceId)) != null && !tasks.isEmpty()) {
                result.put("title", ResManager.loadKDString((String)"\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba\u6210\u529f\u3002", (String)"WorkflowTransferTaskPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                String details = String.format(ResManager.loadKDString((String)"\u5176\u4e2d\u5355\u636e\u7f16\u53f7\u4e3a\uff1a[%1$s]\u7684\u4efb\u52a1\u5728 %2$s", (String)"WorkflowTransferTaskPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), ((TaskEntity)tasks.get(0)).getBillNo(), wfBizException.getMessage());
                result.put("details", details);
            }
            this.logger.info(String.format("\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba\u51fa\u9519\uff0c%s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return result;
    }

    private Map<String, String> transferTasks(String transferIds, ILocaleString suggestion, Boolean subscribe) {
        String taskIds = (String)this.getView().getFormShowParameter().getCustomParam(TASKID);
        return this.getTaskService().adminTransferTasks(taskIds, transferIds, suggestion, subscribe);
    }

    private void addLog(String transferIds, String names) {
        String taskIds = (String)this.getView().getFormShowParameter().getCustomParam(TASKID);
        WfUtils.addOpLog((String)"wf_taskmonitoring", (String)"transfer", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba", "WorkflowTransferTaskPlugin_2", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c06\u4efb\u52a1 [%1$s] \u7684\u53c2\u4e0e\u4eba\u91cd\u65b0\u8bbe\u7f6e\u4e3a\uff1a%2$s [%3$s]", "WorkflowTransferTaskPlugin_3", "bos-wf-formplugin"), (Object[])new Object[]{taskIds, names, transferIds});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(PAGEID);
        this.getPageCache().remove(CURRENTNODE);
    }
}

