/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.monitor.plugin.WorkflowHistoricalProcessesPlugin;
import kd.bos.workflow.taskcenter.plugin.util.WorkflowTCDataPluginUtil;

public class WorkflowViewBillsListPlugin
extends WorkflowHistoricalProcessesPlugin {
    private static final String ENTRABILLNAMESHOW = "entrabillnameshow";
    private static final String SUBJECTSHOW = "subjectshow";
    private static final String STARTNAME = "startname";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String BTN_VIEWBILLRELATIONGRAPH = "viewbillrelationgraph";

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String[][] arrays = new String[][]{{"Id", "id"}, {ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"WorkflowViewBillsListPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), ENTRABILLNAMESHOW}, {ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6", (String)"WorkflowViewBillsListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), ENTITYNUMBER}, {ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"WorkflowViewBillsListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), STARTNAME}, {ResManager.loadKDString((String)"\u8fd0\u884c\u72b6\u6001", (String)"WorkflowViewBillsListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), SUBJECTSHOW}};
        HashMap<String, String> fieldWidths = new HashMap<String, String>();
        fieldWidths.put(ENTRABILLNAMESHOW, "35%");
        fieldWidths.put(ENTITYNUMBER, "30%");
        fieldWidths.put(STARTNAME, "20%");
        fieldWidths.put(SUBJECTSHOW, "15%");
        List listColumns = args.getListColumns();
        BillList parent = (BillList)args.getSource();
        for (Control control : parent.getItems()) {
            if (!(control instanceof ListGridView)) continue;
            parent = (ListGridView)control;
            break;
        }
        if (!listColumns.isEmpty()) {
            return;
        }
        for (String[] arr : arrays) {
            ListColumn listColumn = this.createListColumn(null, arr, "wf_historicalprocesses", fieldWidths);
            listColumn.setBlankFieldCanOrderAndFilter(true);
            listColumn.setParent((Container)parent);
            listColumn.setParentViewKey(parent.getKey());
            listColumn.setColumnOrderAndFilter(false);
            if (STARTNAME.equals(arr[1])) {
                listColumn.setHyperlink(true);
            }
            listColumns.add(listColumn);
        }
    }

    private void viewBill(Object pkId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"wf_circulaterelation");
        String entityNumber = dynamicObject.getString(ENTITYNUMBER);
        Long businessKey = dynamicObject.getLong("businesskey");
        String type = String.format("%s%s", entityNumber, businessKey);
        boolean hasCurrentPageTab = WorkflowTCDataPluginUtil.hasCurrentPageTab(businessKey, type, this.getView());
        if (!hasCurrentPageTab) {
            IFormView formView = this.getView().getParentView();
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPageId(WorkflowTCDataPluginUtil.getPageId(businessKey, type, formView));
            billShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setBillStatus(BillOperationStatus.VIEW);
            billShowParameter.setFormId(entityNumber);
            billShowParameter.setPkId((Object)businessKey);
            billShowParameter.addCustPlugin("kd.bos.workflow.runtime.plugin.BillConvertControlPlugin");
            billShowParameter.setHasRight(true);
            billShowParameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args, IFormView view, String type) {
        Object pkId = ((IListView)this.getView()).getFocusRowPkId();
        this.viewBill(pkId);
        args.setCancel(true);
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String processInstanceId = (String)this.getView().getFormShowParameter().getCustomParam("processInstanceId");
        args.setListDataProvider((IListDataProvider)new HistoryListDataProvider(processInstanceId));
    }

    @Override
    public Map<String, List<Object>> buildFilter(List<QFilter> filters) {
        return Collections.emptyMap();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BTN_VIEWBILLRELATIONGRAPH.equals(key)) {
            this.viewBillRelationGraph(evt);
        } else {
            super.itemClick(evt);
        }
    }

    private void viewBillRelationGraph(ItemClickEvent evt) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() != 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(Optional.ofNullable(rows).map(ArrayList::size).orElseGet(() -> 0).intValue());
            return;
        }
        Long circulateRelationId = (Long)rows.get(0).getPrimaryKeyValue();
        String fields = "procinstid";
        CirculateRelationEntity entity = (CirculateRelationEntity)this.getRepositoryService().findEntityById(circulateRelationId, "wf_circulaterelation", fields);
        BizFlowPluginUtil.openBillRelationGraph(entity.getProcinstId(), this.getView());
    }

    class HistoryListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String processInstanceId;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public HistoryListDataProvider(String processInstanceId) {
            this.processInstanceId = processInstanceId;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String orderBy = this.getOrderByExpr();
            orderBy = WorkflowViewBillsListPlugin.this.getOrderByStr(orderBy);
            Map<String, List<Object>> filterSqlAndParams = WorkflowViewBillsListPlugin.this.buildFilter(this.getQFilters());
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            this.queryResult = new QueryResult();
            this.queryResult.setDataCount(this.getDataCount(filterSqlAndParams));
            DynamicObjectCollection data = null;
            try {
                data = WorkflowViewBillsListPlugin.this.getHistoryService().getViewBillsData(start, limit, this.processInstanceId, filterSql, params, orderBy);
            }
            catch (KDException ex) {
                WorkflowViewBillsListPlugin.this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)ex));
            }
            this.queryResult.setCollection(data);
            return data;
        }

        public int getRealCount() {
            Map<String, List<Object>> filterSqlAndParams = WorkflowViewBillsListPlugin.this.buildFilter(this.getQFilters());
            return this.getDataCount(filterSqlAndParams);
        }

        private int getDataCount(Map<String, List<Object>> filterSqlAndParams) {
            int dataCount = 0;
            String filterSql = "";
            List<Object> params = new ArrayList();
            if (!filterSqlAndParams.isEmpty()) {
                Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
                filterSql = entry.getKey();
                params = entry.getValue();
            }
            try {
                dataCount = (int)WorkflowViewBillsListPlugin.this.getHistoryService().getViewBillsCount(this.processInstanceId, filterSql, params);
            }
            catch (KDException ex) {
                if (WFErrorCode.workflowEngineNotConfiguration().equals((Object)ex.getErrorCode())) {
                    WorkflowViewBillsListPlugin.this.getView().showMessage(ex.getMessage());
                }
                throw ex;
            }
            return dataCount;
        }
    }
}

