/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin.task;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.pojo.ErrorAbandonProcess;
import kd.bos.workflow.monitor.plugin.task.SubTree;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BatchAbandonTask
extends AbstractTask {
    private final ManagementService managementService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
    private final RuntimeService runtimeService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRuntimeService();
    private LinkedHashMap<Long, ExecutionEntity> map;
    private LocaleString msg;
    private boolean abandonMainProcess;
    private List<Long> procInstIdsWithSubProcTag = new ArrayList<Long>();
    private List<Long> hasSubProcTagRootInstIds = new ArrayList<Long>();

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        List proInstanceIds = (List)params.get("proInstanceIds");
        if (proInstanceIds == null || proInstanceIds.isEmpty() || proInstanceIds.size() > 100) {
            return;
        }
        this.msg = LocaleString.fromMap((Map)((Map)params.get("msg")));
        this.abandonMainProcess = Boolean.TRUE.equals(params.get("abandonMainProcess"));
        String idsWithSubProcTagStr = (String)params.get("procInstIdsWithSubProcTag");
        if (StringUtils.isNotEmpty((CharSequence)idsWithSubProcTagStr)) {
            this.procInstIdsWithSubProcTag = (List)SerializationUtils.fromJsonString((String)idsWithSubProcTagStr, List.class);
        }
        List instances = this.runtimeService.findExecutionListByIds(proInstanceIds);
        Map<Long, ExecutionEntity> collect = instances.stream().collect(Collectors.toMap(Entity::getId, item -> item));
        this.map = new LinkedHashMap<Long, ExecutionEntity>(collect);
        LinkedHashMap<Long, List<SubTree>> treeGroupByRootId = this.buildTreeGroupByRootId(instances);
        ArrayList<ErrorAbandonProcess> result = new ArrayList<ErrorAbandonProcess>();
        int size = treeGroupByRootId.values().size();
        int i = 0;
        for (List<SubTree> value : treeGroupByRootId.values()) {
            String desc = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u7b2c  %1$s / %2$s \u6b21\u5faa\u73af", (String)"BatchAbandonTask_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), ++i, size);
            this.feedbackProgress(100 * i / size, desc, null);
            if (this.isStop()) {
                this.stop();
                return;
            }
            result.addAll(this.abandonProcesses(value));
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("errorAbandonProcesses", result);
        map.put("total", Integer.valueOf(proInstanceIds.size()));
        this.feedbackCustomdata(map);
    }

    public LinkedHashMap<Long, List<SubTree>> subNodesGroupByRootId(List<ExecutionEntity> instances) {
        List subNodes = instances.stream().map(SubTree::fromEntity).collect(Collectors.toList());
        LinkedHashMap<Long, Object> hasSuperInstanceMap = new LinkedHashMap<Long, Object>();
        for (Object item : subNodes) {
            if (((SubTree)item).getSuperExecutionId() == null || ((SubTree)item).getSuperExecutionId().equals(0L)) continue;
            hasSuperInstanceMap.put(((SubTree)item).getSuperExecutionId(), item);
        }
        List executionListByIds = this.runtimeService.findExecutionListByIds(new ArrayList(hasSuperInstanceMap.keySet()));
        for (ExecutionEntity item : executionListByIds) {
            SubTree subTree = (SubTree)hasSuperInstanceMap.get(item.getId());
            subTree.setSuperInstanceId(item.getProcessInstanceId());
        }
        LinkedHashMap<Long, List<SubTree>> rootMap = new LinkedHashMap<Long, List<SubTree>>();
        for (SubTree item : subNodes) {
            Long instanceId;
            Long rooInstanceId = item.getRooInstanceId();
            if (rootMap.containsKey(rooInstanceId)) {
                rootMap.get(rooInstanceId).add(item);
            } else {
                ArrayList subTrees = Lists.newArrayList((Object[])new SubTree[]{item});
                rootMap.put(rooInstanceId, subTrees);
            }
            if (!this.procInstIdsWithSubProcTag.contains(instanceId = item.getInstanceId())) continue;
            this.hasSubProcTagRootInstIds.add(rooInstanceId);
        }
        return rootMap;
    }

    public List<SubTree> buildTree(List<SubTree> nodes) {
        HashMap<Long, SubTree> map = new HashMap<Long, SubTree>();
        ArrayList<SubTree> head = new ArrayList<SubTree>();
        for (SubTree node : nodes) {
            map.put(node.getInstanceId(), node);
        }
        map.remove(null);
        for (SubTree node : nodes) {
            SubTree parent = null;
            Long superExecutionId = node.getSuperExecutionId();
            while (superExecutionId != null) {
                ArrayList<Long> ids = new ArrayList<Long>(1);
                ids.add(superExecutionId);
                List executionListByIds = this.runtimeService.findExecutionListByIds(ids);
                if (!WfUtils.isNotEmptyForCollection((Collection)executionListByIds)) continue;
                ExecutionEntity superExecution = (ExecutionEntity)executionListByIds.get(0);
                Long superProcessInstId = superExecution.getProcessInstanceId();
                if (map.get(superProcessInstId) != null) {
                    parent = (SubTree)map.get(superProcessInstId);
                    break;
                }
                superExecutionId = superExecution.getSuperExecutionId();
            }
            if (parent == null) {
                head.add(node);
                continue;
            }
            parent.getChildren().add(node);
        }
        return head;
    }

    public LinkedHashMap<Long, List<SubTree>> buildTreeGroupByRootId(List<ExecutionEntity> instances) {
        LinkedHashMap<Long, List<SubTree>> groupByinstances = this.subNodesGroupByRootId(instances);
        LinkedHashMap<Long, List<SubTree>> result = new LinkedHashMap<Long, List<SubTree>>();
        for (Map.Entry<Long, List<SubTree>> item : groupByinstances.entrySet()) {
            List<SubTree> subTrees = this.buildTree(item.getValue());
            result.put(item.getKey(), subTrees);
        }
        return result;
    }

    public List<ErrorAbandonProcess> abandonProcesses(List<SubTree> heads) {
        ArrayList<ErrorAbandonProcess> result = new ArrayList<ErrorAbandonProcess>();
        for (SubTree item : heads) {
            List<ErrorAbandonProcess> errorAbandonProcesses = this.abandonOneProcessBySubTree(item);
            result.addAll(errorAbandonProcesses);
        }
        return result;
    }

    public List<ErrorAbandonProcess> abandonOneProcessBySubTree(SubTree tree) {
        LinkedList<SubTree> nodes = new LinkedList<SubTree>();
        nodes.add(tree);
        ArrayList<ErrorAbandonProcess> result = new ArrayList<ErrorAbandonProcess>();
        int deep = 0;
        while (!nodes.isEmpty()) {
            if (++deep > 5) {
                ErrorAbandonProcess errorAbandonProcess = new ErrorAbandonProcess();
                errorAbandonProcess.setErrMsg("Cyclic data");
                return Lists.newArrayList((Object[])new ErrorAbandonProcess[]{errorAbandonProcess});
            }
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                SubTree poll = (SubTree)nodes.poll();
                if (poll == null) continue;
                Long rooInstanceId = poll.getRooInstanceId();
                ErrorAbandonProcess errorAbandonProcess = null;
                errorAbandonProcess = this.abandonMainProcess && WfUtils.isNotEmpty((Long)rooInstanceId) && this.hasSubProcTagRootInstIds.contains(rooInstanceId) ? this.abandonProcess(poll.getInstanceId(), "forceAbortAll") : this.abandonProcess(poll.getInstanceId());
                if (ErrorAbandonProcess.EMPTY.equals((Object)errorAbandonProcess)) continue;
                nodes.addAll(poll.getChildren());
                result.add(errorAbandonProcess);
            }
        }
        return result;
    }

    public ErrorAbandonProcess abandonProcess(Long intanceId, String dynType) {
        ExecutionEntity executionEntity = this.map.get(intanceId);
        ErrorAbandonProcess errorMsg = new ErrorAbandonProcess();
        try {
            this.managementService.abandonProcessInstance(intanceId.longValue(), (ILocaleString)this.msg, dynType);
        }
        catch (Exception e) {
            errorMsg.setErrMsg(e.getMessage());
            errorMsg.setProcessInstanceId(intanceId);
            errorMsg.setBillNo(executionEntity.getBillNo());
            errorMsg.setBusinessKey(executionEntity.getBusinessKey());
            errorMsg.setName(executionEntity.getName());
            errorMsg.setEntraBillName(executionEntity.getEntraBillName());
        }
        return errorMsg;
    }

    public ErrorAbandonProcess abandonProcess(Long intanceId) {
        return this.abandonProcess(intanceId, null);
    }
}

