/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.workflow.engine.pojo.ErrorAbandonProcess;
import kd.bos.workflow.monitor.plugin.vo.ErrorAbandonVo;

public class BatchAbandonTaskClick
extends AbstractTaskClick {
    private static final Log logger = LogFactory.getLog(BatchAbandonTaskClick.class);

    public void click(ClickEventArgs e) {
        TaskInfo taskInfo = this.queryTask();
        IFormView parentView = this.getParentView();
        if (taskInfo.isTaskEnd()) {
            logger.info(System.currentTimeMillis() + ":" + Arrays.toString(Thread.currentThread().getStackTrace()));
            e.setClearTask(true);
            ErrorAbandonVo errorAbandonVo = this.calData(taskInfo);
            this.draw(errorAbandonVo);
        } else if (parentView == null) {
            String tips = ResManager.loadKDString((String)"\u4efb\u52a1\u9875\u9762\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u6253\u5f00\u8fdb\u5ea6\u754c\u9762\u3002", (String)"BatchAbandonTaskClick_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getMainView().showMessage(tips);
        } else {
            this.showProgressForm(parentView);
        }
    }

    private void showProgressForm(IFormView view) {
        if (this.isExistProgressForm()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sch_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isBlank((CharSequence)this.getJobFormInfo().getCaption())) {
            showParameter.setCaption(this.getJobFormInfo().getCaption());
        }
        showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
        showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
        view.showForm(showParameter);
        this.getMainView().sendFormAction(view);
        this.setProgressPageId(showParameter.getPageId());
    }

    private ErrorAbandonVo calData(TaskInfo taskInfo) {
        String data = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)data)) {
            return new ErrorAbandonVo();
        }
        ObjectMapper JSON2 = new ObjectMapper();
        ErrorAbandonVo res = new ErrorAbandonVo();
        try {
            res = (ErrorAbandonVo)JSON2.readValue(data, ErrorAbandonVo.class);
        }
        catch (JsonProcessingException e) {
            logger.info("ErrorAbandonVo\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff1a" + (Object)((Object)e));
            return res;
        }
        return res;
    }

    private void draw(ErrorAbandonVo res) {
        List<ErrorAbandonProcess> errorAbandonProcesses = res.getErrorAbandonProcesses();
        if (errorAbandonProcesses == null || errorAbandonProcesses.isEmpty()) {
            String sussess = ResManager.loadKDString((String)"\u5f3a\u5236\u7ec8\u6b62\u6210\u529f\u3002", (String)"WorkflowTCDataPlugin_50", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getMainView().showSuccessNotification(sussess);
        } else {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("wf_errorabondontips");
            param.setCustomParam("errorAbandonVo", (Object)SerializationUtils.toJsonString((Object)res));
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getMainView().showForm(param);
            ((IListView)this.getParentView()).refresh();
        }
    }
}

