/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin.worktransfer;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowBatchTransferPlugin
extends AbstractWorkflowPlugin {
    private static final String ORIGINALPARTICIPATE = "originalparticipate";
    private static final String RESETPARTICIPATE = "resetparticipate";
    private static final String BTNOK = "btnok";
    private static final String BATCHTRANSFER = "batchtransfer";
    private static final String TYPE = "type";
    private static final String TASK = "task";
    private static final String PROCESS = "process";
    private static final String ROLE = "role";
    private static final String EXECUTION = "execution";
    private static final String ALL = "all";
    private static final String TRANSFERID = "transferId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(RESETPARTICIPATE);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)ALL);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (WfUtils.isNotEmptyForMap((Map)customParams)) {
                if (EXECUTION.equals(customParams.get(TYPE))) {
                    ((ListShowParameter)parameter).setMultiSelect(Boolean.FALSE.booleanValue());
                } else {
                    ((ListShowParameter)parameter).setMultiSelect(Boolean.TRUE.booleanValue());
                }
            }
        });
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (BTNOK.equals(key)) {
            this.confirm();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String original = (String)customParams.get(TRANSFERID);
        if (!WfUtils.isEmpty((String)original)) {
            this.getModel().setValue(ORIGINALPARTICIPATE, (Object)Long.valueOf(original));
        }
    }

    private void confirm() {
        Map<String, String> returnData;
        String receiverIds = this.getReceiverIds();
        if (WfUtils.isEmpty((String)receiverIds)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u63a5\u6536\u4eba\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowBatchTransferPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] receiverIdsArray = receiverIds.split(",");
        if (WfUtils.isNotEmptyForArrays((Object[])receiverIdsArray)) {
            for (Object receiverId : receiverIdsArray) {
                if (!WfUtils.isEmpty((ILocaleString)WfUtils.findUserName((Long)Long.valueOf((String)receiverId)))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WorkflowBatchTransferPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ((returnData = this.worksBatchTransfer(receiverIds)) != null && !returnData.isEmpty()) {
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private String getReceiverIds() {
        StringBuilder receiverIds = new StringBuilder();
        DynamicObjectCollection receivers = (DynamicObjectCollection)this.getModel().getValue(RESETPARTICIPATE);
        if (receivers != null && !receivers.isEmpty()) {
            for (DynamicObject receiver : receivers) {
                DynamicObject receiverDynamicObject = receiver.getDynamicObject("fbasedataid");
                if (receiverDynamicObject == null) continue;
                receiverIds.append(receiverDynamicObject.getPkValue()).append(',');
            }
        }
        if (receiverIds.length() > 1) {
            return receiverIds.substring(0, receiverIds.length() - 1);
        }
        return receiverIds.toString();
    }

    private Map<String, String> worksBatchTransfer(String receiverIds) {
        String type;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String pkIds = (String)customParams.get("pkIds");
        String transferId = (String)customParams.get(TRANSFERID);
        switch (type = (String)customParams.get(TYPE)) {
            case "task": {
                ILocaleString suggestion = WfUtils.getPromptWordLocaleString((String)"\u7ba1\u7406\u5458\u5c06\u5de5\u4f5c\u6279\u91cf\u79fb\u4ea4", (String)"WorkflowBatchTransferPlugin_2", (String)"bos-wf-formplugin");
                return this.getRuntimeService().batchTransferTasks(pkIds, transferId, receiverIds, suggestion, Boolean.FALSE, Boolean.TRUE);
            }
            case "process": {
                return this.getRuntimeService().batchTransferProcessDefinitions(pkIds, transferId, receiverIds);
            }
            case "role": {
                String roleEntryIds = (String)customParams.get("roleEntryIds");
                return this.getRuntimeService().batchTransferWorkflowRoles(pkIds, roleEntryIds, transferId, receiverIds);
            }
            case "execution": {
                return this.getRuntimeService().batchTransferWorkflowExecutions(pkIds, transferId, receiverIds);
            }
            case "all": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6279\u91cf\u79fb\u4ea4\u540e\u8be5\u4eba\u5458\u6240\u6709\u7684\u5de5\u4f5c\u5c06\u79fb\u4ea4\u7ed9\u6307\u5b9a\u7684\u63a5\u6536\u4eba\uff0c\u662f\u5426\u8981\u6279\u91cf\u79fb\u4ea4\uff1f", (String)"WorkflowBatchTransferPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(BATCHTRANSFER));
                return null;
            }
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (BATCHTRANSFER.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String transferId = (String)customParams.get(TRANSFERID);
            Map returnData = this.getRuntimeService().worksBatchTransfer(Long.valueOf(transferId), this.getReceiverIds());
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }
}

