/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin.worktransfer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;

public class WorkflowWorkTransferPlugin
extends AbstractWorkflowPlugin
implements TabSelectListener {
    private static final String TOOLBAR_PAGE = "toolbar_page";
    private static final String TABAP = "tabap";
    private static final String BATCHTRANSFER = "batchtransfer";
    private static final String VIEWTRANSFERLOG = "viewtransferlog";
    private static final String BARITEM_REFRESH = "baritem_refresh";
    private static final String TRANSFER = "transfer";
    private static final String TASKID = "taskid";
    private static final String PROCDEFID = "processdefinitionid";
    private static final String ROLEID = "roleid";
    private static final String EXECUTIONID = "executionId";
    private static final String TASK = "task";
    private static final String PROCESS = "process";
    private static final String ROLE = "role";
    private static final String EXECUTION = "execution";
    private static final String TABPAGE_TASK = "tabpage_task";
    private static final String TABPAGE_PROCESS = "tabpage_process";
    private static final String TABPAGE_ROLE = "tabpage_role";
    private static final String TABPAGE_EXECUTION = "tabpage_execution";
    private static final String RENOVATEWORKTRANSFER = "renovateworktransfer";
    private static final String PKKEY = "pkKey";
    private static final String PKIDS = "pkIds";
    private static final String TRANSFERTYPE = "transferType";
    private static final String PAGEID = "_pageId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarPage = (Toolbar)this.getControl(TOOLBAR_PAGE);
        toolbarPage.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{BARITEM_REFRESH, BATCHTRANSFER, VIEWTRANSFERLOG, RENOVATEWORKTRANSFER});
        Tab tab = (Tab)this.getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(TRANSFER);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.isRenovatedSuccess()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5728\u8fdb\u884c\u5de5\u4f5c\u79fb\u4ea4\u524d\uff0c\u9700\u8981\u51c6\u5907\u521d\u59cb\u6570\u636e\u3002\u7531\u4e8e\u9700\u8981\u4fee\u590d\u7684\u76f8\u5173\u6570\u636e\u8f83\u591a\uff0c\u53ef\u80fd\u9700\u8981\u8f83\u957f\u65f6\u95f4\u3002\u5efa\u8bae\u60a8\u5728\u7a7a\u95f2\u65f6\u95f4\u8fdb\u884c\u6570\u636e\u51c6\u5907\u3002\u662f\u5426\u73b0\u5728\u8fdb\u884c\u51c6\u5907\uff1f", (String)"WorkflowWorkTransferPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(RENOVATEWORKTRANSFER));
        }
        this.initWorkTransferList();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "batchtransfer": {
                this.batchTransfer();
                break;
            }
            case "viewtransferlog": {
                this.viewTransferLog();
                break;
            }
            case "baritem_refresh": {
                this.getWorkTransferList();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (TRANSFER.equals(propName)) {
            this.getWorkTransferList();
        }
    }

    private void getWorkTransferList() {
        if (WfUtils.isEmpty((Long)this.getTransferId())) {
            return;
        }
        this.initWorkTransferList();
    }

    private void initWorkTransferList() {
        String tabKey = this.getCurrentTab();
        this.showTabListFormInContainer(tabKey);
    }

    private Long getTransferId() {
        DynamicObject transfer = (DynamicObject)this.getModel().getValue(TRANSFER);
        Long userId = 0L;
        if (transfer != null) {
            userId = (Long)transfer.getPkValue();
        }
        return userId;
    }

    private void batchTransfer() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_worktransfer", (String)"1=DTAJKFL7DN")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6279\u91cf\u79fb\u4ea4\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowWorkTransferPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.isRenovatedSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u51c6\u5907\u5de5\u4f5c\u79fb\u4ea4\u76f8\u5173\u6570\u636e\u3002", (String)"WorkflowWorkTransferPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long transferId = this.getTransferId();
        if (WfUtils.isEmpty((Long)transferId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u4eba\u5458\u201d\u3002", (String)"WorkflowWorkTransferPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> selectedRowsInfo = this.getSelectedRowsInfo();
        String pkIds = (String)selectedRowsInfo.get(PKIDS);
        if (WfUtils.isEmpty((String)pkIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkflowWorkTransferPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String transferType = (String)selectedRowsInfo.get(TRANSFERTYPE);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("transferId", String.valueOf(transferId));
        params.put("type", transferType);
        params.put("roleEntryIds", (String)selectedRowsInfo.get("roleEntryIds"));
        params.put(PKIDS, pkIds);
        super.showForm(BATCHTRANSFER, "wf_batchoftransfer", params);
    }

    private Map<String, Object> getSelectedRowsInfo() {
        String tabKey;
        HashMap<String, Object> selectedRowsInfo = new HashMap<String, Object>();
        String transferType = "";
        String pkKey = "";
        switch (tabKey = this.getCurrentTab()) {
            case "tabpage_task": {
                transferType = TASK;
                pkKey = TASKID;
                break;
            }
            case "tabpage_process": {
                transferType = PROCESS;
                pkKey = PROCDEFID;
                break;
            }
            case "tabpage_role": {
                transferType = ROLE;
                pkKey = ROLEID;
                break;
            }
            case "tabpage_execution": {
                transferType = EXECUTION;
                pkKey = EXECUTIONID;
                break;
            }
        }
        StringBuilder pkIds = new StringBuilder();
        StringBuilder entryIds = new StringBuilder();
        BillList billList = this.getTargetBillList(tabKey);
        if (billList != null) {
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            for (ListSelectedRow selectedRow : selectedRows) {
                Object entryId;
                Object pkId = selectedRow.getPrimaryKeyValue();
                if (pkId != null) {
                    pkIds.append(String.valueOf(pkId)).append(',');
                }
                if (!ROLE.equalsIgnoreCase(transferType) || (entryId = selectedRow.getEntryPrimaryKeyValue()) == null) continue;
                entryIds.append(String.valueOf(entryId)).append(',');
            }
        }
        selectedRowsInfo.put(PKKEY, pkKey);
        selectedRowsInfo.put(TRANSFERTYPE, transferType);
        selectedRowsInfo.put(PKIDS, pkIds.toString());
        if (entryIds.length() > 0) {
            selectedRowsInfo.put("roleEntryIds", entryIds.toString());
        }
        return selectedRowsInfo;
    }

    private BillList getTargetBillList(String tabKey) {
        if (WfUtils.isEmpty((String)tabKey)) {
            return null;
        }
        String pageId = this.getPageCache().get(tabKey + PAGEID);
        IFormView targetView = this.getView().getView(pageId);
        if (targetView != null) {
            return (BillList)targetView.getControl("billlistap");
        }
        return null;
    }

    private void viewTransferLog() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_worktransfer", (String)"1DO1JH4MOGIK")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5de5\u4f5c\u79fb\u4ea4\u201d\u7684\u201c\u67e5\u770b\u79fb\u4ea4\u65e5\u5fd7\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowWorkTransferPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        Long origAuditorId = this.getTransferId();
        if (!WfUtils.isEmpty((Long)origAuditorId)) {
            QFilter qFilter1 = new QFilter("origauditorid", "=", (Object)origAuditorId);
            qFilters.add(qFilter1);
        }
        this.showTransferLogList(qFilters);
    }

    private void showTransferLogList(List<QFilter> qFilters) {
        IFormView parentView = this.getView().getParentView();
        ListShowParameter listShowParam = new ListShowParameter();
        listShowParam.setBillFormId("wf_workstransferlog");
        listShowParam.setParentPageId(this.getView().getPageId());
        listShowParam.getOpenStyle().setTargetKey("_submaintab_");
        listShowParam.getOpenStyle().setShowType(ShowType.NewTabPage);
        listShowParam.setCaption(ResManager.loadKDString((String)"\u5de5\u4f5c\u79fb\u4ea4\u65e5\u5fd7", (String)"WorkflowWorkTransferPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        listShowParam.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        ListFilterParameter listFilterParam = new ListFilterParameter();
        listFilterParam.setQFilters(qFilters);
        listShowParam.setListFilterParameter(listFilterParam);
        parentView.showForm((FormShowParameter)listShowParam);
        this.getView().sendFormAction(parentView);
    }

    private boolean isRenovatedSuccess() {
        QFilter qFilter1 = new QFilter("key", "=", (Object)"renovateWorkTransferRelatedData");
        QFilter qFilter2 = new QFilter("value", "=", (Object)"true");
        QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2};
        return QueryServiceHelper.exists((String)"wf_confcenter", (QFilter[])qFilters);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (RENOVATEWORKTRANSFER.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String resultInfo = this.getRuntimeService().renovateWorkTransferRelatedData();
            if (WfUtils.isEmpty((String)resultInfo)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u79fb\u4ea4\u6570\u636e\u5df2\u51c6\u5907\u5b8c\u6bd5\u3002", (String)"WorkflowWorkTransferPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u79fb\u4ea4\u6570\u636e\u51c6\u5907\u5b8c\u6210\uff0c\u5176\u4e2d\uff1a%s\u3002", (String)"WorkflowWorkTransferPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), resultInfo));
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.showTabListFormInContainer(tabKey);
    }

    private void showTabListFormInContainer(String tabKey) {
        String formId = "";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        Long transferId = this.getTransferId();
        if (WfUtils.isNotEmpty((Long)transferId)) {
            boolean userEnable = UserServiceHelper.isUserEnable((long)transferId);
            this.getView().setVisible(Boolean.valueOf(!userEnable), new String[]{TABPAGE_EXECUTION});
            if (userEnable && TABPAGE_EXECUTION.equalsIgnoreCase(tabKey)) {
                Tab tab = (Tab)this.getView().getControl(TABAP);
                tab.activeTab(TABPAGE_TASK);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TABPAGE_EXECUTION});
        }
        HashMap<String, Comparable<Boolean>> customParams = null;
        switch (tabKey) {
            case "tabpage_task": {
                formId = "wf_taskintransits";
                qFilters.add(new QFilter("userid", "=", (Object)transferId));
                qFilters.add(new QFilter("delegateid", "=", (Object)0L));
                qFilters.add(new QFilter("handlestate", "!=", (Object)"unConverted"));
                qFilters.add(new QFilter("handlestate", "!=", (Object)"converting"));
                qFilters.add(new QFilter("processtype", "=", (Object)ModelType.AuditFlow.name()));
                break;
            }
            case "tabpage_process": {
                formId = "wf_participativeprocdef";
                qFilters.add(new QFilter("value", "like", (Object)("%" + transferId + "%")));
                qFilters.add(new QFilter("proctype", "=", (Object)ProcessType.AuditFlow.name()));
                qFilters.add(new QFilter("version", "!=", (Object)"testing"));
                break;
            }
            case "tabpage_role": {
                formId = "wf_participativerole";
                qFilters.add(new QFilter("roleentry.user", "=", (Object)transferId));
                customParams = new HashMap<String, Comparable<Boolean>>(1);
                customParams.put("openFromNonRoleList", Boolean.TRUE);
                break;
            }
            case "tabpage_execution": {
                formId = "wf_execution_tc";
                qFilters.add(new QFilter("processtype", "=", (Object)ModelType.AuditFlow.name()));
                customParams = new HashMap(1);
                customParams.put("workTransferCreatorId", transferId);
                customParams.put("executionTransfer", Boolean.TRUE);
                break;
            }
        }
        if (WfUtils.isEmpty((Long)transferId)) {
            qFilters.add(new QFilter("id", "=", (Object)0L));
        }
        if (!WfUtils.isEmpty((String)tabKey) && !WfUtils.isEmpty((String)formId)) {
            this.showListFormInContainer(formId, tabKey, qFilters, customParams);
        }
    }

    private void showListFormInContainer(String formId, String tabKey, List<QFilter> qFilters, Map<String, Object> customParams) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setShowTitle(false);
        parameter.setBillFormId(formId);
        parameter.setFormId("wf_worktransferlist");
        parameter.setMultiSelect(true);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(tabKey);
        if (qFilters != null && !qFilters.isEmpty()) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setQFilters(qFilters);
            parameter.setListFilterParameter(listFilterParameter);
        }
        if (customParams != null && !customParams.isEmpty()) {
            parameter.setCustomParams(customParams);
        }
        this.getView().showForm((FormShowParameter)parameter);
        this.getPageCache().put(tabKey + PAGEID, parameter.getPageId());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (BATCHTRANSFER.equals(actionId) && returnData instanceof Map) {
            Map message = (Map)returnData;
            if (message.isEmpty()) {
                return;
            }
            String title = (String)message.get("title");
            String details = (String)message.get("details");
            if (!WfUtils.isEmpty((String)details)) {
                StandardTips.view((IFormView)this.getView()).batchOptionMsg(title, details.replaceAll("\r\n", "</br>"));
            } else {
                String tips = ResManager.loadKDString((String)"\u79fb\u4ea4", (String)"AdminTransferTaskCmd_26", (String)"bos-wf-engine", (Object[])new Object[0]);
                StandardTips.view((IFormView)this.getView()).batchAllSuccess(tips);
            }
            this.getWorkTransferList();
        }
    }

    private String getCurrentTab() {
        Tab tabap = (Tab)this.getControl(TABAP);
        return tabap.getCurrentTab();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.removeCache();
    }

    private void removeCache() {
        this.getPageCache().remove("tabpage_task_pageId");
        this.getPageCache().remove("tabpage_process_pageId");
        this.getPageCache().remove("tabpage_role_pageId");
        this.getPageCache().remove("tabpage_execution_pageId");
    }
}

