/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.runtime.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.design.util.IBaseChangeLogCallBack;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;

public class AdminsSettingPlugin
extends AbstractWorkflowPlugin {
    public static final String FORM_ID = "wf_administrator";
    private static final String DELETE = "delete";
    private static final String ADDNEW = "addnew";
    private static final String ORGENTRY = "orgentry";
    private static final String ORGID = "orgid";
    private static final String ORGTYPE = "orgtype";
    private static final String INCLUDESUBORG = "includesuborg";
    private static final String DELETEAPP = "deleteapp";
    private static final String ADDNEWAPP = "addnewapp";
    private static final String APPENTRY = "appentry";
    private static final String BIZTYPE = "biztype";
    private static final String APPIDS = "appids";
    private static final String APPNUMBERS = "appnumbers";
    private static final String APPNAMES = "appnames";
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String USER_ID = "userid";
    private static final String MODIFY_DATE = "modifydate";
    private static final String CREATE_DATE = "createdate";
    private static final String WF_ADMINISTRATOR = "wf_administrator";
    private static final String WF_APPSELECT = "wf_app_select";
    private static final String ADMIN = "admin";
    private static final String TYPES = "types";
    private static final String DATACACHE = "dataCache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1"});
        this.addClickListeners(new String[]{ORGID});
        TextEdit tpl = (TextEdit)this.getView().getControl(APPNAMES);
        tpl.addButtonClickListener((ClickListener)this);
        this.showUsersAddCustomParam();
        this.showOrgAddCustomParam();
    }

    private void showUsersAddCustomParam() {
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(USER_ID);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
    }

    private void showOrgAddCustomParam() {
        BasedataEdit bosOrgF7 = (BasedataEdit)this.getControl(ORGID);
        bosOrgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            EntryGrid grid = (EntryGrid)this.getControl(ORGENTRY);
            int focusRow = grid.getEntryState().getFocusRow();
            String orgType = (String)this.getModel().getValue(ORGTYPE, focusRow);
            parameter.setCustomParam("orgFuncId", (Object)orgType);
        });
    }

    private void initOrgType() {
        List orgBizList = OrgUnitServiceHelper.getOrgBizSelectorList();
        HashMap<String, String> addOrgUnit = new HashMap<String, String>();
        addOrgUnit.put("15", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"AdminsSettingPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        orgBizList.add(addOrgUnit);
        if (WfUtils.isNotEmptyForCollection((Collection)orgBizList)) {
            StringBuilder types = new StringBuilder();
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(orgBizList.size());
            for (Map m : orgBizList) {
                for (Map.Entry entry : m.entrySet()) {
                    items.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey()));
                    types.append((String)entry.getKey()).append(",");
                }
            }
            this.getView().getPageCache().put(TYPES, types.toString());
            ComboEdit select = (ComboEdit)this.getControl(ORGTYPE);
            select.setComboItems(items);
        }
    }

    private void initBizType() {
        List<ComboItem> items = this.getItemsByParentId("10000");
        ComboEdit select = (ComboEdit)this.getControl(BIZTYPE);
        select.setComboItems(items);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initOrgType();
        this.getView().setEnable(Boolean.FALSE, new String[]{TYPE});
        this.initBizType();
        boolean userEnable = false;
        if (this.isAddNew()) {
            userEnable = true;
        }
        this.getView().setEnable(Boolean.valueOf(userEnable), new String[]{USER_ID});
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (WfAdminUtil.controlBtnByAdmin((Long)userId) && !WfAdminUtil.isWfManager((Long)userId)) {
            FieldEdit fieldEdit1 = (FieldEdit)this.getControl(ORGID);
            FieldEdit fieldEdit2 = (FieldEdit)this.getControl(ORGTYPE);
            FieldEdit fieldEdit3 = (FieldEdit)this.getControl(INCLUDESUBORG);
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ORGENTRY);
            if (null != entrys && !entrys.isEmpty()) {
                int size = entrys.size();
                for (int i = 0; i < size; ++i) {
                    fieldEdit1.setEnable(ORGID, false, i);
                    fieldEdit2.setEnable(ORGTYPE, false, i);
                    fieldEdit3.setEnable(INCLUDESUBORG, false, i);
                }
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ADDNEW, DELETE, ADDNEWAPP, DELETEAPP});
        } else {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ORGENTRY);
            if (null != entrys && !entrys.isEmpty()) {
                String types = this.getPageCache().get(TYPES);
                int size = entrys.size();
                for (int i = 0; i < size; ++i) {
                    String type;
                    DynamicObject row = this.getModel().getEntryRowEntity(ORGENTRY, i);
                    if (row == null || !WfUtils.isNotEmpty((String)row.getString(ORGTYPE)) || types.contains(type = row.getString(ORGTYPE))) continue;
                    this.getModel().setValue(ORGTYPE, (Object)"", i);
                }
            }
        }
        Map<String, ILocaleString> data = this.getUsedAppNames();
        this.getPageCache().put(DATACACHE, SerializationUtils.toJsonString(data));
        this.replaceAndPutCache(data);
        BaseChangeLogsUtil.putBaseModelCache(this.getView(), ADMIN, new IBaseChangeLogCallBack(){

            @Override
            public JSONArray getModelArray() {
                return AdminsSettingPlugin.this.getViewModelArray();
            }
        });
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"remark"});
        this.getModel().setValue("remark", (Object)ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5177\u6709\u8bbe\u8ba1\u4e2d\u5fc3\u3001\u7ba1\u7406\u4e2d\u5fc3\u3001\u76d1\u63a7\u4e2d\u5fc3\u548c\u57fa\u7840\u8d44\u6599\u7684\u529f\u80fd\u6743\u9650\uff1b\u5f53\u9009\u62e9\u7ec4\u7ec7\u8303\u56f4\u540e\uff0c\u5177\u6709\u6240\u9009\u8303\u56f4\u7684\u6d41\u7a0b\u8bbe\u8ba1\u5217\u8868\u3001\u6d41\u7a0b\u7ba1\u7406\u5217\u8868\u3001\u8fd0\u884c\u671f\u6570\u636e\u548c\u5de5\u4f5c\u6d41\u89d2\u8272\u7684\u6570\u636e\u6743\u9650\u3002", (String)"AdminsSettingPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Save && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String baseFormId = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0).toString();
            BaseChangeLogsUtil.addBaseLog(this.getView(), ADMIN, "wf_administrator", baseFormId, new IBaseChangeLogCallBack(){

                @Override
                public JSONArray getModelArray() {
                    return AdminsSettingPlugin.this.getViewModelArray();
                }
            });
            Object user = this.getModel().getValue(USER_ID);
            DynamicObject userObject = (DynamicObject)user;
            if (null != userObject) {
                String userId = userObject.getString(ID);
                WfAdminUtil.removeWfAdminCache((String)userId);
            }
            this.getView().close();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (ORGENTRY.equals(entryName)) {
            int index = e.getRowDataEntities()[0].getRowIndex();
            this.getModel().setValue(ORGTYPE, (Object)"15", index);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (WfAdminUtil.controlBtnByAdmin((Long)userId) && !WfAdminUtil.isWfManager((Long)userId)) {
            args.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u6d41\u7a0b\u7ba1\u7406\u5458\u53ef\u4fdd\u5b58\u3002", (String)"AdminsSettingPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (args.getSource() instanceof Save) {
            if (!this.validateModelValue()) {
                args.cancel = true;
                return;
            }
            this.prepareModelValue();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "addnewapp": {
                this.getModel().createNewEntryRow(APPENTRY);
                break;
            }
            case "delete": {
                EntryGrid grid1 = (EntryGrid)this.getControl(ORGENTRY);
                int[] focusRows1 = grid1.getEntryState().getSelectedRows();
                if (focusRows1.length > 0) {
                    this.getModel().deleteEntryRows(ORGENTRY, focusRows1);
                    break;
                }
                StandardTips.view((IFormView)this.getView()).notSelectRow();
                break;
            }
            case "deleteapp": {
                EntryGrid grid2 = (EntryGrid)this.getControl(APPENTRY);
                int[] focusRows2 = grid2.getEntryState().getSelectedRows();
                if (focusRows2.length > 0) {
                    this.getModel().deleteEntryRows(APPENTRY, focusRows2);
                    break;
                }
                StandardTips.view((IFormView)this.getView()).notSelectRow();
                break;
            }
            case "appnames": {
                this.openAppSelectWin();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (APPNAMES.equals(key)) {
            this.openAppSelectWin();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        if (WF_APPSELECT.equalsIgnoreCase(e.getActionId()) && (returnData = e.getReturnData()) instanceof Map) {
            Map appInfos = (Map)returnData;
            EntryGrid grid = (EntryGrid)this.getControl(APPENTRY);
            int[] focusRows = grid.getEntryState().getFocusRows();
            if (focusRows.length > 0) {
                int index = focusRows[0];
                String appNumbers = (String)appInfos.get(APPNUMBERS);
                this.getModel().setValue(APPIDS, appInfos.get(APPIDS), index);
                this.getModel().setValue(APPNUMBERS, (Object)appNumbers, index);
                this.getModel().setValue(APPNAMES, appInfos.get(APPNAMES), index);
                Map allAppNames = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(DATACACHE), Map.class);
                if (appNumbers != null && appNumbers.contains(",")) {
                    String[] keys;
                    ILocaleString names = BaseChangeLogsUtil.newMultiLangString("");
                    for (String key : keys = appNumbers.split(",")) {
                        names = WfMultiLangUtils.jointILocaleString((ILocaleString)names, (ILocaleString)LocaleString.fromMap((Map)((Map)allAppNames.get(key))), (String)",");
                    }
                    this.getPageCache().put(appNumbers, SerializationUtils.toJsonString((Object)names));
                } else {
                    this.getPageCache().put(appNumbers, SerializationUtils.toJsonString(allAppNames.get(appNumbers)));
                }
            }
        }
    }

    private void prepareModelValue() {
        if (this.isAddNew()) {
            this.getModel().setValue(CREATE_DATE, (Object)WfUtils.now());
            this.getModel().setValue(MODIFY_DATE, (Object)WfUtils.now());
        } else {
            this.getModel().setValue(MODIFY_DATE, (Object)WfUtils.now());
        }
    }

    private boolean validateModelValue() {
        String emptyErrorMessage = this.validateEmpty();
        if (WfUtils.isNotEmpty((String)emptyErrorMessage)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u3002", (String)"AdminsSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), emptyErrorMessage));
            return false;
        }
        if (!this.validateUnique()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5df2\u5b58\u5728\u4e8e\u7ec4\u7ec7\u8303\u56f4\u4e0b\u3002", (String)"AdminsSettingPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateUnique() {
        Object user = this.getModel().getValue(USER_ID);
        Long userId = ((DynamicObject)user).getLong(ID);
        Object id = this.getPKID();
        boolean isAddNew = WfUtils.isNullObject((Object)id);
        QFilter[] filters = null;
        QFilter userFilter = new QFilter(USER_ID, "=", (Object)userId);
        if (isAddNew) {
            filters = new QFilter[]{userFilter};
        } else {
            QFilter idFilter = new QFilter(ID, "<>", id);
            filters = new QFilter[]{userFilter, idFilter};
        }
        return !QueryServiceHelper.exists((String)"wf_administrator", (QFilter[])filters);
    }

    private String validateEmpty() {
        DynamicObjectCollection items;
        DynamicObjectCollection orgentry;
        StringBuilder errorMessage = new StringBuilder();
        Object user = this.getModel().getValue(USER_ID);
        if (user == null) {
            errorMessage.append(ResManager.loadKDString((String)"\u4eba\u5458 ", (String)"AdminsSettingPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        if (WfUtils.isNotEmptyForCollection((Collection)(orgentry = this.getModel().getEntryEntity(ORGENTRY)))) {
            for (DynamicObject item : orgentry) {
                if (item != null && WfUtils.isEmptyString((Object)item.get(ORGTYPE))) {
                    errorMessage.append(ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b", (String)"AdminsSettingPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (item != null && WfUtils.isEmptyString((Object)item.get(ORGID))) {
                    errorMessage.append(ResManager.loadKDString((String)"\u7ba1\u8f96\u7ec4\u7ec7", (String)"AdminsSettingPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (errorMessage.length() <= 0) continue;
                break;
            }
        }
        if (WfUtils.isNotEmptyForCollection((Collection)(items = this.getModel().getEntryEntity(APPENTRY)))) {
            for (DynamicObject item : items) {
                if (item != null && WfUtils.isEmptyString((Object)item.get(BIZTYPE))) {
                    errorMessage.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91\u7c7b\u578b ", (String)"AdminsSettingPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                }
                if (item != null && WfUtils.isEmptyString((Object)item.get(APPNAMES))) {
                    errorMessage.append(ResManager.loadKDString((String)"\u7ba1\u8f96\u5e94\u7528", (String)"AdminsSettingPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (errorMessage.length() <= 0) continue;
                break;
            }
        }
        return errorMessage.toString();
    }

    private Object getPKID() {
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        return baseShowParameter.getPkId();
    }

    private boolean isAddNew() {
        return WfUtils.isEmptyString((Object)this.getPKID());
    }

    private JSONArray getViewModelArray() {
        JSONArray arr = new JSONArray();
        for (int i = 0; i < this.getModel().getEntryRowCount(ORGENTRY); ++i) {
            DynamicObject orgObject = (DynamicObject)this.getView().getControl(ORGENTRY).getModel().getValue(ORGID, i);
            Object state = this.getView().getControl(ORGENTRY).getModel().getValue(INCLUDESUBORG, i);
            if (null == orgObject) continue;
            JSONObject org = new JSONObject();
            org.put("org", (Object)SerializationUtils.toJsonString((Object)orgObject.getLocaleString("name")));
            org.put("state", state);
            arr.add((Object)org);
        }
        IDataModel model = this.getView().getControl(APPENTRY).getModel();
        for (int i = 0; i < this.getModel().getEntryRowCount(APPENTRY); ++i) {
            String bizType = (String)model.getValue(BIZTYPE, i);
            String appNumbers = (String)model.getValue(APPNUMBERS, i);
            Object receiveMsg = model.getValue("receivemsg", i);
            JSONObject app = new JSONObject();
            app.put(BIZTYPE, (Object)bizType);
            app.put(APPNAMES, (Object)this.getPageCache().get(appNumbers));
            app.put("receivemsg", receiveMsg);
            arr.add((Object)app);
        }
        return arr;
    }

    private List<ComboItem> getItemsByParentId(String parentId) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(8);
        List processCategoryEntities = this.getRepositoryService().getProcateByParentId(Long.valueOf(Long.parseLong(parentId)), null);
        if (WfUtils.isNotEmptyForCollection((Collection)processCategoryEntities)) {
            for (ProcessCategoryEntity entity : processCategoryEntities) {
                items.add(new ComboItem(LocaleString.fromMap((Map)entity.getILocaleStringName()), entity.getId() + ""));
            }
        }
        return items;
    }

    private Map<String, ILocaleString> getUsedAppNames() {
        HashMap<String, ILocaleString> ret = new HashMap<String, ILocaleString>(8);
        QFilter qFilter = new QFilter("isleaf", "=", (Object)"1");
        List cates = this.getRepositoryService().findEntitiesByFilters("wf_processcagetory", new QFilter[]{qFilter}, "number,name", null);
        if (WfUtils.isNotEmptyForCollection((Collection)cates)) {
            for (ProcessCategoryEntity cate : cates) {
                ret.put(cate.getNumber(), cate.getILocaleStringName());
            }
        }
        return ret;
    }

    private void replaceAndPutCache(Map<String, ILocaleString> allAppNames) {
        Lang lang = RequestContext.get().getLang();
        IDataModel model = this.getView().getControl(APPENTRY).getModel();
        for (int i = 0; i < this.getModel().getEntryRowCount(APPENTRY); ++i) {
            String appNumbers = (String)model.getValue(APPNUMBERS, i);
            if (appNumbers != null && appNumbers.contains(",")) {
                String[] keys;
                ILocaleString names = BaseChangeLogsUtil.newMultiLangString("");
                for (String key : keys = appNumbers.split(",")) {
                    names = WfMultiLangUtils.jointILocaleString((ILocaleString)names, (ILocaleString)allAppNames.get(key), (String)",");
                }
                this.getPageCache().put(appNumbers, SerializationUtils.toJsonString((Object)names));
                model.setValue(APPNAMES, names.get((Object)lang.toString()), i);
                continue;
            }
            this.getPageCache().put(appNumbers, SerializationUtils.toJsonString((Object)allAppNames.get(appNumbers)));
            if (null == allAppNames.get(appNumbers)) continue;
            model.setValue(APPNAMES, allAppNames.get(appNumbers).get((Object)lang.toString()), i);
        }
    }

    private void openAppSelectWin() {
        String bizTypeId = null;
        EntryGrid grid = (EntryGrid)this.getControl(APPENTRY);
        int[] focusRows = grid.getEntryState().getFocusRows();
        if (focusRows.length > 0) {
            int index = focusRows[0];
            bizTypeId = (String)this.getModel().getValue(BIZTYPE, index);
        }
        if (null != bizTypeId) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(WF_APPSELECT);
            parameter.setCustomParam("parentId", (Object)bizTypeId);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, WF_APPSELECT));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u4e91\u7c7b\u578b\u3002", (String)"AdminsSettingPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        if (BIZTYPE.equals(propName)) {
            this.getModel().setValue(APPNAMES, (Object)"", rowIndex);
            this.getModel().setValue(APPIDS, (Object)"", rowIndex);
            this.getModel().setValue(APPNUMBERS, (Object)"", rowIndex);
        }
        if (APPNAMES.equals(propName) && WfUtils.isEmptyString((Object)newValue)) {
            this.getModel().setValue(APPIDS, (Object)"", rowIndex);
            this.getModel().setValue(APPNUMBERS, (Object)"", rowIndex);
        }
    }
}

