/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.runtime.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.UnSubmit;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.AdvConBarItemAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.mcontrol.MBarItemAp;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.FormView;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModel;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModelDetail;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModelDetailFieldInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillPageAttributeConfigEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.BillPageAttributeConfigPlugin;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class ApprovalBillControlPlugIn
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(ApprovalBillControlPlugIn.class);
    public static final String PLUGIN_NAME = "kd.bos.workflow.runtime.plugin.ApprovalBillControlPlugIn";
    public static final String PROCESSDEFINITIONID = "processDefinitionId";
    public static final String PROCESSINSTANCEID = "processInstanceId";
    public static final String TASKDEFINITIONKEY = "taskDefinitionKey";
    public static final String FORMKEY = "formkey";
    public static final String BUSINESSKEY = "businessKey";
    public static final String ONLYVIEW = "onlyView";
    public static final String PCSHOW = "pcShow";
    public static final String VIEWBILL = "VIEWBILL";
    public static final String ISTOAPPLYORAPPLYED = "istoapplyorapplyed";
    public static final String TASKID = "taskid";
    public static final String FROMMSGCENTER = "fromMsgCenter";
    public static final String ISTOHANDLE = "istohandle";
    public static final String SHOWBILLBTNSWHENTOAPPLYORAPPLYED = "showBillBtnsWhenToApplyOrApplyed";
    private IClientViewProxy clientViewProxy = null;
    private static final String CONTROLFORMODIFY = "modify";
    private static final String CONTROLFORMUSTINPUT = "mustinput";
    private static final String CONTROLFORHIDE = "hide";
    private static final String CONTROLFORDISPLAY = "display";
    private static final String SCENEFORFIELD = "field";
    private static final String SCENEFORBTN = "btn";
    private static final String SCENEFORIMG = "img";
    public static final String PAGECACHEKEYFORMUSTINPUTFIELDINFOMAP = "mustInputFieldInfoMap";

    public void beforeBindData(EventObject e) {
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!"AUDITFLOW".equals(formShowParameter.getCustomParam("SCENE"))) {
            return;
        }
        Object pcShowObj = formShowParameter.getCustomParam(PCSHOW);
        boolean pcShow = null == pcShowObj ? true : (Boolean)pcShowObj;
        boolean isShowBillApprovalRecord = WfConfigurationUtil.isShowBillApprovalRecord((boolean)pcShow);
        if (!isShowBillApprovalRecord) {
            formShowParameter.setCustomParam("hideApprovalRecord", (Object)"true");
        }
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        FormView billView = (FormView)this.getView();
        Boolean viewbill = (Boolean)formShowParameter.getCustomParam(VIEWBILL);
        Boolean msgCenter = (Boolean)formShowParameter.getCustomParam(FROMMSGCENTER);
        if (viewbill != null && viewbill.booleanValue() && null != msgCenter && !msgCenter.booleanValue()) {
            ApprovalPluginUtil.hideFormControls(billView);
            this.setNotVisibleForBlackControl(billView);
            return;
        }
        if (!this.settledAsAccord()) {
            this.settledAsDefault();
        }
        this.setNotVisibleForBlackControl(billView);
    }

    private boolean settledAsAccord() {
        if (!(this.getView() instanceof BillView)) {
            return false;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (null == formShowParameter) {
            return false;
        }
        BillView billView = (BillView)this.getView();
        if (null == billView) {
            return false;
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Object attributeConfigsObj = wfService.getRepositoryService().getPageAttrCfg((String)formShowParameter.getCustomParam(BUSINESSKEY), (Long)formShowParameter.getCustomParam(PROCESSDEFINITIONID), (Long)formShowParameter.getCustomParam(PROCESSINSTANCEID), (String)formShowParameter.getCustomParam(TASKDEFINITIONKEY), (String)formShowParameter.getCustomParam(FORMKEY), (Boolean)formShowParameter.getCustomParam(PCSHOW));
        if (null == attributeConfigsObj) {
            return false;
        }
        Boolean onlyView = (Boolean)formShowParameter.getCustomParam(ONLYVIEW);
        boolean isButtonSeted = false;
        HashMap<String, Boolean> toolBarHide = new HashMap<String, Boolean>();
        if (attributeConfigsObj instanceof List) {
            List attributeConfigs = (List)attributeConfigsObj;
            if (0 == attributeConfigs.size()) {
                return false;
            }
            boolean getSettledContolResult = false;
            for (BillPageAttributeConfigEntity cfg : attributeConfigs) {
                if (null == cfg) continue;
                getSettledContolResult = this.settledControl(new String[]{cfg.getFieldnumber()}, cfg.isHide(), cfg.isModify(), false, onlyView, toolBarHide);
                if (isButtonSeted) continue;
                isButtonSeted = getSettledContolResult;
            }
        } else if (attributeConfigsObj instanceof BillPageAttributeConfigModel) {
            BillPageAttributeConfigModel attributeConfigsModel = (BillPageAttributeConfigModel)attributeConfigsObj;
            this.settledControlOptimize(attributeConfigsModel, SCENEFORFIELD, onlyView, toolBarHide);
            isButtonSeted = this.settledControlOptimize(attributeConfigsModel, SCENEFORBTN, onlyView, toolBarHide);
            this.settledControlOptimize(attributeConfigsModel, SCENEFORIMG, onlyView, toolBarHide);
        }
        if (!isButtonSeted) {
            ApprovalPluginUtil.hideBillControls(billView);
            return true;
        }
        if (toolBarHide.size() > 0) {
            Set entrySet = toolBarHide.entrySet();
            Iterator ite = entrySet.iterator();
            Map.Entry entry = null;
            while (ite.hasNext()) {
                entry = ite.next();
                billView.setVisible(Boolean.valueOf((Boolean)entry.getValue() == false), new String[]{(String)entry.getKey()});
            }
        }
        return true;
    }

    private boolean settledControlOptimize(BillPageAttributeConfigModel attributeConfigsModel, String scene, Boolean onlyView, Map<String, Boolean> toolBarHide) {
        BillPageAttributeConfigModelDetail configModelDetail = null;
        boolean sceneForField = SCENEFORFIELD.equals(scene);
        boolean sceneForBtn = SCENEFORBTN.equals(scene);
        boolean sceneForImg = SCENEFORIMG.equals(scene);
        if (sceneForField) {
            configModelDetail = attributeConfigsModel.getField();
        } else if (sceneForBtn) {
            configModelDetail = attributeConfigsModel.getBtn();
        } else if (sceneForImg) {
            configModelDetail = attributeConfigsModel.getImg();
        }
        if (null == configModelDetail) {
            return false;
        }
        if (sceneForField) {
            this.settledControlOptimizeDetail(configModelDetail, CONTROLFORMODIFY, onlyView, toolBarHide);
            this.settledControlOptimizeDetail(configModelDetail, CONTROLFORHIDE, onlyView, toolBarHide);
            this.settledControlOptimizeDetail(configModelDetail, CONTROLFORMUSTINPUT, onlyView, toolBarHide);
        } else {
            if (sceneForBtn) {
                this.settledControlOptimizeDetail(configModelDetail, CONTROLFORDISPLAY, onlyView, toolBarHide);
                this.settledControlOptimizeDetail(configModelDetail, CONTROLFORHIDE, onlyView, toolBarHide);
                return true;
            }
            if (sceneForImg) {
                this.settledControlOptimizeDetail(configModelDetail, CONTROLFORDISPLAY, onlyView, toolBarHide);
            }
        }
        return false;
    }

    private void settledControlOptimizeDetail(BillPageAttributeConfigModelDetail configModelDetail, String scene, Boolean onlyView, Map<String, Boolean> toolBarHide) {
        if (null == configModelDetail) {
            return;
        }
        BillPageAttributeConfigModelDetailFieldInfo modelDetailFieldInfo = null;
        boolean isModify = CONTROLFORMODIFY.equals(scene);
        boolean isMustInput = CONTROLFORMUSTINPUT.equals(scene);
        boolean isHide = CONTROLFORHIDE.equals(scene);
        boolean isDisplay = CONTROLFORDISPLAY.equals(scene);
        if (isModify) {
            modelDetailFieldInfo = configModelDetail.getModify();
        } else if (isMustInput) {
            modelDetailFieldInfo = configModelDetail.getMustinput();
        } else if (isHide) {
            modelDetailFieldInfo = configModelDetail.getHide();
        } else if (isDisplay) {
            modelDetailFieldInfo = configModelDetail.getDisplay();
            isHide = false;
        }
        if (null == modelDetailFieldInfo) {
            return;
        }
        String fieldNumber = modelDetailFieldInfo.getFieldnumber();
        if (null == fieldNumber || fieldNumber.trim().isEmpty()) {
            return;
        }
        this.settledControl(fieldNumber.split(","), isHide, isModify, isMustInput, onlyView, toolBarHide);
    }

    private void settledAsDefault() {
        Boolean isToapplyOrApplyed;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formkey = (String)formShowParameter.getCustomParam(FORMKEY);
        FormView billView = (FormView)this.getView();
        Boolean isToHandle = formShowParameter.getCustomParam(ISTOHANDLE) == null ? Boolean.FALSE : (Boolean)formShowParameter.getCustomParam(ISTOHANDLE);
        Boolean bl = isToapplyOrApplyed = formShowParameter.getCustomParam(ISTOAPPLYORAPPLYED) == null ? Boolean.FALSE : (Boolean)formShowParameter.getCustomParam(ISTOAPPLYORAPPLYED);
        if (!isToapplyOrApplyed.booleanValue() && !isToHandle.booleanValue()) {
            ApprovalPluginUtil.hideFormControls(billView);
        } else {
            this.setNotVisibleForNewAndCopy(billView, formkey);
            if (!isToHandle.booleanValue()) {
                boolean showBillBtnsWhenToApplyOrApplyed;
                boolean bl2 = showBillBtnsWhenToApplyOrApplyed = formShowParameter.getCustomParam(SHOWBILLBTNSWHENTOAPPLYORAPPLYED) == null ? false : Boolean.parseBoolean((String)formShowParameter.getCustomParam(SHOWBILLBTNSWHENTOAPPLYORAPPLYED));
                if (showBillBtnsWhenToApplyOrApplyed) {
                    ApprovalPluginUtil.hideFormControls(billView, true);
                } else {
                    ApprovalPluginUtil.hideFormControls(billView);
                }
            }
        }
    }

    private boolean settledControl(String[] fieldNumbers, boolean cfgHide, boolean cfgModify, boolean cfgMustInput, Boolean onlyView, Map<String, Boolean> toolBarHide) {
        if (null == fieldNumbers || 0 == fieldNumbers.length || null == toolBarHide) {
            return false;
        }
        boolean isButtonSeted = false;
        if (null == onlyView) {
            onlyView = false;
        }
        boolean isHide = cfgHide || onlyView != false;
        boolean isModify = cfgModify && onlyView == false;
        boolean isMustInput = cfgMustInput && onlyView == false;
        BillView billView = (BillView)this.getView();
        Control control = null;
        int subLastIndex = 0;
        HashMap<String, String> mustInputFieldInfoMap = new HashMap<String, String>(fieldNumbers.length);
        for (String fieldNumber : fieldNumbers) {
            if (null == fieldNumber || fieldNumber.trim().isEmpty()) continue;
            if (fieldNumber.indexOf(46) > -1) {
                subLastIndex = fieldNumber.lastIndexOf(46);
                String subFieldNumber = fieldNumber.substring(subLastIndex + 1);
                control = this.getControl(subFieldNumber);
                if (Toolbar.class.isInstance(control)) {
                    String controlKey = control.getKey();
                    if (isHide) {
                        Boolean toolBarHideExist = toolBarHide.get(controlKey);
                        if (toolBarHideExist == null) {
                            toolBarHide.put(controlKey, Boolean.TRUE);
                        }
                    } else {
                        toolBarHide.put(controlKey, Boolean.FALSE);
                    }
                    billView.setVisible(Boolean.valueOf(!isHide), new String[]{fieldNumber.substring(0, subLastIndex)});
                    isButtonSeted = true;
                    continue;
                }
                if (Button.class.isInstance(control)) {
                    String entryKey = fieldNumber.substring(0, subLastIndex);
                    if (CardEntry.class.isInstance(this.getControl(entryKey))) {
                        if (control.getClass().equals(Button.class)) {
                            ApprovalPluginUtil.setControlVisibleForCardEntry(this.getView(), entryKey, !isHide, subFieldNumber);
                        } else if ((control instanceof Label || control instanceof Image) && !isHide) {
                            ApprovalPluginUtil.setControlVisibleForCardEntry(this.getView(), entryKey, true, subFieldNumber);
                        }
                    } else {
                        this.setVisibleForButtonType(billView, control, isHide, subFieldNumber);
                    }
                    isButtonSeted = true;
                    continue;
                }
                FieldEdit ctrl = (FieldEdit)control;
                if (ctrl != null && ctrl.getEntryKey() != null) {
                    this.changeCtrlState(ctrl, subFieldNumber, cfgHide, isModify, isMustInput, mustInputFieldInfoMap, fieldNumber);
                    continue;
                }
                this.changeCtrlState(billView, subFieldNumber, cfgHide, isModify, isMustInput, mustInputFieldInfoMap, fieldNumber);
                continue;
            }
            control = this.getControl(fieldNumber);
            if (Button.class.isInstance(control)) {
                isButtonSeted = true;
                this.setVisibleForButtonType(billView, control, isHide, fieldNumber);
                continue;
            }
            this.changeCtrlState(billView, fieldNumber, cfgHide, isModify, isMustInput, mustInputFieldInfoMap, fieldNumber);
        }
        if (mustInputFieldInfoMap.isEmpty()) {
            return isButtonSeted;
        }
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return isButtonSeted;
        }
        parentView.getPageCache().put(PAGECACHEKEYFORMUSTINPUTFIELDINFOMAP, SerializationUtils.toJsonString(mustInputFieldInfoMap));
        return isButtonSeted;
    }

    private void setVisibleForButtonType(BillView billView, Control control, Boolean isHide, String fieldNumber) {
        if (control.getClass().equals(Button.class) || control.getClass().equals(Vector.class)) {
            billView.setVisible(Boolean.valueOf(isHide == false), new String[]{fieldNumber});
        } else if ((control instanceof Label || control instanceof Image) && !isHide.booleanValue()) {
            billView.setVisible(Boolean.TRUE, new String[]{fieldNumber});
        }
    }

    private void changeCtrlState(Object ctrl, String fieldNumber, boolean isHide, boolean isModify, boolean isMustInput, Map<String, String> mustInputInfoMap, String fieldNumberWhole) {
        FieldEdit fieldEdit = null;
        if (ctrl instanceof IFormView) {
            Control fieldControl;
            IFormView formView = (IFormView)ctrl;
            if (isModify) {
                this.unlockFirst(fieldNumber, null);
                formView.setEnable(Boolean.TRUE, new String[]{fieldNumber});
            }
            if ((fieldControl = formView.getControl(fieldNumber)) instanceof FieldEdit) {
                fieldEdit = (FieldEdit)fieldControl;
            }
            if (isHide) {
                formView.setVisible(Boolean.FALSE, new String[]{fieldNumber});
            }
        } else if (ctrl instanceof FieldEdit) {
            fieldEdit = (FieldEdit)ctrl;
            String entryKey = fieldEdit.getEntryKey();
            Control entryControl = this.getControl(entryKey);
            if (null == entryControl) {
                logger.debug("kd.bos.workflow.runtime.plugin.ApprovalBillControlPlugIn.changeCtrlState(Object, String, boolean, boolean, boolean, Map<String, String>, String) entryKey is " + entryKey);
                return;
            }
            if (entryControl.getClass().equals(EntryGrid.class) || entryControl.getClass().equals(SubEntryGrid.class) || entryControl.getClass().equals(TreeEntryGrid.class)) {
                if (isModify) {
                    this.unlockFirst(fieldNumber, fieldEdit.getEntryKey());
                    fieldEdit.setEnable(fieldNumber, true, -1);
                }
                if (isHide) {
                    fieldEdit.setVisible(fieldNumber, false);
                }
            }
            if (CardEntry.class.isInstance(entryControl)) {
                if (isModify) {
                    this.unlockFirst(fieldNumber, null);
                }
                if (isHide) {
                    ApprovalPluginUtil.setControlVisibleForCardEntry(this.getView(), entryKey, false, fieldNumber);
                }
            }
        }
        if (isHide || !isMustInput || null == fieldEdit) {
            return;
        }
        logger.debug("kd.bos.workflow.runtime.plugin.ApprovalBillControlPlugIn.changeCtrlState(Object, String, boolean, boolean, boolean, Map<String, String>, String) mustinput setting fieldNumberWhole is " + fieldNumberWhole);
        fieldEdit.setMustInput(true);
        String fieldNameLocal = null;
        IDataEntityProperty fieldEditProperty = fieldEdit.getProperty();
        fieldNameLocal = null == fieldEditProperty ? this.getFieldNameLocalFromMetadata(fieldNumber) : fieldEditProperty.getDisplayName().getLocaleValue();
        if (WfUtils.isEmpty((String)fieldNameLocal)) {
            fieldNameLocal = fieldNumber;
        }
        mustInputInfoMap.put(fieldNumberWhole, fieldNameLocal);
    }

    private String getFieldNameLocalFromMetadata(String fieldNumber) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityNumber = this.getModel().getDataEntityType().getName();
        String queryNumber = null;
        Object formKeyObj = customParams.get(FORMKEY);
        Object pcShowObj = customParams.get(PCSHOW);
        boolean isEntityMob = null != pcShowObj && !Boolean.parseBoolean(pcShowObj.toString()) && null != formKeyObj && formKeyObj.toString().endsWith("_mob");
        queryNumber = isEntityMob ? entityNumber : formKeyObj;
        if (null == queryNumber) {
            return null;
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)queryNumber.toString(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (null == formMetadata) {
            return null;
        }
        if (isEntityMob) {
            BillFormAp billFormAp = (BillFormAp)formMetadata.getRootAp();
            formMetadata = billFormAp.getMobMeta();
        }
        if (null == formMetadata) {
            return null;
        }
        List items = formMetadata.getItems();
        if (null == items || items.isEmpty()) {
            return null;
        }
        LocaleString controlName = null;
        String controlNameLocal = null;
        for (ControlAp controlAp : items) {
            if (null == controlAp || !fieldNumber.equals(controlAp.getKey())) continue;
            controlName = controlAp.getName();
            if (null == controlName) break;
            controlNameLocal = controlName.getLocaleValue();
            break;
        }
        return controlNameLocal;
    }

    private void unlockFirst(String field, String entryKey) {
        if (WfUtils.isEmpty((String)entryKey)) {
            HashMap<String, Integer> prop = new HashMap<String, Integer>(1);
            prop.put("l", 0);
            this.getView().updateControlMetadata(field, prop);
        } else {
            this.getClientViewProxy().invokeControlMethod(entryKey, "setColProp", new Object[]{field, "l", 0});
        }
    }

    private IClientViewProxy getClientViewProxy() {
        if (this.clientViewProxy == null) {
            this.clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        }
        return this.clientViewProxy;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof UnSubmit) {
            this.getView().getFormShowParameter().setStatusValue(1);
        }
    }

    private void setNotVisibleForBlackControl(FormView billView) {
        String[] blackControlCodes;
        for (String bFieldNumber : blackControlCodes = BillPageAttributeConfigPlugin.getBlackControlCodes()) {
            billView.setVisible(Boolean.valueOf(false), new String[]{bFieldNumber});
        }
    }

    private void setNotVisibleForNewAndCopy(FormView billView, String formkey) {
        if (WfUtils.isEmpty((String)formkey) || null == billView) {
            return;
        }
        try {
            String id = MetadataDao.getIdByNumber((String)formkey, (MetaCategory)MetaCategory.Form);
            if (WfUtils.isEmpty((String)id)) {
                return;
            }
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
            if (null != formMetadata && WfUtils.isNotEmptyForCollection((Collection)formMetadata.getItems())) {
                List li = formMetadata.getItems();
                for (ControlAp controlAp : li) {
                    String operationKey;
                    Class<?> clazz = controlAp.getClass();
                    if (!BarItemAp.class.equals(clazz) && !MBarItemAp.class.equals(clazz) && !AdvConBarItemAp.class.equals(clazz) && !ButtonAp.class.equals(clazz) || !"new".equalsIgnoreCase(operationKey = ((ButtonAp)controlAp).getOperationKey()) && !"copy".equalsIgnoreCase(operationKey) && !"push".equalsIgnoreCase(operationKey)) continue;
                    String key = controlAp.getKey();
                    billView.setVisible(Boolean.FALSE, new String[]{key});
                }
            }
        }
        catch (Exception e) {
            logger.error("setNotVisibleForNewAndCopy error:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }
}

