/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.runtime.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.UserList;
import kd.bos.list.events.BackPressedEvent;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.ParticipantStrategy;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ParticipantRangeUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BosMobileUserListDynPlugIn
extends AbstractMobListPlugin
implements ListSelectedListener,
ClickListener {
    private static final String TIPS_FOR_REQUIRED_LIST = "tipsForRequiredList";
    private static final String CANCLE_CLOSE = "cancleClose";

    public void registerListener(EventObject e) {
        UserList userList;
        FormShowParameter formParameter = this.getView().getFormShowParameter();
        if (formParameter instanceof MobileListShowParameter) {
            this.addClickListeners(new String[]{"confirm"});
        } else if (formParameter instanceof MobileFormShowParameter && (userList = (UserList)this.getView().getControl("userlist")) != null) {
            userList.addListSelectedListener((ListSelectedListener)this);
        }
    }

    public void backPressed(BackPressedEvent evt) {
        this.getView().getPageCache().put(CANCLE_CLOSE, "false");
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        boolean cancel = false;
        String cancleClose = this.getPageCache().get(CANCLE_CLOSE);
        if (null != cancleClose) {
            cancel = Boolean.parseBoolean(cancleClose);
        }
        if (cancel) {
            this.getView().showTipNotification(this.getPageCache().get(TIPS_FOR_REQUIRED_LIST));
        }
        e.setCancel(cancel);
    }

    public void endSelect(EndSelectEvent arg0) {
        Object requiredUsersStr;
        Map customParams;
        Object endSelectData = arg0.getData();
        if (null != endSelectData && null != (customParams = this.getView().getFormShowParameter().getCustomParams()) && 0 != customParams.size() && null != (requiredUsersStr = customParams.get("selectedPersonValueForRequired")) && arg0.getData() instanceof ListSelectedRowCollection) {
            String tipsForRequiredList = ParticipantRangeUtil.getTipsForRequiredList((String)requiredUsersStr.toString(), (ListSelectedRowCollection)((ListSelectedRowCollection)arg0.getData()));
            this.getView().getPageCache().put(CANCLE_CLOSE, "true");
            this.getView().getPageCache().put(TIPS_FOR_REQUIRED_LIST, tipsForRequiredList);
            return;
        }
        this.getView().getPageCache().put(CANCLE_CLOSE, "false");
        this.getView().close();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object sourceObj = evt.getSource();
        if (sourceObj instanceof Button && "confirm".equals(((Button)sourceObj).getKey())) {
            ListSelectedRowCollection collection = null;
            BillList billList = (BillList)this.getControl("billlistap");
            if (null != billList) {
                collection = billList.getSelectedRows();
            }
            String tipsForRequiredList = null;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (customParams != null && customParams.size() > 0) {
                Object requiredUsersStr = customParams.get("selectedPersonValueForRequired");
                if (null != requiredUsersStr) {
                    tipsForRequiredList = ParticipantRangeUtil.getTipsForRequiredList((String)requiredUsersStr.toString(), (ListSelectedRowCollection)collection);
                }
                Long processDefinitionId = (Long)customParams.get("procdefid");
                Long processInstanceId = (Long)customParams.get("procinstid");
                String currentNodeId = (String)customParams.get("taskdefinitionkey");
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                BpmnModel bpmnModel = null;
                Long schemeId = (Long)customParams.get("schemeid");
                bpmnModel = schemeId != null ? wfService.getRepositoryService().getBpmnModel(processDefinitionId, schemeId, processInstanceId) : wfService.getRepositoryService().getBpmnModel(processDefinitionId, processInstanceId);
                UserTask userTask = (UserTask)bpmnModel.getFlowElement(currentNodeId);
                String taskType = userTask.getType();
                if ("AuditTask".equalsIgnoreCase(taskType) || "YunzhijiaTask".equalsIgnoreCase(taskType)) {
                    AuditTask auditTask = (AuditTask)userTask;
                    ParticipantStrategy participantStrategy = auditTask.getParticipantStrategy();
                    if (WfUtils.isNotEmptyForCollection((Collection)collection)) {
                        if (participantStrategy != null) {
                            Boolean isSinglePersonAssign = participantStrategy.isSingleParticipant();
                            if (collection != null && isSinglePersonAssign != null && isSinglePersonAssign.booleanValue() && collection.size() > 1) {
                                tipsForRequiredList = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8282\u70b9\u7684\u6307\u5b9a\u53c2\u4e0e\u4eba\u63a7\u5236\u7b56\u7565\u4e3a\u201c\u53c2\u4e0e\u4eba\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u4eba\u201d\uff0c\u8bf7\u4e3a\u8be5\u8282\u70b9\u6307\u5b9a\u4e00\u4f4d\u53c2\u4e0e\u4eba\u3002", (String)"BosMobileUserListDynPlugIn_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), userTask.getName());
                            }
                        }
                    } else {
                        String formNum;
                        Boolean configCenterFlag = Boolean.TRUE;
                        String nodeType = (String)customParams.get("nodetype");
                        if ((processInstanceId == null || "UserTask".equals(nodeType)) && (formNum = (String)customParams.get("formnum")) != null && WfConfigurationUtil.isStopSubmitWhenNextPersonEmpty((String)formNum)) {
                            tipsForRequiredList = String.format(ResManager.loadKDString((String)"\u4e0b\u4e00\u6b65\u8282\u70b9\u53c2\u4e0e\u4eba\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u5165\u6d41\u7a0b\uff0c\u8bf7\u8054\u7cfb\u6d41\u7a0b\u7ba1\u7406\u5458\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a\u6d41\u7a0b\u7f16\u7801\u201c%1$s\u201d\uff0c\u8282\u70b9\u540d\u79f0\u201c%2$s\u201d\u3002", (String)"ApprovalParticipantChoosePlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), auditTask.getNumber(), auditTask.getName());
                            configCenterFlag = Boolean.FALSE;
                        }
                        if (participantStrategy != null && configCenterFlag.booleanValue()) {
                            Boolean isEmptyParticipant = participantStrategy.isEmptyParticipant();
                            if (collection != null && isEmptyParticipant != null && configCenterFlag.booleanValue() && isEmptyParticipant.booleanValue() && collection.size() == 0) {
                                tipsForRequiredList = String.format(ResManager.loadKDString((String)"\u8bf7\u4e3a\u201c%s\u8282\u70b9\u201d\u6307\u5b9a\u53c2\u4e0e\u4eba\u3002", (String)"ApprovalPluginNew_58", (String)"bos-wf-formplugin", (Object[])new Object[0]), userTask.getName());
                            }
                        }
                    }
                }
            }
            if (WfUtils.isNotEmpty(tipsForRequiredList)) {
                this.getView().getPageCache().put(CANCLE_CLOSE, "true");
                this.getView().getPageCache().put(TIPS_FOR_REQUIRED_LIST, tipsForRequiredList);
                return;
            }
            this.getView().getPageCache().put(CANCLE_CLOSE, "false");
            this.getView().close();
        }
    }
}

