/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.runtime.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.SaveOrUpdateDynResourceCmd;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WfDynModifyUserPlugin
extends AbstractWorkflowPlugin {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String NODES = "nodes";
    public static final String PARTICIPANT = "participant";
    public static final String BTN_CANCEL = "cancelbtn";
    public static final String BTN_CONFIRM = "confirmbtn";
    public static final String CACHE_PROCESSNAME = "processName";
    public static final String CACHE_RESOURCE = "resource";
    public static final String CACHE_PROINSTIDS = "proinstIds";
    public static final String FBASEDATAID = "fbasedataid";
    public static final String ID = "id";
    public static final String PROCESSINSTANCEID = "processInstanceId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        this.showUsersAddCustomParam();
    }

    private void showUsersAddCustomParam() {
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(PARTICIPANT);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            listFilterParameter.setFilter(qFilter);
            ((ListShowParameter)parameter).setListFilterParameter(listFilterParameter);
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
    }

    public void afterCreateNewData(EventObject eo) {
        List procInstIds = (List)this.getView().getFormShowParameter().getCustomParam("procInstId");
        if (procInstIds.size() > 1) {
            this.getPageCache().put(CACHE_PROINSTIDS, SerializationUtils.toJsonString((Object)procInstIds));
            this.getView().setVisible(Boolean.FALSE, new String[]{NODES});
        } else {
            Long procInstId = (Long)procInstIds.get(0);
            if (WfUtils.isEmpty((Long)procInstId) || this.getRuntimeService().getProcessInstance(procInstId) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\u6216\u5df2\u7ed3\u675f\u3002", (String)"WfDynModifyUserPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("procInstId", String.valueOf(procInstId));
            ExecutionEntity execution = null;
            List executions = this.getRuntimeService().getChildExecutionsByProcessInstanceId(procInstId);
            if (executions == null || executions.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u7684\u6d41\u7a0b\u5b9e\u4f8b\u3002", (String)"WfDynModifyUserPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder activityIds = new StringBuilder();
            BpmnModel bpmnModel = this.getRepositoryService().getBpmnModel(null, procInstId);
            Process process = bpmnModel.getMainProcess();
            List elements = process.getFlowElementList();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            for (FlowElement e : elements) {
                if (!(e instanceof UserTask) || e.getType().equals("SSCApprove")) continue;
                UserTask u = (UserTask)e;
                ComboItem comboItem = new ComboItem();
                String activityId = u.getId();
                String multiKey = BpmnModelUtil.getActivityNameMultiKey((String)activityId);
                LocaleString caption = (LocaleString)BpmnModelUtil.getMultiLangFieldValue((Long)procInstId, (String)multiKey, (String)u.getName());
                comboItem.setCaption(caption);
                comboItem.setValue(activityId);
                comboItems.add(comboItem);
                activityIds.append(activityId).append(",");
            }
            ((ComboEdit)this.getControl(NODES)).setComboItems(comboItems);
            this.cacheResource(procInstId);
            for (ExecutionEntity exec : executions) {
                if (null == exec || exec.isScope() || !activityIds.toString().contains(exec.getActivityId())) continue;
                execution = exec;
                break;
            }
            if (execution == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u7684\u6d41\u7a0b\u5b9e\u4f8b\u3002", (String)"WfDynModifyUserPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("procDefId", String.valueOf(execution.getProcessDefinitionId()));
            this.getModel().setValue(NODES, (Object)execution.getActivityId());
            this.setParticipantControlValue(execution.getActivityId());
        }
    }

    private ParticipantModelEntityImpl getParticipant(String activityId) {
        if (WfUtils.isEmpty((String)this.getPageCache().get(CACHE_RESOURCE))) {
            return null;
        }
        Map resourceMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_RESOURCE), Map.class);
        if (WfUtils.isNotEmpty((String)((String)resourceMap.get(activityId)))) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"wf_dynamicresource");
            DynamicResourceEntityImpl resource = new DynamicResourceEntityImpl((DynamicObject)DataEntitySerializer.deSerializerFromString((String)((String)resourceMap.get(activityId)), (IDataEntityType)entityType));
            String modelJson = resource.getContent().getLocaleValue();
            if (WfUtils.isNotEmpty((String)modelJson)) {
                BpmnModel sbpmnModel = null;
                try {
                    JsonNode jsonNode = new ObjectMapper().readTree(modelJson);
                    sbpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
                    UserTask userTask = (UserTask)sbpmnModel.getMainProcess().getFlowElement(activityId);
                    List participants = null;
                    if (userTask != null && userTask.getParticipant() != null && (participants = userTask.getParticipant().getParticipant()) != null && !participants.isEmpty()) {
                        return (ParticipantModelEntityImpl)userTask.getParticipant().getParticipant().get(0);
                    }
                }
                catch (IOException ie) {
                    this.logger.error(ie.getMessage(), (Throwable)ie);
                }
            }
        }
        return null;
    }

    private void cacheResource(Long procInstId) {
        List resource = this.getRuntimeService().getDynamicResourceByProcessInstanceId(procInstId);
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        BpmnModel bpmnModel = null;
        JsonNode jsonNode = null;
        ObjectMapper mapper = new ObjectMapper();
        BpmnJsonConverter converter = new BpmnJsonConverter();
        for (DynamicResourceEntity i : resource) {
            String type = i.getType();
            if ("addsignafter".equals(type) || "addsignbefore".equals(type) || "freeflow".equals(type)) continue;
            String modelJson = i.getContent().getLocaleValue();
            try {
                jsonNode = mapper.readTree(modelJson);
                bpmnModel = converter.convertToBpmnModel(jsonNode);
                List fes = bpmnModel.getMainProcess().getFlowElementList();
                for (FlowElement f : fes) {
                    UserTask userTask;
                    String activityId = f.getId();
                    if (!(f instanceof UserTask) || (userTask = (UserTask)f) == null || userTask.getParticipant() == null || userTask.getParticipant().getParticipant() == null || userTask.getParticipant().getParticipant().isEmpty()) continue;
                    resourceMap.put(activityId, DataEntitySerializer.serializerToString((Object)i.getDynamicObject(), (boolean)false, (boolean)true));
                }
            }
            catch (IOException ie) {
                this.logger.error(ie.getMessage(), (Throwable)ie);
            }
        }
        this.getPageCache().put(CACHE_RESOURCE, SerializationUtils.toJsonString(resourceMap));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(NODES)) {
            String activityId = this.getModel().getValue(propertyName).toString();
            this.setParticipantControlValue(activityId);
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if (BTN_CONFIRM.equals(ctrl.getKey())) {
            String appId = "a479ec06000000ac";
            String entityNum = "wf_execution";
            if ("bpm".equalsIgnoreCase(this.getView().getFormShowParameter().getAppId())) {
                appId = "194JD185SVFC";
                entityNum = "wf_execution_tree";
            }
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)entityNum, (String)"018KF2ZNSR7J")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u8bbe\u7f6e\u6302\u8d77\u53c2\u4e0e\u4eba\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_18", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection user = (DynamicObjectCollection)this.getModel().getValue(PARTICIPANT);
            if (user == null || user.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfDynModifyUserPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (WfUtils.isNotEmpty((String)this.getPageCache().get(CACHE_PROINSTIDS))) {
                List proInstIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_PROINSTIDS), Long.class);
                this.getRuntimeService().saveOrUpdateDynResource(null, null, proInstIds, this.getPkValues(user).toString());
            } else {
                String activityId = this.getModel().getValue(NODES).toString();
                if (WfUtils.isEmpty((String)activityId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u8282\u70b9\u201d\u3002", (String)"WfDynModifyUserPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                this.saveOrUpdateSingleResource(user, activityId);
            }
            this.addLog(user);
            this.getView().close();
        }
    }

    private void addLog(DynamicObjectCollection newUser) {
        List procInstIds = (List)this.getView().getFormShowParameter().getCustomParam("procInstId");
        String ids = String.valueOf(procInstIds);
        String activityId = (String)this.getModel().getValue(NODES);
        StringBuilder names = new StringBuilder();
        StringBuilder userIds = new StringBuilder();
        for (int i = 0; i < newUser.size(); ++i) {
            DynamicObject user = (DynamicObject)newUser.get(i);
            if (i < newUser.size() - 1) {
                names.append(user.getDynamicObject(FBASEDATAID).getString("name")).append(',');
                userIds.append(user.getDynamicObject(FBASEDATAID).getLong(ID)).append(',');
                continue;
            }
            names.append(user.getDynamicObject(FBASEDATAID).getString("name"));
            userIds.append(user.getDynamicObject(FBASEDATAID).getLong(ID));
        }
        WfUtils.addOpLog((String)"wf_execution", (String)"dynModifyUser", (MultiLangEnumBridge)new MultiLangEnumBridge("\u52a8\u6001\u4fee\u6539\u53c2\u4e0e\u4eba", "WfDynModifyUserPlugin_4", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c06 %1$s \u8282\u70b9\u53c2\u4e0e\u4eba\u4fee\u6539\u4e3a\uff1a%2$s [%3$s]", "WfDynModifyUserPlugin_5", "bos-wf-formplugin"), (Object[])new Object[]{activityId, names.toString(), userIds.toString()});
    }

    private void saveOrUpdateSingleResource(DynamicObjectCollection users, String activityId) {
        boolean isUpdate = false;
        DynamicResourceEntityImpl resource = null;
        BpmnModel sbpmnModel = null;
        UserTask userTask = null;
        Map resourceMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_RESOURCE), Map.class);
        if (WfUtils.isNotEmpty((String)((String)resourceMap.get(activityId)))) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"wf_dynamicresource");
            resource = new DynamicResourceEntityImpl((DynamicObject)DataEntitySerializer.deSerializerFromString((String)((String)resourceMap.get(activityId)), (IDataEntityType)entityType));
            resource = (DynamicResourceEntity)this.getRepositoryService().findEntityById(resource.getId(), "wf_dynamicresource");
            String content = resource.getContent().getLocaleValue();
            try {
                JsonNode jsonNode = new ObjectMapper().readTree(content);
                sbpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
                userTask = (UserTask)sbpmnModel.getMainProcess().getFlowElement(activityId);
                List participants = null;
                if (userTask != null && userTask.getParticipant() != null && (participants = userTask.getParticipant().getParticipant()) != null && !participants.isEmpty()) {
                    StringBuffer sb = this.getPkValues(users);
                    ((ParticipantModelEntityImpl)participants.get(0)).setValue(sb.toString());
                    content = GraphCodecUtils.convertBpmnModelToJSON((BpmnModel)sbpmnModel);
                    resource.setContent((ILocaleString)new LocaleString(content));
                    isUpdate = true;
                }
            }
            catch (IOException ie) {
                this.logger.error(ie.getMessage(), (Throwable)ie);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f6c\u6362\u5f02\u5e38\uff01", (String)"WfDynModifyUserPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (!isUpdate) {
            String content;
            BpmnModel newBpmnModel = this.getRepositoryService().getBpmnModel(null, Long.valueOf(this.getPageCache().get("procInstId"))).clone();
            if (resource == null) {
                resource = new DynamicResourceEntityImpl();
                resource.setName("dyn." + newBpmnModel.getMainProcess().getNumber() + ".bpmn20.json");
                resource.setProcessDefineId(Long.valueOf(this.getPageCache().get("procDefId")));
                resource.setProcessInstanceId(Long.valueOf(this.getPageCache().get("procInstId")));
                resource.setActivityId(activityId);
                resource.setType("dynParticipant");
            }
            if (userTask == null) {
                DynamicObjectCollection userObj = (DynamicObjectCollection)this.getModel().getValue(PARTICIPANT);
                userTask = SaveOrUpdateDynResourceCmd.createUserTask((String)activityId, (BpmnModel)newBpmnModel, (String)this.getPkValues(userObj).toString());
            }
            if (sbpmnModel == null) {
                sbpmnModel = new BpmnModel();
                Process dynProcess = new Process();
                sbpmnModel.addProcess(dynProcess);
                if (null != newBpmnModel.getLocationMap()) {
                    sbpmnModel.addGraphicInfo(activityId, (GraphicInfo)newBpmnModel.getLocationMap().get(activityId));
                }
                dynProcess.addFlowElement((FlowElement)userTask);
                content = GraphCodecUtils.convertBpmnModelToJSON((BpmnModel)sbpmnModel);
                resource.setContent((ILocaleString)new LocaleString(content));
            } else {
                List flowElements = sbpmnModel.getMainProcess().getFlowElementList();
                flowElements.add(userTask);
                sbpmnModel.getMainProcess().setFlowElementList(flowElements);
                content = GraphCodecUtils.convertBpmnModelToJSON((BpmnModel)sbpmnModel);
                resource.setContent((ILocaleString)new LocaleString(content));
            }
        }
        if (null != resource) {
            this.getRuntimeService().saveOrUpdateDynResource(resource.getProcessInstanceId(), resource, null, null);
        }
    }

    private StringBuffer getPkValues(DynamicObjectCollection users) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < users.size(); ++i) {
            DynamicObject user = (DynamicObject)users.get(i);
            if (i < users.size() - 1) {
                sb.append(user.getDynamicObject(FBASEDATAID).getLong(ID)).append(',');
                continue;
            }
            sb.append(user.getDynamicObject(FBASEDATAID).getLong(ID));
        }
        return sb;
    }

    private void setParticipantControlValue(String activityId) {
        String[] pkValueStrs;
        int pkValueStrsLength;
        if (WfUtils.isEmpty((String)activityId)) {
            return;
        }
        ParticipantModelEntityImpl p = this.getParticipant(activityId);
        if (null != p && null != p.getValue() && 0 != (pkValueStrsLength = (pkValueStrs = p.getValue().split(",")).length)) {
            ArrayList<Long> pkValues = new ArrayList<Long>(pkValueStrsLength);
            for (String pkValue : pkValueStrs) {
                pkValues.add(Long.valueOf(pkValue));
            }
            this.getModel().setValue(PARTICIPANT, (Object)pkValues.toArray());
            return;
        }
        this.getModel().setValue(PARTICIPANT, null);
    }
}

