/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.runtime.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WfJumpNodesForAPIPlugin
extends AbstractWorkflowPlugin
implements RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String SRCNODEID = "srcnodeid";
    private static final String PROINSTID = "proInstId";
    private static final String PRODEFID = "prodefId";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String CONFIRMJUMPFROMSHARED = "confirmJumpFromShared";

    @Override
    public void initialize() {
        Button btnok = (Button)this.getView().getControl(BTN_OK);
        btnok.addClickListener((ClickListener)this);
        Button btncancel = (Button)this.getView().getControl(BTN_CANCEL);
        btncancel.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase(BTN_OK)) {
            this.returnDataToParent();
        } else if (key.equalsIgnoreCase(BTN_CANCEL)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        String permission = (String)this.getView().getFormShowParameter().getCustomParam("permission");
        if ("wfexecution".equals(permission) && !PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_execution", (String)"/8M3P61RNHXZ")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u8df3\u8f6c\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String srcId = (String)this.getModel().getValue(SRCNODEID);
        if (WfUtils.isNotEmpty((String)srcId)) {
            if (srcId.contains("SSCApprove")) {
                String message = ResManager.loadKDString((String)"\u4efb\u52a1\u8df3\u8f6c\u79bb\u5f00\u5171\u4eab\u8282\u70b9\u9700\u5728\u201c\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3>\u4efb\u52a1\u7ba1\u7406\u201d\u624b\u52a8\u5220\u9664\u5bf9\u5e94\u7684\u5171\u4eab\u4efb\u52a1\uff0c\u786e\u5b9a\u8df3\u8f6c\u5417\uff1f", (String)"WfJumpNodesPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRMJUMPFROMSHARED));
            } else {
                this.confirmReturnDataToParent(srcId);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u8282\u70b9\u548c\u76ee\u6807\u8282\u70b9\u3002", (String)"WfJumpNodesPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void confirmReturnDataToParent(String srcId) {
        if (WfUtils.isNotEmpty((String)srcId)) {
            AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
            int[] rowIndexs = grid.getEntryState().getSelectedRows();
            HashMap<String, String> map = new HashMap<String, String>(rowIndexs.length);
            for (int i = 0; i < rowIndexs.length; ++i) {
                map.put("id", (String)this.getModel().getValue("nodeid", rowIndexs[i]));
                map.put("name", (String)this.getModel().getValue("nodename", rowIndexs[i]));
                map.put("documentation", (String)this.getModel().getValue("nodedec", rowIndexs[i]));
            }
            map.put("srcId", srcId);
            this.getView().getParentView();
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eo) {
        Long executionId = (Long)this.getView().getFormShowParameter().getCustomParam("executionId");
        ExecutionEntity execution = (ExecutionEntity)this.getRepositoryService().findEntityById(executionId, "wf_execution");
        if (execution != null) {
            this.getPageCache().put(PROINSTID, String.valueOf(execution.getProcessInstanceId()));
            this.getPageCache().put(PRODEFID, String.valueOf(execution.getProcessDefinitionId()));
            List jumpNodes = this.getManagementService().getJumpNodes(executionId);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(5);
            String srcNodeId = "";
            for (Map n : jumpNodes) {
                ComboItem comboItem = new ComboItem();
                String nid = (String)n.get("value");
                if (WfUtils.isEmpty((String)srcNodeId)) {
                    srcNodeId = nid;
                }
                comboItem.setCaption((LocaleString)n.get("caption"));
                comboItem.setValue(nid);
                comboItems.add(comboItem);
            }
            ComboEdit operation = (ComboEdit)this.getControl(SRCNODEID);
            operation.setComboItems(comboItems);
            this.getView().getModel().setValue(SRCNODEID, (Object)srcNodeId);
            this.clearAndFillNewVal(srcNodeId);
        }
    }

    private void clearAndFillNewVal(String srcNodeId) {
        Long proInstId = Long.valueOf(this.getPageCache().get(PROINSTID));
        ExecutionEntity execution = (ExecutionEntity)this.getRepositoryService().findEntityById(proInstId, "wf_execution");
        BpmnModel bpmnModel = this.getManagementService().getDynamicConfigSchemeBpmnModel(execution.getSchemeId());
        this.getModel().deleteEntryData(ENTRYENTITY);
        List<FlowElement> jumpNodes = this.filterOptionalNodes(BpmnModelUtil.getJumpNodes((BpmnModel)bpmnModel, (String)srcNodeId));
        if (jumpNodes != null && !jumpNodes.isEmpty()) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRYENTITY, jumpNodes.size());
            int i = 0;
            for (FlowElement fe : jumpNodes) {
                model.setValue("nodeid", (Object)fe.getId(), i);
                model.setValue("nodename", (Object)fe.getName(), i);
                model.setValue("nodedec", (Object)fe.getDocumentation(), i);
                ++i;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (SRCNODEID.equals(propertyName)) {
            String srcNodeId = (String)this.getModel().getValue(SRCNODEID);
            if (WfUtils.isEmpty((String)srcNodeId)) {
                this.getModel().deleteEntryData(ENTRYENTITY);
            } else {
                this.clearAndFillNewVal(srcNodeId);
            }
        }
    }

    public List<FlowElement> filterOptionalNodes(List<FlowElement> nodesWithoutFilter) {
        ArrayList<FlowElement> filterNodes = new ArrayList<FlowElement>(nodesWithoutFilter.size());
        for (FlowElement node : nodesWithoutFilter) {
            if (node instanceof StartEvent) continue;
            filterNodes.add(node);
        }
        return filterNodes;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            switch (callBackId) {
                case "confirmJumpFromShared": {
                    String srcId = (String)this.getModel().getValue(SRCNODEID);
                    this.confirmReturnDataToParent(srcId);
                }
            }
        }
    }
}

