/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.runtime.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowStartProcessInTerminalPlugin
extends AbstractWorkflowPlugin {
    private static final String BUSINESSKEY = "businesskey";
    private static final String ENTITYID = "entityid";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String ENTITYNAME = "entityname";
    private static final String OPERATIONNUMBER = "operationnumber";
    private static final String OPERATIONNAME = "operationname";
    private static final String BTNOK = "btnok";
    private static final String SUBMIT = "submit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUSINESSKEY, ENTITYNAME, OPERATIONNAME, BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{ENTITYID, ENTITYNUMBER, OPERATIONNUMBER});
        this.getModel().setValue(OPERATIONNUMBER, (Object)SUBMIT);
        this.getModel().setValue(OPERATIONNAME, (Object)ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"WorkflowStartProcessInTerminalPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "entityname": {
                DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, ENTITYNAME);
                break;
            }
            case "businesskey": {
                this.selectEntryBill();
                break;
            }
            case "operationname": {
                this.selectOperation();
                break;
            }
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    private void selectEntryBill() {
        String entityNumber = (String)this.getModel().getValue(ENTITYNUMBER);
        if (WfUtils.isEmpty((String)entityNumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\uff01", (String)"WorkflowStartProcessInTerminalPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BUSINESSKEY));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void selectOperation() {
        String operation = SUBMIT;
        String currentOperation = (String)this.getModel().getValue(OPERATIONNUMBER);
        if (!WfUtils.isEmpty((String)currentOperation)) {
            operation = currentOperation;
        }
        String entityId = (String)this.getModel().getValue(ENTITYID);
        String entrabillNumber = (String)this.getModel().getValue(ENTITYNUMBER);
        if (WfUtils.isEmpty((String)entrabillNumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\uff01", (String)"WorkflowStartProcessInTerminalPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap context = new HashMap();
        HashMap<String, String> nodeProperties = new HashMap<String, String>();
        nodeProperties.put("entityId", entityId);
        nodeProperties.put("formKey", entrabillNumber);
        context.put("nodeProperties", nodeProperties);
        params.put("context", context);
        params.put("selchexkbox", Boolean.FALSE);
        if (operation != null) {
            params.put("selectValues", operation);
        }
        this.showForm(OPERATIONNAME, "wf_formoperation", params);
    }

    private void confirm() {
        String businessKey = (String)this.getModel().getValue(BUSINESSKEY);
        String operation = (String)this.getModel().getValue(OPERATIONNUMBER);
        String entityNumber = (String)this.getModel().getValue(ENTITYNUMBER);
        String bkid = (String)this.getModel().getValue("bktxt");
        DynamicObject initiaor = (DynamicObject)this.getModel().getValue("initiaor");
        HashMap<String, String> variables = new HashMap<String, String>();
        DynamicObjectCollection dc = this.getModel().getEntryEntity("entryentity");
        if (dc != null && !dc.isEmpty()) {
            for (DynamicObject obj : dc) {
                String key = obj.getString("key");
                String value = obj.getString("value");
                if (!WfUtils.isNotEmpty((String)key) || !WfUtils.isNotEmpty((String)value)) continue;
                variables.put(key, value);
            }
        }
        try {
            String appId;
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (entity != null && variables.get("appnumber") == null && !"bos".equalsIgnoreCase(appId = ServiceLookup.getServiceAppId((String)entity.getAppId()))) {
                String appNumber = EntityMetadataCache.getAppNumberById((String)appId);
                variables.put("appnumber", appNumber);
            }
            if (initiaor != null && initiaor.getPkValue() != null) {
                variables.put("_initiator_", initiaor.getPkValue().toString());
            }
            if (WfUtils.isEmpty((String)businessKey)) {
                businessKey = bkid;
            }
            WorkflowServiceHelper.tryTriggerProcess((String)businessKey, (String)operation, (String)entityNumber, variables);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u542f\u52a8\u6210\u529f\uff0c\u6b63\u5728\u540e\u53f0\u8fd0\u884c\u3002", (String)"WorkflowStartProcessInTerminalPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowStartProcessInTerminalPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "entityname": {
                this.closeBackForEntrabill((Map)returnData);
                break;
            }
            case "businesskey": {
                this.closeBackForBusinessKey(returnData);
                break;
            }
            case "operationname": {
                this.closeBackForOperation((Map)returnData);
                break;
            }
            default: {
                super.closedCallBack(closedCallBackEvent);
            }
        }
    }

    private void closeBackForEntrabill(Map<String, Object> result) {
        this.getModel().setValue(ENTITYNUMBER, result.get("number"));
        this.getModel().setValue(ENTITYNAME, result.get("name"));
        this.getModel().setValue(ENTITYID, result.get("id"));
    }

    private void closeBackForBusinessKey(Object returnData) {
        Object[] businessKeys;
        if (returnData instanceof ListSelectedRowCollection && (businessKeys = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues()) != null && businessKeys.length > 0) {
            this.getModel().setValue(BUSINESSKEY, businessKeys[0]);
        }
    }

    private void closeBackForOperation(Map<String, Object> result) {
        this.getModel().setValue(OPERATIONNUMBER, result.get("number"));
        this.getModel().setValue(OPERATIONNAME, result.get("name"));
    }
}

