/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.mvc.SessionManager;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.workflow.design.plugin.ChangeFlowChartComponent;
import kd.bos.workflow.design.plugin.ViewFlowChartPermComponent;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.WorkflowFormService;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.TaskHandleState;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.EngineAPIExceptionEnum;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.util.WfBOUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.CollectionUtils;

@KSObject
@SdkPublic
public class WorkFlowFormServiceHelper {
    @KSMethod
    public static void openTransferView(IFormView formView, List<Long> taskIds, CloseCallBack closeCallBack) {
        if (formView == null) {
            return;
        }
        if (CollectionUtils.isEmpty(taskIds)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"WorkFlowFormServiceHelper_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_transfertohandletask");
        parameter.setCaption(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u8f6c\u4ea4", (String)"WorkFlowFormServiceHelper_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), new Object[0]));
        parameter.setCustomParam("taskIds", taskIds);
        if (!ObjectUtils.isEmpty((Object)closeCallBack)) {
            parameter.setCloseCallBack(closeCallBack);
        }
        formView.showForm(parameter);
    }

    @KSMethod
    public static void openCoordinateRequestView(IFormView formView, Long taskId, boolean isTaskCoordinate, CloseCallBack closeCallBack) {
        if (formView == null) {
            return;
        }
        if (WfUtils.isEmpty((Long)taskId) || ObjectUtils.isEmpty((Object)isTaskCoordinate)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"WorkFlowFormServiceHelper_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean exists = WfBOUtil.existByORM((String)"wf_task", (Object)taskId);
        if (!exists) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u3002", (String)"WorkFlowFormServiceHelper_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (TaskUtils.isTaskSuspended((Long)taskId)) {
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e3a\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd%1$s\u6216%2$s%3$s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\u3002", (String)"WorkFlowFormServiceHelper_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getTransferName()));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("taskid", taskId);
        customParams.put("is_taskcoordinate", String.valueOf(isTaskCoordinate));
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("wf_taskcoordinate");
        if (isTaskCoordinate) {
            para.setCaption(String.format(ResManager.loadKDString((String)"%1$s\u4efb\u52a1%2$s", (String)"WorkFlowFormServiceHelper_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getTransferName()));
        } else {
            para.setCaption(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%s", (String)"WorkFlowFormServiceHelper_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName()));
        }
        para.setCustomParams(customParams);
        if (!ObjectUtils.isEmpty((Object)closeCallBack)) {
            para.setCloseCallBack(closeCallBack);
        }
        formView.showForm(para);
    }

    @KSMethod
    public static void openTaskReminderView(IFormView formView, Long proInstanceId) {
        if (formView == null) {
            return;
        }
        if (WfUtils.isEmpty((Long)proInstanceId)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"WorkFlowFormServiceHelper_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ExecutionEntity e = (ExecutionEntity)wfService.getRepositoryService().findEntityById(proInstanceId, "wf_execution");
        if (e == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8fd9\u6761\u6570\u636e\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5904\u7406\u3002", (String)"WorkFlowFormServiceHelper_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        TaskService taskService = wfService.getTaskService();
        Map returnInfo = taskService.taskReminders(proInstanceId, (ILocaleString)new LocaleString(""), "query");
        if (null != returnInfo && 0 != returnInfo.size()) {
            Object message = returnInfo.get("message");
            if (!WfUtils.isEmptyString(message)) {
                formView.showMessage(message.toString());
            } else {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("executionId", proInstanceId);
                customParams.put("allUserName", returnInfo.get("allUserName").toString());
                FormShowParameter para = new FormShowParameter();
                para.getOpenStyle().setShowType(ShowType.Modal);
                para.setFormId("wf_taskreminder");
                para.setCaption(String.format(ResManager.loadKDString((String)"\u6d88\u606f%s", (String)"WorkFlowFormServiceHelper_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getUrgeName()));
                para.setCustomParams(customParams);
                para.setHasRight(true);
                formView.showForm(para);
            }
        }
    }

    @KSMethod
    public static void openTaskCirculateView(IFormView formView, Long taskId, CloseCallBack closeCallBack) {
        if (formView == null) {
            return;
        }
        if (WfUtils.isEmpty((Long)taskId)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"WorkFlowFormServiceHelper_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Long> customParams = new HashMap<String, Long>();
        customParams.put("taskid", taskId);
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("wf_taskcirculation");
        para.setCaption(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%s", (String)"WorkFlowFormServiceHelper_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName()));
        para.setCustomParams(customParams);
        if (!ObjectUtils.isEmpty((Object)closeCallBack)) {
            para.setCloseCallBack(closeCallBack);
        }
        formView.showForm(para);
    }

    @KSMethod
    public static void openUpdateTaskParticipantView(IFormView formView, List<Long> taskIds, CloseCallBack closeCallBack) {
        if (formView == null) {
            return;
        }
        if (CollectionUtils.isEmpty(taskIds)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"WorkFlowFormServiceHelper_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_transfertask");
        parameter.setCustomParam("currentNode", (Object)"");
        StringBuilder taskIdStr = new StringBuilder();
        StringBuilder userIdStr = new StringBuilder();
        String currentNode = "";
        for (Long taskId : taskIds) {
            if (WorkFlowFormServiceHelper.isTaskExist(String.valueOf(taskId), formView)) {
                taskIdStr.append(String.valueOf(taskId)).append(',');
                if (taskIds.size() == 1) {
                    WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                    List identityLinkEntities = wfService.getRuntimeService().getIdentityLinksByTaskId(taskId);
                    for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                        if (!"participant".equals(identityLinkEntity.getType())) continue;
                        Long user = identityLinkEntity.getUserId();
                        userIdStr.append(String.valueOf(user)).append(',');
                    }
                    TaskEntity taskEntity = (TaskEntity)wfService.getRepositoryService().findEntityById(taskId, "wf_task");
                    currentNode = taskEntity.getCategory();
                }
            } else {
                return;
            }
            parameter.setCustomParam("entrance", null);
            parameter.setCustomParam("taskId", (Object)taskIdStr);
            parameter.setCustomParam("userId", (Object)userIdStr.toString());
            parameter.setCustomParam("currentNode", (Object)currentNode);
            if (!ObjectUtils.isEmpty((Object)closeCallBack)) {
                parameter.setCloseCallBack(closeCallBack);
            }
            formView.showForm(parameter);
        }
    }

    private static boolean isTaskExist(String taskId, IFormView view) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskHandleState state = wfService.getRepositoryService().isTaskHandled(taskId);
        if (state != null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5904\u7406\u3002", (String)"WorkFlowFormServiceHelper_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @KSMethod
    public static void openAddSignView(String id, IFormView formView, CloseCallBack closeCallBack) {
        if (formView == null) {
            return;
        }
        Long taskId = WorkFlowFormServiceHelper.getLong(id, formView);
        if (taskId == null) {
            return;
        }
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        String validate = workflowService.validateApi(taskId, "addsignView");
        if (EngineAPIExceptionEnum.isExistCode((String)validate)) {
            formView.showTipNotification(EngineAPIExceptionEnum.getDescByCode((String)validate));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_addsignpage");
        parameter.setCustomParam("taskid", (Object)id);
        parameter.setCloseCallBack(closeCallBack);
        formView.showForm(parameter);
    }

    @KSMethod
    public static void openProcessAbortView(String id, IFormView formView, CloseCallBack closeCallBack) {
        if (formView == null) {
            return;
        }
        Long processInstanceId = WorkFlowFormServiceHelper.getLong(id, formView);
        if (processInstanceId == null) {
            return;
        }
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        RuntimeService runtimeService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRuntimeService();
        String validate = workflowService.validateApi(processInstanceId, "abort");
        if (EngineAPIExceptionEnum.isExistCode((String)validate)) {
            formView.showTipNotification(EngineAPIExceptionEnum.getDescByCode((String)validate));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_adminabandon_option");
        parameter.setCustomParam("permission", (Object)"wfexecution");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("executionId", (Object)processInstanceId);
        parameter.setCustomParam("api", (Object)"api");
        ArrayList<Long> processInstanceIds = new ArrayList<Long>(1);
        processInstanceIds.add(processInstanceId);
        List procInstIdsWithSubProcTag = runtimeService.getProcessInstanceIdsWithSubProcTag(processInstanceIds);
        if (!procInstIdsWithSubProcTag.isEmpty()) {
            parameter.setCustomParam("showAbandonSubProcFlex", (Object)Boolean.TRUE);
        }
        parameter.setCloseCallBack(closeCallBack);
        formView.showForm(parameter);
    }

    @KSMethod
    public static void openSkipView(String id, IFormView formView, CloseCallBack closeCallBack) {
        if (formView == null) {
            return;
        }
        Long processInstanceId = WorkFlowFormServiceHelper.getLong(id, formView);
        if (processInstanceId == null) {
            return;
        }
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        String validate = workflowService.validateApi(processInstanceId, "jumpView");
        if (EngineAPIExceptionEnum.isExistCode((String)validate)) {
            formView.showTipNotification(EngineAPIExceptionEnum.getDescByCode((String)validate));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u53ef\u9009\u8282\u70b9", (String)"ProcessInstancePluginUtil_23", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setFormId("wf_skipnode");
        parameter.setCustomParam("permission", (Object)"wfexecution");
        parameter.setCustomParam("executionId", (Object)processInstanceId);
        parameter.setCustomParam("api", (Object)"api");
        parameter.setCloseCallBack(closeCallBack);
        formView.showForm(parameter);
    }

    private static Long getLong(String id, IFormView view) {
        Long processInstanceId = null;
        try {
            processInstanceId = Long.valueOf(id);
            if (WfUtils.isEmpty((Long)processInstanceId)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"WorkFlowFormServiceHelper_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return null;
            }
            return processInstanceId;
        }
        catch (Exception e) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"WorkFlowFormServiceHelper_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return null;
        }
    }

    @KSMethod
    public static void viewFlowchartWithProcInstId(String pageId, OpenStyle style, Long procInstId) {
        WorkflowFormService.create().viewFlowchartWithProcInstId(pageId, style, procInstId);
    }

    @KSMethod
    public static void changeFlowChart(IFormView view, Long processInstanceId) {
        ViewFlowChartPermComponent permComponent = new ViewFlowChartPermComponent(view);
        if (!permComponent.processInstanceHasPerm(processInstanceId)) {
            String tips = ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u5bf9\u5e94\u6d41\u7a0b\u56fe\u7684\u6743\u9650", (String)"WorkflowViewFlowchartPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            view.showTipNotification(tips);
            return;
        }
        ChangeFlowChartComponent changeComponent = new ChangeFlowChartComponent(view, processInstanceId);
        changeComponent.changeFlowChart();
    }

    @KSMethod
    public static void openMessageCenterList(String pageId, String showType, Map<String, String> filterConditions) {
        if (WfUtils.isEmpty((String)showType) || WfUtils.isEmpty((String)pageId)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u5b58\u5728\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u7684\uff1apageId\u3001showType", (String)"WorkFlowFormServiceHelper_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"pageID\u9519\u8bef\u3002", (String)"WorkFlowFormServiceHelper_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", view);
        map.put("appmainnumber", "wf_msg_center");
        map.put("appname", AppMetadataCache.getAppInfo((String)"wftask").getName());
        HashMap<String, Object> customparameters = new HashMap<String, Object>(2);
        if ("toHandle".equals(showType) || "handled".equals(showType) || "toApply".equals(showType) || "applyed".equals(showType) || "delegateToHandle".equals(showType) || "transferToHandle".equals(showType) || "transferHandled".equals(showType) || "delegateHandled".equals(showType)) {
            customparameters.put("tabType", 1);
        } else if ("activity".equals(showType) || "message".equals(showType) || "warning".equals(showType) || "notice".equals(showType) || "alarm".equals(showType)) {
            customparameters.put("tabType", 2);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u9875\u7b7e\u7c7b\u578b\u4e0d\u5c5e\u4e8etask/message\uff0c\u8bf7\u68c0\u67e5", (String)"WorkFlowFormServiceHelper_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String openpage = showType + "-api";
        if (filterConditions != null && filterConditions.containsKey("schemeId")) {
            customparameters.put("filterSchemeId", filterConditions.get("schemeId"));
            openpage = openpage + "-" + filterConditions.get("schemeId");
        }
        customparameters.put("openPage", openpage);
        customparameters.put("billFormId", WorkFlowFormServiceHelper.getType(showType));
        if (filterConditions != null && filterConditions.containsKey("resoureId") && WfUtils.isNotEmpty((String)filterConditions.get("resoureId"))) {
            customparameters.put("messageId", Long.parseLong(filterConditions.get("resoureId")));
        }
        map.put("customparameters", customparameters);
        OpenPageUtils.openApp((String)"wftask", (String)"0011", map, (IFormView)view);
    }

    @KSMethod
    public static void openTaskAndMessageDetails(String pageId, String showType, Long resourceId) {
        if (WfUtils.isEmpty((Long)resourceId) || WfUtils.isEmpty((String)pageId) || WfUtils.isEmpty((String)showType)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u5b58\u5728\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u7684\uff1apageId\u3001tabType\u3001resourceId", (String)"WorkFlowFormServiceHelper_14", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"pageID\u9519\u8bef\u3002", (String)"WorkFlowFormServiceHelper_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> customparameters = new HashMap<String, Object>(2);
        if ("toHandle".equals(showType) || "handled".equals(showType)) {
            customparameters.put("tabType", 1);
        } else if ("activity".equals(showType) || "message".equals(showType) || "warning".equals(showType) || "notice".equals(showType) || "alarm".equals(showType)) {
            customparameters.put("tabType", 2);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"showType\u4e0d\u5c5e\u4e8e\u4efb\u52a1\u548c\u6d88\u606f\u5206\u7c7b\uff0c\u8bf7\u68c0\u67e5", (String)"WorkFlowFormServiceHelper_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String openpage = showType + "-api";
        customparameters.put("openPage", openpage);
        customparameters.put("billFormId", WorkFlowFormServiceHelper.getType(showType));
        customparameters.put("messageId", resourceId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", view);
        map.put("appmainnumber", "wf_msg_center");
        map.put("appname", AppMetadataCache.getAppInfo((String)"wftask").getName());
        map.put("customparameters", customparameters);
        OpenPageUtils.openApp((String)"wftask", (String)"0012", map, (IFormView)view);
    }

    private static String getType(String showType) {
        switch (showType) {
            case "toHandle": {
                return "wf_task";
            }
            case "handled": {
                return "wf_hitaskinst";
            }
            case "toApply": {
                return "wf_execution_tc";
            }
            case "applyed": {
                return "wf_hiprocinst";
            }
            case "transferToHandle": {
                return "transfer";
            }
            case "transferHandled": {
                return "transfer";
            }
            case "delegateToHandle": {
                return "delegate";
            }
            case "delegateHandled": {
                return "delegate";
            }
        }
        return showType;
    }

    @KSMethod
    public static void viewBillDetails(String pageId, String showType, Long resourceId) {
        if (WfUtils.isEmpty((Long)resourceId) || WfUtils.isEmpty((String)pageId) || WfUtils.isEmpty((String)showType)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u5b58\u5728\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u7684\uff1apageId\u3001tabType\u3001resourceId", (String)"WorkFlowFormServiceHelper_14", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"pageID\u9519\u8bef\u3002", (String)"WorkFlowFormServiceHelper_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> customparameters = new HashMap<String, Object>(2);
        if (!("toHandle".equals(showType) || "handled".equals(showType) || "toApply".equals(showType) || "applyed".equals(showType) || "delegateToHandle".equals(showType) || "transferToHandle".equals(showType) || "transferHandled".equals(showType) || "delegateHandled".equals(showType))) {
            view.showTipNotification(ResManager.loadKDString((String)"showType\u4e0d\u5c5e\u4e8e\u4efb\u52a1\u548c\u6d88\u606f\u5206\u7c7b\uff0c\u8bf7\u68c0\u67e5", (String)"WorkFlowFormServiceHelper_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        customparameters.put("tabType", 1);
        String openpage = showType + "-api-viewBill";
        customparameters.put("openPage", openpage);
        customparameters.put("billFormId", WorkFlowFormServiceHelper.getType(showType));
        customparameters.put("messageId", resourceId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", view);
        map.put("appmainnumber", "wf_msg_center");
        map.put("appname", AppMetadataCache.getAppInfo((String)"wftask").getName());
        map.put("customparameters", customparameters);
        OpenPageUtils.openApp((String)"wftask", (String)"0012", map, (IFormView)view);
    }
}

