/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.service.archive;

import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.ArchiveService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ArchiveRouteIndexCondition;
import kd.bos.workflow.service.archive.ArchiveFormService;

public class ArchiveFormServiceImpl
implements ArchiveFormService {
    private static Log logger = LogFactory.getLog(ArchiveFormServiceImpl.class);

    @Override
    public void injectArchiveRouteInfo(IFormView view) {
        try {
            String archiveRouteKey = null;
            IPageCache pageCache = view.getPageCache();
            if (WfUtils.isNotEmpty((String)pageCache.get("routeKey")) && WfUtils.isNotEmpty((String)pageCache.get("archiveRouteKey"))) {
                archiveRouteKey = pageCache.get("archiveRouteKey");
                ArchiveService archiveService = ArchiveService.create();
                archiveService.injectArchiveRouteInfo(archiveRouteKey);
            } else {
                FormShowParameter parameter = view.getFormShowParameter();
                String routeKey = (String)parameter.getCustomParam("routeKey");
                archiveRouteKey = (String)parameter.getCustomParam("archiveRouteKey");
                if (ArchiveFormServiceImpl.isArchiveRouteKeyNotEmpty(archiveRouteKey)) {
                    pageCache.put("routeKey", routeKey);
                    pageCache.put("archiveRouteKey", archiveRouteKey);
                    ArchiveService archiveService = ArchiveService.create();
                    archiveService.injectArchiveRouteInfo(archiveRouteKey);
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("inject_archiveRouteKey is error, %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    @Override
    public void injectArchiveRouteInfo(IFormView view, QueryBuilder queryBuilder) {
        try {
            String routeKey = null;
            String archiveRouteKey = null;
            if (queryBuilder != null) {
                routeKey = queryBuilder.getRouteKey();
                archiveRouteKey = queryBuilder.getAchiveKey();
            } else {
                IListView listView = (IListView)view;
                IListModel listModel = listView.getListModel();
                routeKey = listModel.getRouteKey();
                archiveRouteKey = listModel.getAchiveKey();
            }
            IPageCache pageCache = view.getPageCache();
            pageCache.put("routeKey", routeKey);
            pageCache.put("archiveRouteKey", archiveRouteKey);
            if (!ArchiveFormServiceImpl.isArchiveRouteKeyNotEmpty(archiveRouteKey)) {
                return;
            }
            ArchiveService archiveService = ArchiveService.create();
            archiveService.injectArchiveRouteInfo(archiveRouteKey);
            logger.debug(String.format("ArchiveHelper_injectArchiveRouteInfo success [%s][%s]", routeKey, archiveRouteKey));
        }
        catch (Exception e) {
            logger.error(String.format("inject_archiveRouteKey is error, %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    @Override
    public void injectArchiveRouteInfo(IFormView view, String archiveEntity, ArchiveRouteIndexCondition condition) {
        ArchiveService archiveService = ArchiveService.create();
        String archiveRouteKey = archiveService.injectArchiveRouteInfo(archiveEntity, condition);
        if (ArchiveFormServiceImpl.isArchiveRouteKeyNotEmpty(archiveRouteKey)) {
            IPageCache pageCache = view.getPageCache();
            pageCache.put("routeKey", WfUtils.WFS.getRouteKey());
            pageCache.put("archiveRouteKey", archiveRouteKey);
        }
    }

    @Override
    public void setArchiveRouteInfo(IFormView view, FormShowParameter parameter) {
        try {
            IPageCache pageCache = view.getPageCache();
            String routeKey = pageCache.get("routeKey");
            String archiveRouteKey = pageCache.get("archiveRouteKey");
            logger.debug(String.format("inject_archiveRouteKey_routeKey[%s]_archiveRoute[%s]", routeKey, archiveRouteKey));
            if (ArchiveFormServiceImpl.isArchiveRouteKeyNotEmpty(archiveRouteKey)) {
                parameter.setCustomParam("routeKey", (Object)routeKey);
                parameter.setCustomParam("archiveRouteKey", (Object)archiveRouteKey);
            }
        }
        catch (Exception e) {
            logger.error(String.format("set_archiveRouteKey is error, %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    @Override
    public boolean isArchiveDBInView(IFormView view) {
        boolean isArchiveDB = Boolean.FALSE;
        try {
            IPageCache pageCache = view.getPageCache();
            String archiveRouteKey = pageCache.get("archiveRouteKey");
            if (WfUtils.isEmpty((String)archiveRouteKey) && view instanceof IListView) {
                IListModel listModel = ((IListView)view).getListModel();
                archiveRouteKey = listModel.getAchiveKey();
            }
            if (ArchiveFormServiceImpl.isArchiveRouteKeyNotEmpty(archiveRouteKey)) {
                isArchiveDB = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            logger.error(String.format("isArchiveDBInView is error, %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return isArchiveDB;
    }

    private static boolean isArchiveRouteKeyNotEmpty(String archiveRouteKey) {
        return WfUtils.isNotEmpty((String)archiveRouteKey) && !DBRoute.workflow.getRouteKey().equalsIgnoreCase(archiveRouteKey) && !WfUtils.WFS.getRouteKey().equalsIgnoreCase(archiveRouteKey);
    }
}

