/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.service.separatestorage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.separatestorage.EntityMappingConvertFactory;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;
import kd.bos.workflow.service.separatestorage.SeparateStorageFormService;

public class SeparateStorageFormServiceImpl
implements SeparateStorageFormService {
    private static Log logger = LogFactory.getLog(SeparateStorageFormServiceImpl.class);

    @Override
    public boolean injectSeparateStorageKey(IFormView view, String entityNumber, Object focusRowPkId) {
        try {
            Object pkId = focusRowPkId;
            if (pkId == null && view instanceof IListView) {
                pkId = ((IListView)view).getFocusRowPkId();
            }
            if (pkId == null) {
                logger.debug("Focus row data pk id is null, cannot inject separate storage key.");
                return false;
            }
            String separateStorageKey = "";
            IPageCache pageCache = view.getPageCache();
            if (StringUtils.isNotBlank((CharSequence)pageCache.get("listDataSourceFlag"))) {
                Map sskPksMap;
                String listDataSourceFlag = pageCache.get("listDataSourceFlag");
                if ("-1".equals(listDataSourceFlag)) {
                    separateStorageKey = SeparateStorageType.ORIGINAL.getKey();
                } else if ("1".equals(listDataSourceFlag) && StringUtils.isNotBlank((CharSequence)pageCache.get("separateStorageKeyPksMapCacheKey")) && WfUtils.isNotEmptyForMap((Map)(sskPksMap = (Map)SerializationUtils.fromJsonString((String)pageCache.get("separateStorageKeyPksMapCacheKey"), Map.class)))) {
                    for (Map.Entry entry : sskPksMap.entrySet()) {
                        if (!WfUtils.isNotEmptyForCollection((Collection)((Collection)entry.getValue())) || !((List)entry.getValue()).contains(String.valueOf(pkId))) continue;
                        separateStorageKey = (String)entry.getKey();
                        break;
                    }
                    if ("".equals(separateStorageKey)) {
                        separateStorageKey = SeparateStorageType.ORIGINAL.getKey();
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)separateStorageKey)) {
                ThreadTruck.put((Object)"separateStorageKey", (Object)separateStorageKey);
                logger.debug(String.format("inject separateStorageKey success, separateStorageKey:[%s]", separateStorageKey));
                return true;
            }
            Map entityNumbers = EntityMappingConvertFactory.get().getAllConvertedEntityNumber(entityNumber);
            for (Map.Entry entry : entityNumbers.entrySet()) {
                if (!QueryServiceHelper.exists((String)((String)entry.getValue()), (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)})) continue;
                separateStorageKey = (String)entry.getKey();
                break;
            }
            if (StringUtils.isNotBlank((CharSequence)separateStorageKey)) {
                ThreadTruck.put((Object)"separateStorageKey", (Object)separateStorageKey);
                logger.debug(String.format("inject separateStorageKey success, separateStorageKey:[%s]", separateStorageKey));
                return true;
            }
        }
        catch (Exception e) {
            logger.error(String.format("inject separateStorageKey failed, %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return false;
    }

    @Override
    public boolean injectSeparateStorageKey(IFormView view, String entityNumber) {
        return this.injectSeparateStorageKey(view, entityNumber, null);
    }

    @Override
    public boolean injectSeparateStorageKey(IFormView view) {
        try {
            String separateStorageKey = "";
            IPageCache pageCache = view.getPageCache();
            if (StringUtils.isNotBlank((CharSequence)pageCache.get("separateStorageKey"))) {
                separateStorageKey = pageCache.get("separateStorageKey");
            } else {
                FormShowParameter parameter = view.getFormShowParameter();
                separateStorageKey = (String)parameter.getCustomParam("separateStorageKey");
            }
            if (StringUtils.isNotBlank((CharSequence)separateStorageKey)) {
                ThreadTruck.put((Object)"separateStorageKey", (Object)separateStorageKey);
                return true;
            }
        }
        catch (Exception e) {
            logger.error(String.format("inject separate storage key is error, %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return false;
    }

    @Override
    public void setSeparateStorageKey(FormShowParameter parameter) {
        try {
            String separateStorageKey = (String)ThreadTruck.get((Object)"separateStorageKey");
            if (SeparateStorageType.isExist((String)separateStorageKey)) {
                parameter.setCustomParam("separateStorageKey", (Object)separateStorageKey);
                logger.debug(String.format("set separateStorageKey success, key:[%s]", separateStorageKey));
            }
        }
        catch (Exception e) {
            logger.error(String.format("set separateStorageKey failed, %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    @Override
    public void putSeparateStorageKeyPksMapInPageCache(IFormView view, DynamicObjectCollection data) {
        if (view == null || data == null || data.size() == 0) {
            return;
        }
        IPageCache pageCache = view.getPageCache();
        if (data.size() > 0 && data.size() <= WfConfigurationUtil.getMaximumOfPksInPageCache()) {
            HashMap separateStorageKeyPksMap = new HashMap();
            boolean allOriginalFlag = true;
            for (DynamicObject d : data) {
                String separateStorageKey = d.getString("separateStorageKey");
                if (SeparateStorageType.ORIGINAL.getKey().equals(separateStorageKey)) continue;
                allOriginalFlag = false;
                Long id = d.getLong("id");
                List<String> ids = separateStorageKeyPksMap.get(separateStorageKey) == null ? new ArrayList() : (List)separateStorageKeyPksMap.get(separateStorageKey);
                ids.add(String.valueOf(id));
                separateStorageKeyPksMap.putIfAbsent(separateStorageKey, ids);
            }
            if (allOriginalFlag) {
                pageCache.put("listDataSourceFlag", "-1");
            } else {
                pageCache.put("listDataSourceFlag", "1");
                pageCache.put("separateStorageKeyPksMapCacheKey", SerializationUtils.toJsonString(separateStorageKeyPksMap));
            }
        }
    }

    @Override
    public void removeSeparateStorageKey() {
        ThreadTruck.remove((Object)"separateStorageKey");
    }
}

