/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.setting.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ExpressionExtEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ExpressionExtEntityImpl;

public class WfExpressionExtEditPlugin
extends AbstractWorkflowPlugin {
    private static final String CONTROLTYPE = "controltype";
    private static final String COMPARETYPE = "comparetype";
    private static final String VALUETYPE = "valuetype";
    private static final String VALUEENTITY = "valueentity";
    private static final String VALUECOMBOITEMS = "valuecomboitems";
    private static final String ENTITY = "entity";
    private static final String NAME = "name";
    private static final String PARSECLASS = "parseclass";
    private static final String ISPREINSDATA = "ispreinsdata";
    private static final String F7 = "F7";
    private static final String NUMBER = "number";
    private static final String ENUM = "enum";
    private static final String TEXT = "text";
    private static final String VALETYPE_STR = "String";
    private static final String VALETYPE_NUM = "Long";
    private static final String VALETYPE_DATE = "date";
    private static final String CONFIRM = "confirm";
    private static final String CANCEL = "cancel";
    private static final String SAVEPERMISSION = "0=KX5+QVF5+R";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM, CANCEL, PARSECLASS});
    }

    public void afterCreateNewData(EventObject evt) {
        Long pk;
        if (this.getView().getFormShowParameter().getCustomParam("pk") != null && WfUtils.isNotEmpty((Long)(pk = (Long)this.getView().getFormShowParameter().getCustomParam("pk")))) {
            this.getPageCache().put("pk", pk.toString());
            ExpressionExtEntity entity = (ExpressionExtEntity)this.getRepositoryService().findEntityById(pk, "wf_expressionext");
            if (entity != null) {
                this.getModel().setValue(ISPREINSDATA, (Object)entity.getIsPreinsData());
                this.getModel().setValue(ENTITY, this.getEntityPk(entity.getEntitynumber()));
                this.getModel().setValue(NAME, (Object)entity.getName());
                this.getModel().setValue(NUMBER, (Object)entity.getNumber());
                String controlType = entity.getControltype();
                this.getModel().setValue(CONTROLTYPE, (Object)controlType);
                if (F7.equals(controlType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{VALUEENTITY});
                    this.getModel().setValue(VALUEENTITY, this.getEntityPk(entity.getValueentitynumber()));
                } else if (ENUM.equals(controlType)) {
                    this.getModel().setValue(VALUECOMBOITEMS, (Object)entity.getValuecomboitems());
                    this.getView().setVisible(Boolean.TRUE, new String[]{VALUECOMBOITEMS});
                }
                this.getModel().setValue(COMPARETYPE, (Object)entity.getComparetype());
                this.getModel().setValue(VALUETYPE, (Object)entity.getValuetype());
                this.getModel().setValue(PARSECLASS, (Object)entity.getParseclass());
                if (!entity.getParseclass().contains("appid") || !entity.getParseclass().endsWith("}")) {
                    HashMap prop = new HashMap();
                    HashMap<String, Boolean> item = new HashMap<String, Boolean>();
                    item.put("showEditButton", false);
                    prop.put("item", item);
                    this.getView().updateControlMetadata(PARSECLASS, prop);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (CONFIRM.equalsIgnoreCase(key)) {
            String parseClass;
            String valueType;
            String number;
            DynamicObject o;
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_expressionext", (String)SAVEPERMISSION)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fdd\u5b58\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            ExpressionExtEntityImpl entity = new ExpressionExtEntityImpl();
            if (WfUtils.isNotEmpty((String)this.getPageCache().get("pk"))) {
                Long pk = Long.valueOf(this.getPageCache().get("pk"));
                entity = (ExpressionExtEntity)this.getRepositoryService().findEntityById(pk, "wf_expressionext");
            }
            if ((o = (DynamicObject)this.getModel().getValue(ENTITY)) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6269\u5c55\u5bf9\u8c61\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfExpressionExtEditPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            entity.setEntitynumber(o.getString(NUMBER));
            ILocaleString name = (ILocaleString)this.getModel().getValue(NAME);
            if (name != null && WfUtils.isNotEmpty((String)name.toString())) {
                entity.setName(name);
                number = (String)this.getModel().getValue(NUMBER);
                if (!WfUtils.isNotEmpty((String)number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"WfExpressionExtEditPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"WfExpressionExtEditPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (!number.startsWith("mc_")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u201c\u7f16\u7801\u201d\uff0c\u4ee5\u201cmc_\u201d\u5f00\u5934\u3002", (String)"WfExpressionExtEditPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            entity.setNumber(number);
            String controlType = (String)this.getModel().getValue(CONTROLTYPE);
            if (!WfUtils.isNotEmpty((String)controlType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd4\u56de\u503c\u4e3a\u7a7a\u3002", (String)"WfExpressionExtEditPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (F7.equals(controlType)) {
                DynamicObject d = (DynamicObject)this.getModel().getValue(VALUEENTITY);
                if (d == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u503c\u5b9e\u4f53\u4e3a\u7a7a\u3002", (String)"WfExpressionExtEditPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                entity.setValueentitynumber(d.getString(NUMBER));
            } else if (ENUM.equals(controlType)) {
                if (!WfUtils.isNotEmptyString((Object)this.getModel().getValue(VALUECOMBOITEMS))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u7ed3\u679c\u96c6\u4e3a\u7a7a\u3002", (String)"WfExpressionExtEditPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                entity.setValuecomboitems(this.getModel().getValue(VALUECOMBOITEMS).toString());
            }
            entity.setControltype(controlType);
            String compareType = (String)this.getModel().getValue(COMPARETYPE);
            if (WfUtils.isNotEmpty((String)compareType)) {
                entity.setComparetype(compareType);
            }
            if (WfUtils.isNotEmpty((String)(valueType = (String)this.getModel().getValue(VALUETYPE)))) {
                if (valueType.equals(VALETYPE_NUM)) {
                    entity.setHasquotes(false);
                } else {
                    entity.setHasquotes(true);
                }
                entity.setValuetype(valueType);
            }
            if (!WfUtils.isNotEmpty((String)(parseClass = (String)this.getModel().getValue(PARSECLASS)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u89e3\u6790\u7c7b\u4e3a\u7a7a\u3002", (String)"WfExpressionExtEditPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            entity.setParseclass(parseClass);
            Long id = entity.getId();
            Entity e = this.getRepositoryService().saveOrUpdateEntity((Entity)entity);
            String objName = o.getString(NAME);
            if (WfUtils.isNotEmpty((Long)id)) {
                WfUtils.addOpLog((String)"wf_expressionext", (String)"update", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fee\u6539\u6269\u5c55\u5bf9\u8c61", "WfExpressionExtEditPlugin_10", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fee\u6539 %1$s \u7684\u6269\u5c55\u5bf9\u8c61\uff1a%2$s ", "WfExpressionExtEditPlugin_11", "bos-wf-formplugin"), (Object[])new Object[]{objName, name});
            } else {
                WfUtils.addOpLog((String)"wf_expressionext", (String)"createnew", (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e\u6269\u5c55\u5bf9\u8c61", "WfExpressionExtEditPlugin_12", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e %1$s \u7684\u6269\u5c55\u5bf9\u8c61\uff1a%2$s ", "WfExpressionExtEditPlugin_13", "bos-wf-formplugin"), (Object[])new Object[]{objName, name});
            }
            WfCacheHelper.removeAllExtExpressionProps();
            this.getView().close();
            return;
        }
        if (CANCEL.equals(key)) {
            this.getView().close();
            return;
        }
        if (!PARSECLASS.equals(key)) return;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("evt_pluginconfig");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("class", this.getModel().getValue(PARSECLASS));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "configPluginCloseCallBack"));
        this.getView().showForm(parameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (CONTROLTYPE.equals(propertyName)) {
            String controlType = this.getModel().getValue(propertyName).toString();
            this.getModel().setValue(VALUECOMBOITEMS, (Object)"");
            this.getModel().setValue(VALUEENTITY, (Object)"");
            if (WfUtils.isEmpty((String)controlType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{VALUEENTITY});
                this.getView().setVisible(Boolean.FALSE, new String[]{VALUECOMBOITEMS});
                this.getModel().setValue(COMPARETYPE, (Object)"");
                this.getModel().setValue(VALUETYPE, (Object)"");
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{VALUEENTITY});
                this.getView().setVisible(Boolean.FALSE, new String[]{VALUECOMBOITEMS});
                if (F7.equals(controlType)) {
                    this.getModel().setValue(COMPARETYPE, (Object)F7);
                    this.getView().setVisible(Boolean.TRUE, new String[]{VALUEENTITY});
                } else if (NUMBER.equals(controlType)) {
                    this.getModel().setValue(VALUETYPE, (Object)VALETYPE_NUM);
                    this.getModel().setValue(COMPARETYPE, (Object)NUMBER);
                } else if (ENUM.equals(controlType)) {
                    this.getModel().setValue(VALUETYPE, (Object)VALETYPE_STR);
                    this.getModel().setValue(COMPARETYPE, (Object)TEXT);
                    this.getView().setVisible(Boolean.TRUE, new String[]{VALUECOMBOITEMS});
                } else {
                    if (VALETYPE_DATE.equals(controlType)) {
                        this.getModel().setValue(VALUETYPE, (Object)VALETYPE_DATE);
                    } else {
                        this.getModel().setValue(VALUETYPE, (Object)VALETYPE_STR);
                    }
                    this.getModel().setValue(COMPARETYPE, (Object)controlType);
                }
            }
        } else if (VALUEENTITY.equals(propertyName)) {
            DynamicObject valueEntity = (DynamicObject)this.getModel().getValue(propertyName);
            if (valueEntity == null) {
                this.getModel().setValue(VALUETYPE, (Object)"");
            } else {
                Class clazz = valueEntity.getDataEntityType().getPrimaryKey().getPropertyType();
                if (clazz == Long.TYPE) {
                    this.getModel().setValue(VALUETYPE, (Object)VALETYPE_NUM);
                } else {
                    this.getModel().setValue(VALUETYPE, (Object)VALETYPE_STR);
                }
            }
        } else if (NUMBER.equals(propertyName)) {
            String number = this.getModel().getValue(propertyName).toString();
            if (WfUtils.isEmpty((String)this.getPageCache().get("pk")) && WfUtils.isNotEmpty((String)number) && this.getRepositoryService().findExpressionExtEntityByNumber(number) != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u91cd\u590d\u4f7f\u7528\u3002", (String)"WfExpressionExtEditPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), number), Integer.valueOf(3000));
                this.getModel().setValue(NUMBER, (Object)"");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map map;
        if ("configPluginCloseCallBack".equals(event.getActionId()) && (map = (Map)event.getReturnData()) != null) {
            this.getModel().setValue(PARSECLASS, (Object)map.toString());
        }
    }

    private Object getEntityPk(String entityNumber) {
        String fields = "id,name";
        QFilter filter = new QFilter(NUMBER, "=", (Object)entityNumber);
        QFilter[] qFilters = new QFilter[]{filter};
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"bos_entitymeta", (String)fields, (QFilter[])qFilters);
        if (dynObjs != null && dynObjs.length == 1) {
            return dynObjs[0].get("id");
        }
        return null;
    }
}

