/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.setting.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Optional;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowListPlugin;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.persistence.entity.design.ExpressionExtEntity;
import kd.bos.workflow.exception.WFErrorCode;

public class WfExpressionExtPlugin
extends AbstractWorkflowListPlugin
implements ClickListener,
IConfirmCallBack {
    private static final String CREATENEW = "createnew";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    protected static final String PK = "pk";
    private static final String DELETE_CALL_BACK = "deleteCallback";
    private static final String EDIT_PAGE = "wf_expressionext_edit";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ExtListDataProviderImpl());
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        try {
            ListSelectedRow selectedRow = null;
            switch (key) {
                case "createnew": {
                    if (!this.hasPermission("47156aff000000ac", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5bf9\u8c61\u6269\u5c55\u5c5e\u6027\u201d\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"WfExpressionExtPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]))) break;
                    this.showForm(this.getShowParameter(CREATENEW, EDIT_PAGE));
                    break;
                }
                case "update": {
                    if (!this.hasPermission("4715a0df000000ac", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5bf9\u8c61\u6269\u5c55\u5c5e\u6027\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"WfExpressionExtPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]))) break;
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    selectedRow = this.getSelectedRow();
                    if (selectedRow != null) {
                        m.put(PK, selectedRow.getPrimaryKeyValue());
                        this.showForm(this.getShowParameter(UPDATE, EDIT_PAGE, m));
                    }
                    break;
                }
                case "delete": {
                    if (!this.hasPermission("4715e1f1000000ac", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5bf9\u8c61\u6269\u5c55\u5c5e\u6027\u201d\u7684\u201c\u5220\u9664\u201d\u7684\u6743\u9650\u3002", (String)"WfExpressionExtPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0])) || (selectedRow = this.getSelectedRow()) == null) break;
                    Long id = (Long)selectedRow.getPrimaryKeyValue();
                    ExpressionExtEntity entity = (ExpressionExtEntity)this.getRepositoryService().findEntityById(id, "wf_expressionext", "ispreinsdata");
                    if (entity != null) {
                        if (entity.getIsPreinsData()) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WfExpressionExtPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u53ef\u80fd\u4f1a\u5bf9\u6d41\u7a0b\u9020\u6210\u5f71\u54cd\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5417\uff1f", (String)"WfExpressionExtPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_CALL_BACK));
                        break;
                    }
                    ((ListView)this.getView()).refresh();
                    break;
                }
            }
        }
        catch (KDException e) {
            if (WFErrorCode.workflowEngineNotConfiguration().equals((Object)e.getErrorCode())) {
                this.getView().showMessage(e.getMessage());
            }
            throw e;
        }
    }

    private boolean hasPermission(String permItemId, String message) {
        boolean hasSpecificPerm = true;
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_expressionext", (String)permItemId)) {
            this.getView().showTipNotification(message);
            hasSpecificPerm = false;
        }
        return hasSpecificPerm;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (DELETE_CALL_BACK.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            Long id = (Long)this.getSelectedRow().getPrimaryKeyValue();
            QFilter f = new QFilter("id", "=", (Object)id);
            DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"wf_expressionext", (String)"name,number", (QFilter[])new QFilter[]{f});
            if (dyo.length == 1) {
                this.getRepositoryService().deleteEntity(id, "wf_expressionext");
                WfUtils.addOpLog((String)"wf_expressionext", (String)DELETE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664\u6269\u5c55\u5bf9\u8c61", "WfExpressionExtPlugin_6", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664 \u6269\u5c55\u5bf9\u8c61\uff1a%1$s [%2$s]", "WfExpressionExtPlugin_7", "bos-wf-formplugin"), (Object[])new Object[]{dyo[0].get("name"), dyo[0].get("number")});
                WfCacheHelper.removeAllExtExpressionProps();
                ((ListView)this.getView()).refresh();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u672a\u627e\u5230\u3002", (String)"WfExpressionExtPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListView view = (ListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    public ListSelectedRow getSelectedRow() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() == 0 || rows.size() > 1) {
            Integer integer = Optional.ofNullable(rows).map(ArrayList::size).orElseGet(() -> 0);
            StandardTips.view((IFormView)this.getView()).selectMultiRow(integer.intValue());
            return null;
        }
        return rows.get(0);
    }

    public void afterCreateNewData(EventObject e) {
        PluginUtil.setControlInvisible(this.getView(), "exit");
    }

    private static class ExtListDataProviderImpl
    extends ListDataProvider {
        private QueryResult queryResult = null;

        private ExtListDataProviderImpl() {
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            this.addQFilters(new QFilter("entitynumber", "!=", (Object)"process").and(new QFilter("type", "!=", (Object)"function")));
            this.queryResult = new QueryResult();
            this.queryResult.setDataCount(this.getRealCount());
            return super.getData(start, limit);
        }

        public int getRealCount() {
            QFilter[] f = this.getQueryBuilder().getFilters();
            int length = 2;
            if (f != null && f.length > 0) {
                length += f.length;
            }
            QFilter[] fnew = new QFilter[length];
            fnew[0] = new QFilter("entitynumber", "!=", (Object)"process");
            fnew[1] = new QFilter("type", "!=", (Object)"function");
            if (f != null && f.length > 0) {
                for (int i = 2; i < length; ++i) {
                    fnew[i] = f[i - 2];
                }
            }
            this.getQueryBuilder().setFilters(fnew);
            return super.getRealCount();
        }
    }
}

