/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class AddSignNamePlugin
extends AbstractWorkflowPlugin
implements ClickListener {
    private static final String BTNCONFIRM = "confirm";
    private static final String NODENAME = "nodename";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNCONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        int i;
        int nodeNum = Integer.parseInt((String)this.getView().getFormShowParameter().getCustomParam("nodenum"));
        LocaleString addSignName = WfConfigurationUtil.getAddSignNameLocaleString();
        for (i = 1; i <= nodeNum; ++i) {
            this.getModel().setValue(NODENAME + i, (Object)addSignName);
        }
        for (i = nodeNum + 1; i <= 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{NODENAME + i});
        }
        String nodeNames = (String)this.getView().getFormShowParameter().getCustomParam("nodenames");
        if (WfUtils.isNotEmpty((String)nodeNames)) {
            List lists = (List)SerializationUtils.fromJsonString((String)nodeNames, List.class);
            for (int i2 = 0; i2 < lists.size(); ++i2) {
                LinkedHashMap list = (LinkedHashMap)lists.get(i2);
                LocaleString value = new LocaleString();
                if (WfUtils.isNotEmptyForMap((Map)list)) {
                    value = LocaleString.fromMap((Map)list);
                }
                this.getModel().setValue(NODENAME + (i2 + 1), (Object)value);
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (BTNCONFIRM.equals(key)) {
            this.comfirm();
        }
    }

    private void comfirm() {
        int nodeNum = Integer.parseInt((String)this.getView().getFormShowParameter().getCustomParam("nodenum"));
        ArrayList<LocaleString> nodeNames = new ArrayList<LocaleString>(nodeNum);
        for (int i = 1; i <= nodeNum; ++i) {
            OrmLocaleValue value = (OrmLocaleValue)this.getModel().getValue(NODENAME + i);
            if (value == null || WfUtils.isEmpty((ILocaleString)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8282\u70b9\u540d\u79f0\u201d\u3002", (String)"AddSignNamePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            LocaleString localeString = new LocaleString();
            if (WfUtils.isNotEmptyForMap((Map)value)) {
                localeString = LocaleString.fromMap((Map)value);
            }
            nodeNames.add(localeString);
        }
        this.getView().returnDataToParent(nodeNames);
        this.getView().close();
    }
}

