/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.UserEdit;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.persistence.IDynamicResourceItem;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.quantitysum.LocalVariables;
import kd.bos.workflow.engine.task.Task;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeAddSignAddUserCustomEvent;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeAddSignConfirmCustomEvent;

public class AddSignPagePlugin
extends AbstractWorkflowPlugin
implements ClickListener {
    private static final String BOS_WF_FORMPLUGIN = "bos-wf-formplugin";
    private static final String CARDENTRYFIXROWAP = "cardentryfixrowap";
    private static final String FLEXPANELAP5 = "flexpanelap5";
    private static final String BTNOK = "confirm";
    private static final String DEALTYPEPANEL = "dealtypepanel";
    private static final String YZJTYPEPANEL = "yzjtypepanel";
    private static final String FLEXADDUSER = "flex_adduser";
    private static final String ADDUSER = "adduser";
    private static final String CLEAR = "clear";
    private static final String ADDSIGNBEFORECAllBACK = "addSignBeforeCallBack";
    private static final String ADDSIGNAFTERCAllBACK = "addSignAfterCallBack";
    private static final String ADDSIGNCLEARCALLBACK = "addSignClearCallBack";
    private static final String EDITADDSIGNNAMECALLBACK = "editAddSignNameCallBack";
    private static final String USERID = "userid";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ADDUSERCALLBACK = "addUserCallBack";
    private static final char FLAG = ':';
    private static final String ARROW = "arrow";
    private static final int ONE = 1;
    private static final String ADDSIGNNAME = "addsignname";
    private static final String ADDSIGNNAME_SINGLE = "addsignname1";
    private static final String ADDDIGNNAMEICON = "addsignnameicon";
    private static final String NODENAMES = "nodenames";
    private static final String ONLYONEUSER = "onlyoneuser";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, FLEXADDUSER, ADDUSER, CLEAR, ADDSIGNNAME, ADDDIGNNAMEICON});
    }

    public void afterCreateNewData(EventObject e) {
        Long taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskid"));
        List iDynamicResourceItems = DynProcessProcessorHelper.getDynamicResourceItem((Long)taskId, (String)"addsignafter");
        if (iDynamicResourceItems != null && !iDynamicResourceItems.isEmpty()) {
            AddSignInfo addSignInfo = this.convertContentToAddSignInfo((IDynamicResourceItem)iDynamicResourceItems.get(0));
            if (addSignInfo != null) {
                List nodeNames;
                Map addSiggMsgMap = addSignInfo.getAddSingMsg();
                LocaleString addSignMsg = new LocaleString();
                for (Map.Entry entry : addSiggMsgMap.entrySet()) {
                    addSignMsg.put(entry.getKey(), (Object)this.getAddSignMsgByKey(addSiggMsgMap, (String)entry.getKey()));
                }
                this.getModel().setValue("addsignmsg", (Object)addSignMsg);
                if ("addsignbefore".equals(addSignInfo.getAddSignType())) {
                    this.getModel().setValue("addsigntype", (Object)1);
                    this.getView().setVisible(Boolean.FALSE, new String[]{CLEAR});
                } else {
                    this.getModel().setValue("addsigntype", (Object)2);
                }
                this.getModel().setValue("allowaddsign", (Object)addSignInfo.getAllowAddSign());
                if ("anyone".equals(addSignInfo.getAddSignDealType())) {
                    this.getModel().setValue("addsigndealtype", (Object)1);
                } else if ("seq".equals(addSignInfo.getAddSignDealType())) {
                    this.getModel().setValue("addsigndealtype", (Object)2);
                } else if ("yzj".equals(addSignInfo.getAddSignDealType())) {
                    this.getModel().setValue("addsigndealtype", (Object)3);
                }
                this.updateEntryentityData(addSignInfo.getUserIds());
                if ("passByOne".equals(addSignInfo.getYzjType())) {
                    this.getModel().setValue("yzjtype", (Object)1);
                } else {
                    this.getModel().setValue("yzjtype", (Object)2);
                }
                if ("yzj".equals(addSignInfo.getAddSignDealType())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{YZJTYPEPANEL});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{YZJTYPEPANEL});
                }
                if (addSignInfo.getUserIds().size() == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{DEALTYPEPANEL});
                    this.getView().setVisible(Boolean.FALSE, new String[]{YZJTYPEPANEL});
                }
                if ((nodeNames = addSignInfo.getNodeNames()) != null && !nodeNames.isEmpty()) {
                    this.getPageCache().put(NODENAMES, SerializationUtils.toJsonString((Object)nodeNames));
                    StringBuilder nodeNameStr = new StringBuilder();
                    for (LocaleString nodeName : nodeNames) {
                        nodeNameStr.append(nodeName.getLocaleValue()).append(", ");
                    }
                    this.getModel().setValue(ADDSIGNNAME, (Object)nodeNameStr.substring(0, nodeNameStr.length() - 2));
                    this.getModel().setValue(ADDSIGNNAME_SINGLE, (Object)((LocaleString)nodeNames.get(0)).getLocaleValue());
                }
                if ("2".equals((String)this.getModel().getValue("addsigndealtype"))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ADDSIGNNAME});
                    if ("mobile".equals(this.getDevice())) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP5});
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{ADDSIGNNAME_SINGLE});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{ADDSIGNNAME});
                    if ("mobile".equals(this.getDevice())) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP5});
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{ADDSIGNNAME_SINGLE});
                }
                boolean onlyOneUser = Boolean.parseBoolean(this.getPageCache().get(ONLYONEUSER));
                if (onlyOneUser) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{CARDENTRYFIXROWAP});
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEXADDUSER});
                }
            }
        } else {
            Task task = this.getTaskService().getTask(taskId);
            if (BpmnModelUtil.instanceofYunzhijiaTask((String)task.getCategory())) {
                this.buildAddSignType();
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{DEALTYPEPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{YZJTYPEPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{CLEAR});
            LocaleString addSignName = WfConfigurationUtil.getAddSignNameLocaleString();
            this.getModel().setValue(ADDSIGNNAME_SINGLE, (Object)addSignName);
            this.getModel().setValue(ADDSIGNNAME, (Object)addSignName.getLocaleValue());
        }
    }

    private void buildAddSignType() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("addsigntype");
        ComboItem comboItem = new ComboItem();
        comboItem.setId("1");
        comboItem.setValue("1");
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u524d\u52a0\u7b7e", (String)"AddSignPagePlugin_16", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0])));
        comboEdit.setComboItems((List)Lists.newArrayList((Object[])new ComboItem[]{comboItem}));
    }

    private AddSignInfo convertContentToAddSignInfo(IDynamicResourceItem iDynamicResourceItem) {
        ILocaleString content = iDynamicResourceItem.getContent();
        String contentStr = null;
        if (WfUtils.isNotEmpty((ILocaleString)content)) {
            contentStr = content.getLocaleValue();
        }
        if (WfUtils.isEmpty(contentStr)) {
            Set set = content.keySet();
            for (String key : set) {
                contentStr = (String)content.get((Object)key);
                if (!WfUtils.isNotEmpty((ILocaleString)content)) continue;
                break;
            }
        }
        BpmnModel dynBpmnModel = ProcessDefinitionUtil.getBpmnModel((String)contentStr);
        List flowElementList = dynBpmnModel.getMainProcess().getFlowElementList();
        ArrayList<FlowElement> addSignElements = new ArrayList<FlowElement>();
        for (FlowElement flowElement : flowElementList) {
            if (flowElement instanceof AuditTask && ((AuditTask)flowElement).isAddSign()) {
                addSignElements.add(flowElement);
            }
            if (!(flowElement instanceof SequenceFlow)) continue;
            break;
        }
        if (addSignElements.isEmpty()) {
            return null;
        }
        List<Long> userIds = this.getParticipants(addSignElements);
        boolean allowAddSign = ((AuditTask)addSignElements.get(0)).isCountersigned();
        String addSignType = iDynamicResourceItem.getType();
        Map<String, String> addSingMsg = this.getAddSignMsg(addSignElements);
        String addSignDealType = this.getAddSignDealType(addSignElements, userIds);
        String yzjType = this.getYzjType(addSignElements);
        List<LocaleString> nodeNames = this.getNodeNames(content);
        AddSignInfo addSignInfo = new AddSignInfo();
        addSignInfo.setUserIds(userIds);
        addSignInfo.setAllowAddSign(Boolean.valueOf(allowAddSign));
        addSignInfo.setAddSignDealType(addSignDealType);
        addSignInfo.setAddSignType(addSignType);
        addSignInfo.setAddSingMsg(addSingMsg);
        addSignInfo.setYzjType(yzjType);
        addSignInfo.setNodeNames(nodeNames);
        return addSignInfo;
    }

    private List<LocaleString> getNodeNames(ILocaleString content) {
        ArrayList<LocaleString> nodeNames = new ArrayList<LocaleString>();
        BpmnModel zhBpmnModel = ProcessDefinitionUtil.getBpmnModel((String)content.getLocaleValue_zh_CN());
        List flowElements = zhBpmnModel.getMainProcess().getFlowElementList();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (flowElement instanceof AuditTask && ((AuditTask)flowElement).isAddSign()) {
                LocaleString name = new LocaleString();
                for (Lang lang : WfUtils.getSupportLangs()) {
                    String key = lang.name();
                    String value = "";
                    if (Lang.zh_CN.name().equalsIgnoreCase(key)) {
                        value = flowElement.getName();
                    } else {
                        BpmnModel model = ProcessDefinitionUtil.getBpmnModel((String)((String)content.get((Object)key)));
                        value = ((FlowElement)model.getMainProcess().getFlowElementList().get(i)).getName();
                    }
                    name.setItem(lang.name(), (Object)value);
                }
                nodeNames.add(name);
            }
            if (flowElement instanceof SequenceFlow) break;
        }
        return nodeNames;
    }

    private String getYzjType(List<FlowElement> addSignElements) {
        if (addSignElements.get(0) instanceof YunzhijiaTask) {
            YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)addSignElements.get(0);
            return yunzhijiaTask.getBusinessModel();
        }
        return "passByOne";
    }

    private String getAddSignDealType(List<FlowElement> addSignElements, List<Long> userIds) {
        if (addSignElements.size() > 1) {
            return "seq";
        }
        if (addSignElements.get(0) instanceof YunzhijiaTask) {
            return "yzj";
        }
        if (userIds.size() == 1) {
            return "one";
        }
        return "anyone";
    }

    private Map<String, String> getAddSignMsg(List<FlowElement> addSignElements) {
        AuditTask auditTask = (AuditTask)addSignElements.get(0);
        return auditTask.getAddSignMsg();
    }

    private List<Long> getParticipants(List<FlowElement> addSignElements) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (FlowElement addSignElement : addSignElements) {
            AuditTask auditTask = (AuditTask)addSignElement;
            ParticipatantModel participatantModel = auditTask.getParticipant();
            List participants = participatantModel.getParticipant();
            for (ParticipantModelEntityImpl participant : participants) {
                if (!"person".equals(participant.getType()) || !WfUtils.isNotEmpty((String)participant.getValue())) continue;
                userIds.add(Long.valueOf(participant.getValue()));
            }
        }
        return userIds;
    }

    private String getAddSignMsgByKey(Map<String, String> addSiggMsgMap, String lang) {
        String value = addSiggMsgMap.get(lang);
        if (WfUtils.isEmpty((String)value)) {
            return "";
        }
        return value.substring(value.indexOf(58) + 1, value.length());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        String name = e.getProperty().getName();
        String addSignDealType = (String)this.getModel().getValue("addsigndealtype");
        if ("addsigntype".equals(name)) {
            String addSignType = (String)this.getModel().getValue("addsigntype");
            if ("1".equals(addSignType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CLEAR});
            } else if ("2".equals(addSignType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CLEAR});
            }
        } else if ("addsigndealtype".equals(name)) {
            if ("3".equals(addSignDealType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{YZJTYPEPANEL});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{YZJTYPEPANEL});
            }
            this.hideOrShowArrows();
        } else if (ADDSIGNNAME.equals(name) && WfUtils.isEmpty((String)(value = (String)this.getModel().getValue(ADDSIGNNAME)))) {
            this.getPageCache().remove(NODENAMES);
        }
        DynamicObjectCollection existUser = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        if (existUser != null && existUser.size() > 1 && "2".equals(addSignDealType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ADDSIGNNAME});
            if ("mobile".equals(this.getDevice())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP5});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{ADDSIGNNAME_SINGLE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADDSIGNNAME});
            if ("mobile".equals(this.getDevice())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP5});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{ADDSIGNNAME_SINGLE});
        }
    }

    private void hideOrShowArrows() {
        String addSignDealType = (String)this.getModel().getValue("addsigndealtype");
        boolean show = "2".equals(addSignDealType);
        DynamicObjectCollection userObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        if (userObjects != null && !userObjects.isEmpty()) {
            if (userObjects.size() == 1) {
                show = false;
            }
            CardEntry grid = (CardEntry)this.getControl(ENTRYENTITY);
            for (int i = 0; i < userObjects.size(); ++i) {
                if (i == userObjects.size() - 1) {
                    grid.setChildVisible(false, i, new String[]{ARROW});
                    continue;
                }
                grid.setChildVisible(show, i, new String[]{ARROW});
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "confirm": {
                this.comfirm();
                break;
            }
            case "flex_adduser": 
            case "adduser": {
                this.addSignUser();
                break;
            }
            case "clear": {
                this.clearPageInfo();
                break;
            }
            case "addsignname": {
                this.editAddSignNameForPC();
                break;
            }
            case "addsignnameicon": {
                this.editAddSignNameForMobile();
                break;
            }
        }
    }

    private void editAddSignNameForPC() {
        String nodeNum = this.beforeEditAddSignName();
        if (nodeNum != null) {
            MobileFormShowParameter parameter = new MobileFormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("wf_addsignname");
            parameter.setCustomParam("nodenum", (Object)nodeNum);
            parameter.setCustomParam(NODENAMES, (Object)this.getPageCache().get(NODENAMES));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDITADDSIGNNAMECALLBACK));
            this.showForm((FormShowParameter)parameter);
        }
    }

    private void editAddSignNameForMobile() {
        String nodeNum = this.beforeEditAddSignName();
        if (nodeNum != null) {
            MobileFormShowParameter parameter = new MobileFormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            parameter.setCaption(WFMultiLangConstants.getTitleAddSign());
            parameter.setFormId("wf_addsignnamemobile");
            parameter.setCustomParam("nodenum", (Object)String.valueOf(nodeNum));
            parameter.setCustomParam(NODENAMES, (Object)this.getPageCache().get(NODENAMES));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDITADDSIGNNAMECALLBACK));
            this.showForm((FormShowParameter)parameter);
        }
    }

    private String beforeEditAddSignName() {
        DynamicObjectCollection userObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        if (userObjects == null || userObjects.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u52a0\u7b7e\u4eba\u3002", (String)"AddSignPagePlugin_12", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        String addSignDealTypeValue = (String)this.getModel().getValue("addsigndealtype");
        String nodeNum = userObjects.size() > 1 && "2".equals(addSignDealTypeValue) ? String.valueOf(userObjects.size()) : "1";
        if (Integer.parseInt(nodeNum) > 10) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6700\u5927\u503c\u4e3a10\u4e2a\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AddSignPagePlugin_13", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        return nodeNum;
    }

    private void clearPageInfo() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8282\u70b9\u540e\u52a0\u7b7e\u7684\u5185\u5bb9\u5417\uff1f", (String)"AddSignPagePlugin_0", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ADDSIGNCLEARCALLBACK));
    }

    private void addSignUser() {
        String device = this.getDevice();
        if ("mobile".equals(device)) {
            DynamicObjectCollection userObjects;
            boolean onlyOneUser = Boolean.parseBoolean(this.getPageCache().get(ONLYONEUSER));
            if (onlyOneUser && (userObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY)) != null && userObjects.size() == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u52a0\u7b7e\u8bf4\u660e\u201d\u3002", (String)"AddSignPagePlugin_9", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.addUserForMobile();
        } else {
            this.addUserForPC();
        }
    }

    private void addUserForPC() {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setBillFormId("bos_user");
        para.setShowTitle(false);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        boolean onlyOneUser = Boolean.parseBoolean(this.getPageCache().get(ONLYONEUSER));
        if (onlyOneUser) {
            para.setMultiSelect(false);
        } else {
            para.setMultiSelect(true);
        }
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDUSERCALLBACK));
        para.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u52a0\u7b7e\u4eba", (String)"AddSignPagePlugin_1", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        List<QFilter> qFilters = new ArrayList<QFilter>();
        BeforeAddSignAddUserCustomEvent args = this.beforeAddUserCustomEvent(qFilters);
        qFilters = args.getQFilters();
        if (!qFilters.isEmpty()) {
            para.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        qFilters.add(qFilter);
        listFilterParameter.setQFilters(qFilters);
        para.setListFilterParameter(listFilterParameter);
        para.setFormId("bos_usertreelistf7");
        para.setCustomParam("externalUserType", (Object)"all");
        para.setShowFrequent(true);
        this.showForm((FormShowParameter)para);
    }

    private void addUserForMobile() {
        UserEdit userEdit = (UserEdit)this.getView().getControl("userf7control");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADDUSERCALLBACK);
        userEdit.addDataSelectEventListener(dataSelectEvent -> {
            dataSelectEvent.setCloseCallBack(closeCallBack);
            boolean onlyOneUser = Boolean.parseBoolean(this.getPageCache().get(ONLYONEUSER));
            if (onlyOneUser) {
                dataSelectEvent.setMultiple(false);
            } else {
                dataSelectEvent.setMultiple(true);
            }
        });
        BeforeAddSignAddUserCustomEvent args = this.beforeAddUserCustomEvent(new ArrayList<QFilter>());
        userEdit.setQFilters(args.getQFilters());
        userEdit.showDataSelect();
        userEdit.setShowFrequent(true);
    }

    private BeforeAddSignAddUserCustomEvent beforeAddUserCustomEvent(List<QFilter> qFilters) {
        BeforeAddSignAddUserCustomEvent args = new BeforeAddSignAddUserCustomEvent(this.getView(), "selectAddSignUserIsolation", "addSignselectUser", null, qFilters);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
        return args;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if (ADDUSERCALLBACK.equals(e.getActionId())) {
            this.addSignUserCallBack(e);
        } else if (EDITADDSIGNNAMECALLBACK.equals(e.getActionId())) {
            List returnData = (List)e.getReturnData();
            StringBuilder nodeNames = new StringBuilder();
            for (LocaleString nodeName : returnData) {
                String currentNodeName = (String)nodeName.get((Object)RequestContext.get().getLang().name());
                if (WfUtils.isEmpty((String)currentNodeName)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddSignPagePlugin_11", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
                    this.getModel().setValue(ADDSIGNNAME, (Object)"");
                    return;
                }
                nodeNames.append((String)nodeName.get((Object)RequestContext.get().getLang().name())).append(", ");
            }
            this.getModel().setValue(ADDSIGNNAME, (Object)nodeNames.substring(0, nodeNames.length() - 2));
            this.getPageCache().put(NODENAMES, SerializationUtils.toJsonString((Object)returnData));
        }
    }

    private void addSignUserCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (!(returnData instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)e.getReturnData();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        DynamicObjectCollection existUserDynamicObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        ArrayList<Long> existUserIds = new ArrayList<Long>();
        if (existUserDynamicObjects != null && !existUserDynamicObjects.isEmpty()) {
            for (DynamicObject userInfo : existUserDynamicObjects) {
                Long userId = userInfo.getLong(USERID);
                if (existUserIds.contains(userId)) continue;
                existUserIds.add(userId);
            }
        }
        ArrayList<Long> excludeUserIds = new ArrayList<Long>();
        Long concurrentUserId = Long.valueOf(RequestContext.get().getUserId());
        excludeUserIds.add(concurrentUserId);
        HashSet<Long> excludes = new HashSet<Long>();
        HashSet<Long> userIds = new HashSet<Long>();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long userId = (Long)listSelectedRow.getPrimaryKeyValue();
            if (excludeUserIds.contains(userId)) {
                excludes.add(userId);
                continue;
            }
            if (existUserIds.contains(userId)) continue;
            userIds.add(userId);
        }
        this.updateEntryentityData(userIds);
        if (userIds.size() + existUserIds.size() > 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{DEALTYPEPANEL});
            String addSignDealTypeValue = (String)this.getModel().getValue("addsigndealtype");
            if ("3".equals(addSignDealTypeValue)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{YZJTYPEPANEL});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{DEALTYPEPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{YZJTYPEPANEL});
        }
        if (!excludes.isEmpty()) {
            String userNames = WfUtils.getUsersName(new ArrayList(excludes));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u201c%s\u201d\u4f5c\u4e3a\u52a0\u7b7e\u4eba\uff1a\u52a0\u7b7e\u65f6\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u3002", (String)"AddSignPagePlugin_14", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), userNames));
            return;
        }
        boolean onlyOneUser = Boolean.parseBoolean(this.getPageCache().get(ONLYONEUSER));
        if (onlyOneUser) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CARDENTRYFIXROWAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXADDUSER});
        }
    }

    private void updateEntryentityData(Set<Long> userIds) {
        if (CollectionUtil.isEmpty(userIds)) {
            return;
        }
        String contxtPath = UrlService.getDomainContextUrl();
        String arrowUrl = contxtPath + "/icons/mobile/navigation_bar/icon_details.png";
        QFilter filter = new QFilter("id", "in", userIds);
        Map userInfos = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"useropenid,name,picturefield,id,phone", (QFilter[])new QFilter[]{filter});
        for (Long userId : userIds) {
            DynamicObject userInfo = (DynamicObject)userInfos.get(userId);
            int index = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("name", (Object)userInfo.getLocaleString("name").toString(), index);
            this.getModel().setValue("phone", (Object)userInfo.getString("phone"), index);
            this.getModel().setValue("avatar", (Object)WfUtils.getAbsAvatarPath((Object)userInfo.get("picturefield")), index);
            this.getModel().setValue("userId", (Object)userId, index);
            this.getModel().setValue(ARROW, (Object)arrowUrl, index);
        }
        this.hideOrShowArrows();
    }

    private void updateEntryentityData(List<Long> userIds) {
        if (CollectionUtil.isEmpty(userIds)) {
            return;
        }
        Set<Long> useIdSets = userIds.stream().collect(Collectors.toSet());
        this.updateEntryentityData(useIdSets);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("deleteentry".equals(afterDoOperationEventArgs.getOperateKey())) {
            DynamicObjectCollection existUserDynamicObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
            if (existUserDynamicObjects != null && existUserDynamicObjects.size() > 1) {
                this.getView().setVisible(Boolean.TRUE, new String[]{DEALTYPEPANEL});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{DEALTYPEPANEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{YZJTYPEPANEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{ADDSIGNNAME});
                if ("mobile".equals(this.getDevice())) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP5});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{ADDSIGNNAME_SINGLE});
                this.getModel().setValue("addsigndealtype", (Object)1);
            }
            this.hideOrShowArrows();
            boolean onlyOneUser = Boolean.parseBoolean(this.getPageCache().get(ONLYONEUSER));
            if (onlyOneUser) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CARDENTRYFIXROWAP, FLEXADDUSER});
            }
        }
    }

    private void comfirm() {
        Boolean isValidateSuccess = this.getValidateSubmitResult();
        if (!isValidateSuccess.booleanValue()) {
            return;
        }
        String addSignTypeValue = (String)this.getModel().getValue("addsigntype");
        if ("1".equals(addSignTypeValue)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u524d\u52a0\u7b7e\uff0c\u5c06\u76f4\u63a5\u4ea4\u7531\u52a0\u7b7e\u4eba\u5458\u5148\u5ba1\u6279\uff0c\u5e76\u5173\u95ed\u5f53\u524d\u5ba1\u6279\uff0c\u60a8\u786e\u5b9a\u5417\uff1f", (String)"AddSignPagePlugin_2", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ADDSIGNBEFORECAllBACK));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u540e\u52a0\u7b7e\uff0c\u5f85\u60a8\u5ba1\u6279\u901a\u8fc7\u540e\u5c06\u4ea4\u7531\u52a0\u7b7e\u4eba\u5458\u5ba1\u6279\uff0c\u60a8\u786e\u5b9a\u5417\uff1f", (String)"AddSignPagePlugin_3", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ADDSIGNAFTERCAllBACK));
        }
    }

    private AddSignInfo getAddSingInfo() {
        AddSignInfo addSignInfo = new AddSignInfo();
        OrmLocaleValue addSingMsg = (OrmLocaleValue)this.getModel().getValue("addsignmsg");
        HashMap<String, String> map = new HashMap<String, String>(addSingMsg.entrySet().size());
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        TaskService taskService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService();
        Long taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskid"));
        ILocaleString currentUserName = (ILocaleString)taskService.getNameFormatByTaskIdAndUserId(taskId, Collections.singletonList(currentUserId)).get(currentUserId);
        ILocaleString contentValue = WfUtils.getPromptWordLocaleString((String)"%1$s \u52a0\u7b7e\uff0c\u8bf4\u660e:%2$s", (String)"AddSignPagePlugin_4", (String)BOS_WF_FORMPLUGIN);
        for (Map.Entry enrty : addSingMsg.entrySet()) {
            String key = (String)enrty.getKey();
            String content = (String)contentValue.get((Object)key);
            content = WfUtils.isEmpty((String)content) ? contentValue.toString() : content;
            currentUserName = WfUtils.isEmpty((ILocaleString)currentUserName) ? new LocaleString() : currentUserName;
            String currentUserNameLang = WfUtils.isEmpty((String)((String)currentUserName.get((Object)key))) ? currentUserName.toString() : (String)currentUserName.get((Object)key);
            String addSingMsgLang = WfUtils.isEmpty((String)addSingMsg.get((Object)key)) ? addSingMsg.toString() : addSingMsg.get((Object)key);
            this.logger.info(String.format("getAddSingInfo,key is %s; content is: %s;currentUserName is:%s;currentUserNameLang is: %s;addSingMsg is %s; addSingMsgLang is:%s", key, content, currentUserName.get((Object)key), currentUserNameLang, addSingMsg.get((Object)key), addSingMsgLang));
            map.put(key, String.format(content, currentUserNameLang, addSingMsgLang));
        }
        addSignInfo.setAddSingMsg(map);
        String addSignType = this.getAddSignType();
        addSignInfo.setAddSignType(addSignType);
        Boolean allowAddSign = (Boolean)this.getModel().getValue("allowaddsign");
        addSignInfo.setAllowAddSign(allowAddSign);
        String addSignDealType = "";
        ArrayList<Long> userIds = new ArrayList<Long>();
        DynamicObjectCollection userObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        if (userObjects != null && userObjects.size() == 1) {
            addSignDealType = "one";
            userIds.add(((DynamicObject)userObjects.get(0)).getLong("userId"));
        } else {
            String addSignDealTypeValue = (String)this.getModel().getValue("addsigndealtype");
            if ("1".equals(addSignDealTypeValue)) {
                addSignDealType = "anyone";
            } else if ("2".equals(addSignDealTypeValue)) {
                addSignDealType = "seq";
            } else if ("3".equals(addSignDealTypeValue)) {
                addSignDealType = "yzj";
            }
            if (userObjects != null && !userObjects.isEmpty()) {
                for (DynamicObject userObject : userObjects) {
                    Long userId = userObject.getLong(USERID);
                    if (userIds.contains(userId)) continue;
                    userIds.add(userId);
                }
            }
        }
        addSignInfo.setAddSignDealType(addSignDealType);
        addSignInfo.setUserIds(userIds);
        String yzjType = (String)this.getModel().getValue("yzjtype");
        if ("1".equals(yzjType)) {
            addSignInfo.setYzjType("passByOne");
        } else if ("2".equals(yzjType)) {
            addSignInfo.setYzjType("oneVoteVeto");
        }
        if ("2".equals((String)this.getModel().getValue("addsigndealtype"))) {
            Object lists;
            String nodeNamesStr = this.getPageCache().get(NODENAMES);
            if (WfUtils.isNotEmpty((String)nodeNamesStr) && (lists = (List)SerializationUtils.fromJsonString((String)nodeNamesStr, List.class)) != null && !lists.isEmpty()) {
                ArrayList<LocaleString> nodeNames = new ArrayList<LocaleString>(lists.size());
                for (int i = 0; i < lists.size(); ++i) {
                    LinkedHashMap list = (LinkedHashMap)lists.get(i);
                    LocaleString value = new LocaleString();
                    if (WfUtils.isNotEmptyForMap((Map)list)) {
                        value = LocaleString.fromMap((Map)list);
                    }
                    nodeNames.add(value);
                }
                addSignInfo.setNodeNames(nodeNames);
            }
        } else {
            ILocaleString addSingName = (ILocaleString)this.getModel().getValue(ADDSIGNNAME_SINGLE);
            for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                String addSingNameLang = (String)addSingName.getItem(lang.toString());
                addSingNameLang = WfUtils.isEmpty((String)addSingNameLang) ? addSingName.toString() : addSingNameLang;
                addSingName.put((Object)lang.toString(), (Object)addSingNameLang);
            }
            ArrayList<LocaleString> localeList = new ArrayList<LocaleString>();
            localeList.add(LocaleString.fromMap((Map)addSingName));
            addSignInfo.setNodeNames(localeList);
        }
        return addSignInfo;
    }

    private String getAddSignType() {
        String addSignType = (String)this.getModel().getValue("addsigntype");
        if ("1".equals(addSignType)) {
            return "addsignbefore";
        }
        return "addsignafter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent callBackResult) {
        Boolean callBackSure = MessageBoxResult.Yes.equals((Object)callBackResult.getResult()) || MessageBoxResult.OK.equals((Object)callBackResult.getResult());
        if (!callBackSure.booleanValue()) {
            return;
        }
        LocalVariables.putLocalVariables((boolean)true, (String[])new String[]{"tohandle"});
        AddSignInfo addSignInfo = this.getAddSingInfo();
        Long taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskid"));
        BeforeAddSignConfirmCustomEvent confirmCustomEvent = this.beforeConfirmCustomEvent(addSignInfo, taskId);
        addSignInfo.setExtProps(confirmCustomEvent.getExtProps());
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String result = null;
        RequestContext requestContext = RequestContext.get();
        String client = requestContext.getClient();
        if ("mobile".equals(this.getDevice())) {
            requestContext.setClient("mobile");
        }
        try {
            if (ADDSIGNBEFORECAllBACK.equals(callBackResult.getCallBackId())) {
                result = this.getTaskService().addSign(taskId, addSignInfo);
                if ("addsignsucces".equals(result)) {
                    if (this.getView().getParentView().getParentView() == null) {
                        this.getView().showSuccessNotification(WFMultiLangConstants.getTitleAddSignSuccess());
                    }
                    ret.put("addsignsucces", "addsignsucces");
                    ret.put("addsigntype", this.getModel().getValue("addsigntype"));
                    this.getView().returnDataToParent(ret);
                    this.getView().close();
                } else {
                    this.getView().showErrorNotification(result);
                }
            } else if (ADDSIGNAFTERCAllBACK.equals(callBackResult.getCallBackId())) {
                result = this.getTaskService().addSign(taskId, addSignInfo);
                if ("addsignsucces".equals(result)) {
                    if (this.getView().getParentView().getParentView() == null) {
                        this.getView().showSuccessNotification(WFMultiLangConstants.getTitleAddSignSuccess());
                    }
                    DynamicObjectCollection nextNodes = (DynamicObjectCollection)this.getModel().getValue(ENTRYENTITY);
                    List insertRows = nextNodes.getInsertRows();
                    List<Long> nextNodeUserId = this.getNextNodes(insertRows, "seq".equals(addSignInfo.getAddSignDealType()));
                    ret.put("addsignsucces", "addsignsucces");
                    ret.put("addsigntype", this.getModel().getValue("addsigntype"));
                    String addSignName = "seq".equals(addSignInfo.getAddSignDealType()) ? this.getModel().getValue(ADDSIGNNAME).toString().split(",")[0] : this.getModel().getValue(ADDSIGNNAME_SINGLE).toString();
                    ret.put(ADDSIGNNAME, addSignName);
                    ret.put("nextNodeUserId", nextNodeUserId);
                    this.getView().returnDataToParent(ret);
                    this.getView().close();
                } else {
                    this.getView().showErrorNotification(result);
                }
            } else if (ADDSIGNCLEARCALLBACK.equals(callBackResult.getCallBackId())) {
                result = this.getTaskService().addSignClear(taskId, "addsignafter");
                if ("noresource".equals(result) || "clearSuccess".equals(result)) {
                    this.clearAddSignInfoInPage();
                }
                if ("noresource".equals(result)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u65e0\u540e\u52a0\u7b7e\u5185\u5bb9\uff0c\u65e0\u9700\u5220\u9664\u3002", (String)"AddSignPagePlugin_7", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
                } else if ("clearSuccess".equals(result)) {
                    ret.put(ADDSIGNCLEARCALLBACK, ADDSIGNCLEARCALLBACK);
                    this.getView().returnDataToParent(ret);
                    this.getView().close();
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u201c\u540e\u52a0\u7b7e\u201d\u5185\u5bb9\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"AddSignPagePlugin_8", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]), result));
                }
            }
        }
        finally {
            RequestContext rc = RequestContext.get();
            rc.setClient(client);
        }
    }

    private BeforeAddSignConfirmCustomEvent beforeConfirmCustomEvent(AddSignInfo addSignInfo, Long taskId) {
        BeforeAddSignConfirmCustomEvent args = new BeforeAddSignConfirmCustomEvent(this.getView(), "selectAddSignConfirmIsolation", "addSignconfirm", null, taskId, addSignInfo);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
        return args;
    }

    private void clearAddSignInfoInPage() {
        this.getModel().setValue("addsignmsg", null);
        this.getModel().setValue("addsigntype", (Object)"1");
        this.getModel().setValue("allowaddsign", (Object)Boolean.FALSE);
        this.getModel().setValue("addsigndealtype", (Object)"1");
        this.getModel().setValue("yzjtype", (Object)"1");
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getView().setVisible(Boolean.FALSE, new String[]{DEALTYPEPANEL});
        boolean onlyOneUser = Boolean.parseBoolean(this.getPageCache().get(ONLYONEUSER));
        if (onlyOneUser) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CARDENTRYFIXROWAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXADDUSER});
        }
    }

    private Boolean getValidateSubmitResult() {
        ILocaleString addSingMsg = (ILocaleString)this.getModel().getValue("addsignmsg");
        if (WfUtils.isEmpty((ILocaleString)addSingMsg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u52a0\u7b7e\u8bf4\u660e\u201d\u3002", (String)"AddSignPagePlugin_15", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        DynamicObjectCollection userObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        if (userObjects != null && userObjects.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u52a0\u7b7e\u4eba\u201d\u3002", (String)"AddSignPagePlugin_10", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String addSignName = (String)this.getModel().getValue(ADDSIGNNAME);
        ILocaleString addSignNameSingle = (ILocaleString)this.getModel().getValue(ADDSIGNNAME_SINGLE);
        Boolean isMultipleNode = "2".equals((String)this.getModel().getValue("addsigndealtype"));
        if (isMultipleNode.booleanValue() && WfUtils.isEmpty((String)addSignName) || !isMultipleNode.booleanValue() && WfUtils.isEmpty((ILocaleString)addSignNameSingle)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8282\u70b9\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddSignPagePlugin_11", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String getDevice() {
        return (String)this.getView().getFormShowParameter().getCustomParam("device");
    }

    public List<Long> getNextNodes(List<DynamicObject> nextNodes, Boolean isSeq) {
        ArrayList<Long> nextNodeUserId = new ArrayList<Long>(nextNodes.size());
        for (DynamicObject nextNode : nextNodes) {
            Long userid = Long.valueOf((String)nextNode.get(USERID));
            nextNodeUserId.add(userid);
        }
        return isSeq != false ? nextNodeUserId.subList(0, 1) : nextNodeUserId;
    }
}

