/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.SubmitAndNew;
import kd.bos.entity.operate.UnSubmit;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;

public class ApprovalBillOperationPlugin
extends AbstractWorkflowPlugin {
    public static final String PLUGIN_NAME = "kd.bos.workflow.taskcenter.plugin.ApprovalBillOperationPlugin";
    public static final String PROCESSDEFINITIONID = "processDefinitionId";
    public static final String PROCESSINSTANCEID = "processInstanceId";
    public static final String TASKDEFINITIONKEY = "taskDefinitionKey";
    public static final String TYPE = "type";
    public static final String PARENTPAGEID = "parentPageId";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String isClose;
        String operations;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs == null || afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        IFormView parentView = null;
        String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam(PARENTPAGEID);
        if (WfUtils.isNotEmpty((String)parentPageId)) {
            parentView = this.getView().getViewNoPlugin(parentPageId);
        }
        if (null == parentView) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IPageCache parentPageCache = parentView.getPageCache();
        if ("close".equals(operateKey)) {
            parentPageCache.put("isClose", "true");
        }
        if (WfUtils.isEmpty((String)(operations = this.getOperationsFromBPMNModel())) || !Arrays.asList(operations.split(",")).contains(operateKey)) {
            parentPageCache.put("approvalScene", "false");
            return;
        }
        String taskId = (String)parentView.getFormShowParameter().getCustomParam("tId");
        if (WfUtils.isEmpty((String)taskId)) {
            Object t = parentView.getFormShowParameter().getCustomParam("taskId");
            if (t instanceof Long) {
                taskId = (Long)t + "";
            } else if (t instanceof String) {
                taskId = (String)t;
            }
        }
        if (WfUtils.isNotEmpty((String)taskId)) {
            String bkId = "";
            List f = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            if (f != null && !f.isEmpty()) {
                bkId = String.valueOf(f.get(0));
            }
            this.getTaskService().completeUserTaskById(Long.valueOf(taskId), bkId);
        }
        if (WfUtils.isEmpty((String)(isClose = parentPageCache.get("isClose")))) {
            parentPageCache.put("isClose", "false");
            parentPageCache.put("approvalScene", "true");
        }
        this.getView().getActionResult();
        Object source = afterDoOperationEventArgs.getSource();
        if (source instanceof SubmitAndNew || source instanceof SaveAndNew) {
            parentPageCache.remove("isClose");
            parentPageCache.put("approvalScene", "false");
            return;
        }
        this.getView().close();
    }

    private String getOperationsFromBPMNModel() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long processDefinitionId = (Long)formShowParameter.getCustomParam(PROCESSDEFINITIONID);
        Long processInstanceId = (Long)formShowParameter.getCustomParam(PROCESSINSTANCEID);
        String taskdefinitionkey = (String)formShowParameter.getCustomParam(TASKDEFINITIONKEY);
        BpmnModel bpmnModel = super.getRepositoryService().getBpmnModel(processDefinitionId, processInstanceId);
        UserTask element = (UserTask)bpmnModel.getFlowElement(taskdefinitionkey);
        return null == element ? "" : element.getOperationStr();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (args.getSource() instanceof UnSubmit && "toApply".equals(formShowParameter.getCustomParam(TYPE))) {
            formShowParameter.setStatusValue(1);
        }
        String operations = this.getOperationsFromBPMNModel();
        String operationKey = ((FormOperate)args.getSource()).getOperateKey();
        if (WfUtils.isNotEmpty((String)operations) && operations.contains(operationKey)) {
            Long processInstanceId = (Long)formShowParameter.getCustomParam(PROCESSINSTANCEID);
            String taskdefinitionkey = (String)formShowParameter.getCustomParam(TASKDEFINITIONKEY);
            QFilter filterProcInstId = new QFilter("processinstanceid", "=", (Object)processInstanceId);
            QFilter filterActivityId = new QFilter("activityid", "=", (Object)taskdefinitionkey);
            QFilter filterSuspendType = new QFilter(TYPE, "=", (Object)SuspendType.MANUALSUSPEND.getCode());
            QFilter filterTime = new QFilter("undosuspendtime", "is null", null);
            QFilter[] filters = new QFilter[]{filterProcInstId, filterActivityId, filterSuspendType, filterTime};
            Long durations = this.getRepositoryService().getEntityCountByFilter("wf_durationdetail", filters);
            if (durations > 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e3a\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\u3002", (String)"ApprovalBillOperationPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String isClose;
        IPageCache parentPageCache;
        IFormView parentView;
        super.beforeClosed(e);
        String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam(PARENTPAGEID);
        if (WfUtils.isNotEmpty((String)parentPageId) && null != (parentView = this.getView().getViewNoPlugin(parentPageId)) && null != (parentPageCache = parentView.getPageCache()) && WfUtils.isEmpty((String)(isClose = parentPageCache.get("isClose")))) {
            parentPageCache.put("approvalScene", "false");
            parentPageCache.put("isClose", "true");
        }
    }
}

