/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.AgentTaskHandleContext;
import kd.bos.workflow.engine.impl.cmd.task.TaskHandleContext;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.taskcenter.plugin.ApprovalPagePluginNew;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class ApprovalBillPlugin
extends ApprovalPagePluginNew
implements RowClickEventListener {
    private static final String SHRINK = "shrink";
    private static final String FLOATMENU = "floatmenu";
    private static final String FLOATMENUITEM_TASKDEAL = "floatmenuitem_taskdeal";
    private static final String FLOATMENUITEM_APPRECORD = "floatmenuitem_apprecord";
    private static final String FLOATMENUITEM_FEEDBACK = "floatmenuitem_feedback";
    private static final String FLEXPANELAP_DEAL = "flexpanelap";

    @Override
    public void initialize() {
        this.addItemClickListeners(new String[]{FLOATMENU});
        this.addClickListeners(new String[]{SHRINK, "btntransfer", "imageap_showtransferpage", "btnsubmit_transfer", "btn_feedbackrecall", "btnsubmit_feedback"});
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        if (null != progressBar) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.setPreOpenForm(e, Boolean.TRUE);
    }

    @Override
    public void afterCreateNewData(EventObject evt) {
        try {
            TaskHandleContext context;
            ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object type = customParams.get("type");
            if (null != type) {
                customParams.put("type", ApprovalPluginUtil.getTypeFromParams(customParams));
            }
            if (!(context = super.getTaskInfoByParams(customParams)).getTaskExist().booleanValue()) {
                if ("taskNotExistReason_notExist".equals(context.getTaskNotExistReason())) {
                    ApprovalPluginUtil.callRecordReadTime((AgentTaskHandleContext)context, customParams);
                }
                String taskNotExistInfo = super.getTaskNotExistInfo(context.getTaskNotExistReason());
                this.getView().showMessage(taskNotExistInfo, MessageTypes.Default, new ConfirmCallBackListener("callBack_withdraw"));
                return;
            }
            boolean jumpToRightPageForApproval = ApprovalPluginUtil.jumpToRightPageForApproval(context.getTask(), this.ISPCSHOWVALUE, this.getView());
            if (jumpToRightPageForApproval) {
                return;
            }
            boolean showRecordSidebar = WfConfigurationUtil.isShowRecordSidebar();
            if (showRecordSidebar) {
                this.setVisibleForPanelAndMenu(false, true);
            } else {
                this.setVisibleForPanelAndMenu(true, false);
            }
            customParams.put("type", this.getPageCache().get("tasktype"));
            UserTask elements = (UserTask)this.getAuditTaskElements();
            super.showBillInfoForUserTask(ApprovalPluginUtil.getTypeFromParams(customParams), new CloseCallBack((IFormPlugin)this, "approvalbillcallback"), Boolean.TRUE, context, "flexpanel_yyym");
            this.viewStateControl(context.getOnlyView());
            boolean isViewState = context.getOnlyView();
            if (isViewState) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLOATMENUITEM_TASKDEAL});
            } else {
                this.loadTaskDealTab(elements, context);
                this.getView().setVisible(Boolean.FALSE, new String[]{"tabap_taskcoordinate"});
            }
            super.showApprovalRecord(this.ISPCSHOWVALUE, Boolean.FALSE, super.isHideYzj(), Boolean.FALSE);
            boolean isShowTabFeedback = WfConfigurationUtil.getShowTabFeedback();
            this.getView().setVisible(Boolean.valueOf(isShowTabFeedback), new String[]{"tabpageap_feedback"});
            this.getView().setVisible(Boolean.valueOf(isShowTabFeedback), new String[]{FLOATMENUITEM_FEEDBACK});
            if (isShowTabFeedback) {
                super.showFeedbackInfo();
            }
            ApprovalPluginUtil.callRecordReadTime((AgentTaskHandleContext)context, customParams);
            super.setExploreTabCaptain(context);
        }
        catch (Exception e) {
            super.dealWithExceptionForInitial(e);
        }
    }

    private void setVisibleForPanelAndMenu(boolean isShowFloatMenu, boolean isShowFlexpanel) {
        this.getView().setVisible(Boolean.valueOf(isShowFloatMenu), new String[]{FLOATMENU});
        this.getView().setVisible(Boolean.valueOf(isShowFlexpanel), new String[]{FLEXPANELAP_DEAL});
    }

    private void loadTaskDealTab(UserTask element, TaskHandleContext context) {
        boolean allowTransfer = ApprovalPluginUtil.isAllowTransfer(element, context.getTask());
        if (allowTransfer && context.getDelegate().booleanValue()) {
            boolean bl = allowTransfer = !WfConfigurationUtil.isTrustHandle();
        }
        if (!allowTransfer) {
            this.showHideTaskDeal();
            this.getView().setVisible(Boolean.FALSE, new String[]{FLOATMENUITEM_TASKDEAL});
        } else {
            HashMap<String, String> cacheMap = new HashMap<String, String>();
            super.setPageCacheForElementButtonVisible(element, cacheMap, context);
            super.setTaskDealPanelDetail();
            super.showTransferPanel();
            if (WfUtils.isNotEmptyForMap(cacheMap)) {
                this.getPageCache().put(cacheMap);
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String id;
        this.setVisibleForPanelAndMenu(false, true);
        Tab tab = (Tab)this.getView().getControl("tabap");
        switch (id = evt.getItemKey()) {
            case "floatmenuitem_taskdeal": {
                tab.activeTab("tabap_taskdeal");
                break;
            }
            case "floatmenuitem_apprecord": {
                tab.activeTab("tabpageap_approvalrecord");
                break;
            }
            case "floatmenuitem_feedback": {
                if (!WfConfigurationUtil.getShowTabFeedback()) break;
                tab.activeTab("tabpageap_feedback");
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "shrink": {
                this.setVisibleForPanelAndMenu(true, false);
                break;
            }
            case "imageap_showtransferpage": {
                super.showTransferPage();
                break;
            }
            case "btnsubmit_transfer": {
                ApprovalPluginUtil.showRecallDelegateConfirmPage(Long.parseLong(this.getPageCache().get("taskid")), () -> super.showSubmitTransferFunc(), this.getView(), "usertaskTranDeleTaskRecall");
                break;
            }
            case "btn_feedbackrecall": {
                super.showFeedbackRecallFunc();
                break;
            }
            case "btnsubmit_feedback": {
                super.showSubmitFeedbackFunc();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "approvalbillcallback": {
                this.getPageCache().put("isClose", "true");
                super.showClosePage(null);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("callBack_withdraw".equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLOATMENU});
        }
    }
}

