/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.taskcenter.plugin.ApprovalPluginNew;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class ApprovalOpinionDetailMobPlugin
extends ApprovalPluginNew {
    private static final String TEXTAREAFIELD_MSG = "textareafield_msg";
    private static final String MBARITEMAP_SUBMIT = "mbaritemap_submit";

    @Override
    public void initialize() {
        this.addClickListeners(new String[]{MBARITEMAP_SUBMIT});
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.logger.info("ApprovalOpinionDetailMobPlugin.afterCreateNewData \u63a5\u6536\u7684\u53c2\u6570 params:" + params);
        super.setPageCacheData(params);
        String auditType = (String)params.get("auditType");
        if ("reject".equals(auditType) || "forceReject".equals(auditType)) {
            Map getNextNodeMap = (Map)params.get("getNextNodeMap");
            if (WfUtils.isNotEmptyForMap((Map)getNextNodeMap)) {
                Object dataItems;
                List nextNodeMapList = (List)getNextNodeMap.get("nextNodeMapList");
                if (WfUtils.isNotEmptyForCollection((Collection)nextNodeMapList)) {
                    this.getPageCache().put(params.get("auditNumber") + "_currentrow", SerializationUtils.toJsonString(nextNodeMapList.get(0)));
                }
                if (null != (dataItems = getNextNodeMap.get("dataItems"))) {
                    this.getPageCache().put("dataItems", SerializationUtils.toJsonString(dataItems));
                }
                String nextNodeId = (String)((Map)nextNodeMapList.get(0)).get("nextNodeValue");
                this.showRejectBackToNode(auditType, nextNodeId);
            }
            this.initProcessAttachment();
        } else if ("terminate".equals(auditType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanel_procattach", "backtonodepanel"});
        } else {
            this.initProcessAttachment();
            this.showRejectBackToNode(auditType, "null");
        }
        ApprovalPluginUtil.initSignatureFP(this.getView());
        this.trigAfterCreatNewDataForApprovalCustomEvent();
        ILocaleString auditText = this.getAuditText(params);
        Boolean ignoreNextNode = WfConfigurationUtil.ignoreNextNode((String)"ignoredefaultadvice");
        if (ignoreNextNode != null && ignoreNextNode.booleanValue() || "approve".equals(auditType)) {
            this.getModel().setValue(TEXTAREAFIELD_MSG, (Object)auditText.getLocaleValue());
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        ApprovalPluginUtil.addExtraNodeTplApprovalPluginsBeforeShowForm(e.getFormShowParameter());
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        this.logger.info("ApprovalOpinionDetailMobPlugin.click \u4e8b\u4ef6\uff1a" + key);
        switch (key) {
            case "mbaritemap_submit": {
                this.beforeshowSubmitDataForMob();
                break;
            }
        }
    }

    private void beforeshowSubmitDataForMob() {
        String auditType = (String)this.getView().getFormShowParameter().getCustomParam("auditType");
        if ("terminate".equals(auditType)) {
            ILocaleString approvalMsg = (ILocaleString)this.getModel().getValue(TEXTAREAFIELD_MSG);
            if (StringUtils.isBlank((Object)approvalMsg) || StringUtils.isBlank((CharSequence)approvalMsg.getLocaleValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5ba1\u6279\u610f\u89c1\u201d\u3002", (String)"ApprovalOpinionDetailMobPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean b = ApprovalPluginUtil.checkForceSignature(this.getView(), "signaturefield");
            if (b) {
                return;
            }
            this.trigTerminalBeforeSubmitCustomEventOrClose(approvalMsg.getLocaleValue());
        } else {
            String taskId;
            boolean isParticipant;
            Long processInstanceId;
            if (("reject".equalsIgnoreCase(auditType) || "forceReject".equalsIgnoreCase(auditType)) && WfUtils.isNotEmpty((Long)(processInstanceId = WfUtils.normalizeId((String)this.getPageCache().get("processInstanceId"))))) {
                String taskdefinitionkey = this.getPageCache().get("taskdefinitionkey");
                boolean removeReject = this.getTaskService().judgeForkTaskCanReject(processInstanceId, taskdefinitionkey);
                if (removeReject) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u4e3a\u5206\u652f\u5185\u90e8\u8282\u70b9\uff0c\u5df2\u7ecf\u6709\u5176\u4ed6\u5206\u652f\u8282\u70b9\u9a73\u56de\uff0c\u6682\u65f6\u4e0d\u80fd\u9a73\u56de\u3002", (String)"ApprovalPagePluginNew_22", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
            }
            if (!(isParticipant = CoordinateRecordUtil.isParticipant((Long)(WfUtils.isEmpty((String)(taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskid"))) ? null : Long.valueOf(taskId)), (String)RequestContext.get().getUserId(), (String)"participant"))) {
                this.getView().showErrorNotification(WFMultiLangConstants.getIsNotTaskParticipant());
                return;
            }
            boolean isExistUndoCoordinateRecord = CoordinateRecordUtil.getIsExistUndoCoordinateRecord((String)taskId);
            if (isExistUndoCoordinateRecord) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5305\u542b\u672a\u5904\u7406\u7684\u201c%s\u201d\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"ApprovalOpinionDetailMobPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callBack_isContainUndoCoordinate"));
            } else {
                super.showSubmitDataForMob(this.getView(), (ILocaleString)this.getModel().getValue(TEXTAREAFIELD_MSG));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult callBackResult = messageBoxClosedEvent.getResult();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        Boolean callBackSure = MessageBoxResult.Yes.equals((Object)callBackResult) || MessageBoxResult.OK.equals((Object)callBackResult);
        if (null == callBackSure || !callBackSure.booleanValue()) {
            return;
        }
        if (callBackId.equals("confirmCallBackIdForValidator")) {
            String operation = this.getPageCache().get("confirmCallBackIdForValidator");
            this.getPageCache().put("confirmCallBackIdForValidator" + operation, String.valueOf(true));
            super.showSubmitDataForMob(this.getView(), (ILocaleString)this.getModel().getValue(TEXTAREAFIELD_MSG));
        } else if (callBackId.equals("isSubmitWhenNoNextPerson")) {
            this.getPageCache().put(callBackId, callBackSure.toString());
            super.showSubmitDataForMob(this.getView(), (ILocaleString)this.getModel().getValue(TEXTAREAFIELD_MSG));
        } else if (callBackId.equals("callBack_isContainUndoCoordinate")) {
            super.showSubmitDataForMob(this.getView(), (ILocaleString)this.getModel().getValue(TEXTAREAFIELD_MSG));
        } else if (callBackId.equals("submitDeleTaskRecall")) {
            this.beforeshowSubmitDataForMob();
        }
    }

    private ILocaleString getAuditText(Map<String, Object> params) {
        String auditNumber = (String)params.get("auditNumber");
        String processInstanceId = this.getPageCache().get("processInstanceId");
        String processDefinitionId = this.getPageCache().get("processDefinitionId");
        String nodeId = this.getPageCache().get("taskdefinitionkey");
        return PluginUtil.getAuditText(auditNumber, Long.valueOf(processInstanceId), Long.valueOf(processDefinitionId), nodeId);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        boolean isConfirm;
        if (e.getReturnData() != null && "WfSensitiveCallBackFlag".equals(e.getActionId()) && (isConfirm = ApprovalPluginUtil.setCloseSensitiveFieldPageData(e.getReturnData(), this.getPageCache()))) {
            this.beforeshowSubmitDataForMob();
        }
    }
}

