/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class ApprovalPageAddSignPlugin
extends AbstractWorkflowPlugin {
    private static final String TOOLBARAP = "toolbarap";
    private static final String SUSPENSIONSTATE = "SUSPENSIONSTATE";
    private static final String ADDSIGNCLEARCALLBACK = "addSignClearCallBack";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void beforeBindData(EventObject e) {
        Boolean onlyView = Boolean.valueOf(this.getPageCache().get("onlyView"));
        if (onlyView.booleanValue() || this.isManualSuspend() || this.isDelegateTask() && WfConfigurationUtil.isTrustHandle()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnaddsign"});
        } else {
            Boolean isAllowAddSign = Boolean.valueOf(this.getPageCache().get("allowaddsign"));
            Boolean isTaskCoordinate = Boolean.valueOf(this.getPageCache().get("is_taskcoordinate"));
            if (isAllowAddSign.booleanValue() && !isTaskCoordinate.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnaddsign"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnaddsign"});
            }
        }
    }

    protected boolean isDelegateTask() {
        boolean isDelegateTask = false;
        String t = this.getPageCache().get("isDelegateTask");
        if (WfUtils.isEmpty((String)t)) {
            String taskId = this.getPageCache().get("taskid");
            if (!WfUtils.isEmpty((String)taskId) && TaskDelegateUtil.isDelegateTask((Long)Long.valueOf(taskId), (Long)Long.valueOf(RequestContext.get().getUserId()))) {
                isDelegateTask = true;
            }
        } else {
            isDelegateTask = Boolean.parseBoolean(t);
        }
        return isDelegateTask;
    }

    protected boolean isManualSuspend() {
        boolean isManualSuspend = false;
        String suspensionState = this.getPageCache().get(SUSPENSIONSTATE);
        if (WfUtils.isNotEmpty((String)suspensionState) && !ManagementConstants.ACTIVE.getStateCode().equals(suspensionState)) {
            isManualSuspend = true;
        }
        return isManualSuspend;
    }

    public void itemClick(ItemClickEvent evt) {
        String id = evt.getItemKey();
        if ("btnaddsign".equals(id)) {
            String result = this.validate();
            if (WfUtils.isNotEmpty((String)result)) {
                this.getView().showTipNotification(result);
                return;
            }
            result = this.validateIsParticipant();
            if (WfUtils.isNotEmpty((String)result)) {
                this.getView().showTipNotification(result);
                return;
            }
            ApprovalPluginUtil.showRecallDelegateConfirmPage(Long.valueOf(this.getPageCache().get("taskid")), () -> this.showAddSignPage(), this.getView(), "addsignDeleTaskRecall");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult callBackResult = messageBoxClosedEvent.getResult();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && "addsignDeleTaskRecall".equals(callBackId)) {
            this.showAddSignPage();
        }
    }

    private String validate() {
        String taskId = this.getPageCache().get("taskid");
        if (WfUtils.isEmpty((String)taskId)) {
            return ResManager.loadKDString((String)"taskID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ApprovalPageAddSignPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        boolean isParticipant = CoordinateRecordUtil.isParticipant((Long)Long.valueOf(this.getPageCache().get("taskid")), (String)RequestContext.get().getUserId(), (String)"participant");
        if (!isParticipant) {
            return WFMultiLangConstants.getIsNotTaskParticipant();
        }
        if (TaskUtils.isTaskSuspended((Long)Long.valueOf(taskId))) {
            return ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e3a\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd\u52a0\u7b7e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\u3002", (String)"ApprovalPageAddSignPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private String validateIsParticipant() {
        boolean isParticipant = CoordinateRecordUtil.isParticipant((Long)Long.valueOf(this.getPageCache().get("taskid")), (String)RequestContext.get().getUserId(), (String)"participant");
        if (!isParticipant) {
            return WFMultiLangConstants.getIsNotTaskParticipant();
        }
        return null;
    }

    private void showAddSignPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_addsignpage");
        parameter.setCustomParam("taskid", (Object)this.getPageCache().get("taskid"));
        parameter.setCustomParam("processInstanceId", (Object)this.getPageCache().get("processInstanceId"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showAddSignPageCallBack"));
        this.showForm(parameter);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (null == e) {
            return;
        }
        String key = e.getKey();
        String btnkeys = this.getPageCache().get("addControlKeys");
        if (null == btnkeys || btnkeys.contains(key)) {
            return;
        }
        this.addItemClickListeners(btnkeys.split(","));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if ("showAddSignPageCallBack".equals(e.getActionId())) {
            int addSignType;
            if (returnData == null) {
                return;
            }
            Map result = (Map)returnData;
            String addSignSuccess = (String)result.get("addsignsucces");
            int n = addSignType = result.get("addsigntype") != null ? Integer.parseInt((String)result.get("addsigntype")) : 0;
            if ("addsignsucces".equals(addSignSuccess) && addSignType == 1) {
                if (this.getView().getParentView() != null) {
                    this.getView().getParentView().showSuccessNotification(WFMultiLangConstants.getTitleAddSignSuccess());
                    this.getView().sendFormAction(this.getView().getParentView());
                }
                this.getModel().setDataChanged(false);
                boolean success = ApprovalPluginUtil.executeClosePageAfterSubmitTask(true, this.getView());
                if (success) {
                    return;
                }
                this.getPageCache().put("approvalScene", "true");
                this.getView().close();
            } else if ("addsignsucces".equals(addSignSuccess) && addSignType == 2) {
                String selectValue = (String)this.getModel().getValue("combo_decision");
                if (WfUtils.isNotEmpty((String)selectValue) && !"choosedesicionresult".equals(selectValue)) {
                    this.getPageCache().put("auditCacheUnUsable", "false");
                    this.getPageCache().put("addsign", "addsign");
                    this.getPageCache().put("ApprovalPagePluginNew::NEXTNODE_SHOW_STATUS", "true");
                    this.getModel().setValue("combo_decision", null);
                    this.getModel().setValue("combo_decision", (Object)selectValue);
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_recallmodify"});
            } else if (ADDSIGNCLEARCALLBACK.equals(result.get(ADDSIGNCLEARCALLBACK))) {
                String selectValue = (String)this.getModel().getValue("combo_decision");
                if (WfUtils.isNotEmpty((String)selectValue) && !"choosedesicionresult".equals(selectValue)) {
                    this.getModel().setValue("combo_decision", null);
                    this.getModel().setValue("combo_decision", (Object)selectValue);
                }
                this.getPageCache().remove("decisionparticipant");
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_recallmodify"});
                this.getPageCache().remove("decisionparticipant");
            }
        }
    }
}

