/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.AuditComment;
import kd.bos.workflow.bpmn.model.AuditCommentModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.TaskHandleContext;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.taskcenter.plugin.ApprovalPluginNew;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class ApprovalPageAuditCommentPlugin
extends ApprovalPluginNew
implements RowClickEventListener,
TabSelectListener,
TipsListener,
ProgresssListener {
    private static final String DECISION_OPTIONS = "decisionOptions";
    private static final String MSG_APPROVAL = "msg_approval";
    private static final String ICON_COMAUDITCOMMENTLIST = "icon_comauditcommentlist";
    private static final String LABEL_COMAUDITCOMMENTLIST = "label_comauditcommentlist";
    private static final String CLOSECALLBACK_COMMONAUDITCOMMENTLIST = "closecallback_commonauditcommentlist";
    protected static final String TABAP = "tabap";
    public static final String COMBO_DECISION = "combo_decision";
    public static final String FIRSTVISIT = "firstVisit";

    public void registerListener(EventObject e) {
        Label label;
        Vector icon = (Vector)this.getControl(ICON_COMAUDITCOMMENTLIST);
        if (icon != null) {
            icon.addTipsListener((TipsListener)this);
        }
        if ((label = (Label)this.getControl(LABEL_COMAUDITCOMMENTLIST)) != null) {
            label.addTipsListener((TipsListener)this);
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        FormShowParameter para = evt.getFormshowParameter();
        if (para == null) {
            para = new FormShowParameter();
            evt.setFormshowParameter(para);
        }
        if (ICON_COMAUDITCOMMENTLIST.equals(key) || LABEL_COMAUDITCOMMENTLIST.equals(key)) {
            AuditCommentModel auditComment;
            AuditTask auditTask = (AuditTask)this.getAuditTaskElements();
            String decisionSelectValue = (String)this.getModel().getValue(COMBO_DECISION);
            String auditNumber = decisionSelectValue.split("_and_")[1].equals("null") ? null : decisionSelectValue.split("_and_")[1];
            String auditType = decisionSelectValue.split("_and_")[2].equals("null") ? null : decisionSelectValue.split("_and_")[2];
            List auditComments = null;
            if (auditTask != null && (auditComment = auditTask.getAuditCommentModel()) != null && auditComment.isAuditCommentWhenMatch()) {
                auditComments = auditComment.getAuditComments();
                para.setCustomParam("auditComments", (Object)auditComments);
                para.setCustomParam("auditNumber", (Object)auditNumber);
                para.setCustomParam("auditType", (Object)auditType);
                String content = this.getPageCache().get(DECISION_OPTIONS);
                para.setCustomParam("content", (Object)content);
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_COMMONAUDITCOMMENTLIST));
            }
        }
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e instanceof AfterCreatNewDataForApprovalCustomEvent) {
            String decisionSelectValue = (String)this.getModel().getValue(COMBO_DECISION);
            if (WfUtils.isEmpty((String)decisionSelectValue)) {
                return;
            }
            AfterCreatNewDataForApprovalCustomEvent evt = (AfterCreatNewDataForApprovalCustomEvent)e;
            this.context = (TaskHandleContext)evt.getContext();
            this.initAuditComment(decisionSelectValue, this.getTaskHandleContext());
        }
    }

    private void initAuditComment(String decisionSelectValue, TaskHandleContext context) {
        if (!"choosedesicionresult".equals(decisionSelectValue) && WfUtils.isNotEmpty((String)decisionSelectValue)) {
            String auditNumber = decisionSelectValue.split("_and_")[1].equals("null") ? null : decisionSelectValue.split("_and_")[1];
            String auditType = decisionSelectValue.split("_and_")[2].equals("null") ? null : decisionSelectValue.split("_and_")[2];
            String processInstanceId = this.getPageCache().get("processInstanceId");
            String nodeId = this.getPageCache().get("taskdefinitionkey");
            JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas((Long)Long.parseLong(processInstanceId));
            ILocaleString auditText = this.getAuditText(multiLangDatas, null == auditNumber ? "" : auditNumber, nodeId);
            ILocaleString approvalMsg = null;
            AuditTask auditTask = null;
            if (context != null) {
                auditTask = (AuditTask)context.getFlowElement();
            } else {
                context = new TaskHandleContext();
                auditTask = (AuditTask)this.getAuditTaskElements();
                context.setFlowElement((UserTask)auditTask);
            }
            AuditCommentModel auditComment = null;
            if (auditTask != null) {
                auditComment = auditTask.getAuditCommentModel();
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{ICON_COMAUDITCOMMENTLIST});
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_COMAUDITCOMMENTLIST});
            Boolean ignoreNextNode = WfConfigurationUtil.ignoreNextNode((String)"ignoredefaultadvice");
            if ("forceReject".equals(auditType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{ICON_COMAUDITCOMMENTLIST});
                this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_COMAUDITCOMMENTLIST});
                if (approvalMsg == null && ignoreNextNode.booleanValue()) {
                    approvalMsg = auditText;
                }
            } else {
                approvalMsg = this.getApprovalMsg(auditNumber, auditType, auditComment, nodeId, multiLangDatas);
                if ("terminate".equals(auditType)) {
                    if (approvalMsg == null && ignoreNextNode.booleanValue()) {
                        approvalMsg = auditText;
                    }
                } else if (approvalMsg == null) {
                    if ("approve".equals(auditType)) {
                        approvalMsg = auditText;
                    } else if ("reject".equals(auditType) && ignoreNextNode.booleanValue()) {
                        approvalMsg = auditText;
                    }
                }
            }
            approvalMsg = ApprovalPluginUtil.getDefaultApprovalMsg(approvalMsg);
            String firstVisit = this.getPageCache().get(FIRSTVISIT);
            ILocaleString inputApprovalMSg = null;
            if (StringUtils.isBlank((CharSequence)firstVisit)) {
                this.getPageCache().put(FIRSTVISIT, FIRSTVISIT);
                inputApprovalMSg = (ILocaleString)this.getModel().getValue(MSG_APPROVAL);
                if (inputApprovalMSg != null && StringUtils.isBlank((CharSequence)inputApprovalMSg.getLocaleValue())) {
                    inputApprovalMSg = null;
                }
            }
            String decisionStrVal = this.getPageCache().get(decisionSelectValue);
            LocaleString decisionVal = null;
            if (decisionStrVal != null) {
                Map decisionMapVal = (Map)SerializationUtils.fromJsonString((String)decisionStrVal, Object.class);
                decisionVal = LocaleString.fromMap((Map)decisionMapVal);
            }
            if (ignoreNextNode != null && ignoreNextNode.booleanValue()) {
                if (StringUtils.isBlank((CharSequence)firstVisit)) {
                    if (StringUtils.isNotBlank((Object)inputApprovalMSg)) {
                        this.getModel().setValue(MSG_APPROVAL, (Object)inputApprovalMSg);
                    } else {
                        this.getModel().setValue(MSG_APPROVAL, (Object)approvalMsg);
                    }
                } else if (decisionVal == null) {
                    this.getModel().setValue(MSG_APPROVAL, (Object)approvalMsg);
                } else {
                    this.getModel().setValue(MSG_APPROVAL, (Object)decisionVal);
                }
            } else if (decisionSelectValue.endsWith("approve")) {
                if (StringUtils.isBlank((CharSequence)firstVisit)) {
                    if (StringUtils.isNotBlank((Object)inputApprovalMSg)) {
                        this.getModel().setValue(MSG_APPROVAL, (Object)inputApprovalMSg);
                    } else {
                        this.getModel().setValue(MSG_APPROVAL, (Object)approvalMsg);
                    }
                } else {
                    if (decisionStrVal == null) {
                        decisionVal = approvalMsg;
                    }
                    this.getModel().setValue(MSG_APPROVAL, (Object)decisionVal);
                    this.getPageCache().remove(decisionSelectValue);
                }
            } else if (StringUtils.isBlank((CharSequence)firstVisit) && StringUtils.isNotBlank((Object)inputApprovalMSg)) {
                this.getModel().setValue(MSG_APPROVAL, (Object)inputApprovalMSg);
            } else {
                if (decisionStrVal == null) {
                    decisionVal = approvalMsg;
                }
                this.getModel().setValue(MSG_APPROVAL, (Object)decisionVal);
                this.getPageCache().remove(decisionSelectValue);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ICON_COMAUDITCOMMENTLIST});
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_COMAUDITCOMMENTLIST});
        }
    }

    private ILocaleString getApprovalMsg(String auditNumber, String auditType, AuditCommentModel auditComment, String nodeId, JSONObject multiLangDatas) {
        ILocaleString approvalMsg = null;
        ILocaleString approvalMsgDefaudit = null;
        if (auditComment != null && auditComment.isAuditCommentWhenMatch()) {
            String content = this.getPageCache().get(DECISION_OPTIONS);
            List decisionOptions = SerializationUtils.fromJsonStringToList((String)content, JSONObject.class);
            List auditComments = auditComment.getAuditComments();
            if (auditComments != null && auditComments.size() > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{ICON_COMAUDITCOMMENTLIST});
                this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_COMAUDITCOMMENTLIST});
                ArrayList<ILocaleString> approvalMsgList = new ArrayList<ILocaleString>(auditComments.size());
                for (AuditComment audit : auditComments) {
                    String decisions = audit.getDecision();
                    if (WfUtils.isEmpty((String)decisions)) {
                        StringBuilder decisionsSB = new StringBuilder();
                        for (JSONObject decisionOption : decisionOptions) {
                            if (!"approve".equals(decisionOption.get((Object)"auditType"))) continue;
                            decisionsSB.append(decisionOption.get((Object)"number")).append(',');
                        }
                        decisions = decisionsSB.toString();
                    }
                    String[] decisionArray = decisions.split(",");
                    for (int i = 0; i < decisionArray.length; ++i) {
                        if (!auditNumber.equals(decisionArray[i])) continue;
                        approvalMsgList.add(this.getAuditComment(audit));
                    }
                    if (!audit.isDefaudit() || !WfUtils.isEmpty((String)audit.getDecision())) continue;
                    approvalMsgDefaudit = this.getAuditComment(audit);
                }
                if (approvalMsgList != null && !approvalMsgList.isEmpty()) {
                    approvalMsg = WfUtils.isNotEmpty(approvalMsgDefaudit) ? approvalMsgDefaudit : (ILocaleString)approvalMsgList.get(0);
                } else if (auditComments.isEmpty() && WfConfigurationUtil.enableGetCommentFromBasedata()) {
                    QFilter qDecisionType = new QFilter("decisiontype", "=", (Object)auditType);
                    QFilter qEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"name", (QFilter[])new QFilter[]{qDecisionType, qEnable}, (String)"number", (int)1);
                    if (dynamicObjects.length > 0) {
                        approvalMsg = dynamicObjects[0].getLocaleString("name");
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{ICON_COMAUDITCOMMENTLIST});
                        this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_COMAUDITCOMMENTLIST});
                    }
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{ICON_COMAUDITCOMMENTLIST});
                    this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_COMAUDITCOMMENTLIST});
                }
                if (approvalMsg == null) {
                    String decisions = ((AuditComment)auditComments.get(0)).getDecision();
                    if (WfUtils.isEmpty((String)decisions)) {
                        StringBuilder decisionsSB = new StringBuilder();
                        for (JSONObject decisionOption : decisionOptions) {
                            if (!"approve".equals(decisionOption.get((Object)"auditType"))) continue;
                            decisionsSB.append(decisionOption.get((Object)"number")).append(',');
                        }
                        decisions = decisionsSB.toString();
                    }
                    String[] decisionArray = decisions.split(",");
                    for (int i = 0; i < decisionArray.length; ++i) {
                        if (!auditNumber.equals(decisionArray[i])) continue;
                        approvalMsg = this.getAuditComment((AuditComment)auditComments.get(0));
                    }
                }
            } else if (WfConfigurationUtil.enableGetCommentFromBasedata()) {
                QFilter qDecisionType = new QFilter("decisiontype", "=", (Object)auditType);
                QFilter qEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_commonauditcommenttree", (String)"name", (QFilter[])new QFilter[]{qDecisionType, qEnable}, (String)"number", (int)1);
                if (dynamicObjects.length > 0) {
                    approvalMsg = dynamicObjects[0].getLocaleString("name");
                    this.getView().setVisible(Boolean.TRUE, new String[]{ICON_COMAUDITCOMMENTLIST});
                    this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_COMAUDITCOMMENTLIST});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{ICON_COMAUDITCOMMENTLIST});
                    this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_COMAUDITCOMMENTLIST});
                }
            }
        }
        return approvalMsg;
    }

    private String getAuditCommentsNameMultiKey(String activityId, String decisionItemId) {
        return String.format("%s.auditCommentModel.auditComments.[%s].content", activityId, decisionItemId);
    }

    private ILocaleString getAuditText(JSONObject multiLangDatas, String auditNumber, String nodeId) {
        String decisionOptions = this.getPageCache().get(DECISION_OPTIONS);
        List decisionOptionsList = SerializationUtils.fromJsonStringToList((String)decisionOptions, DecisionOption.class);
        String decisionId = "";
        DecisionOption decisionOption = null;
        for (int i = 0; i < decisionOptionsList.size(); ++i) {
            decisionOption = (DecisionOption)decisionOptionsList.get(i);
            if (!auditNumber.equals(decisionOption.getNumber())) continue;
            decisionId = decisionOption.getId();
            String multiKey = BpmnModelUtil.getDecisionNameMultiKey((String)nodeId, (String)decisionId);
            return BpmnModelUtil.getMultiLangFieldValue((JSONObject)multiLangDatas, (String)multiKey, (String)decisionOption.getName());
        }
        return new LocaleString("");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (COMBO_DECISION.equals(propName)) {
            ChangeData[] changeData = e.getChangeSet();
            Object newValue = changeData[0].getNewValue();
            Object oldValue = changeData[0].getOldValue();
            Object msgValue = this.getModel().getValue(MSG_APPROVAL);
            if (oldValue != null && msgValue != null) {
                this.getPageCache().put(oldValue.toString(), SerializationUtils.toJsonString((Object)msgValue));
            }
            this.initAuditComment((String)newValue, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            Object returnData = e.getReturnData();
            if (CLOSECALLBACK_COMMONAUDITCOMMENTLIST.equals(e.getActionId())) {
                this.setCloseAuditCommentPageData(returnData);
            }
        }
    }

    private void setCloseAuditCommentPageData(Object returnData) {
        if (returnData instanceof Map) {
            String cotent = null;
            Map returnContentInfo = (Map)returnData;
            for (Map.Entry contentInfo : returnContentInfo.entrySet()) {
                cotent = (String)contentInfo.getValue();
            }
            this.getModel().setValue(MSG_APPROVAL, cotent);
        }
    }

    public void onProgress(ProgressEvent arg0) {
    }

    public void afterShowTips(AfterShowTipsEvent arg0) {
    }

    public void tabSelected(TabSelectEvent arg0) {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(FIRSTVISIT);
    }

    private ILocaleString getAuditComment(AuditComment audit) {
        LocaleString approvalMessage = new LocaleString("");
        if (null == audit) {
            return approvalMessage;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)audit.getBasedataid(), (String)"wf_commonauditcommenttree", (String)"name");
        if (null == dynamicObject) {
            return approvalMessage;
        }
        return dynamicObject.getLocaleString("name");
    }
}

