/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.workflow.bpmn.model.AuditPointModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.task.TaskHandleContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.task.auditpoint.AuditPointCheckResult;
import kd.bos.workflow.engine.task.auditpoint.AuditPointType;
import kd.bos.workflow.taskcenter.plugin.ApprovalPluginNew;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.util.PictureResourceEnum;

public class ApprovalPageAuditPointPlugin
extends ApprovalPluginNew
implements TipsListener {
    private static final String FLEXPANEL_AUDITPOINTS = "flexpanel_auditpoints";
    private static final String AUDITPOINTS_TITLE = "auditpoints_title";
    private static final String IMAGEAP_ISPASS = "imageap_ispass";
    private static final String AUDITPOINTS_TIPS = "displaynametips";
    private static final String CARDENTRYISPASS = "cardentryispass";
    private static final String AUDITPOINTS_ERRORMESSAGE = "errormessage";
    private static final String AUDITPOINTS_CARDENTRYFAILRE = "cardentryfailedreason";
    private static final String AUDITPOINTS_DESCRIPTION = "description";

    public void registerListener(EventObject e) {
        Label auditPointsTips = (Label)this.getControl(AUDITPOINTS_TIPS);
        if (auditPointsTips != null) {
            auditPointsTips.addTipsListener((TipsListener)this);
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        FormShowParameter para = evt.getFormshowParameter();
        if (para == null) {
            para = new FormShowParameter();
            evt.setFormshowParameter(para);
        }
        if (AUDITPOINTS_TIPS.equals(key)) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity_auditpoint");
            int index = cardEntry.getEntryState().getFocusRow();
            IDataModel model = this.getModel();
            if (index != -1) {
                String description = (String)model.getValue(AUDITPOINTS_DESCRIPTION, index);
                if (WfUtils.isEmpty((String)description)) {
                    description = ResManager.loadKDString((String)"\u8be5\u201c\u68c0\u67e5\u9879\u201d\u65e0\u8be6\u7ec6\u8bf4\u660e\u3002", (String)"ApprovalPagePluginNew_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                }
                para.setCustomParam("auditPointsTips", (Object)description);
            } else {
                this.logger.debug("\u5ba1\u6279\u8981\u70b9\u68c0\u67e5\u9879\u6ca1\u6709\u9009\u4e2d\u884c\uff01");
            }
        }
    }

    public void afterShowTips(AfterShowTipsEvent arg0) {
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e instanceof AfterCreatNewDataForApprovalCustomEvent) {
            AfterCreatNewDataForApprovalCustomEvent evt = (AfterCreatNewDataForApprovalCustomEvent)e;
            this.context = (TaskHandleContext)evt.getContext();
            this.showAuditPoints(this.getTaskHandleContext());
        }
    }

    private void showAuditPoints(TaskHandleContext context) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object taskIdObj = customParams.get("taskId");
        TaskEntity taskEntity = null;
        UserTask flowElement = null;
        if (context != null && context.getOnlyView() != null && !context.getOnlyView().booleanValue()) {
            taskEntity = (TaskEntity)context.getTask();
            flowElement = context.getFlowElement();
        } else {
            Long taskId = WfUtils.getLongValueFromObj(taskIdObj);
            if (taskId != null) {
                taskEntity = (TaskEntity)this.getRepositoryService().findEntityById(taskId, "wf_task");
                flowElement = this.getAuditTaskElements();
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANEL_AUDITPOINTS});
        if (flowElement instanceof AuditTask && taskEntity != null) {
            this.showAuditPointCheckList((AuditTask)flowElement, taskEntity);
        }
    }

    private void showAuditPointCheckList(AuditTask auditTask, TaskEntity taskEntity) {
        AuditPointModel auditPointModel = auditTask.getAuditPointModel();
        if (auditPointModel == null || !auditPointModel.isAuditPointWhenMatch()) {
            return;
        }
        IDataModel model = this.getModel();
        String title = auditPointModel.getAuditPointTitle();
        Label auditPointsTitle = (Label)this.getControl(AUDITPOINTS_TITLE);
        auditPointsTitle.setText(WfUtils.isEmpty((String)title) ? ResManager.loadKDString((String)"\u5ba1\u6279\u8981\u70b9", (String)"ApprovalPagePluginNew_20", (String)"bos-wf-formplugin", (Object[])new Object[0]) : title);
        int i = 0;
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity_auditpoint");
        List auditPointIntances = this.getTaskService().getAuditPointInstancesByTaskId(taskEntity.getId());
        if (auditPointIntances == null || auditPointIntances.isEmpty()) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANEL_AUDITPOINTS});
        model.batchCreateNewEntryRow("entryentity_auditpoint", auditPointIntances.size());
        RepositoryService service = this.getRepositoryService();
        for (AuditPointInstanceEntity auditPointIntance : auditPointIntances) {
            String type = auditPointIntance.getType();
            this.setControlsDisplayOrHidden(cardEntry, type, i);
            model.setValue("auditpointinsid", (Object)auditPointIntance.getId(), i);
            ILocaleString description = auditPointIntance.getDescription();
            if (!WfUtils.isEmpty((String)type)) {
                model.setValue("auditpoint_type", (Object)type, i);
                model.setValue("displayname", (Object)auditPointIntance.getDisplayname().getLocaleValue(), i);
                model.setValue(AUDITPOINTS_DESCRIPTION, (Object)description.getLocaleValue(), i);
            } else {
                model.setValue("auditpoint_type", (Object)AuditPointType.TEXTREMINDER.getNumber(), i);
                model.setValue("displayname", (Object)description.getLocaleValue(), i);
            }
            switch (type) {
                case "textreminder": 
                case "": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_TEXTREMINDER.getValue(), i);
                    break;
                }
                case "automaticchecks": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_APPROVE.getValue(), i);
                    ILocaleString failedReason = auditPointIntance.getFailedReason();
                    String checkResult = auditPointIntance.getCheckResult();
                    if (auditPointIntance.isImmediately().booleanValue()) {
                        String langKey;
                        String key = ConditionUtil.getConInstKey((String)auditTask.getNumber(), (String)"auditPoint");
                        Map resultAndFailedReason = service.calculateAuditPointCheckResult(auditPointIntance.getBusinessRule(), (VariableScope)taskEntity, key);
                        Boolean isPassed = (Boolean)resultAndFailedReason.get("isPassed");
                        String exceptionMessage = (String)resultAndFailedReason.get("failedReason");
                        AuditPointInstanceEntity auditPointInstanceEntity = (AuditPointInstanceEntity)service.findEntityById(auditPointIntance.getId(), "wf_auditpointinstance");
                        if (isPassed.booleanValue()) {
                            checkResult = AuditPointCheckResult.APPROVE.getNumber();
                            auditPointInstanceEntity.setCheckResult(checkResult);
                        } else {
                            checkResult = AuditPointCheckResult.FAILED.getNumber();
                            auditPointInstanceEntity.setCheckResult(checkResult);
                            if (!WfUtils.isEmpty((String)exceptionMessage)) {
                                if (exceptionMessage.length() > 2000) {
                                    exceptionMessage = exceptionMessage.substring(0, 1999);
                                }
                                failedReason = WfUtils.getMultiLangValue((String)exceptionMessage);
                            } else {
                                ILocaleString failedReasonExpression = auditPointInstanceEntity.getFailedReasonExpression();
                                if (WfUtils.isNotEmpty((ILocaleString)failedReasonExpression)) {
                                    for (Map.Entry entry : failedReasonExpression.entrySet()) {
                                        langKey = (String)entry.getKey();
                                        String failedReasonValue = (String)entry.getValue();
                                        String failedReasonParsed = service.getBillExpressionParsedValue(taskEntity.getBusinessKey(), taskEntity.getEntityNumber(), failedReasonValue, (VariableScope)taskEntity);
                                        if (failedReasonParsed.length() > 2000) {
                                            failedReasonParsed = failedReasonParsed.substring(0, 1999);
                                        }
                                        failedReason.setItem(langKey, (Object)failedReasonParsed);
                                    }
                                    auditPointInstanceEntity.setFailedReason(failedReason);
                                }
                            }
                        }
                        ILocaleString descriptionExpression = auditPointIntance.getDescriptionExpression();
                        if (WfUtils.isNotEmpty((ILocaleString)descriptionExpression)) {
                            for (Map.Entry entry : descriptionExpression.entrySet()) {
                                langKey = (String)entry.getKey();
                                String descriptionValue = (String)entry.getValue();
                                String descriptionParsed = service.getBillExpressionParsedValue(taskEntity.getBusinessKey(), taskEntity.getEntityNumber(), descriptionValue, (VariableScope)taskEntity);
                                if (descriptionParsed.length() > 510) {
                                    descriptionParsed = descriptionParsed.substring(0, 509);
                                }
                                description.setItem(langKey, (Object)descriptionParsed);
                            }
                            auditPointInstanceEntity.setDescription(description);
                        }
                        service.saveOrUpdateEntity((Entity)auditPointInstanceEntity);
                    }
                    model.setValue("combo_ispass", (Object)checkResult, i);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"combo_ispass"});
                    if (AuditPointCheckResult.FAILED.getNumber().equals(checkResult)) {
                        model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_FAILED.getValue(), i);
                        model.setValue(AUDITPOINTS_ERRORMESSAGE, (Object)failedReason.getLocaleValue(), i);
                        cardEntry.setChildVisible(true, i, new String[]{AUDITPOINTS_CARDENTRYFAILRE});
                        cardEntry.setChildVisible(true, i, new String[]{AUDITPOINTS_ERRORMESSAGE});
                    }
                    model.setValue(AUDITPOINTS_DESCRIPTION, (Object)description.getLocaleValue(), i);
                    break;
                }
                case "manualchecks": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_UNCONFIRMED.getValue(), i);
                    model.setValue("isneedreason", (Object)auditPointIntance.isNeedReason(), i);
                    model.setValue("isneedmark", (Object)auditPointIntance.isNeedMark(), i);
                    break;
                }
            }
            ++i;
        }
    }

    private void setControlsDisplayOrHidden(CardEntry cardEntry, String type, int i) {
        switch (type) {
            case "textreminder": 
            case "": {
                cardEntry.setChildVisible(true, i, new String[]{IMAGEAP_ISPASS, "displayname"});
                cardEntry.setChildVisible(false, i, new String[]{CARDENTRYISPASS, "combo_ispass", AUDITPOINTS_ERRORMESSAGE, AUDITPOINTS_CARDENTRYFAILRE, "failedreason"});
                break;
            }
            case "automaticchecks": 
            case "manualchecks": {
                cardEntry.setChildVisible(true, i, new String[]{IMAGEAP_ISPASS, "displayname", CARDENTRYISPASS, "combo_ispass"});
                cardEntry.setChildVisible(false, i, new String[]{AUDITPOINTS_ERRORMESSAGE, AUDITPOINTS_CARDENTRYFAILRE, "failedreason"});
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("combo_ispass".equals(propName)) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity_auditpoint");
            int index = cardEntry.getEntryState().getFocusRow();
            IDataModel model = this.getModel();
            String ispassed = (String)model.getValue("combo_ispass", index);
            if (WfUtils.isEmpty((String)ispassed)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u5ba1\u6279\u8981\u70b9\u68c0\u67e5\u9879\u662f\u5426\u901a\u8fc7\u3002", (String)"ApprovalPageAuditPointPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean isNeedReason = (Boolean)model.getValue("isneedreason", index);
            switch (ispassed) {
                case "approve": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_APPROVE.getValue(), index);
                    break;
                }
                case "failed": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_FAILED.getValue(), index);
                    break;
                }
                case "unconfirmed": {
                    model.setValue(IMAGEAP_ISPASS, (Object)PictureResourceEnum.AUDITPOINT_IMAGES_UNCONFIRMED.getValue(), index);
                    break;
                }
            }
            if (AuditPointCheckResult.FAILED.getNumber().equals(ispassed) && isNeedReason.booleanValue()) {
                cardEntry.setChildVisible(true, index, new String[]{AUDITPOINTS_CARDENTRYFAILRE});
                cardEntry.setChildVisible(true, index, new String[]{"failedreason"});
            } else {
                cardEntry.setChildVisible(false, index, new String[]{AUDITPOINTS_CARDENTRYFAILRE});
                cardEntry.setChildVisible(false, index, new String[]{"failedreason"});
            }
        }
    }
}

