/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.ca.SignService;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ca.SignScheme;
import kd.bos.form.ClientCallback;
import kd.bos.form.ClientMethodResult;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.operate.SignOperateCallback;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.ca.SignServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.quantitysum.LocalVariables;
import kd.bos.workflow.taskcenter.plugin.entity.SignInfoForBatch;
import kd.bos.workflow.taskcenter.plugin.util.SignServiceUtil;

public class ApprovalPageBatchPlugin
extends AbstractWorkflowPlugin
implements RowClickEventListener,
SignCallbackLisenter {
    private static Log logger = LogFactory.getLog(ApprovalPageBatchPlugin.class);
    private static final String MSG_APPROVAL = "msg_approval";
    private static final String BTNCANCEL = "btncancel";
    private static final String BTNOK = "btnok";
    public static final String TASKIDS = "taskids";
    public static final String FORMID = "wf_approvalpage_batch";
    public static final String BATCHOPTYPE = "batchoptype";

    @Override
    public void initialize() {
        this.addClickListeners(new String[]{BTNCANCEL, BTNOK});
    }

    public void afterCreateNewData(EventObject evt) {
        String opType = (String)this.getView().getFormShowParameter().getCustomParam(BATCHOPTYPE);
        if ("approve".equals(opType)) {
            this.getModel().setValue(MSG_APPROVAL, (Object)WFMultiLangConstants.getApproveMsgTip());
        } else {
            this.getModel().setValue(MSG_APPROVAL, (Object)ResManager.loadKDString((String)"\u9a73\u56de", (String)"ApprovalPageBatchPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.submitDataForBatch();
                break;
            }
            case "btncancel": {
                this.getModel().setDataChanged(false);
                this.getView().close();
                break;
            }
        }
    }

    private void submitDataForBatch() {
        SignInfoForBatch signInfoForBatch = SignServiceUtil.collectionData(this.getView());
        logger.debug("ApprovalPageBatchPlugin.submitDataForBatch signInfoForBatch collectionData entityNumber: " + signInfoForBatch.getEntityNumber() + ";noSignTaskIds: " + signInfoForBatch.getNoSignTaskIds() + ";signTask: " + signInfoForBatch.getSignTask() + ";verifySignTask: " + signInfoForBatch.getVerifySignTask() + ";businessAndBillnoMapping: " + signInfoForBatch.getBusinessAndBillnoMapping() + ";signForSameEntity: " + signInfoForBatch.isSignForSameEntity());
        List<Long> noSignTaskIds = signInfoForBatch.getNoSignTaskIds();
        Map<String, String> businessAndBillnoMapping = signInfoForBatch.getBusinessAndBillnoMapping();
        ArrayList<String> failList = new ArrayList<String>();
        if (!signInfoForBatch.isSignForSameEntity()) {
            logger.debug("ApprovalPageBatchPlugin.submitDataForBatch signForSameEntity is false.");
            String formatErrMsg = ResManager.loadKDString((String)"[%1$s]\u8be5\u4efb\u52a1\u9700\u8981\u6dfb\u52a0\u6216\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\uff0c\u8bf7\u5728\u5de6\u4fa7\u5bfc\u822a\u680f\u4e2d\u70b9\u51fb\u8fdb\u5165\u8be5\u5355\u636e\u7684\u5b50\u83dc\u5355\u5b8c\u6210\u5ba1\u6279\u3002", (String)"ApprovalPageBatchPlugin_01", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.submitDataAndReturn(noSignTaskIds, businessAndBillnoMapping, failList, formatErrMsg);
            return;
        }
        if (signInfoForBatch.isNoSignTask()) {
            logger.debug("ApprovalPageBatchPlugin.submitDataForBatch noSignTask is true.");
            this.submitDataAndReturn(noSignTaskIds, businessAndBillnoMapping, failList, null);
            return;
        }
        SignScheme signScheme = SignService.getSignScheme((String)signInfoForBatch.getEntityNumber());
        if (null == signScheme) {
            logger.debug("ApprovalPageBatchPlugin.submitDataForBatch signScheme is null.");
            String formatErrMsg = ResManager.loadKDString((String)"[%1$s]\u6ca1\u6709\u7b7e\u540d\u65b9\u6848\uff0c\u4e0d\u80fd\u9a8c\u8bc1\u6216\u6dfb\u52a0\u6570\u5b57\u7b7e\u540d\u3002", (String)"ApprovalPageBatchPlugin_02", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.submitDataAndReturn(noSignTaskIds, businessAndBillnoMapping, failList, formatErrMsg);
            return;
        }
        SignServiceUtil.verifySignsForBatch(signInfoForBatch, failList);
        SignOperateCallback signOperateCallback = new SignOperateCallback(this.getView(), (SignCallbackLisenter)this, null, ClientCallback.SignClientType.Secondry, "signForApproval");
        boolean submitDataInSignCallBack = SignServiceUtil.signForBatch(signInfoForBatch, signScheme, signOperateCallback, failList, this.getView());
        if (submitDataInSignCallBack) {
            return;
        }
        noSignTaskIds = signInfoForBatch.getTaskIds();
        logger.debug("ApprovalPageBatchPlugin.submitDataForBatch noSignTaskIds: " + noSignTaskIds);
        this.submitDataAndReturn(noSignTaskIds, businessAndBillnoMapping, failList, null);
    }

    private void submitDataAndReturn(List<Long> taskIdsNormal, Map<String, String> mappingForBusABill, List<String> failList, String formatErrMsg) {
        String submitDataResult = this.submitData(taskIdsNormal);
        if (null != formatErrMsg) {
            logger.debug("ApprovalPageBatchPlugin.submitDataAndReturn formatErrMsg :" + formatErrMsg);
            this.packageFailList(mappingForBusABill, failList, formatErrMsg);
        }
        logger.debug("ApprovalPageBatchPlugin.submitDataAndReturn failList :" + failList);
        this.returnDataToParent(submitDataResult, failList);
    }

    public void signCallback(SignCallbackEvent evt) {
        SignServiceUtil.showLoading(this.getView(), "", false);
        String signInfoForBatchStr = this.getPageCache().get("signInfoForBatch");
        logger.debug("ApprovalPageBatchPlugin.signCallback signInfoForBatchStr: " + signInfoForBatchStr);
        SignInfoForBatch signInfoForBatch = (SignInfoForBatch)SerializationUtils.fromJsonString((String)signInfoForBatchStr, SignInfoForBatch.class);
        logger.debug("ApprovalPageBatchPlugin.signCallback signInfoForBatch : " + signInfoForBatch.getEntityNumber() + ";noSignTaskIds: " + signInfoForBatch.getNoSignTaskIds() + ";signTask: " + signInfoForBatch.getSignTask() + ";verifySignTask: " + signInfoForBatch.getVerifySignTask() + ";businessAndBillnoMapping: " + signInfoForBatch.getBusinessAndBillnoMapping() + ";signForSameEntity: " + signInfoForBatch.isSignForSameEntity());
        String failListStr = this.getPageCache().get("failList");
        logger.debug("ApprovalPageBatchPlugin.signCallback failListStr: " + failListStr);
        List failList = (List)SerializationUtils.fromJsonString((String)failListStr, List.class);
        logger.debug("ApprovalPageBatchPlugin.signCallback failList: " + failList);
        List<Long> taskIds = null;
        Map<String, String> businessAndBillnoMapping = signInfoForBatch.getBusinessAndBillnoMapping();
        ClientMethodResult ret = evt.getResult();
        logger.debug("ApprovalPageBatchPlugin.signCallback() ret.getSuccess(): " + ret.getSuccess());
        if (!ret.getSuccess().booleanValue()) {
            signInfoForBatch.removeTaskForSignFailed(failList);
            taskIds = signInfoForBatch.getTaskIds();
            this.submitDataAndReturn(taskIds, businessAndBillnoMapping, failList, null);
            return;
        }
        try {
            logger.debug("ApprovalPageBatchPlugin.signCallback() save signInfo begin.");
            Map signTextsMap = ret.getResult();
            String clearTextStr = evt.getClearText();
            Map clearTextMap = (Map)SerializationUtils.fromJsonString((String)clearTextStr, Map.class);
            logger.debug("ApprovalPageBatchPlugin.signCallback() save signInfo begin entityNumber: " + signInfoForBatch.getEntityNumber() + ";signTextsMap: " + signTextsMap + ";clearTextMap: " + clearTextMap);
            SignServiceHelper.saveSignMessage((String)signInfoForBatch.getEntityNumber(), (Map)signTextsMap, (Map)clearTextMap);
            taskIds = signInfoForBatch.getTaskIds();
            logger.debug("ApprovalPageBatchPlugin.signCallback() save signInfo end.");
        }
        catch (Exception e) {
            logger.warn("ApprovalPageBatchPlugin.signCallback() save signInfo exception: " + WfUtils.getExceptionStacktrace((Throwable)e));
            signInfoForBatch.removeTaskForSignFailed(failList);
            taskIds = signInfoForBatch.getTaskIds();
            logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        this.submitDataAndReturn(taskIds, businessAndBillnoMapping, failList, null);
    }

    private void packageFailList(Map<String, String> mappingForBusABill, List<String> failList, String formatErrMsg) {
        Collection<String> values = mappingForBusABill.values();
        for (String v : values) {
            if (null == v) continue;
            failList.add(String.format(formatErrMsg, v));
        }
    }

    private void returnDataToParent(String submitDataResult, List<String> failList) {
        JSONObject jsonObject = new JSONObject();
        int totalCount = Integer.parseInt(this.getPageCache().get("totalCount"));
        int successCount = 0;
        int failedCount = 0;
        List<String> failListForSubmitData = new ArrayList<String>(0);
        if (null != submitDataResult) {
            logger.debug("ApprovalPageBatchPlugin.returnDataToParent submitDataResult: " + submitDataResult);
            jsonObject = (JSONObject)JSON.parse((String)submitDataResult);
            successCount = jsonObject.getIntValue("successCount");
            failedCount = jsonObject.getIntValue("failedCount");
            if (failedCount > 0) {
                JSONArray failListJSON = jsonObject.getJSONArray("failList");
                failListForSubmitData = failListJSON.stream().map(item -> item.toString()).collect(Collectors.toList());
            }
        }
        if (!failList.isEmpty()) {
            failListForSubmitData.addAll(failList);
        }
        jsonObject.put("successCount", (Object)successCount);
        jsonObject.put("failedCount", (Object)(totalCount - successCount));
        jsonObject.put("failList", failListForSubmitData);
        jsonObject.put("opType", this.getView().getFormShowParameter().getCustomParam(BATCHOPTYPE));
        this.getView().returnDataToParent((Object)jsonObject.toJSONString());
        this.getView().close();
    }

    private String submitData(List<Long> taskIds) {
        if (null == taskIds || taskIds.isEmpty()) {
            return null;
        }
        StringBuilder taskIdsStr = new StringBuilder();
        for (Long taskId : taskIds) {
            taskIdsStr.append(taskId).append(",");
        }
        logger.debug("ApprovalPageBatchPlugin.submitData(List<Long>) taskIdsStr: " + taskIdsStr);
        LocalVariables.putLocalVariables((boolean)true, (String[])new String[]{"tohandle", "handled"});
        String opType = (String)this.getView().getFormShowParameter().getCustomParam(BATCHOPTYPE);
        HashMap<String, String> variables = new HashMap<String, String>();
        ILocaleString msg = (ILocaleString)this.getModel().getValue(MSG_APPROVAL);
        variables.put("batchOpType", opType);
        variables.put("auditType", opType);
        variables.put("auditMessage", (String)msg);
        return this.getTaskService().updateBillAndCompleteForBatch(taskIdsStr.substring(0, taskIdsStr.lastIndexOf(",")), msg, variables);
    }
}

