/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.taskcenter.plugin.util.WorkflowTCDataPluginUtil;

public class ApprovalPageBizFlowPlugin
extends AbstractWorkflowPlugin {
    private static final String BTNHANDLE = "btnhandle";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        boolean show = this.getBtnPushState();
        this.getView().setVisible(Boolean.valueOf(show), new String[]{BTNHANDLE});
    }

    private boolean getBtnPushState() {
        String taskType = this.getPageCache().get("tasktype");
        if (!"toHandle".equals(taskType)) {
            return false;
        }
        String processInstanceId = this.getPageCache().get("processInstanceId");
        if (WfUtils.isEmpty((String)processInstanceId)) {
            return false;
        }
        String workFlowType = ViewFlowchartUtil.getWorkFlowType((Long)Long.valueOf(processInstanceId));
        return ProcessType.BizFlow.name().equals(workFlowType);
    }

    public void itemClick(ItemClickEvent evt) {
        String id = evt.getItemKey();
        if (BTNHANDLE.equals(id)) {
            this.btnHandle();
        }
    }

    private void btnHandle() {
        String taskIdStr = this.getPageCache().get("taskid");
        if (WfUtils.isEmpty((String)taskIdStr)) {
            this.getView().showTipNotification(WFMultiLangConstants.getTaskIdIsNull());
            return;
        }
        Long taskId = Long.valueOf(taskIdStr);
        TaskEntity taskEntity = (TaskEntity)this.getRepositoryService().findEntityById(taskId, "wf_task");
        if (taskEntity == null) {
            this.getView().showTipNotification(WFMultiLangConstants.getTaskIsNotExist());
            return;
        }
        boolean isParticipant = CoordinateRecordUtil.isParticipant((Long)taskId, (String)RequestContext.get().getUserId(), (String)"participant");
        if (!isParticipant) {
            this.getView().showTipNotification(WFMultiLangConstants.getIsNotTaskParticipant());
            return;
        }
        if (TaskUtils.isTaskSuspended((Long)taskId)) {
            this.getView().showTipNotification(WFMultiLangConstants.getTaskSuspendedInfo());
            return;
        }
        String executionType = taskEntity.getExecutionType();
        if ("manualpush".equals(executionType)) {
            ArrayList<Long> taskIds = new ArrayList<Long>();
            taskIds.add(taskId);
            WorkflowTCDataPluginUtil.manualPush(taskIds, taskEntity.getProcessingPage(), this, BTNHANDLE);
        } else if ("manualdraw".equals(executionType)) {
            WorkflowTCDataPluginUtil.manualDraw(taskId, this, BTNHANDLE);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (BTNHANDLE.equals(e.getActionId())) {
            // empty if block
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (null == e) {
            return;
        }
        String key = e.getKey();
        String btnkeys = this.getPageCache().get("addControlKeys");
        if (null == btnkeys || btnkeys.contains(key)) {
            return;
        }
        this.addItemClickListeners(btnkeys.split(","));
    }
}

