/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import com.alibaba.fastjson.JSONArray;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.taskcenter.plugin.ApprovalPluginNew;

public class ApprovalPageRejectPlugin
extends ApprovalPluginNew {
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String BTN_OK = "btn_ok";
    private static final String ENTRYENTITY = "entryentity";
    private static final String NODE_NAME = "node_name";
    private static final String IMAGE_PERSON = "image_person";
    private static final String PERSON_NAME = "person_name";
    private static final String NODE_RECORD = "node_record";
    private static final String NEXTNODEDATALIST = "nextNodeDataList";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_OK});
    }

    public void afterCreateNewData(EventObject evt) {
        this.showRejectInfo();
    }

    private void showRejectInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray nextNodeDataList = this.filterUnFlowThroughNode((JSONArray)customParams.get(NEXTNODEDATALIST), Long.valueOf((String)customParams.get("processInstanceId")));
        this.setEntryEntity(nextNodeDataList, customParams);
    }

    private void setEntryEntity(JSONArray nextNodeDataList, Map<String, Object> params) {
        IDataModel model = this.getModel();
        String entryName = ENTRYENTITY;
        super.showClearEntryEntity(model, entryName);
        if (null != nextNodeDataList && 0 < nextNodeDataList.size()) {
            int i = 0;
            String activityId = null;
            String approvalInfo = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List approvalRecordChildren = null;
            Long processInstanceId = Long.valueOf((String)params.get("processInstanceId"));
            model.batchCreateNewEntryRow(entryName, nextNodeDataList.size());
            Map data = null;
            Object nextNodeType = null;
            for (Object nextNodeData : nextNodeDataList) {
                approvalInfo = null;
                data = (Map)nextNodeData;
                model.setValue(NODE_NAME, (Object)((String)data.get("nextNodeText")), i);
                model.setValue(IMAGE_PERSON, (Object)((String)data.get("avatar")), i);
                model.setValue(PERSON_NAME, super.getRealValue((String)data.get("nextDealPersonText")), i);
                activityId = (String)data.get("nextNodeValue");
                approvalRecordChildren = super.getTaskService().findCommentsByProcessInstanceIdAndActivityId(processInstanceId, activityId);
                if (0 != approvalRecordChildren.size()) {
                    approvalInfo = sdf.format(((CommentEntity)approvalRecordChildren.get(0)).getTime()) + " " + ((CommentEntity)approvalRecordChildren.get(0)).getResultName();
                } else {
                    nextNodeType = data.get("nextNodeType");
                    if (WfUtils.isEmptyString(nextNodeType) || !BpmnModelUtil.instanceofAutoTask((String)nextNodeType.toString())) {
                        approvalInfo = ResManager.loadKDString((String)"\u6682\u65e0\u8bb0\u5f55\u4fe1\u606f\u3002", (String)"ApprovalPageRejectPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    }
                }
                model.setValue(NODE_RECORD, (Object)approvalInfo, i);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_cancel": {
                this.getView().close();
                break;
            }
            case "btn_ok": {
                this.showSubmitData();
                break;
            }
        }
    }

    private void showSubmitData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (0 == selectRows.length) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u9a73\u56de\u81f3\u201d\u7684\u8282\u70b9\u3002", (String)"ApprovalPageRejectPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONArray nextNodeDataList = WfConfigurationUtil.isIgnoreNoThroughNode() ? (JSONArray)customParams.get("rejectNode") : (JSONArray)customParams.get(NEXTNODEDATALIST);
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("nextNodeMapList", nextNodeDataList.get(selectRows[0]));
            returnData.put("auditNumber", customParams.get("auditNumber"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private JSONArray filterUnFlowThroughNode(JSONArray list, Long procId) {
        if (list != null && !list.isEmpty() && WfConfigurationUtil.isIgnoreNoThroughNode()) {
            JSONArray nodeList = new JSONArray();
            nodeList.addAll((Collection)list);
            Map data = null;
            List entities = this.getHistoryService().getHistoricActivityByProcessInstanceId(procId);
            for (int i = nodeList.size() - 1; i >= 0; --i) {
                data = (Map)nodeList.get(i);
                String nextNodeId = (String)data.get("nextNodeValue");
                boolean isThrough = false;
                int len = entities.size();
                for (int j = 0; j < len; ++j) {
                    if (!nextNodeId.equals(((HistoricActivityInstanceEntity)entities.get(j)).getActivityId())) continue;
                    isThrough = true;
                    break;
                }
                if (isThrough) continue;
                nodeList.remove(i);
            }
            this.getView().getFormShowParameter().getCustomParams().put("rejectNode", nodeList);
            this.getView().cacheFormShowParameter();
            return nodeList;
        }
        return list;
    }
}

