/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.component.ApprovalRecord;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.ApprovalPluginNew;

public class ApprovalProgressPageMobilePluginNew
extends ApprovalPluginNew
implements RowClickEventListener {
    private static final String PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String LABELAP_TITLE = "labelap_title";
    private static final String LABELAP_RULE = "labelap_rule";
    private static final String APPROVALRECORDAP = "approvalrecordap";
    private static final String MBARITEMAP_CANCEL = "mbaritemap_cancel";

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter p = (FormShowParameter)e.getSource();
        if (p.getAppId() == null) {
            p.setAppId("wf");
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{MBARITEMAP_CANCEL});
    }

    public void afterCreateNewData(EventObject evt) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.setTitleInfo(params);
        this.setApprovalRecordInfo(params);
    }

    private void setTitleInfo(Map<String, Object> params) {
        Label labelap_title = (Label)this.getView().getControl(LABELAP_TITLE);
        this.getPageCache().put("processDefinitionId", (String)params.get("processDefinitionId"));
        this.getPageCache().put(PROCESS_INSTANCE_ID, (String)params.get(PROCESS_INSTANCE_ID));
        this.getPageCache().put("taskdefinitionkey", (String)params.get("taskdefinitionkey"));
        UserTask userTask = (UserTask)super.getAuditTaskElements();
        labelap_title.setText(WfUtils.isEmptyString((Object)userTask) ? "" : userTask.getName());
        Label labelap_rule = (Label)this.getView().getControl(LABELAP_RULE);
        String ruleText = this.getRuleTextFromBPMNModel(params);
        labelap_rule.setText(ruleText);
    }

    private String getRuleTextFromBPMNModel(Map<String, Object> params) {
        Long processDefinitionId = Long.valueOf((String)params.get("processDefinitionId"));
        Long processInstanceId = Long.valueOf((String)params.get(PROCESS_INSTANCE_ID));
        String taskdefinitionkey = (String)params.get("taskdefinitionkey");
        BpmnModel bpmnModel = super.getRepositoryService().getBpmnModel(processDefinitionId, processInstanceId);
        String message = BpmnModelUtil.getYunzhijiaThroughRules((YunzhijiaTask)((YunzhijiaTask)bpmnModel.getFlowElement(taskdefinitionkey)), (Long)processInstanceId);
        return message;
    }

    private void setApprovalRecordInfo(Map<String, Object> params) {
        Long parenttaskid = WfUtils.normalizeId((String)params.get("parenttaskid").toString());
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List approvalRecordItems = wfService.getTaskService().queryApprovalRecord(Long.valueOf(params.get(PROCESS_INSTANCE_ID).toString()), params.get("businesskey").toString());
        ArrayList<IApprovalRecordGroup> currentNodeApprovalRecordItems = new ArrayList<IApprovalRecordGroup>();
        for (IApprovalRecordGroup iApprovalRecordGroup : approvalRecordItems) {
            if (iApprovalRecordGroup.getGroup() == null || !iApprovalRecordGroup.getGroup().equals(parenttaskid.toString())) continue;
            currentNodeApprovalRecordItems.add(iApprovalRecordGroup);
        }
        ApprovalRecord approvalRecord = (ApprovalRecord)this.getControl(APPROVALRECORDAP);
        approvalRecord.setYzjParameter((String)params.get("businesskey"), (String)params.get("taskid"), "wf_approvalprogresspage");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hideMoreChat", "");
        parameters.put("isPC", "false");
        parameters.put("approvalIsNew", Boolean.TRUE);
        if (params.get(PROCESS_INSTANCE_ID) != null) {
            parameters.put("procInstId", Long.valueOf(params.get(PROCESS_INSTANCE_ID).toString()));
        }
        String billPageId = this.getPageCache().get("billPageId");
        parameters.put("pageId", billPageId);
        approvalRecord.setParameters(parameters);
        approvalRecord.setArData(currentNodeApprovalRecordItems);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase()) {
            case "mbaritemap_cancel": {
                this.getView().close();
                break;
            }
        }
    }
}

